/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdroidfilter.platformtools.darkmodedetector.linux;

import androidx.compose.runtime.internal.StabilityInferred;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import io.github.kdroidfilter.platformtools.darkmodedetector.linux.GnomeThemeDetectorKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0014\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u001d\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/github/kdroidfilter/platformtools/darkmodedetector/linux/GnomeThemeDetector;", "", "<init>", "()V", "MONITORING_CMD", "", "GET_CMD", "", "[Ljava/lang/String;", "darkThemeRegex", "Lkotlin/text/Regex;", "getDarkThemeRegex", "()Lkotlin/text/Regex;", "detectorThread", "Ljava/lang/Thread;", "listeners", "", "Ljava/util/function/Consumer;", "", "isDark", "startMonitoring", "", "isDarkThemeFromLine", "line", "(Ljava/lang/String;)Ljava/lang/Boolean;", "isDarkTheme", "text", "registerListener", "listener", "removeListener", "darkmodedetector"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGnomeThemeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GnomeThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/linux/GnomeThemeDetector\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n31#2,3:159\n34#2:171\n46#2,3:172\n49#2:184\n31#3,9:162\n31#3,9:175\n1#4:185\n*S KotlinDebug\n*F\n+ 1 GnomeThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/linux/GnomeThemeDetector\n*L\n41#1:159,3\n41#1:171\n49#1:172,3\n49#1:184\n41#1:162,9\n49#1:175,9\n*E\n"})
public final class GnomeThemeDetector {
    @NotNull
    public static final GnomeThemeDetector INSTANCE = new GnomeThemeDetector();
    @NotNull
    private static final String MONITORING_CMD = "gsettings monitor org.gnome.desktop.interface";
    @NotNull
    private static final String[] GET_CMD;
    @NotNull
    private static final Regex darkThemeRegex;
    @Nullable
    private static volatile Thread detectorThread;
    @NotNull
    private static final Set<Consumer<Boolean>> listeners;
    public static final int $stable;

    private GnomeThemeDetector() {
    }

    @NotNull
    public final Regex getDarkThemeRegex() {
        return darkThemeRegex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean isDark() {
        boolean bl;
        try {
            Runtime runtime = Runtime.getRuntime();
            for (String cmd : GET_CMD) {
                Process process = runtime.exec(cmd);
                Closeable closeable = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Throwable throwable = null;
                try {
                    void this_$iv$iv;
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl2 = false;
                    String line = reader.readLine();
                    Logger $this$iv = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                    Throwable throwable$iv = null;
                    String tag$iv = $this$iv.getTag();
                    boolean $i$f$d = false;
                    BaseLogger baseLogger = (BaseLogger)$this$iv;
                    Severity severity$iv$iv = Severity.Debug;
                    boolean $i$f$logBlock = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                        Throwable throwable2 = throwable$iv;
                        String string = tag$iv;
                        Severity severity = severity$iv$iv;
                        void var22_34 = this_$iv$iv;
                        boolean bl3 = false;
                        String string2 = "Command '" + cmd + "' output: " + line;
                        var22_34.processLog(severity, string, throwable2, string2);
                    }
                    if (line != null && INSTANCE.isDarkTheme(line)) {
                        boolean bl4 = true;
                        return bl4;
                    }
                    reader = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            bl = false;
        }
        catch (Exception e) {
            void this_$iv$iv;
            void $this$iv;
            Logger logger = GnomeThemeDetectorKt.access$getGnomeLogger$p();
            Throwable throwable$iv = e;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string = tag$iv;
                Severity severity = severity$iv$iv;
                void var26_41 = this_$iv$iv;
                boolean bl5 = false;
                String string3 = "Couldn't detect GNOME theme";
                var26_41.processLog(severity, string, throwable, string3);
            }
            bl = false;
        }
        return bl;
    }

    private final void startMonitoring() {
        Thread thread2;
        Thread thread3 = detectorThread;
        boolean bl = thread3 != null ? thread3.isAlive() : false;
        if (bl) {
            return;
        }
        Thread $this$startMonitoring_u24lambda_u240 = thread2 = new Thread(){
            private boolean lastValue;
            {
                this.lastValue = GnomeThemeDetector.INSTANCE.isDark();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                Object object;
                String string;
                void var25_19;
                Severity severity;
                String string2;
                Throwable throwable;
                Logger this_$iv$iv;
                Logger $this$iv = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    throwable = throwable$iv;
                    string2 = tag$iv;
                    severity = severity$iv$iv;
                    var25_19 = this_$iv$iv;
                    boolean bl = false;
                    string = "Starting GTK theme monitoring thread";
                    var25_19.processLog(severity, string2, throwable, string);
                }
                Runtime runtime = Runtime.getRuntime();
                try {
                    object = runtime.exec("gsettings monitor org.gnome.desktop.interface");
                }
                catch (Exception e) {
                    void this_$iv$iv2;
                    void $this$iv2;
                    this_$iv$iv = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                    Throwable throwable$iv2 = e;
                    String tag$iv2 = $this$iv2.getTag();
                    boolean $i$f$e = false;
                    BaseLogger baseLogger2 = (BaseLogger)$this$iv2;
                    Severity severity$iv$iv2 = Severity.Error;
                    boolean $i$f$logBlock2 = false;
                    if (this_$iv$iv2.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv2) <= 0) {
                        throwable = throwable$iv2;
                        string2 = tag$iv2;
                        severity = severity$iv$iv2;
                        var25_19 = this_$iv$iv2;
                        boolean bl2 = false;
                        string = "Couldn't start monitoring process";
                        var25_19.processLog(severity, string2, throwable, string);
                    }
                    return;
                }
                Process process = object;
                object = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Throwable throwable2 = null;
                try {
                    BaseLogger this_$iv$iv3;
                    Object object2;
                    BaseLogger baseLogger3;
                    Severity severity2;
                    String string3;
                    Throwable throwable3;
                    BufferedReader reader = (BufferedReader)object;
                    boolean bl = false;
                    while (!this.isInterrupted() && reader.readLine() != null) {
                        void this_$iv$iv4;
                        void this_$iv$iv5;
                        String line;
                        if (!StringsKt.contains((CharSequence)line, (CharSequence)"gtk-theme", (boolean)true) && !StringsKt.contains((CharSequence)line, (CharSequence)"color-scheme", (boolean)true)) continue;
                        Logger $this$iv3 = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                        Throwable throwable$iv3 = null;
                        String tag$iv3 = $this$iv3.getTag();
                        boolean $i$f$d2 = false;
                        BaseLogger bl2 = (BaseLogger)$this$iv3;
                        Severity severity$iv$iv3 = Severity.Debug;
                        boolean $i$f$logBlock3 = false;
                        if (this_$iv$iv5.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv3) <= 0) {
                            throwable3 = throwable$iv3;
                            string3 = tag$iv3;
                            severity2 = severity$iv$iv3;
                            baseLogger3 = this_$iv$iv5;
                            boolean bl3 = false;
                            object2 = "Monitoring output: " + line;
                            baseLogger3.processLog(severity2, string3, throwable3, (String)object2);
                        }
                        Boolean bl4 = GnomeThemeDetector.access$isDarkThemeFromLine(GnomeThemeDetector.INSTANCE, line);
                        boolean currentIsDark = bl4 != null ? bl4.booleanValue() : GnomeThemeDetector.INSTANCE.isDark();
                        if (currentIsDark == this.lastValue) continue;
                        this.lastValue = currentIsDark;
                        Logger $this$iv4 = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                        Throwable throwable$iv4 = null;
                        String tag$iv4 = $this$iv4.getTag();
                        boolean $i$f$d32 = false;
                        severity$iv$iv3 = (BaseLogger)$this$iv4;
                        Severity severity$iv$iv4 = Severity.Debug;
                        boolean $i$f$logBlock4 = false;
                        if (this_$iv$iv4.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv4) <= 0) {
                            throwable3 = throwable$iv4;
                            string3 = tag$iv4;
                            severity2 = severity$iv$iv4;
                            baseLogger3 = this_$iv$iv4;
                            boolean bl5 = false;
                            object2 = "Detected theme change => dark: " + currentIsDark;
                            baseLogger3.processLog(severity2, string3, throwable3, (String)object2);
                        }
                        for (Consumer listener : GnomeThemeDetector.access$getListeners$p()) {
                            try {
                                listener.accept(currentIsDark);
                            }
                            catch (RuntimeException ex) {
                                void this_$iv$iv6;
                                void $this$iv5;
                                Logger $i$f$d32 = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                                Throwable throwable$iv5 = ex;
                                String tag$iv5 = $this$iv5.getTag();
                                boolean $i$f$e = false;
                                BaseLogger bl5 = (BaseLogger)$this$iv5;
                                Severity severity$iv$iv5 = Severity.Error;
                                boolean $i$f$logBlock5 = false;
                                if (this_$iv$iv6.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv5) > 0) continue;
                                throwable3 = throwable$iv5;
                                string3 = tag$iv5;
                                severity2 = severity$iv$iv5;
                                baseLogger3 = this_$iv$iv6;
                                boolean bl6 = false;
                                object2 = "Exception while notifying listener";
                                baseLogger3.processLog(severity2, string3, throwable3, (String)object2);
                            }
                        }
                    }
                    Logger $this$iv6 = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                    Throwable throwable$iv6 = null;
                    String tag$iv6 = $this$iv6.getTag();
                    boolean $i$f$d4 = false;
                    BaseLogger ex = (BaseLogger)$this$iv6;
                    Severity severity$iv$iv6 = Severity.Debug;
                    boolean $i$f$logBlock6 = false;
                    if (this_$iv$iv3.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv6) <= 0) {
                        throwable3 = throwable$iv6;
                        string3 = tag$iv6;
                        severity2 = severity$iv$iv6;
                        baseLogger3 = this_$iv$iv3;
                        boolean bl7 = false;
                        object2 = "GTK theme monitoring thread ending";
                        baseLogger3.processLog(severity2, string3, throwable3, (String)object2);
                    }
                    if (process.isAlive()) {
                        process.destroy();
                        $this$iv6 = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                        throwable$iv6 = null;
                        tag$iv6 = $this$iv6.getTag();
                        $i$f$d4 = false;
                        this_$iv$iv3 = (BaseLogger)$this$iv6;
                        severity$iv$iv6 = Severity.Debug;
                        $i$f$logBlock6 = false;
                        if (this_$iv$iv3.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv6) <= 0) {
                            throwable3 = throwable$iv6;
                            string3 = tag$iv6;
                            severity2 = severity$iv$iv6;
                            baseLogger3 = this_$iv$iv3;
                            boolean bl8 = false;
                            object2 = "Monitoring process destroyed";
                            baseLogger3.processLog(severity2, string3, throwable3, (String)object2);
                        }
                    }
                    baseLogger = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable2 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
        };
        boolean bl2 = false;
        $this$startMonitoring_u24lambda_u240.setDaemon(true);
        $this$startMonitoring_u24lambda_u240.start();
        detectorThread = thread2;
    }

    private final Boolean isDarkThemeFromLine(String line) {
        Regex regex = new Regex("\\s+");
        CharSequence charSequence = line;
        int n = 0;
        List tokens = regex.split(charSequence, n);
        if (tokens.size() < 2) {
            return null;
        }
        String string = ((String)tokens.get(1)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String value = StringsKt.replace$default((String)string, (String)"'", (String)"", (boolean)false, (int)4, null);
        return !StringsKt.isBlank((CharSequence)value) ? Boolean.valueOf(this.isDarkTheme(value)) : null;
    }

    private final boolean isDarkTheme(String text) {
        return darkThemeRegex.matches((CharSequence)text);
    }

    public final void registerListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        boolean wasEmpty = listeners.isEmpty();
        listeners.add(listener);
        if (wasEmpty) {
            this.startMonitoring();
        }
    }

    public final void removeListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            Thread thread2 = detectorThread;
            if (thread2 != null) {
                thread2.interrupt();
            }
            detectorThread = null;
        }
    }

    public static final /* synthetic */ Boolean access$isDarkThemeFromLine(GnomeThemeDetector $this, String line) {
        return $this.isDarkThemeFromLine(line);
    }

    public static final /* synthetic */ Set access$getListeners$p() {
        return listeners;
    }

    static {
        String[] stringArray = new String[]{"gsettings get org.gnome.desktop.interface gtk-theme", "gsettings get org.gnome.desktop.interface color-scheme"};
        GET_CMD = stringArray;
        darkThemeRegex = new Regex(".*dark.*", RegexOption.IGNORE_CASE);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        listeners = keySetView;
        $stable = 8;
    }
}

