/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdroidfilter.platformtools.darkmodedetector.mac;

import androidx.compose.runtime.internal.StabilityInferred;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import io.github.kdroidfilter.platformtools.darkmodedetector.mac.MacOSThemeDetector;
import io.github.kdroidfilter.platformtools.darkmodedetector.mac.MacOSThemeDetectorKt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001\u000e\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0007J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u0012\u0004\b\u000f\u0010\u0003\u00a8\u0006\u0018"}, d2={"Lio/github/kdroidfilter/platformtools/darkmodedetector/mac/MacOSThemeDetector;", "", "<init>", "()V", "listeners", "", "Ljava/util/function/Consumer;", "", "darkPattern", "Ljava/util/regex/Pattern;", "callbackExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "themeChangedCallback", "io/github/kdroidfilter/platformtools/darkmodedetector/mac/MacOSThemeDetector$themeChangedCallback$1", "getThemeChangedCallback$annotations", "Lio/github/kdroidfilter/platformtools/darkmodedetector/mac/MacOSThemeDetector$themeChangedCallback$1;", "initObserver", "", "isDark", "registerListener", "listener", "removeListener", "notifyListeners", "darkmodedetector"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMacOSThemeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOSThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/mac/MacOSThemeDetector\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n31#2,3:154\n34#2:166\n46#2,3:167\n49#2:179\n31#2,3:180\n34#2:192\n46#2,3:193\n49#2:205\n31#3,9:157\n31#3,9:170\n31#3,9:183\n31#3,9:196\n1869#4,2:206\n1#5:208\n*S KotlinDebug\n*F\n+ 1 MacOSThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/mac/MacOSThemeDetector\n*L\n69#1:154,3\n69#1:166\n80#1:167,3\n80#1:179\n93#1:180,3\n93#1:192\n112#1:193,3\n112#1:205\n69#1:157,9\n80#1:170,9\n93#1:183,9\n112#1:196,9\n128#1:206,2\n*E\n"})
public final class MacOSThemeDetector {
    @NotNull
    public static final MacOSThemeDetector INSTANCE = new MacOSThemeDetector();
    @NotNull
    private static final Set<Consumer<Boolean>> listeners;
    @NotNull
    private static final Pattern darkPattern;
    private static final ExecutorService callbackExecutor;
    @NotNull
    private static final themeChangedCallback.1 themeChangedCallback;
    public static final int $stable;

    private MacOSThemeDetector() {
    }

    @JvmStatic
    private static /* synthetic */ void getThemeChangedCallback$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void initObserver() {
        String string;
        void var13_15;
        Severity severity;
        String string2;
        Throwable throwable;
        void this_$iv$iv;
        Logger $this$iv = MacOSThemeDetectorKt.access$getMacLogger$p();
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$logBlock = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            throwable = throwable$iv;
            string2 = tag$iv;
            severity = severity$iv$iv;
            var13_15 = this_$iv$iv;
            boolean bl = false;
            string = "Initializing macOS theme observer";
            var13_15.processLog(severity, string2, throwable, string);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            void this_$iv$iv2;
            ID iD = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"NSColorChangesObserver");
            Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"allocateObjcClassPair(...)");
            ID delegateClass = iD;
            if (!ID.NIL.equals((Object)delegateClass)) {
                Pointer selector = Foundation.createSelector((String)"handleAppleThemeChanged:");
                boolean added = Foundation.addMethod((ID)delegateClass, (Pointer)selector, (Callback)themeChangedCallback, (String)"v@");
                if (!added) {
                    void this_$iv$iv3;
                    Logger $this$iv2 = MacOSThemeDetectorKt.access$getMacLogger$p();
                    Throwable throwable$iv2 = null;
                    String tag$iv2 = $this$iv2.getTag();
                    boolean $i$f$e = false;
                    BaseLogger baseLogger2 = (BaseLogger)$this$iv2;
                    Severity severity$iv$iv2 = Severity.Error;
                    boolean $i$f$logBlock2 = false;
                    if (this_$iv$iv3.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv2) <= 0) {
                        throwable = throwable$iv2;
                        string2 = tag$iv2;
                        severity = severity$iv$iv2;
                        var13_15 = this_$iv$iv3;
                        boolean bl = false;
                        string = "Failed to add observer method to NSColorChangesObserver";
                        var13_15.processLog(severity, string2, throwable, string);
                    }
                }
                Foundation.registerObjcClassPair((ID)delegateClass);
            }
            ID delegateObj = Foundation.invoke((String)"NSColorChangesObserver", (String)"new", (Object[])new Object[0]);
            Object[] added = new Object[]{delegateObj, Foundation.createSelector((String)"handleAppleThemeChanged:"), Foundation.nsString((String)"AppleInterfaceThemeChangedNotification"), ID.NIL};
            Foundation.invoke((ID)Foundation.invoke((String)"NSDistributedNotificationCenter", (String)"defaultCenter", (Object[])new Object[0]), (String)"addObserver:selector:name:object:", (Object[])added);
            Logger $this$iv3 = MacOSThemeDetectorKt.access$getMacLogger$p();
            Throwable throwable$iv3 = null;
            String tag$iv3 = $this$iv3.getTag();
            boolean $i$f$d2 = false;
            BaseLogger $i$f$e = (BaseLogger)$this$iv3;
            Severity severity$iv$iv3 = Severity.Debug;
            boolean $i$f$logBlock3 = false;
            if (this_$iv$iv2.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv3) <= 0) {
                throwable = throwable$iv3;
                string2 = tag$iv3;
                severity = severity$iv$iv3;
                var13_15 = this_$iv$iv2;
                boolean bl = false;
                string = "Observer successfully registered";
                var13_15.processLog(severity, string2, throwable, string);
            }
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean isDark() {
        boolean bl;
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID userDefaults = Foundation.invoke((String)"NSUserDefaults", (String)"standardUserDefaults", (Object[])new Object[0]);
            ID styleKey = Foundation.nsString((String)"AppleInterfaceStyle");
            Object[] objectArray = new Object[]{styleKey};
            ID result = Foundation.invoke((ID)userDefaults, (String)"objectForKey:", (Object[])objectArray);
            String styleString = Foundation.toStringViaUTF8((ID)result);
            String string = styleString;
            if (string == null) {
                string = "";
            }
            bl = darkPattern.matcher(string).matches();
        }
        catch (Exception e) {
            void this_$iv$iv;
            void $this$iv;
            Logger result = MacOSThemeDetectorKt.access$getMacLogger$p();
            Throwable throwable$iv = e;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string = tag$iv;
                Severity severity = severity$iv$iv;
                void var12_19 = this_$iv$iv;
                boolean bl2 = false;
                String string2 = "Error reading system theme";
                var12_19.processLog(severity, string, throwable, string2);
            }
            bl = false;
        }
        finally {
            pool.drain();
        }
        return bl;
    }

    public final void registerListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        listeners.add(listener);
    }

    public final void removeListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        listeners.remove(listener);
    }

    private final void notifyListeners(boolean isDark) {
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Consumer it = (Consumer)element$iv;
            boolean bl = false;
            it.accept(isDark);
        }
    }

    private static final Thread callbackExecutor$lambda$0(Runnable r) {
        Thread thread2;
        Thread $this$callbackExecutor_u24lambda_u240_u240 = thread2 = new Thread(r, "MacOS Theme Detector Thread");
        boolean bl = false;
        $this$callbackExecutor_u24lambda_u240_u240.setDaemon(true);
        return thread2;
    }

    public static final /* synthetic */ ExecutorService access$getCallbackExecutor$p() {
        return callbackExecutor;
    }

    public static final /* synthetic */ void access$notifyListeners(MacOSThemeDetector $this, boolean isDark) {
        $this.notifyListeners(isDark);
    }

    static {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        listeners = keySetView;
        Pattern pattern = Pattern.compile(".*dark.*", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        darkPattern = pattern;
        callbackExecutor = Executors.newSingleThreadExecutor(MacOSThemeDetector::callbackExecutor$lambda$0);
        themeChangedCallback = new Callback(){

            public final void callback() {
                MacOSThemeDetector.access$getCallbackExecutor$p().execute(themeChangedCallback.1::callback$lambda$0);
            }

            /*
             * WARNING - void declaration
             */
            private static final void callback$lambda$0() {
                void this_$iv$iv;
                boolean isDark = MacOSThemeDetector.INSTANCE.isDark();
                Logger $this$iv = MacOSThemeDetectorKt.access$getMacLogger$p();
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var9_11 = this_$iv$iv;
                    boolean bl = false;
                    String string2 = "Theme change detected. Dark mode: " + isDark;
                    var9_11.processLog(severity, string, throwable, string2);
                }
                MacOSThemeDetector.access$notifyListeners(MacOSThemeDetector.INSTANCE, isDark);
            }
        };
        INSTANCE.initObserver();
        $stable = 8;
    }
}

