/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.CdrClientConfigKt;
import com.swisscom.health.des.cdr.client.config.Connector;
import com.swisscom.health.des.cdr.client.handler.CdrApiClient;
import com.swisscom.health.des.cdr.client.handler.RetryUploadFileHandlingKt;
import io.micrometer.tracing.Tracer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/RetryUploadFileHandling;", "", "cdrClientConfig", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "tracer", "Lio/micrometer/tracing/Tracer;", "cdrApiClient", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lio/micrometer/tracing/Tracer;Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;)V", "uploadGuard", "Lkotlinx/coroutines/sync/Semaphore;", "uploadRetrying", "", "file", "Ljava/nio/file/Path;", "connector", "Lcom/swisscom/health/des/cdr/client/config/Connector;", "(Ljava/nio/file/Path;Lcom/swisscom/health/des/cdr/client/config/Connector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteOrArchiveFile", "renameFileToErrorAndCreateLogFile", "responseBody", "", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nRetryUploadFileHandling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryUploadFileHandling.kt\ncom/swisscom/health/des/cdr/client/handler/RetryUploadFileHandling\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public class RetryUploadFileHandling {
    @NotNull
    private final CdrClientConfig cdrClientConfig;
    @NotNull
    private final Tracer tracer;
    @NotNull
    private final CdrApiClient cdrApiClient;
    @NotNull
    private final Semaphore uploadGuard;

    public RetryUploadFileHandling(@NotNull CdrClientConfig cdrClientConfig, @NotNull Tracer tracer, @NotNull CdrApiClient cdrApiClient) {
        Intrinsics.checkNotNullParameter((Object)cdrClientConfig, (String)"cdrClientConfig");
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        Intrinsics.checkNotNullParameter((Object)cdrApiClient, (String)"cdrApiClient");
        this.cdrClientConfig = cdrClientConfig;
        this.tracer = tracer;
        this.cdrApiClient = cdrApiClient;
        this.uploadGuard = SemaphoreKt.Semaphore$default((int)this.cdrClientConfig.getPushThreadPoolSize(), (int)0, (int)2, null);
    }

    @Nullable
    public Object uploadRetrying(@NotNull Path file, @NotNull Connector connector, @NotNull Continuation<? super Unit> $completion) {
        return RetryUploadFileHandling.uploadRetrying$suspendImpl(this, file, connector, $completion);
    }

    /*
     * Exception decompiling
     */
    static /* synthetic */ Object uploadRetrying$suspendImpl(RetryUploadFileHandling $this, Path file, Connector connector, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteOrArchiveFile(Path file) {
        Object $this$deleteOrArchiveFile_u24lambda_u240;
        Object object = this;
        try {
            Path path;
            block9: {
                block8: {
                    $this$deleteOrArchiveFile_u24lambda_u240 = object;
                    boolean bl = false;
                    Connector connector = CdrClientConfigKt.getConnectorForSourceFile(((RetryUploadFileHandling)$this$deleteOrArchiveFile_u24lambda_u240).cdrClientConfig.getCustomer(), file);
                    boolean bl2 = false;
                    path = connector.getEffectiveSourceArchiveFolder(file);
                    if (path == null) break block8;
                    Path archiveDir = path;
                    boolean bl3 = false;
                    Path path2 = file;
                    Path path3 = archiveDir.resolve(PathsKt.getNameWithoutExtension((Path)file) + "_" + UUID.randomUUID() + ".xml");
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                    Path path4 = path3;
                    CopyOption[] copyOptionArray = new CopyOption[]{};
                    Path path5 = Files.move(path2, path4, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"move(...)");
                    path = path5;
                    if (path5 != null) break block9;
                }
                Object $this$deleteOrArchiveFile_u24lambda_u240_u240_u241 = $this$deleteOrArchiveFile_u24lambda_u240;
                boolean bl = false;
                if (!Files.deleteIfExists(file)) {
                    RetryUploadFileHandlingKt.access$getLogger$p().warn(() -> RetryUploadFileHandling.deleteOrArchiveFile$lambda$0$0$1$0(file));
                }
                path = Unit.INSTANCE;
            }
            $this$deleteOrArchiveFile_u24lambda_u240 = Result.constructor-impl((Object)path);
        }
        catch (Throwable bl) {
            $this$deleteOrArchiveFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$deleteOrArchiveFile_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            Object it = object;
            boolean bl = false;
        } else {
            Throwable t = throwable;
            boolean bl = false;
            RetryUploadFileHandlingKt.access$getLogger$p().error(() -> RetryUploadFileHandling.deleteOrArchiveFile$lambda$2$0(file, t));
        }
    }

    private void renameFileToErrorAndCreateLogFile(Path file, String responseBody) {
        Object $this$renameFileToErrorAndCreateLogFile_u24lambda_u240;
        Object object = this;
        try {
            $this$renameFileToErrorAndCreateLogFile_u24lambda_u240 = object;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String uuidString = string;
            Path errorFile = file.resolveSibling(PathsKt.getNameWithoutExtension((Path)file) + "_" + uuidString + ".error");
            Path logFile = file.resolveSibling(PathsKt.getNameWithoutExtension((Path)file) + "_" + uuidString + ".response");
            OpenOption[] openOptionArray = file;
            Intrinsics.checkNotNull((Object)errorFile);
            Path path = errorFile;
            Object object2 = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)openOptionArray, path, Arrays.copyOf(object2, ((CopyOption[])object2).length)), (String)"move(...)");
            byte[] byArray = responseBody.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.write(logFile, byArray, openOptionArray);
            Connector connector = CdrClientConfigKt.getConnectorForSourceFile(((RetryUploadFileHandling)$this$renameFileToErrorAndCreateLogFile_u24lambda_u240).cdrClientConfig.getCustomer(), (Path)file);
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)connector.getEffectiveSourceErrorFolder((Path)file), (Object)file.getParent())) {
                Path path2 = errorFile;
                Path path3 = connector.getEffectiveSourceErrorFolder((Path)file).resolve(PathsKt.getName((Path)errorFile));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                object2 = path3;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
                Intrinsics.checkNotNull((Object)logFile);
                path2 = logFile;
                Path path4 = connector.getEffectiveSourceErrorFolder((Path)file).resolve(PathsKt.getName((Path)logFile));
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                object2 = path4;
                copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
            }
            $this$renameFileToErrorAndCreateLogFile_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$renameFileToErrorAndCreateLogFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$renameFileToErrorAndCreateLogFile_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            Unit it = (Unit)object;
            boolean bl = false;
        } else {
            Throwable t = throwable;
            boolean bl = false;
            RetryUploadFileHandlingKt.access$getLogger$p().error(() -> RetryUploadFileHandling.renameFileToErrorAndCreateLogFile$lambda$2$0((Path)file, t));
        }
    }

    private static final Object uploadRetrying$lambda$0(Path $file) {
        return "Uploading file '" + $file + "'";
    }

    private static final Object uploadRetrying$lambda$1$0(Path $uploadFile) {
        return "File '" + $uploadFile.getFileName() + "' successfully synchronized.";
    }

    private static final Object uploadRetrying$lambda$1$1(Path $uploadFile, CdrApiClient.UploadDocumentResult $response) {
        return "File synchronization failed for '" + $uploadFile.getFileName() + "'. Received a 4xx client error (response code: '" + ((CdrApiClient.UploadDocumentResult.UploadClientErrorResponse)$response).getCode() + "'). No retry will be attempted due to client-side issue.";
    }

    private static final Object uploadRetrying$lambda$1$2(Path $uploadFile, RetryUploadFileHandling $this_runCatching, int $retryIndex, CdrApiClient.UploadDocumentResult $response) {
        return "Failed to sync file '" + $uploadFile.getFileName() + "', retry will be attempted in '" + $this_runCatching.cdrClientConfig.getRetryDelay().get($retryIndex) + "' - server response: '" + ((CdrApiClient.UploadDocumentResult.UploadServerErrorResponse)$response).getResponseBody() + "'";
    }

    private static final Object uploadRetrying$lambda$1$3(Path $uploadFile, RetryUploadFileHandling $this_runCatching, int $retryIndex, CdrApiClient.UploadDocumentResult $response) {
        Throwable throwable = ((CdrApiClient.UploadDocumentResult.UploadError)$response).getT();
        return "Failed to sync file '" + $uploadFile.getFileName() + "', retry will be attempted in '" + $this_runCatching.cdrClientConfig.getRetryDelay().get($retryIndex) + "' - exception message: '" + (throwable != null ? throwable.getMessage() : null) + "'";
    }

    private static final Object uploadRetrying$lambda$1$4(Ref.IntRef $retryCount, Path $uploadFile) {
        return "Retry attempt '#" + $retryCount.element + "' for file '" + $uploadFile.getFileName() + "'";
    }

    private static final Object uploadRetrying$lambda$2$0(Path $uploadFile) {
        return "Upload of file '" + $uploadFile.getFileName() + "' done.";
    }

    private static final Object uploadRetrying$lambda$3$0$0(Path $uploadFile, Path $file) {
        return "Upload of file '" + $uploadFile.getFileName() + "' was cancelled due to shutdown, renaming it to original name '" + $file + "' for a future upload.";
    }

    private static final Object uploadRetrying$lambda$3$1$0(Path $uploadFile) {
        return "Upload of file '" + $uploadFile.getFileName() + "' has failed.";
    }

    private static final Object deleteOrArchiveFile$lambda$0$0$1$0(Path $file) {
        return "Tried to delete the file '" + $file + "' but it was already gone";
    }

    private static final Object deleteOrArchiveFile$lambda$2$0(Path $file, Throwable $t) {
        return "Error during handling of successful upload of '" + $file + "': '" + $t + "'";
    }

    private static final Object renameFileToErrorAndCreateLogFile$lambda$2$0(Path $file, Throwable $t) {
        return "Error during handling of failed upload of '" + $file + "': '" + $t + "'";
    }
}

