/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.handler.ConfigValidationService;
import com.swisscom.health.des.cdr.client.handler.ConfigurationWriter;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\rH\u0013J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\f\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0010\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/SchedulingValidationService;", "", "configValidationService", "Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;", "environment", "Lorg/springframework/core/env/Environment;", "configurationWriter", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;", "currentConfig", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "<init>", "(Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;Lorg/springframework/core/env/Environment;Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;)V", "isSchedulingAllowed", "", "()Z", "isSchedulingAllowed$delegate", "Lkotlin/Lazy;", "isConfigSourceUnambiguous", "isConfigSourceUnambiguous$delegate", "isConfigFromOneSource", "isWriteableConfigurationUnambiguous", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nSchedulingValidationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchedulingValidationService.kt\ncom/swisscom/health/des/cdr/client/handler/SchedulingValidationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n2746#2,3:36\n*S KotlinDebug\n*F\n+ 1 SchedulingValidationService.kt\ncom/swisscom/health/des/cdr/client/handler/SchedulingValidationService\n*L\n33#1:36,3\n*E\n"})
public class SchedulingValidationService {
    @NotNull
    private final ConfigValidationService configValidationService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ConfigurationWriter configurationWriter;
    @NotNull
    private final CdrClientConfig currentConfig;
    @NotNull
    private final Lazy isSchedulingAllowed$delegate;
    @NotNull
    private final Lazy isConfigSourceUnambiguous$delegate;

    public SchedulingValidationService(@NotNull ConfigValidationService configValidationService, @NotNull Environment environment, @NotNull ConfigurationWriter configurationWriter, @NotNull CdrClientConfig currentConfig) {
        Intrinsics.checkNotNullParameter((Object)configValidationService, (String)"configValidationService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)configurationWriter, (String)"configurationWriter");
        Intrinsics.checkNotNullParameter((Object)currentConfig, (String)"currentConfig");
        this.configValidationService = configValidationService;
        this.environment = environment;
        this.configurationWriter = configurationWriter;
        this.currentConfig = currentConfig;
        this.isSchedulingAllowed$delegate = LazyKt.lazy(() -> SchedulingValidationService.isSchedulingAllowed_delegate$lambda$0(this));
        this.isConfigSourceUnambiguous$delegate = LazyKt.lazy(() -> SchedulingValidationService.isConfigSourceUnambiguous_delegate$lambda$0(this));
    }

    public boolean isSchedulingAllowed() {
        Lazy lazy = this.isSchedulingAllowed$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean isConfigSourceUnambiguous() {
        Lazy lazy = this.isConfigSourceUnambiguous$delegate;
        return (Boolean)lazy.getValue();
    }

    @PostConstruct
    private boolean isConfigFromOneSource() {
        String[] stringArray = this.environment.getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        List activeProfiles = ArraysKt.toList((Object[])stringArray);
        return !activeProfiles.contains("test") ? this.isWriteableConfigurationUnambiguous() : true;
    }

    public boolean isWriteableConfigurationUnambiguous() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.configurationWriter.collectUpdatableConfigurationItems$cdr_client_service(this.currentConfig, this.currentConfig);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConfigurationWriter.UpdatableConfigurationItem it = (ConfigurationWriter.UpdatableConfigurationItem)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ConfigurationWriter.UpdatableConfigurationItem.AmbiguousWritableSource)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isSchedulingAllowed_delegate$lambda$0(SchedulingValidationService this$0) {
        return this$0.isConfigSourceUnambiguous() && this$0.configValidationService.isConfigValid();
    }

    private static final boolean isConfigSourceUnambiguous_delegate$lambda$0(SchedulingValidationService this$0) {
        return this$0.isConfigFromOneSource();
    }
}

