/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.http;

import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.OAuth2AuthNService;
import com.swisscom.health.des.cdr.client.handler.ConfigValidationService;
import com.swisscom.health.des.cdr.client.handler.SchedulingValidationService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0011\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017J\b\u0010\u000f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/swisscom/health/des/cdr/client/http/HealthIndicators;", "", "config", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "configValidationService", "Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;", "schedulingValidationService", "Lcom/swisscom/health/des/cdr/client/handler/SchedulingValidationService;", "authNService", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;Lcom/swisscom/health/des/cdr/client/handler/SchedulingValidationService;Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService;)V", "fileSynchronizationHealthIndicator", "Lorg/springframework/boot/actuate/health/HealthIndicator;", "configHealthIndicator", "authNHealthIndicator", "Companion", "cdr-client-service"})
public class HealthIndicators {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CdrClientConfig config;
    @NotNull
    private final ConfigValidationService configValidationService;
    @NotNull
    private final SchedulingValidationService schedulingValidationService;
    @NotNull
    private final OAuth2AuthNService authNService;
    @NotNull
    public static final String FILE_SYNCHRONIZATION_INDICATOR_NAME = "fileSynchronization";
    @NotNull
    public static final String FILE_SYNCHRONIZATION_STATUS_ENABLED = "ENABLED";
    @NotNull
    public static final String FILE_SYNCHRONIZATION_STATUS_DISABLED = "DISABLED";
    @NotNull
    public static final String CONFIG_INDICATOR_NAME = "config";
    @NotNull
    public static final String CONFIG_BROKEN = "BROKEN";
    @NotNull
    public static final String CONFIG_ERROR = "ERROR";
    @NotNull
    public static final String CONFIG_OK = "OK";
    @NotNull
    public static final String AUTHN_INDICATOR_NAME = "authN";
    @NotNull
    public static final String AUTHN_AUTHENTICATED = "AUTHENTICATED";
    @NotNull
    public static final String AUTHN_UNAUTHENTICATED = "UNAUTHENTICATED";
    @NotNull
    public static final String AUTHN_DENIED = "DENIED";
    @NotNull
    public static final String AUTHN_COMMUNICATION_ERROR = "COMMUNICATION_ERROR";
    @NotNull
    public static final String AUTHN_UNKNOWN_ERROR = "UNKNOWN_ERROR";

    public HealthIndicators(@NotNull CdrClientConfig config, @NotNull ConfigValidationService configValidationService, @NotNull SchedulingValidationService schedulingValidationService, @NotNull OAuth2AuthNService authNService) {
        Intrinsics.checkNotNullParameter((Object)config, (String)CONFIG_INDICATOR_NAME);
        Intrinsics.checkNotNullParameter((Object)configValidationService, (String)"configValidationService");
        Intrinsics.checkNotNullParameter((Object)schedulingValidationService, (String)"schedulingValidationService");
        Intrinsics.checkNotNullParameter((Object)authNService, (String)"authNService");
        this.config = config;
        this.configValidationService = configValidationService;
        this.schedulingValidationService = schedulingValidationService;
        this.authNService = authNService;
    }

    @Bean
    @NotNull
    public HealthIndicator fileSynchronizationHealthIndicator() {
        return () -> HealthIndicators.fileSynchronizationHealthIndicator$lambda$0(this);
    }

    @Bean
    @NotNull
    public HealthIndicator configHealthIndicator() {
        return () -> HealthIndicators.configHealthIndicator$lambda$0(this);
    }

    @Bean
    @NotNull
    public HealthIndicator authNHealthIndicator() {
        return () -> HealthIndicators.authNHealthIndicator$lambda$0(this);
    }

    private static final Health fileSynchronizationHealthIndicator$lambda$0(HealthIndicators this$0) {
        Health.Builder builder;
        boolean bl = this$0.config.getFileSynchronizationEnabled-lBXH3Wg();
        if (bl) {
            builder = Health.status((String)FILE_SYNCHRONIZATION_STATUS_ENABLED);
        } else if (!bl) {
            builder = Health.status((String)FILE_SYNCHRONIZATION_STATUS_DISABLED);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return builder.build();
    }

    private static final Health configHealthIndicator$lambda$0(HealthIndicators this$0) {
        return (!this$0.schedulingValidationService.isConfigSourceUnambiguous() ? Health.status((String)CONFIG_BROKEN).withDetail("configStatus", (Object)"ambiguous config source") : (!this$0.configValidationService.isConfigValid() ? Health.status((String)CONFIG_ERROR).withDetail("configStatus", (Object)"invalid config") : Health.status((String)CONFIG_OK).withDetail("configStatus", (Object)"valid config"))).build();
    }

    private static final Health authNHealthIndicator$lambda$0(HealthIndicators this$0) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this$0.authNService.currentAuthNStateNonBlocking$cdr_client_service().ordinal()]) {
            case 1 -> Health.status((String)AUTHN_UNAUTHENTICATED).withDetail("authNState", (Object)"no login attempted").build();
            case 2 -> Health.status((String)AUTHN_AUTHENTICATED).withDetail("authNState", (Object)"JWT obtained").build();
            case 3 -> Health.status((String)AUTHN_DENIED).withDetail("authNState", (Object)"wrong credentials or IdP coordinates").build();
            case 4 -> Health.status((String)AUTHN_COMMUNICATION_ERROR).withDetail("authNState", (Object)"io error (recoverable)").build();
            case 5 -> Health.status((String)AUTHN_UNKNOWN_ERROR).withDetail("authNState", (Object)"unrecoverable error").build();
            case 6 -> Health.status((String)AUTHN_UNKNOWN_ERROR).withDetail("authNState", (Object)"connection or other issue").build();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/swisscom/health/des/cdr/client/http/HealthIndicators$Companion;", "", "<init>", "()V", "FILE_SYNCHRONIZATION_INDICATOR_NAME", "", "FILE_SYNCHRONIZATION_STATUS_ENABLED", "FILE_SYNCHRONIZATION_STATUS_DISABLED", "CONFIG_INDICATOR_NAME", "CONFIG_BROKEN", "CONFIG_ERROR", "CONFIG_OK", "AUTHN_INDICATOR_NAME", "AUTHN_AUTHENTICATED", "AUTHN_UNAUTHENTICATED", "AUTHN_DENIED", "AUTHN_COMMUNICATION_ERROR", "AUTHN_UNKNOWN_ERROR", "cdr-client-service"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OAuth2AuthNService.AuthNState.values().length];
            try {
                nArray[OAuth2AuthNService.AuthNState.UNAUTHENTICATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OAuth2AuthNService.AuthNState.AUTHENTICATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OAuth2AuthNService.AuthNState.DENIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OAuth2AuthNService.AuthNState.RETRYABLE_FAILURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OAuth2AuthNService.AuthNState.FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OAuth2AuthNService.AuthNState.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

