/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.lib.linux;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kdroid.composetray.lib.linux.X11;
import com.kdroid.composetray.utils.TrayPositionKt;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import io.github.kdroidfilter.platformtools.OperatingSystem;
import io.github.kdroidfilter.platformtools.OsProvider_jvmKt;
import java.awt.Point;
import java.awt.Window;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00162\u00060\u0001j\u0002`\u0002:\u0001\u0016B%\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0002J\u0006\u0010\u0014\u001a\u00020\u0007J\b\u0010\u0015\u001a\u00020\u0007H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/kdroid/composetray/lib/linux/LinuxOutsideClickWatcher;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "windowSupplier", "Lkotlin/Function0;", "Ljava/awt/Window;", "onOutsideClick", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "prevLeft", "", "display", "Lcom/sun/jna/Pointer;", "rootWindow", "Lcom/sun/jna/NativeLong;", "start", "pollOnce", "stop", "close", "Companion", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLinuxOutsideClickWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxOutsideClickWatcher.kt\ncom/kdroid/composetray/lib/linux/LinuxOutsideClickWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class LinuxOutsideClickWatcher
implements AutoCloseable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Window> windowSupplier;
    @NotNull
    private final Function0<Unit> onOutsideClick;
    @Nullable
    private ScheduledExecutorService scheduler;
    private boolean prevLeft;
    @Nullable
    private Pointer display;
    @NotNull
    private NativeLong rootWindow;
    public static final int $stable = 8;
    private static final int BUTTON1_MASK = 256;

    public LinuxOutsideClickWatcher(@NotNull Function0<? extends Window> windowSupplier, @NotNull Function0<Unit> onOutsideClick) {
        Intrinsics.checkNotNullParameter(windowSupplier, (String)"windowSupplier");
        Intrinsics.checkNotNullParameter(onOutsideClick, (String)"onOutsideClick");
        this.windowSupplier = windowSupplier;
        this.onOutsideClick = onOutsideClick;
        this.rootWindow = new NativeLong(0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void exec;
        ScheduledExecutorService scheduledExecutorService;
        if (OsProvider_jvmKt.getOperatingSystem() != OperatingSystem.LINUX) {
            return;
        }
        if (this.scheduler != null) {
            return;
        }
        try {
            X11 x11 = X11.Companion.getINSTANCE();
            this.display = x11.XOpenDisplay(null);
            if (this.display == null) {
                return;
            }
            this.rootWindow = x11.XDefaultRootWindow(this.display);
        }
        catch (Throwable throwable) {
            this.display = null;
            return;
        }
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(LinuxOutsideClickWatcher::start$lambda$0);
        LinuxOutsideClickWatcher linuxOutsideClickWatcher = this;
        boolean bl = false;
        exec.scheduleAtFixedRate(() -> LinuxOutsideClickWatcher.start$lambda$1$0(this), 0L, 16L, TimeUnit.MILLISECONDS);
        linuxOutsideClickWatcher.scheduler = scheduledExecutorService;
    }

    private final void pollOnce() {
        Pointer pointer = this.display;
        if (pointer == null) {
            return;
        }
        Pointer dpy = pointer;
        try {
            Window win;
            boolean left;
            boolean ok;
            X11 x11 = X11.Companion.getINSTANCE();
            NativeLongByReference rootRet = new NativeLongByReference();
            NativeLongByReference childRet = new NativeLongByReference();
            IntByReference rootX = new IntByReference();
            IntByReference rootY = new IntByReference();
            IntByReference winX = new IntByReference();
            IntByReference winY = new IntByReference();
            IntByReference mask = new IntByReference();
            boolean bl = ok = x11.XQueryPointer(dpy, this.rootWindow, rootRet, childRet, rootX, rootY, winX, winY, mask) != 0;
            if (!ok) {
                return;
            }
            boolean bl2 = left = (mask.getValue() & 0x100) != 0;
            if (left && left != this.prevLeft && (win = (Window)this.windowSupplier.invoke()) != null && win.isShowing()) {
                Point point;
                int px = rootX.getValue();
                int py = rootY.getValue();
                try {
                    point = win.getLocationOnScreen();
                }
                catch (Throwable throwable) {
                    point = null;
                }
                Point winLoc = point;
                if (winLoc != null) {
                    boolean bl3;
                    int wx = winLoc.x;
                    int wy = winLoc.y;
                    int ww = win.getWidth();
                    int wh = win.getHeight();
                    boolean insideWindow = px >= wx && px < wx + ww && py >= wy && py < wy + wh;
                    try {
                        bl3 = TrayPositionKt.isPointWithinLinuxStatusItem(px, py);
                    }
                    catch (Throwable throwable) {
                        bl3 = false;
                    }
                    boolean onTrayIcon = bl3;
                    if (!insideWindow && !onTrayIcon) {
                        this.onOutsideClick.invoke();
                    }
                }
            }
            this.prevLeft = left;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void stop() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            ScheduledExecutorService scheduledExecutorService = this.scheduler;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.scheduler = null;
        try {
            Pointer pointer = this.display;
            if (pointer != null) {
                Pointer it = pointer;
                boolean bl = false;
                X11.Companion.getINSTANCE().XCloseDisplay(it);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.display = null;
            this.rootWindow = new NativeLong(0L);
        }
    }

    private static final Thread start$lambda$0(Runnable r) {
        Thread thread;
        Thread $this$start_u24lambda_u240_u240 = thread = new Thread(r, "LinuxOutsideClickWatcher");
        boolean bl = false;
        $this$start_u24lambda_u240_u240.setDaemon(true);
        return thread;
    }

    private static final void start$lambda$1$0(LinuxOutsideClickWatcher this$0) {
        this$0.pollOnce();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/kdroid/composetray/lib/linux/LinuxOutsideClickWatcher$Companion;", "", "<init>", "()V", "BUTTON1_MASK", "", "ComposeNativeTray"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

