/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.lib.linux;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kdroid.composetray.lib.linux.LinuxLibTray;
import com.kdroid.composetray.lib.linux.LinuxTrayManager;
import com.kdroid.composetray.utils.DebugLnKt;
import com.kdroid.composetray.utils.TrayClickTracker;
import com.kdroid.composetray.utils.TrayPosition;
import com.kdroid.composetray.utils.TrayPositionKt;
import com.sun.jna.ptr.IntByReference;
import io.github.kdroidfilter.platformtools.LinuxDesktopEnvironment;
import io.github.kdroidfilter.platformtools.LinuxEnvironmentKt;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\f\b\u0001\u0018\u0000 ;2\u00020\u0001:\u0002;<B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010 \u001a\u00020!H\u0002J\u000e\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001bJ\u0016\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020!J6\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u000101J\u0006\u00102\u001a\u00020\bJ\u0006\u00103\u001a\u00020\bJ\u0010\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0003H\u0002J\b\u00106\u001a\u00020\bH\u0002J\u001f\u00107\u001a\u00020\b2\b\u00108\u001a\u0004\u0018\u00010\u001e2\u0006\u00109\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/kdroid/composetray/lib/linux/LinuxTrayManager;", "", "instanceId", "", "iconPath", "tooltip", "onLeftClick", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "cbReady", "Lcom/kdroid/composetray/lib/linux/LinuxLibTray$VoidCallback;", "cbExit", "cbOnClick", "cbOnRClick", "cbOnMenuItem", "Lcom/kdroid/composetray/lib/linux/LinuxLibTray$MenuItemCallback;", "go", "Lcom/kdroid/composetray/lib/linux/LinuxLibTray;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "permitHeld", "menuItems", "", "Lcom/kdroid/composetray/lib/linux/LinuxTrayManager$MenuItem;", "idByTitle", "", "", "actionById", "isKDEDesktop", "", "shutdownHook", "Ljava/lang/Thread;", "loopThread", "exitLatch", "Ljava/util/concurrent/CountDownLatch;", "addMenuItem", "menuItem", "updateMenuItemCheckedState", "label", "isChecked", "update", "newIconPath", "newTooltip", "newOnLeftClick", "newMenuItems", "", "startTray", "stopTray", "setIconFromFileSafe", "path", "rebuildMenu", "addMenuItemRecursive", "parentId", "item", "(Ljava/lang/Integer;Lcom/kdroid/composetray/lib/linux/LinuxTrayManager$MenuItem;)V", "Companion", "MenuItem", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLinuxTrayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxTrayManager.kt\ncom/kdroid/composetray/lib/linux/LinuxTrayManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1#2:328\n360#3,7:329\n1869#3,2:336\n1869#3,2:338\n*S KotlinDebug\n*F\n+ 1 LinuxTrayManager.kt\ncom/kdroid/composetray/lib/linux/LinuxTrayManager\n*L\n78#1:329,7\n277#1:336,2\n320#1:338,2\n*E\n"})
public final class LinuxTrayManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String instanceId;
    @NotNull
    private String iconPath;
    @NotNull
    private String tooltip;
    @Nullable
    private Function0<Unit> onLeftClick;
    @Nullable
    private LinuxLibTray.VoidCallback cbReady;
    @Nullable
    private LinuxLibTray.VoidCallback cbExit;
    @Nullable
    private LinuxLibTray.VoidCallback cbOnClick;
    @Nullable
    private LinuxLibTray.VoidCallback cbOnRClick;
    @Nullable
    private LinuxLibTray.MenuItemCallback cbOnMenuItem;
    @NotNull
    private final LinuxLibTray go;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final AtomicBoolean permitHeld;
    @NotNull
    private final List<MenuItem> menuItems;
    @NotNull
    private final Map<String, Integer> idByTitle;
    @NotNull
    private final Map<Integer, Function0<Unit>> actionById;
    @Nullable
    private Thread shutdownHook;
    @Nullable
    private Thread loopThread;
    @Nullable
    private CountDownLatch exitLatch;
    public static final int $stable = 8;
    @NotNull
    private static final Semaphore lifecyclePermit = new Semaphore(1, true);

    public LinuxTrayManager(@NotNull String instanceId, @NotNull String iconPath, @NotNull String tooltip, @Nullable Function0<Unit> onLeftClick) {
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Intrinsics.checkNotNullParameter((Object)iconPath, (String)"iconPath");
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        this.instanceId = instanceId;
        this.iconPath = iconPath;
        this.tooltip = tooltip;
        this.onLeftClick = onLeftClick;
        this.go = LinuxLibTray.INSTANCE;
        this.lock = new ReentrantLock();
        this.running = new AtomicBoolean(false);
        this.permitHeld = new AtomicBoolean(false);
        this.menuItems = new ArrayList();
        this.idByTitle = new LinkedHashMap();
        this.actionById = new LinkedHashMap();
    }

    public /* synthetic */ LinuxTrayManager(String string2, String string3, String string4, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string4 = "";
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        this(string2, string3, string4, (Function0<Unit>)function0);
    }

    private final boolean isKDEDesktop() {
        return LinuxEnvironmentKt.detectLinuxDesktopEnvironment() == LinuxDesktopEnvironment.KDE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMenuItem(@NotNull MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"menuItem");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.menuItems.add(menuItem);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateMenuItemCheckedState(@NotNull String label, boolean isChecked) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean fallback = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            block13: {
                Integer id;
                int idx;
                block12: {
                    int n;
                    boolean bl = false;
                    List<MenuItem> $this$indexOfFirst$iv = this.menuItems;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator<MenuItem> iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        MenuItem item$iv;
                        MenuItem it = item$iv = iterator.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it.getText(), (Object)label)) {
                            n = index$iv;
                            break block12;
                        }
                        ++index$iv;
                    }
                    n = idx = -1;
                }
                if (idx != -1) {
                    MenuItem current = this.menuItems.get(idx);
                    this.menuItems.set(idx, MenuItem.copy$default(current, null, false, false, isChecked, null, null, null, 119, null));
                }
                if ((id = this.idByTitle.get(label)) != null) {
                    try {
                        if (isChecked) {
                            LinuxLibTray.Systray_MenuItem_Check(id);
                            break block13;
                        }
                        LinuxLibTray.Systray_MenuItem_Uncheck(id);
                    }
                    catch (Throwable throwable) {
                        fallback = true;
                    }
                } else {
                    fallback = true;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (fallback) {
            this.rebuildMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(@NotNull String newIconPath, @NotNull String newTooltip, @Nullable Function0<Unit> newOnLeftClick, @Nullable List<MenuItem> newMenuItems) {
        Intrinsics.checkNotNullParameter((Object)newIconPath, (String)"newIconPath");
        Intrinsics.checkNotNullParameter((Object)newTooltip, (String)"newTooltip");
        boolean iconChanged = false;
        boolean tooltipChanged = false;
        Object object = this.lock;
        object.lock();
        try {
            boolean bl = false;
            if (!this.running.get()) {
                return;
            }
            iconChanged = !Intrinsics.areEqual((Object)this.iconPath, (Object)newIconPath);
            tooltipChanged = !Intrinsics.areEqual((Object)this.tooltip, (Object)newTooltip);
            this.iconPath = newIconPath;
            this.tooltip = newTooltip;
            this.onLeftClick = newOnLeftClick;
            if (newMenuItems != null) {
                this.menuItems.clear();
                this.menuItems.addAll((Collection<MenuItem>)newMenuItems);
            }
            Unit $i$a$-withLock-LinuxTrayManager$update$2 = Unit.INSTANCE;
        }
        finally {
            object.unlock();
        }
        if (iconChanged) {
            this.setIconFromFileSafe(this.iconPath);
        }
        if (tooltipChanged) {
            Object object2;
            object = this;
            try {
                LinuxTrayManager $this$update_u24lambda_u241 = (LinuxTrayManager)object;
                boolean bl = false;
                LinuxLibTray.Systray_SetTooltip($this$update_u24lambda_u241.tooltip);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object e = object2 = throwable;
                boolean bl = false;
                DebugLnKt.warnln((Function0<String>)((Function0)() -> LinuxTrayManager.update$lambda$2$0((Throwable)e)));
            }
        }
        if (newMenuItems != null) {
            this.rebuildMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void startTray() {
        boolean started;
        block49: {
            try {
                lifecyclePermit.acquire();
                this.permitHeld.set(true);
            }
            catch (Throwable t) {
                DebugLnKt.warnln((Function0<String>)((Function0)() -> LinuxTrayManager.startTray$lambda$0(t)));
                return;
            }
            started = false;
            if (this.running.compareAndSet(false, true)) break block49;
            lifecyclePermit.release();
            this.permitHeld.set(false);
            this.running.set(false);
            try {
                LinuxLibTray.Systray_NativeEnd();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread thread = this.loopThread;
                if (thread != null) {
                    thread.join(500L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.loopThread = null;
            this.exitLatch = null;
            try {
                Boolean bl;
                Thread thread = this.shutdownHook;
                if (thread != null) {
                    Thread it = thread;
                    boolean bl2 = false;
                    bl = Runtime.getRuntime().removeShutdownHook(it);
                } else {
                    bl = null;
                }
                Boolean bl3 = bl;
            }
            catch (Throwable throwable) {
                Unit unit = Unit.INSTANCE;
            }
            this.shutdownHook = null;
            if (this.permitHeld.compareAndSet(true, false)) {
                try {
                    lifecyclePermit.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            Object $this$startTray_u24lambda_u246;
            Object $this$startTray_u24lambda_u245;
            void $this$startTray_u24lambda_u244;
            Thread it;
            Thread thread = new Thread(() -> LinuxTrayManager.startTray$lambda$1(this));
            Object throwable = thread;
            LinuxTrayManager linuxTrayManager = this;
            boolean $i$a$-also-LinuxTrayManager$startTray$42 = false;
            Runtime.getRuntime().addShutdownHook(it);
            linuxTrayManager.shutdownHook = thread;
            CountDownLatch readyLatch = new CountDownLatch(1);
            this.exitLatch = new CountDownLatch(1);
            this.cbReady = new LinuxLibTray.VoidCallback(readyLatch){
                final /* synthetic */ CountDownLatch $readyLatch;
                {
                    this.$readyLatch = $readyLatch;
                }

                public void invoke() {
                    DebugLnKt.infoln((Function0<String>)((Function0)startTray.4::invoke$lambda$0));
                    this.$readyLatch.countDown();
                }

                private static final String invoke$lambda$0() {
                    return "[LinuxGoTrayManager] systray ready";
                }
            };
            this.cbExit = new LinuxLibTray.VoidCallback(this){
                final /* synthetic */ LinuxTrayManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke() {
                    DebugLnKt.infoln((Function0<String>)((Function0)startTray.5::invoke$lambda$0));
                    try {
                        CountDownLatch countDownLatch = LinuxTrayManager.access$getExitLatch$p(this.this$0);
                        if (countDownLatch != null) {
                            countDownLatch.countDown();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                private static final String invoke$lambda$0() {
                    return "[LinuxGoTrayManager] systray exit";
                }
            };
            this.cbOnClick = new LinuxLibTray.VoidCallback(this){
                final /* synthetic */ LinuxTrayManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke() {
                    block4: {
                        try {
                            Dimension dimension;
                            IntByReference xRef = new IntByReference();
                            IntByReference yRef = new IntByReference();
                            LinuxTrayManager.access$getGo$p(this.this$0);
                            LinuxLibTray.Systray_GetLastClickXY(xRef, yRef);
                            int x = xRef.getValue();
                            int y = yRef.getValue();
                            try {
                                dimension = Toolkit.getDefaultToolkit().getScreenSize();
                            }
                            catch (Throwable throwable) {
                                dimension = new Dimension(0, 0);
                            }
                            Dimension screen = dimension;
                            TrayPosition pos = TrayPositionKt.convertPositionToCorner(x, y, screen.width, screen.height);
                            TrayClickTracker.INSTANCE.setClickPosition(x, y, pos);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Function0 function0 = LinuxTrayManager.access$getOnLeftClick$p(this.this$0);
                        if (function0 == null) break block4;
                        function0.invoke();
                    }
                }
            };
            this.cbOnRClick = new LinuxLibTray.VoidCallback(){

                public void invoke() {
                }
            };
            this.cbOnMenuItem = new LinuxLibTray.MenuItemCallback(this){
                final /* synthetic */ LinuxTrayManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke(int menuId) {
                    block0: {
                        Function0 function0 = (Function0)LinuxTrayManager.access$getActionById$p(this.this$0).get(menuId);
                        if (function0 == null) break block0;
                        function0.invoke();
                    }
                }
            };
            LinuxLibTray.Systray_InitCallbacks(this.cbReady, this.cbExit, this.cbOnClick, this.cbOnRClick, this.cbOnMenuItem);
            LinuxLibTray.Systray_PrepareExternalLoop();
            Thread $i$a$-also-LinuxTrayManager$startTray$42 = it = new Thread(() -> LinuxTrayManager.startTray$lambda$3(this), "LinuxGoTray-Loop");
            linuxTrayManager = this;
            boolean bl = false;
            $this$startTray_u24lambda_u244.setDaemon(true);
            $this$startTray_u24lambda_u244.start();
            linuxTrayManager.loopThread = it;
            try {
                readyLatch.await();
            }
            catch (InterruptedException <unused var>2) {
                Thread.currentThread().interrupt();
            }
            throwable = this;
            try {
                $this$startTray_u24lambda_u245 = (LinuxTrayManager)throwable;
                boolean bl4 = false;
                LinuxLibTray.Systray_SetTitle("Compose Tray");
                $this$startTray_u24lambda_u245 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl4) {
                $this$startTray_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
            }
            this.setIconFromFileSafe(this.iconPath);
            throwable = this;
            try {
                $this$startTray_u24lambda_u246 = (LinuxTrayManager)throwable;
                boolean bl5 = false;
                LinuxLibTray.Systray_SetTooltip(((LinuxTrayManager)$this$startTray_u24lambda_u246).tooltip);
                $this$startTray_u24lambda_u246 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl5) {
                $this$startTray_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
            }
            this.rebuildMenu();
            started = true;
        }
        catch (Throwable t) {
            Unit unit;
            try {
                DebugLnKt.errorln((Function0<String>)((Function0)() -> LinuxTrayManager.startTray$lambda$7(t)));
            }
            catch (Throwable throwable) {
                this.running.set(false);
                try {
                    LinuxLibTray.Systray_NativeEnd();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    Thread thread = this.loopThread;
                    if (thread != null) {
                        thread.join(500L);
                    }
                }
                catch (Throwable it) {
                    // empty catch block
                }
                this.loopThread = null;
                this.exitLatch = null;
                try {
                    Boolean bl;
                    Thread thread = this.shutdownHook;
                    if (thread != null) {
                        Thread it = thread;
                        boolean bl6 = false;
                        bl = Runtime.getRuntime().removeShutdownHook(it);
                    } else {
                        bl = null;
                    }
                    Boolean bl7 = bl;
                }
                catch (Throwable throwable3) {
                    Unit unit2 = Unit.INSTANCE;
                }
                this.shutdownHook = null;
                if (this.permitHeld.compareAndSet(true, false)) {
                    try {
                        lifecyclePermit.release();
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            this.running.set(false);
            try {
                LinuxLibTray.Systray_NativeEnd();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Thread thread = this.loopThread;
                if (thread != null) {
                    thread.join(500L);
                }
            }
            catch (Throwable <unused var>2) {
                // empty catch block
            }
            this.loopThread = null;
            this.exitLatch = null;
            try {
                Boolean bl;
                Thread thread = this.shutdownHook;
                if (thread != null) {
                    Thread it = thread;
                    boolean bl8 = false;
                    bl = Runtime.getRuntime().removeShutdownHook(it);
                } else {
                    bl = null;
                }
                unit = bl;
            }
            catch (Throwable throwable) {
                unit = Unit.INSTANCE;
            }
            this.shutdownHook = null;
            if (this.permitHeld.compareAndSet(true, false)) {
                try {
                    lifecyclePermit.release();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public final void stopTray() {
        Unit unit;
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        CountDownLatch latch = this.exitLatch;
        try {
            LinuxLibTray.Systray_Quit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            LinuxLibTray.Systray_NativeEnd();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CountDownLatch countDownLatch = latch;
            if (countDownLatch != null) {
                countDownLatch.await(150L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Thread thread = this.loopThread;
            if (thread != null) {
                thread.join(500L);
            }
            Thread thread2 = this.loopThread;
            boolean bl = thread2 != null ? thread2.isAlive() : false;
            if (bl) {
                DebugLnKt.warnln((Function0<String>)((Function0)LinuxTrayManager::stopTray$lambda$0));
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.loopThread = null;
        this.exitLatch = null;
        this.idByTitle.clear();
        this.actionById.clear();
        try {
            Boolean bl;
            Thread thread = this.shutdownHook;
            if (thread != null) {
                Thread it = thread;
                boolean bl2 = false;
                bl = Runtime.getRuntime().removeShutdownHook(it);
            } else {
                bl = null;
            }
            unit = bl;
        }
        catch (Throwable throwable) {
            unit = Unit.INSTANCE;
        }
        this.shutdownHook = null;
        if (this.permitHeld.compareAndSet(true, false)) {
            try {
                lifecyclePermit.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final void setIconFromFileSafe(String path) {
        block4: {
            Object object;
            Object object2 = this;
            try {
                LinuxTrayManager $this$setIconFromFileSafe_u24lambda_u240 = object2;
                boolean bl = false;
                File file = new File(path);
                if (file.isFile()) {
                    byte[] bytes = FilesKt.readBytes((File)file);
                    LinuxLibTray.Systray_SetIcon(bytes, bytes.length);
                } else {
                    DebugLnKt.warnln((Function0<String>)((Function0)() -> LinuxTrayManager.setIconFromFileSafe$lambda$0$0(path)));
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object e = object = throwable;
            boolean bl = false;
            DebugLnKt.warnln((Function0<String>)((Function0)() -> LinuxTrayManager.setIconFromFileSafe$lambda$1$0(path, (Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rebuildMenu() {
        List $i$a$-withLock-LinuxTrayManager$rebuildMenu$items$22;
        Object $this$rebuildMenu_u24lambda_u241;
        DebugLnKt.infoln((Function0<String>)((Function0)LinuxTrayManager::rebuildMenu$lambda$0));
        this.idByTitle.clear();
        this.actionById.clear();
        LinuxTrayManager linuxTrayManager = this;
        try {
            $this$rebuildMenu_u24lambda_u241 = linuxTrayManager;
            boolean bl = false;
            LinuxLibTray.Systray_ResetMenu();
            $this$rebuildMenu_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$rebuildMenu_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        $this$rebuildMenu_u24lambda_u241 = this.lock;
        $this$rebuildMenu_u24lambda_u241.lock();
        try {
            boolean $i$a$-withLock-LinuxTrayManager$rebuildMenu$items$22 = false;
            $i$a$-withLock-LinuxTrayManager$rebuildMenu$items$22 = CollectionsKt.toList((Iterable)this.menuItems);
        }
        finally {
            $this$rebuildMenu_u24lambda_u241.unlock();
        }
        List items = $i$a$-withLock-LinuxTrayManager$rebuildMenu$items$22;
        List effectiveItems = items.isEmpty() && this.isKDEDesktop() ? CollectionsKt.listOf((Object)new MenuItem("-", false, false, false, null, null, null, 126, null)) : items;
        Iterable $this$forEach$iv = effectiveItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MenuItem it = (MenuItem)element$iv;
            boolean bl = false;
            this.addMenuItemRecursive(null, it);
        }
    }

    private final void addMenuItemRecursive(Integer parentId, MenuItem item) {
        try {
            if (Intrinsics.areEqual((Object)item.getText(), (Object)"-")) {
                if (parentId == null) {
                    LinuxLibTray.Systray_AddSeparator();
                } else {
                    Object $this$addMenuItemRecursive_u24lambda_u240;
                    Object object = this;
                    try {
                        $this$addMenuItemRecursive_u24lambda_u240 = object;
                        boolean bl = false;
                        LinuxLibTray.Systray_AddSubMenuSeparator(parentId);
                        $this$addMenuItemRecursive_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        $this$addMenuItemRecursive_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = $this$addMenuItemRecursive_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        $this$addMenuItemRecursive_u24lambda_u240 = throwable;
                        boolean bl = false;
                        int id = LinuxLibTray.Systray_AddSubMenuItem(parentId, "-", null);
                        LinuxLibTray.Systray_MenuItem_Disable(id);
                    }
                    Result.box-impl((Object)object);
                }
                return;
            }
            int id = parentId == null ? (item.isCheckable() ? LinuxLibTray.Systray_AddMenuItemCheckbox(item.getText(), null, item.isChecked() ? 1 : 0) : LinuxLibTray.Systray_AddMenuItem(item.getText(), null)) : (item.isCheckable() ? LinuxLibTray.Systray_AddSubMenuItemCheckbox(parentId, item.getText(), null, item.isChecked() ? 1 : 0) : LinuxLibTray.Systray_AddSubMenuItem(parentId, item.getText(), null));
            this.idByTitle.put(item.getText(), id);
            Function0<Unit> function0 = item.getOnClick();
            if (function0 != null) {
                Function0<Unit> it = function0;
                boolean bl = false;
                this.actionById.put(id, it);
            }
            if (item.isEnabled()) {
                LinuxLibTray.Systray_MenuItem_Enable(id);
            } else {
                LinuxLibTray.Systray_MenuItem_Disable(id);
            }
            String string2 = item.getIconPath();
            if (string2 != null) {
                Object $this$addMenuItemRecursive_u24lambda_u243_u240;
                String iconPath = string2;
                boolean bl = false;
                Object object = this;
                try {
                    byte[] bytes;
                    File file;
                    $this$addMenuItemRecursive_u24lambda_u243_u240 = object;
                    boolean bl2 = false;
                    File it = file = new File(iconPath);
                    boolean bl3 = false;
                    File file2 = it.isFile() ? file : null;
                    Object object2 = bytes = (Object)(file2 != null ? FilesKt.readBytes((File)file2) : null);
                    if (bytes != null) {
                        LinuxLibTray.Systray_SetMenuItemIcon(bytes, bytes.length, id);
                    }
                    $this$addMenuItemRecursive_u24lambda_u243_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl2) {
                    $this$addMenuItemRecursive_u24lambda_u243_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object = $this$addMenuItemRecursive_u24lambda_u243_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    Object e = $this$addMenuItemRecursive_u24lambda_u243_u240 = throwable;
                    boolean bl4 = false;
                    DebugLnKt.warnln((Function0<String>)((Function0)() -> LinuxTrayManager.addMenuItemRecursive$lambda$3$1$0((Throwable)e)));
                }
                Result.box-impl((Object)object);
            }
            if (!((Collection)item.getSubMenuItems()).isEmpty()) {
                Iterable $this$forEach$iv = item.getSubMenuItems();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MenuItem sub = (MenuItem)element$iv;
                    boolean bl = false;
                    this.addMenuItemRecursive(id, sub);
                }
            }
        }
        catch (Throwable t) {
            DebugLnKt.errorln((Function0<String>)((Function0)() -> LinuxTrayManager.addMenuItemRecursive$lambda$5(item, t)));
        }
    }

    private static final String update$lambda$2$0(Throwable $e) {
        return "[LinuxGoTrayManager] Failed to set tooltip: " + $e.getMessage();
    }

    private static final String startTray$lambda$0(Throwable $t) {
        return "[LinuxGoTrayManager] Failed to acquire lifecycle permit: " + $t.getMessage();
    }

    private static final void startTray$lambda$1(LinuxTrayManager this$0) {
        this$0.stopTray();
    }

    private static final void startTray$lambda$3(LinuxTrayManager this$0) {
        try {
            LinuxLibTray.Systray_NativeStart();
        }
        catch (Throwable t) {
            DebugLnKt.errorln((Function0<String>)((Function0)() -> LinuxTrayManager.startTray$lambda$3$0(t)));
        }
    }

    private static final String startTray$lambda$3$0(Throwable $t) {
        return "[LinuxGoTrayManager] loop error: " + $t;
    }

    private static final String startTray$lambda$7(Throwable $t) {
        return "[LinuxGoTrayManager] startTray failed: " + $t;
    }

    private static final String stopTray$lambda$0() {
        return "[LinuxGoTrayManager] loop thread still alive after join timeout";
    }

    private static final String setIconFromFileSafe$lambda$0$0(String $path) {
        return "[LinuxGoTrayManager] Icon file not found: " + $path;
    }

    private static final String setIconFromFileSafe$lambda$1$0(String $path, Throwable $e) {
        return "[LinuxGoTrayManager] Failed to set icon from " + $path + ": " + $e.getMessage();
    }

    private static final String rebuildMenu$lambda$0() {
        return "[LinuxGoTrayManager] Rebuilding menu";
    }

    private static final String addMenuItemRecursive$lambda$3$1$0(Throwable $e) {
        return "[LinuxGoTrayManager] Failed to set menu item icon: " + $e.getMessage();
    }

    private static final String addMenuItemRecursive$lambda$5(MenuItem $item, Throwable $t) {
        return "[LinuxGoTrayManager] Error adding menu item '" + $item.getText() + "': " + $t;
    }

    public static final /* synthetic */ CountDownLatch access$getExitLatch$p(LinuxTrayManager $this) {
        return $this.exitLatch;
    }

    public static final /* synthetic */ LinuxLibTray access$getGo$p(LinuxTrayManager $this) {
        return $this.go;
    }

    public static final /* synthetic */ Function0 access$getOnLeftClick$p(LinuxTrayManager $this) {
        return $this.onLeftClick;
    }

    public static final /* synthetic */ Map access$getActionById$p(LinuxTrayManager $this) {
        return $this.actionById;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/kdroid/composetray/lib/linux/LinuxTrayManager$Companion;", "", "<init>", "()V", "lifecyclePermit", "Ljava/util/concurrent/Semaphore;", "ComposeNativeTray"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\rH\u00c6\u0003J_\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\rH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/kdroid/composetray/lib/linux/LinuxTrayManager$MenuItem;", "", "text", "", "isEnabled", "", "isCheckable", "isChecked", "iconPath", "onClick", "Lkotlin/Function0;", "", "subMenuItems", "", "<init>", "(Ljava/lang/String;ZZZLjava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "()Z", "getIconPath", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "getSubMenuItems", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "ComposeNativeTray"})
    @StabilityInferred(parameters=0)
    public static final class MenuItem {
        @NotNull
        private final String text;
        private final boolean isEnabled;
        private final boolean isCheckable;
        private final boolean isChecked;
        @Nullable
        private final String iconPath;
        @Nullable
        private final Function0<Unit> onClick;
        @NotNull
        private final List<MenuItem> subMenuItems;
        public static final int $stable = 8;

        public MenuItem(@NotNull String text, boolean isEnabled, boolean isCheckable, boolean isChecked, @Nullable String iconPath, @Nullable Function0<Unit> onClick, @NotNull List<MenuItem> subMenuItems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(subMenuItems, (String)"subMenuItems");
            this.text = text;
            this.isEnabled = isEnabled;
            this.isCheckable = isCheckable;
            this.isChecked = isChecked;
            this.iconPath = iconPath;
            this.onClick = onClick;
            this.subMenuItems = subMenuItems;
        }

        public /* synthetic */ MenuItem(String string2, boolean bl, boolean bl2, boolean bl3, String string3, Function0 function0, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                bl3 = false;
            }
            if ((n & 0x10) != 0) {
                string3 = null;
            }
            if ((n & 0x20) != 0) {
                function0 = null;
            }
            if ((n & 0x40) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string2, bl, bl2, bl3, string3, (Function0<Unit>)function0, list);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final boolean isCheckable() {
            return this.isCheckable;
        }

        public final boolean isChecked() {
            return this.isChecked;
        }

        @Nullable
        public final String getIconPath() {
            return this.iconPath;
        }

        @Nullable
        public final Function0<Unit> getOnClick() {
            return this.onClick;
        }

        @NotNull
        public final List<MenuItem> getSubMenuItems() {
            return this.subMenuItems;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final boolean component2() {
            return this.isEnabled;
        }

        public final boolean component3() {
            return this.isCheckable;
        }

        public final boolean component4() {
            return this.isChecked;
        }

        @Nullable
        public final String component5() {
            return this.iconPath;
        }

        @Nullable
        public final Function0<Unit> component6() {
            return this.onClick;
        }

        @NotNull
        public final List<MenuItem> component7() {
            return this.subMenuItems;
        }

        @NotNull
        public final MenuItem copy(@NotNull String text, boolean isEnabled, boolean isCheckable, boolean isChecked, @Nullable String iconPath, @Nullable Function0<Unit> onClick, @NotNull List<MenuItem> subMenuItems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(subMenuItems, (String)"subMenuItems");
            return new MenuItem(text, isEnabled, isCheckable, isChecked, iconPath, onClick, subMenuItems);
        }

        public static /* synthetic */ MenuItem copy$default(MenuItem menuItem, String string2, boolean bl, boolean bl2, boolean bl3, String string3, Function0 function0, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = menuItem.text;
            }
            if ((n & 2) != 0) {
                bl = menuItem.isEnabled;
            }
            if ((n & 4) != 0) {
                bl2 = menuItem.isCheckable;
            }
            if ((n & 8) != 0) {
                bl3 = menuItem.isChecked;
            }
            if ((n & 0x10) != 0) {
                string3 = menuItem.iconPath;
            }
            if ((n & 0x20) != 0) {
                function0 = menuItem.onClick;
            }
            if ((n & 0x40) != 0) {
                list = menuItem.subMenuItems;
            }
            return menuItem.copy(string2, bl, bl2, bl3, string3, function0, list);
        }

        @NotNull
        public String toString() {
            return "MenuItem(text=" + this.text + ", isEnabled=" + this.isEnabled + ", isCheckable=" + this.isCheckable + ", isChecked=" + this.isChecked + ", iconPath=" + this.iconPath + ", onClick=" + this.onClick + ", subMenuItems=" + this.subMenuItems + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + Boolean.hashCode(this.isEnabled);
            result = result * 31 + Boolean.hashCode(this.isCheckable);
            result = result * 31 + Boolean.hashCode(this.isChecked);
            result = result * 31 + (this.iconPath == null ? 0 : this.iconPath.hashCode());
            result = result * 31 + (this.onClick == null ? 0 : this.onClick.hashCode());
            result = result * 31 + ((Object)this.subMenuItems).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MenuItem)) {
                return false;
            }
            MenuItem menuItem = (MenuItem)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)menuItem.text)) {
                return false;
            }
            if (this.isEnabled != menuItem.isEnabled) {
                return false;
            }
            if (this.isCheckable != menuItem.isCheckable) {
                return false;
            }
            if (this.isChecked != menuItem.isChecked) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.iconPath, (Object)menuItem.iconPath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onClick, menuItem.onClick)) {
                return false;
            }
            return Intrinsics.areEqual(this.subMenuItems, menuItem.subMenuItems);
        }
    }
}

