/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.lib.windows;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kdroid.composetray.lib.windows.StdCallCallback;
import com.kdroid.composetray.lib.windows.WindowsNativeTray;
import com.kdroid.composetray.lib.windows.WindowsNativeTrayLibrary;
import com.kdroid.composetray.lib.windows.WindowsNativeTrayMenuItem;
import com.kdroid.composetray.utils.DebugLnKt;
import com.kdroid.composetray.utils.TrayClickTracker;
import com.kdroid.composetray.utils.TrayPosition;
import com.kdroid.composetray.utils.TrayPositionKt;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0001\u0018\u0000 ;2\u00020\u0001:\u0003;<=B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010%\u001a\u00020\b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J4\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020(0'J\b\u0010.\u001a\u00020\bH\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u00101\u001a\u00020\bH\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u0010)\u001a\u00020\"H\u0002J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\rH\u0002J\u001e\u00105\u001a\u00020\b2\u0006\u00104\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0018\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020(H\u0002J\b\u00109\u001a\u00020\bH\u0002J\u0006\u0010:\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/kdroid/composetray/lib/windows/WindowsTrayManager;", "", "instanceId", "", "iconPath", "tooltip", "onLeftClick", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "tray", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/kdroid/composetray/lib/windows/WindowsNativeTray;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "initialized", "updateLock", "Ljava/util/concurrent/locks/ReentrantLock;", "initLatch", "Ljava/util/concurrent/CountDownLatch;", "callbackReferences", "", "Lcom/sun/jna/win32/StdCallLibrary$StdCallCallback;", "nativeMenuItemsReferences", "Lcom/kdroid/composetray/lib/windows/WindowsNativeTrayMenuItem;", "trayCallback", "Lcom/kdroid/composetray/lib/windows/WindowsNativeTray$TrayCallback;", "trayThread", "Ljava/lang/Thread;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "ioScope", "updateQueue", "Lcom/kdroid/composetray/lib/windows/WindowsTrayManager$UpdateRequest;", "updateQueueLock", "Ljava/lang/Object;", "initialize", "menuItems", "", "Lcom/kdroid/composetray/lib/windows/WindowsTrayManager$MenuItem;", "update", "newIconPath", "newTooltip", "newOnLeftClick", "newMenuItems", "runMessageLoop", "safeGetTrayPosition", "", "processUpdateQueue", "performUpdate", "setupLeftClickCallback", "trayObj", "setupMenu", "initializeNativeMenuItem", "nativeItem", "menuItem", "cleanupTray", "stopTray", "Companion", "UpdateRequest", "MenuItem", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWindowsTrayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsTrayManager.kt\ncom/kdroid/composetray/lib/windows/WindowsTrayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,490:1\n1878#2,3:491\n1878#2,3:494\n*S KotlinDebug\n*F\n+ 1 WindowsTrayManager.kt\ncom/kdroid/composetray/lib/windows/WindowsTrayManager\n*L\n360#1:491,3\n420#1:494,3\n*E\n"})
public final class WindowsTrayManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String instanceId;
    @NotNull
    private String iconPath;
    @NotNull
    private String tooltip;
    @Nullable
    private Function0<Unit> onLeftClick;
    @NotNull
    private AtomicReference<WindowsNativeTray> tray;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final ReentrantLock updateLock;
    @NotNull
    private final CountDownLatch initLatch;
    @NotNull
    private final List<StdCallLibrary.StdCallCallback> callbackReferences;
    @NotNull
    private final List<WindowsNativeTrayMenuItem> nativeMenuItemsReferences;
    @Nullable
    private WindowsNativeTray.TrayCallback trayCallback;
    @Nullable
    private Thread trayThread;
    @Nullable
    private CoroutineScope mainScope;
    @Nullable
    private CoroutineScope ioScope;
    @NotNull
    private final List<UpdateRequest> updateQueue;
    @NotNull
    private final Object updateQueueLock;
    public static final int $stable = 8;

    public WindowsTrayManager(@NotNull String instanceId, @NotNull String iconPath, @NotNull String tooltip, @Nullable Function0<Unit> onLeftClick) {
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Intrinsics.checkNotNullParameter((Object)iconPath, (String)"iconPath");
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        this.instanceId = instanceId;
        this.iconPath = iconPath;
        this.tooltip = tooltip;
        this.onLeftClick = onLeftClick;
        this.tray = new AtomicReference<Object>(null);
        this.running = new AtomicBoolean(false);
        this.initialized = new AtomicBoolean(false);
        this.updateLock = new ReentrantLock();
        this.initLatch = new CountDownLatch(1);
        this.callbackReferences = new ArrayList();
        this.nativeMenuItemsReferences = new ArrayList();
        this.updateQueue = new ArrayList();
        this.updateQueueLock = new Object();
    }

    public /* synthetic */ WindowsTrayManager(String string2, String string3, String string4, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string4 = "";
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        this(string2, string3, string4, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void initialize(@NotNull List<MenuItem> menuItems) {
        Intrinsics.checkNotNullParameter(menuItems, (String)"menuItems");
        WindowsTrayManager.Companion.log("initialize() called with " + menuItems.size() + " menu items");
        Lock lock = this.updateLock;
        lock.lock();
        try {
            void $this$initialize_u24lambda_u240_u241;
            Thread thread;
            boolean bl = false;
            if (this.initialized.get()) {
                WindowsTrayManager.Companion.log("Already initialized, delegating to update()");
                this.update(this.iconPath, this.tooltip, this.onLeftClick, menuItems);
                return;
            }
            this.running.set(true);
            this.mainScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
            this.ioScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
            Thread thread2 = thread = new Thread(() -> WindowsTrayManager.initialize$lambda$0$0(this, menuItems));
            WindowsTrayManager windowsTrayManager = this;
            boolean bl2 = false;
            $this$initialize_u24lambda_u240_u241.setName("WindowsTray-Thread");
            $this$initialize_u24lambda_u240_u241.setDaemon(false);
            $this$initialize_u24lambda_u240_u241.start();
            windowsTrayManager.trayThread = thread;
            try {
                this.initLatch.await();
            }
            catch (InterruptedException e) {
                WindowsTrayManager.Companion.log("Interrupted while waiting for initialization");
                e.printStackTrace();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(@NotNull String newIconPath, @NotNull String newTooltip, @Nullable Function0<Unit> newOnLeftClick, @NotNull List<MenuItem> newMenuItems) {
        Intrinsics.checkNotNullParameter((Object)newIconPath, (String)"newIconPath");
        Intrinsics.checkNotNullParameter((Object)newTooltip, (String)"newTooltip");
        Intrinsics.checkNotNullParameter(newMenuItems, (String)"newMenuItems");
        WindowsTrayManager.Companion.log("update() called - icon: " + newIconPath + ", tooltip: " + newTooltip + ", menuItems: " + newMenuItems.size());
        if (!this.initialized.get()) {
            WindowsTrayManager.Companion.log("Not initialized, calling initialize()");
            this.iconPath = newIconPath;
            this.tooltip = newTooltip;
            this.onLeftClick = newOnLeftClick;
            this.initialize(newMenuItems);
            return;
        }
        Object object = this.updateQueueLock;
        synchronized (object) {
            boolean bl = false;
            this.updateQueue.add(new UpdateRequest(newIconPath, newTooltip, newOnLeftClick, newMenuItems));
            this.updateQueueLock.notify();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void runMessageLoop() {
        WindowsTrayManager.Companion.log("Entering message loop on tray thread");
        int consecutiveErrors = 0;
        boolean initialPosCaptured = false;
        int initialPosAttempts = 0;
        boolean positionErrorCount = false;
        int maxPositionErrors = 3;
        block8: while (this.running.get()) {
            try {
                if (!initialPosCaptured && initialPosAttempts < 60) {
                    ++initialPosAttempts;
                    if (this.safeGetTrayPosition(this.instanceId)) {
                        initialPosCaptured = true;
                        WindowsTrayManager.Companion.log("Captured initial tray icon position");
                    }
                }
                this.processUpdateQueue();
                int result = WindowsNativeTrayLibrary.tray_loop(0);
                switch (result) {
                    case -1: {
                        WindowsTrayManager.Companion.log("tray_loop returned -1 (error or quit)");
                        if (!this.running.get() || !this.initialized.get()) break block8;
                        if (++consecutiveErrors > 5) {
                            WindowsTrayManager.Companion.log("Too many consecutive errors, exiting loop");
                            break block8;
                        }
                        Thread.sleep(100L);
                        WindowsNativeTray currentTray = this.tray.get();
                        if (currentTray == null) break;
                        try {
                            WindowsTrayManager.Companion.log("Attempting to recover tray...");
                            WindowsNativeTrayLibrary.tray_update(currentTray);
                            consecutiveErrors = 0;
                        }
                        catch (Exception e) {
                            WindowsTrayManager.Companion.log("Failed to recover: " + e.getMessage());
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 0: {
                        consecutiveErrors = 0;
                        break;
                    }
                    default: {
                        WindowsTrayManager.Companion.log("tray_loop returned unexpected value: " + result);
                        consecutiveErrors = 0;
                    }
                }
                Thread.sleep(50L);
            }
            catch (Exception e) {
                WindowsTrayManager.Companion.log("Exception in message loop: " + e.getMessage());
                if (!this.running.get()) break;
                e.printStackTrace();
                Thread.sleep(100L);
            }
        }
        WindowsTrayManager.Companion.log("Message loop ended");
    }

    private final boolean safeGetTrayPosition(String instanceId) {
        boolean bl;
        try {
            boolean bl2;
            boolean precise;
            IntByReference xRef = new IntByReference();
            IntByReference yRef = new IntByReference();
            boolean bl3 = precise = WindowsNativeTrayLibrary.tray_get_notification_icons_position(xRef, yRef) != 0;
            if (precise) {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                TrayPosition corner = TrayPositionKt.convertPositionToCorner(xRef.getValue(), yRef.getValue(), screen.width, screen.height);
                TrayClickTracker.INSTANCE.setClickPosition(instanceId, xRef.getValue(), yRef.getValue(), corner);
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Error e) {
            WindowsTrayManager.Companion.log("Failed to get tray icon position (memory access error): " + e.getMessage());
            bl = false;
        }
        catch (Exception e) {
            WindowsTrayManager.Companion.log("Failed to get tray icon position: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processUpdateQueue() {
        UpdateRequest updateRequest;
        Object object = this.updateQueueLock;
        synchronized (object) {
            boolean bl = false;
            updateRequest = !((Collection)this.updateQueue).isEmpty() ? this.updateQueue.remove(0) : null;
        }
        UpdateRequest update = updateRequest;
        if (update != null) {
            WindowsTrayManager.Companion.log("Processing update from queue");
            this.performUpdate(update);
        }
    }

    private final void performUpdate(UpdateRequest update) {
        WindowsNativeTray windowsNativeTray;
        this.iconPath = update.getIconPath();
        this.tooltip = update.getTooltip();
        this.onLeftClick = update.getOnLeftClick();
        int oldCallbackCount = this.callbackReferences.size();
        this.callbackReferences.clear();
        this.nativeMenuItemsReferences.clear();
        WindowsTrayManager.Companion.log("Cleared " + oldCallbackCount + " old callbacks");
        WindowsNativeTray $this$performUpdate_u24lambda_u240 = windowsNativeTray = new WindowsNativeTray();
        boolean bl = false;
        $this$performUpdate_u24lambda_u240.icon_filepath = update.getIconPath();
        $this$performUpdate_u24lambda_u240.tooltip = update.getTooltip();
        WindowsNativeTray newTray = windowsNativeTray;
        this.setupLeftClickCallback(newTray);
        this.setupMenu(newTray, update.getMenuItems());
        WindowsTrayManager.Companion.log("Calling tray_update()");
        try {
            WindowsNativeTrayLibrary.tray_update(newTray);
            WindowsTrayManager.Companion.log("tray_update() completed");
        }
        catch (Error e) {
            WindowsTrayManager.Companion.log("Failed to update tray (memory access error): " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            WindowsTrayManager.Companion.log("Failed to update tray: " + e.getMessage());
            e.printStackTrace();
        }
        this.tray.set(newTray);
    }

    private final void setupLeftClickCallback(WindowsNativeTray trayObj) {
        WindowsNativeTray.TrayCallback trayCallback;
        if (this.onLeftClick != null) {
            WindowsTrayManager.Companion.log("Setting up left click callback");
            trayCallback = new WindowsNativeTray.TrayCallback(this){
                final /* synthetic */ WindowsTrayManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke(WindowsNativeTray tray) {
                    Intrinsics.checkNotNullParameter((Object)((Object)tray), (String)"tray");
                    com.kdroid.composetray.lib.windows.WindowsTrayManager$Companion.access$log(WindowsTrayManager.Companion, "Left click callback invoked");
                    try {
                        WindowsTrayManager.access$safeGetTrayPosition(this.this$0, WindowsTrayManager.access$getInstanceId$p(this.this$0));
                        CoroutineScope coroutineScope = WindowsTrayManager.access$getMainScope$p(this.this$0);
                        if (coroutineScope != null) {
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ WindowsTrayManager this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope coroutineScope = WindowsTrayManager.access$getIoScope$p(this.this$0);
                                            if (coroutineScope != null) {
                                                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                    int label;
                                                    final /* synthetic */ WindowsTrayManager this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(2, $completion);
                                                    }

                                                    public final Object invokeSuspend(Object $result) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                Function0 function0 = WindowsTrayManager.access$getOnLeftClick$p(this.this$0);
                                                                if (function0 != null) {
                                                                    function0.invoke();
                                                                }
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (int)3, null);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                    }
                    catch (Exception e) {
                        com.kdroid.composetray.lib.windows.WindowsTrayManager$Companion.access$log(WindowsTrayManager.Companion, "Error in left click callback: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            };
        } else {
            WindowsTrayManager.Companion.log("No left click callback set");
            trayCallback = null;
        }
        trayObj.cb = this.trayCallback = trayCallback;
        if (this.trayCallback != null) {
            WindowsNativeTray.TrayCallback trayCallback2 = this.trayCallback;
            Intrinsics.checkNotNull((Object)trayCallback2);
            this.callbackReferences.add(trayCallback2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupMenu(WindowsNativeTray trayObj, List<MenuItem> menuItems) {
        if (menuItems.isEmpty()) {
            WindowsTrayManager.Companion.log("No menu items to set up");
            trayObj.menu = null;
            return;
        }
        WindowsTrayManager.Companion.log("Setting up " + menuItems.size() + " menu items");
        WindowsNativeTrayMenuItem menuItemPrototype = new WindowsNativeTrayMenuItem();
        Structure[] structureArray = menuItemPrototype.toArray(menuItems.size() + 1);
        Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.kdroid.composetray.lib.windows.WindowsNativeTrayMenuItem>");
        WindowsNativeTrayMenuItem[] nativeMenuItems = (WindowsNativeTrayMenuItem[])structureArray;
        Iterable $this$forEachIndexed$iv = menuItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MenuItem menuItem = (MenuItem)item$iv;
            int index = n;
            boolean bl = false;
            WindowsNativeTrayMenuItem nativeItem = nativeMenuItems[index];
            this.initializeNativeMenuItem(nativeItem, (MenuItem)item);
            nativeItem.write();
            this.nativeMenuItemsReferences.add(nativeItem);
        }
        nativeMenuItems[menuItems.size()].text = null;
        nativeMenuItems[menuItems.size()].write();
        trayObj.menu = nativeMenuItems[0].getPointer();
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeNativeMenuItem(WindowsNativeTrayMenuItem nativeItem, MenuItem menuItem) {
        nativeItem.text = menuItem.getText();
        nativeItem.icon_path = menuItem.getIconPath();
        nativeItem.disabled = menuItem.isEnabled() ? 0 : 1;
        nativeItem.checked = menuItem.isChecked() ? 1 : 0;
        Function0<Unit> function0 = menuItem.getOnClick();
        if (function0 != null) {
            Function0<Unit> onClick = function0;
            boolean bl = false;
            StdCallCallback callback2 = new StdCallCallback(menuItem, this, onClick){
                final /* synthetic */ MenuItem $menuItem;
                final /* synthetic */ WindowsTrayManager this$0;
                final /* synthetic */ Function0<Unit> $onClick;
                {
                    this.$menuItem = $menuItem;
                    this.this$0 = $receiver;
                    this.$onClick = $onClick;
                }

                public void invoke(WindowsNativeTrayMenuItem item) {
                    Intrinsics.checkNotNullParameter((Object)((Object)item), (String)"item");
                    com.kdroid.composetray.lib.windows.WindowsTrayManager$Companion.access$log(WindowsTrayManager.Companion, "Menu item clicked: " + this.$menuItem.getText());
                    try {
                        WindowsTrayManager.access$safeGetTrayPosition(this.this$0, WindowsTrayManager.access$getInstanceId$p(this.this$0));
                        if (WindowsTrayManager.access$getRunning$p(this.this$0).get()) {
                            CoroutineScope coroutineScope = WindowsTrayManager.access$getMainScope$p(this.this$0);
                            if (coroutineScope != null) {
                                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$onClick, this.$menuItem, null){
                                    int label;
                                    final /* synthetic */ WindowsTrayManager this$0;
                                    final /* synthetic */ Function0<Unit> $onClick;
                                    final /* synthetic */ MenuItem $menuItem;
                                    {
                                        this.this$0 = $receiver;
                                        this.$onClick = $onClick;
                                        this.$menuItem = $menuItem;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                CoroutineScope coroutineScope = WindowsTrayManager.access$getIoScope$p(this.this$0);
                                                if (coroutineScope != null) {
                                                    BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onClick, this.$menuItem, this.this$0, null){
                                                        int label;
                                                        final /* synthetic */ Function0<Unit> $onClick;
                                                        final /* synthetic */ MenuItem $menuItem;
                                                        final /* synthetic */ WindowsTrayManager this$0;
                                                        {
                                                            this.$onClick = $onClick;
                                                            this.$menuItem = $menuItem;
                                                            this.this$0 = $receiver;
                                                            super(2, $completion);
                                                        }

                                                        /*
                                                         * WARNING - Removed try catching itself - possible behaviour change.
                                                         */
                                                        public final Object invokeSuspend(Object $result) {
                                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                            switch (this.label) {
                                                                case 0: {
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    this.$onClick.invoke();
                                                                    if (this.$menuItem.isCheckable()) {
                                                                        Object object = WindowsTrayManager.access$getUpdateQueueLock$p(this.this$0);
                                                                        synchronized (object) {
                                                                            boolean bl = false;
                                                                            Unit unit = Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    return Unit.INSTANCE;
                                                                }
                                                            }
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                        }

                                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (int)3, null);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        }
                    }
                    catch (Exception e) {
                        com.kdroid.composetray.lib.windows.WindowsTrayManager$Companion.access$log(WindowsTrayManager.Companion, "Error in menu item callback: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            };
            nativeItem.cb = callback2;
            this.callbackReferences.add(callback2);
        }
        if (!((Collection)menuItem.getSubMenuItems()).isEmpty()) {
            WindowsNativeTrayMenuItem subMenuPrototype = new WindowsNativeTrayMenuItem();
            Structure[] structureArray = subMenuPrototype.toArray(menuItem.getSubMenuItems().size() + 1);
            Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.kdroid.composetray.lib.windows.WindowsNativeTrayMenuItem>");
            WindowsNativeTrayMenuItem[] subMenuItemsArray = (WindowsNativeTrayMenuItem[])structureArray;
            Iterable $this$forEachIndexed$iv = menuItem.getSubMenuItems();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void subItem;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                MenuItem menuItem2 = (MenuItem)item$iv;
                int index = n;
                boolean bl = false;
                this.initializeNativeMenuItem(subMenuItemsArray[index], (MenuItem)subItem);
                subMenuItemsArray[index].write();
                this.nativeMenuItemsReferences.add(subMenuItemsArray[index]);
            }
            subMenuItemsArray[menuItem.getSubMenuItems().size()].text = null;
            subMenuItemsArray[menuItem.getSubMenuItems().size()].write();
            nativeItem.submenu = subMenuItemsArray[0].getPointer();
        }
    }

    private final void cleanupTray() {
        if (this.initialized.get()) {
            try {
                WindowsTrayManager.Companion.log("Calling tray_exit()");
                WindowsNativeTrayLibrary.tray_exit();
            }
            catch (Error e) {
                WindowsTrayManager.Companion.log("Error in tray_exit() (memory access): " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                WindowsTrayManager.Companion.log("Error in tray_exit(): " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.callbackReferences.clear();
        this.nativeMenuItemsReferences.clear();
        this.trayCallback = null;
        this.tray.set(null);
        this.initialized.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopTray() {
        WindowsTrayManager.Companion.log("stopTray() called");
        Lock lock = this.updateLock;
        lock.lock();
        try {
            boolean bl = false;
            this.running.set(false);
            Object object = this.updateQueueLock;
            synchronized (object) {
                boolean $i$a$-synchronized-WindowsTrayManager$stopTray$1$22 = false;
                this.updateQueueLock.notify();
                Unit $i$a$-synchronized-WindowsTrayManager$stopTray$1$22 = Unit.INSTANCE;
            }
            Thread thread = this.trayThread;
            if (thread != null) {
                Thread thread2 = thread;
                boolean bl2 = false;
                try {
                    thread2.join(5000L);
                    if (thread2.isAlive()) {
                        WindowsTrayManager.Companion.log("Tray thread still alive after 5 seconds, interrupting");
                        thread2.interrupt();
                    }
                }
                catch (InterruptedException e) {
                    WindowsTrayManager.Companion.log("Interrupted while waiting for tray thread");
                    e.printStackTrace();
                }
            }
            CoroutineScope coroutineScope = this.mainScope;
            if (coroutineScope != null) {
                CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
            }
            CoroutineScope coroutineScope2 = this.ioScope;
            if (coroutineScope2 != null) {
                CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope2, null, (int)1, null);
            }
            this.mainScope = null;
            this.ioScope = null;
            this.trayThread = null;
            WindowsTrayManager.Companion.log("Tray stopped and cleaned up");
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initialize$lambda$0$0(WindowsTrayManager this$0, List $menuItems) {
        try {
            WindowsNativeTray windowsNativeTray;
            WindowsTrayManager.Companion.log("Tray thread started");
            WindowsNativeTray $this$initialize_u24lambda_u240_u240_u240 = windowsNativeTray = new WindowsNativeTray();
            boolean bl = false;
            $this$initialize_u24lambda_u240_u240_u240.icon_filepath = this$0.iconPath;
            $this$initialize_u24lambda_u240_u240_u240.tooltip = this$0.tooltip;
            WindowsNativeTray newTray = windowsNativeTray;
            this$0.setupLeftClickCallback(newTray);
            this$0.setupMenu(newTray, $menuItems);
            WindowsTrayManager.Companion.log("Calling tray_init() on tray thread");
            int initResult = WindowsNativeTrayLibrary.tray_init(newTray);
            WindowsTrayManager.Companion.log("tray_init() returned: " + initResult);
            if (initResult != 0) {
                throw new RuntimeException("Failed to initialize tray: " + initResult);
            }
            this$0.tray.set(newTray);
            this$0.initialized.set(true);
            this$0.initLatch.countDown();
            this$0.runMessageLoop();
        }
        catch (Exception e) {
            WindowsTrayManager.Companion.log("Error in tray thread: " + e.getMessage());
            e.printStackTrace();
            this$0.initLatch.countDown();
        }
        finally {
            this$0.cleanupTray();
        }
    }

    public static final /* synthetic */ boolean access$safeGetTrayPosition(WindowsTrayManager $this, String instanceId) {
        return $this.safeGetTrayPosition(instanceId);
    }

    public static final /* synthetic */ String access$getInstanceId$p(WindowsTrayManager $this) {
        return $this.instanceId;
    }

    public static final /* synthetic */ CoroutineScope access$getMainScope$p(WindowsTrayManager $this) {
        return $this.mainScope;
    }

    public static final /* synthetic */ CoroutineScope access$getIoScope$p(WindowsTrayManager $this) {
        return $this.ioScope;
    }

    public static final /* synthetic */ Function0 access$getOnLeftClick$p(WindowsTrayManager $this) {
        return $this.onLeftClick;
    }

    public static final /* synthetic */ AtomicBoolean access$getRunning$p(WindowsTrayManager $this) {
        return $this.running;
    }

    public static final /* synthetic */ Object access$getUpdateQueueLock$p(WindowsTrayManager $this) {
        return $this.updateQueueLock;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/kdroid/composetray/lib/windows/WindowsTrayManager$Companion;", "", "<init>", "()V", "log", "", "message", "", "ComposeNativeTray"})
    public static final class Companion {
        private Companion() {
        }

        private final void log(String message) {
            DebugLnKt.debugln((Function0<String>)((Function0)() -> Companion.log$lambda$0(message)));
        }

        private static final String log$lambda$0(String $message) {
            return "[WindowsTrayManager] " + $message;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\rH\u00c6\u0003J_\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\rH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/kdroid/composetray/lib/windows/WindowsTrayManager$MenuItem;", "", "text", "", "iconPath", "isEnabled", "", "isCheckable", "isChecked", "onClick", "Lkotlin/Function0;", "", "subMenuItems", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZZLkotlin/jvm/functions/Function0;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "getIconPath", "()Z", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "getSubMenuItems", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "ComposeNativeTray"})
    @StabilityInferred(parameters=0)
    public static final class MenuItem {
        @NotNull
        private final String text;
        @Nullable
        private final String iconPath;
        private final boolean isEnabled;
        private final boolean isCheckable;
        private final boolean isChecked;
        @Nullable
        private final Function0<Unit> onClick;
        @NotNull
        private final List<MenuItem> subMenuItems;
        public static final int $stable = 8;

        public MenuItem(@NotNull String text, @Nullable String iconPath, boolean isEnabled, boolean isCheckable, boolean isChecked, @Nullable Function0<Unit> onClick, @NotNull List<MenuItem> subMenuItems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(subMenuItems, (String)"subMenuItems");
            this.text = text;
            this.iconPath = iconPath;
            this.isEnabled = isEnabled;
            this.isCheckable = isCheckable;
            this.isChecked = isChecked;
            this.onClick = onClick;
            this.subMenuItems = subMenuItems;
        }

        public /* synthetic */ MenuItem(String string2, String string3, boolean bl, boolean bl2, boolean bl3, Function0 function0, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                function0 = null;
            }
            if ((n & 0x40) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string2, string3, bl, bl2, bl3, (Function0<Unit>)function0, list);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getIconPath() {
            return this.iconPath;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final boolean isCheckable() {
            return this.isCheckable;
        }

        public final boolean isChecked() {
            return this.isChecked;
        }

        @Nullable
        public final Function0<Unit> getOnClick() {
            return this.onClick;
        }

        @NotNull
        public final List<MenuItem> getSubMenuItems() {
            return this.subMenuItems;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @Nullable
        public final String component2() {
            return this.iconPath;
        }

        public final boolean component3() {
            return this.isEnabled;
        }

        public final boolean component4() {
            return this.isCheckable;
        }

        public final boolean component5() {
            return this.isChecked;
        }

        @Nullable
        public final Function0<Unit> component6() {
            return this.onClick;
        }

        @NotNull
        public final List<MenuItem> component7() {
            return this.subMenuItems;
        }

        @NotNull
        public final MenuItem copy(@NotNull String text, @Nullable String iconPath, boolean isEnabled, boolean isCheckable, boolean isChecked, @Nullable Function0<Unit> onClick, @NotNull List<MenuItem> subMenuItems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(subMenuItems, (String)"subMenuItems");
            return new MenuItem(text, iconPath, isEnabled, isCheckable, isChecked, onClick, subMenuItems);
        }

        public static /* synthetic */ MenuItem copy$default(MenuItem menuItem, String string2, String string3, boolean bl, boolean bl2, boolean bl3, Function0 function0, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = menuItem.text;
            }
            if ((n & 2) != 0) {
                string3 = menuItem.iconPath;
            }
            if ((n & 4) != 0) {
                bl = menuItem.isEnabled;
            }
            if ((n & 8) != 0) {
                bl2 = menuItem.isCheckable;
            }
            if ((n & 0x10) != 0) {
                bl3 = menuItem.isChecked;
            }
            if ((n & 0x20) != 0) {
                function0 = menuItem.onClick;
            }
            if ((n & 0x40) != 0) {
                list = menuItem.subMenuItems;
            }
            return menuItem.copy(string2, string3, bl, bl2, bl3, function0, list);
        }

        @NotNull
        public String toString() {
            return "MenuItem(text=" + this.text + ", iconPath=" + this.iconPath + ", isEnabled=" + this.isEnabled + ", isCheckable=" + this.isCheckable + ", isChecked=" + this.isChecked + ", onClick=" + this.onClick + ", subMenuItems=" + this.subMenuItems + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + (this.iconPath == null ? 0 : this.iconPath.hashCode());
            result = result * 31 + Boolean.hashCode(this.isEnabled);
            result = result * 31 + Boolean.hashCode(this.isCheckable);
            result = result * 31 + Boolean.hashCode(this.isChecked);
            result = result * 31 + (this.onClick == null ? 0 : this.onClick.hashCode());
            result = result * 31 + ((Object)this.subMenuItems).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MenuItem)) {
                return false;
            }
            MenuItem menuItem = (MenuItem)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)menuItem.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.iconPath, (Object)menuItem.iconPath)) {
                return false;
            }
            if (this.isEnabled != menuItem.isEnabled) {
                return false;
            }
            if (this.isCheckable != menuItem.isCheckable) {
                return false;
            }
            if (this.isChecked != menuItem.isChecked) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onClick, menuItem.onClick)) {
                return false;
            }
            return Intrinsics.areEqual(this.subMenuItems, menuItem.subMenuItems);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/kdroid/composetray/lib/windows/WindowsTrayManager$UpdateRequest;", "", "iconPath", "", "tooltip", "onLeftClick", "Lkotlin/Function0;", "", "menuItems", "", "Lcom/kdroid/composetray/lib/windows/WindowsTrayManager$MenuItem;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/util/List;)V", "getIconPath", "()Ljava/lang/String;", "getTooltip", "getOnLeftClick", "()Lkotlin/jvm/functions/Function0;", "getMenuItems", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "ComposeNativeTray"})
    private static final class UpdateRequest {
        @NotNull
        private final String iconPath;
        @NotNull
        private final String tooltip;
        @Nullable
        private final Function0<Unit> onLeftClick;
        @NotNull
        private final List<MenuItem> menuItems;

        public UpdateRequest(@NotNull String iconPath, @NotNull String tooltip, @Nullable Function0<Unit> onLeftClick, @NotNull List<MenuItem> menuItems) {
            Intrinsics.checkNotNullParameter((Object)iconPath, (String)"iconPath");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter(menuItems, (String)"menuItems");
            this.iconPath = iconPath;
            this.tooltip = tooltip;
            this.onLeftClick = onLeftClick;
            this.menuItems = menuItems;
        }

        @NotNull
        public final String getIconPath() {
            return this.iconPath;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        @Nullable
        public final Function0<Unit> getOnLeftClick() {
            return this.onLeftClick;
        }

        @NotNull
        public final List<MenuItem> getMenuItems() {
            return this.menuItems;
        }

        @NotNull
        public final String component1() {
            return this.iconPath;
        }

        @NotNull
        public final String component2() {
            return this.tooltip;
        }

        @Nullable
        public final Function0<Unit> component3() {
            return this.onLeftClick;
        }

        @NotNull
        public final List<MenuItem> component4() {
            return this.menuItems;
        }

        @NotNull
        public final UpdateRequest copy(@NotNull String iconPath, @NotNull String tooltip, @Nullable Function0<Unit> onLeftClick, @NotNull List<MenuItem> menuItems) {
            Intrinsics.checkNotNullParameter((Object)iconPath, (String)"iconPath");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter(menuItems, (String)"menuItems");
            return new UpdateRequest(iconPath, tooltip, onLeftClick, menuItems);
        }

        public static /* synthetic */ UpdateRequest copy$default(UpdateRequest updateRequest, String string2, String string3, Function0 function0, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = updateRequest.iconPath;
            }
            if ((n & 2) != 0) {
                string3 = updateRequest.tooltip;
            }
            if ((n & 4) != 0) {
                function0 = updateRequest.onLeftClick;
            }
            if ((n & 8) != 0) {
                list = updateRequest.menuItems;
            }
            return updateRequest.copy(string2, string3, function0, list);
        }

        @NotNull
        public String toString() {
            return "UpdateRequest(iconPath=" + this.iconPath + ", tooltip=" + this.tooltip + ", onLeftClick=" + this.onLeftClick + ", menuItems=" + this.menuItems + ")";
        }

        public int hashCode() {
            int result = this.iconPath.hashCode();
            result = result * 31 + this.tooltip.hashCode();
            result = result * 31 + (this.onLeftClick == null ? 0 : this.onLeftClick.hashCode());
            result = result * 31 + ((Object)this.menuItems).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateRequest)) {
                return false;
            }
            UpdateRequest updateRequest = (UpdateRequest)other;
            if (!Intrinsics.areEqual((Object)this.iconPath, (Object)updateRequest.iconPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tooltip, (Object)updateRequest.tooltip)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onLeftClick, updateRequest.onLeftClick)) {
                return false;
            }
            return Intrinsics.areEqual(this.menuItems, updateRequest.menuItems);
        }
    }
}

