/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.utils;

import com.kdroid.composetray.utils.ComposeNativeTrayLoggingLevel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\b\u0010\u001d\u001a\u00020\u0015H\u0002\u001a\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0000\u001a\u0016\u0010\"\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0000\u001a\u0016\u0010#\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0000\u001a\u0016\u0010$\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0000\u001a\u0016\u0010%\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!H\u0000\u001a\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0002\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"1\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0087\u008e\u0002\u00a2\u0006\u0018\u0012\u0004\b\t\u0010\n\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010*\u0004\b\u000b\u0010\f\"\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"allowComposeNativeTrayLogging", "", "getAllowComposeNativeTrayLogging", "()Z", "setAllowComposeNativeTrayLogging", "(Z)V", "<set-?>", "Lcom/kdroid/composetray/utils/ComposeNativeTrayLoggingLevel;", "composeNativeTrayloggingLevel", "getComposeNativeTrayloggingLevel$annotations", "()V", "getComposeNativeTrayloggingLevel$delegate", "()Ljava/lang/Object;", "getComposeNativeTrayloggingLevel", "()Lcom/kdroid/composetray/utils/ComposeNativeTrayLoggingLevel;", "setComposeNativeTrayloggingLevel", "(Lcom/kdroid/composetray/utils/ComposeNativeTrayLoggingLevel;)V", "composeNativeTrayLoggingLevel", "getComposeNativeTrayLoggingLevel", "setComposeNativeTrayLoggingLevel", "COLOR_RED", "", "COLOR_AQUA", "COLOR_LIGHT_GRAY", "COLOR_ORANGE", "COLOR_RESET", "timeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getCurrentTimestamp", "debugln", "", "message", "Lkotlin/Function0;", "verboseln", "infoln", "warnln", "errorln", "println", "color", "ComposeNativeTray"})
public final class DebugLnKt {
    private static boolean allowComposeNativeTrayLogging;
    @NotNull
    private static ComposeNativeTrayLoggingLevel composeNativeTrayLoggingLevel;
    @NotNull
    private static final String COLOR_RED = "\u001b[31m";
    @NotNull
    private static final String COLOR_AQUA = "\u001b[36m";
    @NotNull
    private static final String COLOR_LIGHT_GRAY = "\u001b[37m";
    @NotNull
    private static final String COLOR_ORANGE = "\u001b[38;2;255;165;0m";
    @NotNull
    private static final String COLOR_RESET = "\u001b[0m";
    private static final DateTimeFormatter timeFormatter;

    public static final boolean getAllowComposeNativeTrayLogging() {
        return allowComposeNativeTrayLogging;
    }

    public static final void setAllowComposeNativeTrayLogging(boolean bl) {
        allowComposeNativeTrayLogging = bl;
    }

    @NotNull
    public static final ComposeNativeTrayLoggingLevel getComposeNativeTrayloggingLevel() {
        return composeNativeTrayLoggingLevel;
    }

    public static final void setComposeNativeTrayloggingLevel(@NotNull ComposeNativeTrayLoggingLevel composeNativeTrayLoggingLevel) {
        Intrinsics.checkNotNullParameter((Object)composeNativeTrayLoggingLevel, (String)"<set-?>");
        DebugLnKt.composeNativeTrayLoggingLevel = composeNativeTrayLoggingLevel;
    }

    @Deprecated(message="migrate to composeNativeTrayLoggingLevel", replaceWith=@ReplaceWith(expression="composeNativeTrayLoggingLevel", imports={}))
    public static /* synthetic */ void getComposeNativeTrayloggingLevel$annotations() {
    }

    private static Object getComposeNativeTrayloggingLevel$delegate() {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(DebugLnKt.class, "composeNativeTrayLoggingLevel", "getComposeNativeTrayLoggingLevel()Lcom/kdroid/composetray/utils/ComposeNativeTrayLoggingLevel;", 1)));
    }

    @NotNull
    public static final ComposeNativeTrayLoggingLevel getComposeNativeTrayLoggingLevel() {
        return composeNativeTrayLoggingLevel;
    }

    public static final void setComposeNativeTrayLoggingLevel(@NotNull ComposeNativeTrayLoggingLevel composeNativeTrayLoggingLevel) {
        Intrinsics.checkNotNullParameter((Object)composeNativeTrayLoggingLevel, (String)"<set-?>");
        DebugLnKt.composeNativeTrayLoggingLevel = composeNativeTrayLoggingLevel;
    }

    private static final String getCurrentTimestamp() {
        String string2 = LocalDateTime.now().format(timeFormatter);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final void debugln(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (allowComposeNativeTrayLogging && composeNativeTrayLoggingLevel.compareTo(ComposeNativeTrayLoggingLevel.DEBUG) <= 0) {
            System.out.println((Object)("[" + DebugLnKt.getCurrentTimestamp() + "] " + message.invoke()));
        }
    }

    public static final void verboseln(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (allowComposeNativeTrayLogging && composeNativeTrayLoggingLevel.compareTo(ComposeNativeTrayLoggingLevel.VERBOSE) <= 0) {
            DebugLnKt.println("[" + DebugLnKt.getCurrentTimestamp() + "] " + message.invoke(), COLOR_LIGHT_GRAY);
        }
    }

    public static final void infoln(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (allowComposeNativeTrayLogging && composeNativeTrayLoggingLevel.compareTo(ComposeNativeTrayLoggingLevel.INFO) <= 0) {
            DebugLnKt.println("[" + DebugLnKt.getCurrentTimestamp() + "] " + message.invoke(), COLOR_AQUA);
        }
    }

    public static final void warnln(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (allowComposeNativeTrayLogging && composeNativeTrayLoggingLevel.compareTo(ComposeNativeTrayLoggingLevel.WARN) <= 0) {
            DebugLnKt.println("[" + DebugLnKt.getCurrentTimestamp() + "] " + message.invoke(), COLOR_ORANGE);
        }
    }

    public static final void errorln(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (allowComposeNativeTrayLogging && composeNativeTrayLoggingLevel.compareTo(ComposeNativeTrayLoggingLevel.ERROR) <= 0) {
            DebugLnKt.println("[" + DebugLnKt.getCurrentTimestamp() + "] " + message.invoke(), COLOR_RED);
        }
    }

    private static final void println(String message, String color) {
        System.out.println((Object)(color + message + COLOR_RESET));
    }

    static {
        composeNativeTrayLoggingLevel = ComposeNativeTrayLoggingLevel.VERBOSE;
        timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

