/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kdroid.composetray.utils.AppIdProvider;
import com.kdroid.composetray.utils.DebugLnKt;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0014\u001a\u00020\u00132\u001b\b\u0002\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016\u00a2\u0006\u0002\b\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0002\b\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0002J!\u0010\u001d\u001a\u00020\u00182\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0002\b\u0019H\u0002J#\u0010\u001e\u001a\u00020\u00182\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0005H\u0002J\u0016\u0010\"\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002J\u0016\u0010%\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/kdroid/composetray/utils/SingleInstanceManager;", "", "<init>", "()V", "TAG", "", "APP_IDENTIFIER", "value", "Lcom/kdroid/composetray/utils/SingleInstanceManager$Configuration;", "configuration", "getConfiguration", "()Lcom/kdroid/composetray/utils/SingleInstanceManager$Configuration;", "setConfiguration", "(Lcom/kdroid/composetray/utils/SingleInstanceManager$Configuration;)V", "fileChannel", "Ljava/nio/channels/FileChannel;", "fileLock", "Ljava/nio/channels/FileLock;", "isWatching", "", "isSingleInstance", "onRestoreFileCreated", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "", "Lkotlin/ExtensionFunctionType;", "onRestoreRequest", "createLockFile", "Ljava/io/File;", "watchForRestoreRequests", "sendRestoreRequest", "deleteRestoreRequestFile", "releaseLock", "getAppIdentifier", "debugLog", "msg", "Lkotlin/Function0;", "errorLog", "Configuration", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSingleInstanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleInstanceManager.kt\ncom/kdroid/composetray/utils/SingleInstanceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class SingleInstanceManager {
    @NotNull
    public static final SingleInstanceManager INSTANCE = new SingleInstanceManager();
    @NotNull
    private static final String TAG = "SingleInstanceChecker";
    @NotNull
    private static final String APP_IDENTIFIER = INSTANCE.getAppIdentifier();
    @NotNull
    private static Configuration configuration = new Configuration(null, null, 3, null);
    @Nullable
    private static FileChannel fileChannel;
    @Nullable
    private static FileLock fileLock;
    private static boolean isWatching;
    public static final int $stable;

    private SingleInstanceManager() {
    }

    @NotNull
    public final Configuration getConfiguration() {
        return configuration;
    }

    public final void setConfiguration(@NotNull Configuration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(fileChannel == null)) {
            boolean bl = false;
            String string2 = "Configuration can be changed only before first call to isSingleInstance()!";
            throw new IllegalStateException(string2.toString());
        }
        configuration = value;
    }

    public final boolean isSingleInstance(@Nullable Function1<? super Path, Unit> onRestoreFileCreated, @NotNull Function1<? super Path, Unit> onRestoreRequest) {
        boolean bl;
        Intrinsics.checkNotNullParameter(onRestoreRequest, (String)"onRestoreRequest");
        if (fileLock != null) {
            this.debugLog((Function0<String>)((Function0)SingleInstanceManager::isSingleInstance$lambda$0));
            return true;
        }
        File lockFile = this.createLockFile();
        fileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
        try {
            boolean bl2;
            FileChannel fileChannel = SingleInstanceManager.fileChannel;
            FileLock fileLock = SingleInstanceManager.fileLock = fileChannel != null ? fileChannel.tryLock() : null;
            if (SingleInstanceManager.fileLock != null) {
                this.debugLog((Function0<String>)((Function0)SingleInstanceManager::isSingleInstance$lambda$1));
                if (!isWatching) {
                    isWatching = true;
                    this.watchForRestoreRequests(onRestoreRequest);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> SingleInstanceManager.isSingleInstance$lambda$2(lockFile)));
                bl2 = true;
            } else {
                this.sendRestoreRequest(onRestoreFileCreated);
                this.debugLog((Function0<String>)((Function0)SingleInstanceManager::isSingleInstance$lambda$3));
                bl2 = false;
            }
            bl = bl2;
        }
        catch (OverlappingFileLockException e) {
            this.debugLog((Function0<String>)((Function0)SingleInstanceManager::isSingleInstance$lambda$4));
            return true;
        }
        catch (Exception e) {
            this.errorLog((Function0<String>)((Function0)() -> SingleInstanceManager.isSingleInstance$lambda$5(e)));
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean isSingleInstance$default(SingleInstanceManager singleInstanceManager, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return singleInstanceManager.isSingleInstance((Function1<? super Path, Unit>)function1, (Function1<? super Path, Unit>)function12);
    }

    private final File createLockFile() {
        File lockFile = configuration.getLockFilePath().toFile();
        lockFile.getParentFile().mkdirs();
        Intrinsics.checkNotNull((Object)lockFile);
        return lockFile;
    }

    private final void watchForRestoreRequests(Function1<? super Path, Unit> onRestoreRequest) {
        new Thread(() -> SingleInstanceManager.watchForRestoreRequests$lambda$0(onRestoreRequest)).start();
    }

    private final void sendRestoreRequest(Function1<? super Path, Unit> onRestoreFileCreated) {
        try {
            Path restoreRequestFilePath = configuration.getRestoreRequestFilePath();
            if (onRestoreFileCreated != null) {
                Path tempRestoreFilePath = Files.createTempFile(configuration.getLockIdentifier(), ".restore_request", new FileAttribute[0]);
                Intrinsics.checkNotNull((Object)tempRestoreFilePath);
                onRestoreFileCreated.invoke((Object)tempRestoreFilePath);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                v0 = Files.move(tempRestoreFilePath, restoreRequestFilePath, copyOptionArray);
            } else {
                v0 = Files.createFile(restoreRequestFilePath, new FileAttribute[0]);
            }
            this.debugLog((Function0<String>)((Function0)() -> SingleInstanceManager.sendRestoreRequest$lambda$0(restoreRequestFilePath)));
        }
        catch (Exception e) {
            this.errorLog((Function0<String>)((Function0)() -> SingleInstanceManager.sendRestoreRequest$lambda$1(e)));
        }
    }

    private final void deleteRestoreRequestFile() {
        try {
            Path restoreRequestFilePath = configuration.getRestoreRequestFilePath();
            Files.deleteIfExists(restoreRequestFilePath);
            this.debugLog((Function0<String>)((Function0)() -> SingleInstanceManager.deleteRestoreRequestFile$lambda$0(restoreRequestFilePath)));
        }
        catch (Exception e) {
            this.errorLog((Function0<String>)((Function0)() -> SingleInstanceManager.deleteRestoreRequestFile$lambda$1(e)));
        }
    }

    private final void releaseLock() {
        try {
            FileLock fileLock = SingleInstanceManager.fileLock;
            if (fileLock != null) {
                fileLock.release();
            }
            FileChannel fileChannel = SingleInstanceManager.fileChannel;
            if (fileChannel != null) {
                fileChannel.close();
            }
            this.debugLog((Function0<String>)((Function0)SingleInstanceManager::releaseLock$lambda$0));
        }
        catch (Exception e) {
            this.errorLog((Function0<String>)((Function0)() -> SingleInstanceManager.releaseLock$lambda$1(e)));
        }
    }

    private final String getAppIdentifier() {
        return AppIdProvider.INSTANCE.appId();
    }

    private final void debugLog(Function0<String> msg) {
        DebugLnKt.debugln((Function0<String>)((Function0)() -> SingleInstanceManager.debugLog$lambda$0(msg)));
    }

    private final void errorLog(Function0<String> msg) {
        DebugLnKt.errorln((Function0<String>)((Function0)() -> SingleInstanceManager.errorLog$lambda$0(msg)));
    }

    private static final String isSingleInstance$lambda$0() {
        return "The lock is already held by this process";
    }

    private static final String isSingleInstance$lambda$1() {
        return "Lock acquired, starting to watch for restore requests";
    }

    private static final void isSingleInstance$lambda$2(File $lockFile) {
        INSTANCE.releaseLock();
        $lockFile.delete();
        INSTANCE.deleteRestoreRequestFile();
        INSTANCE.debugLog((Function0<String>)((Function0)SingleInstanceManager::isSingleInstance$lambda$2$0));
    }

    private static final String isSingleInstance$lambda$2$0() {
        return "Shutdown hook executed";
    }

    private static final String isSingleInstance$lambda$3() {
        return "Restore request sent to the existing instance";
    }

    private static final String isSingleInstance$lambda$4() {
        return "The lock is already held by this process (OverlappingFileLockException)";
    }

    private static final String isSingleInstance$lambda$5(Exception $e) {
        return "Error in isSingleInstance: " + $e;
    }

    private static final void watchForRestoreRequests$lambda$0(Function1 $onRestoreRequest) {
        try {
            WatchKey key;
            boolean valid;
            WatchService watchService = FileSystems.getDefault().newWatchService();
            WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE};
            configuration.getLockFilesDir().register(watchService, kindArray);
            INSTANCE.debugLog((Function0<String>)((Function0)SingleInstanceManager::watchForRestoreRequests$lambda$0$0));
            do {
                key = watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (Intrinsics.areEqual(kind, StandardWatchEventKinds.OVERFLOW)) continue;
                    Object obj = event.context();
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.file.Path");
                    Path filename = (Path)obj;
                    if (!Intrinsics.areEqual((Object)((Object)filename).toString(), (Object)configuration.getRestoreRequestFileName())) continue;
                    INSTANCE.debugLog((Function0<String>)((Function0)SingleInstanceManager::watchForRestoreRequests$lambda$0$1));
                    $onRestoreRequest.invoke((Object)configuration.getRestoreRequestFilePath());
                    INSTANCE.deleteRestoreRequestFile();
                }
            } while (valid = key.reset());
        }
        catch (Exception e) {
            INSTANCE.errorLog((Function0<String>)((Function0)() -> SingleInstanceManager.watchForRestoreRequests$lambda$0$2(e)));
        }
    }

    private static final String watchForRestoreRequests$lambda$0$0() {
        return "Watching directory: " + configuration.getLockFilesDir() + " for restore requests";
    }

    private static final String watchForRestoreRequests$lambda$0$1() {
        return "Restore request file detected";
    }

    private static final String watchForRestoreRequests$lambda$0$2(Exception $e) {
        return "Error in watchForRestoreRequests: " + $e;
    }

    private static final String sendRestoreRequest$lambda$0(Path $restoreRequestFilePath) {
        return "Restore request file created: " + $restoreRequestFilePath;
    }

    private static final String sendRestoreRequest$lambda$1(Exception $e) {
        return "Error while sending restore request: " + $e;
    }

    private static final String deleteRestoreRequestFile$lambda$0(Path $restoreRequestFilePath) {
        return "Restore request file deleted: " + $restoreRequestFilePath;
    }

    private static final String deleteRestoreRequestFile$lambda$1(Exception $e) {
        return "Error while deleting restore request file: " + $e;
    }

    private static final String releaseLock$lambda$0() {
        return "Lock released";
    }

    private static final String releaseLock$lambda$1(Exception $e) {
        return "Error while releasing the lock: " + $e;
    }

    private static final String debugLog$lambda$0(Function0 $msg) {
        return "[SingleInstanceChecker] " + $msg.invoke();
    }

    private static final String errorLog$lambda$0(Function0 $msg) {
        return "[SingleInstanceChecker] " + $msg.invoke();
    }

    static {
        $stable = 8;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/kdroid/composetray/utils/SingleInstanceManager$Configuration;", "", "lockFilesDir", "Ljava/nio/file/Path;", "lockIdentifier", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getLockFilesDir", "()Ljava/nio/file/Path;", "getLockIdentifier", "()Ljava/lang/String;", "lockFileName", "getLockFileName", "restoreRequestFileName", "getRestoreRequestFileName", "lockFilePath", "getLockFilePath", "restoreRequestFilePath", "getRestoreRequestFilePath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ComposeNativeTray"})
    @StabilityInferred(parameters=0)
    public static final class Configuration {
        @NotNull
        private final Path lockFilesDir;
        @NotNull
        private final String lockIdentifier;
        @NotNull
        private final String lockFileName;
        @NotNull
        private final String restoreRequestFileName;
        @NotNull
        private final Path lockFilePath;
        @NotNull
        private final Path restoreRequestFilePath;
        public static final int $stable = 8;

        public Configuration(@NotNull Path lockFilesDir, @NotNull String lockIdentifier) {
            Intrinsics.checkNotNullParameter((Object)lockFilesDir, (String)"lockFilesDir");
            Intrinsics.checkNotNullParameter((Object)lockIdentifier, (String)"lockIdentifier");
            this.lockFilesDir = lockFilesDir;
            this.lockIdentifier = lockIdentifier;
            this.lockFileName = this.lockIdentifier + ".lock";
            this.restoreRequestFileName = this.lockIdentifier + ".restore_request";
            Path path = this.lockFilesDir.resolve(this.lockFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            this.lockFilePath = path;
            Path path2 = this.lockFilesDir.resolve(this.restoreRequestFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            this.restoreRequestFilePath = path2;
        }

        public /* synthetic */ Configuration(Path path, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Path path2 = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                path = path2;
            }
            if ((n & 2) != 0) {
                string2 = APP_IDENTIFIER;
            }
            this(path, string2);
        }

        @NotNull
        public final Path getLockFilesDir() {
            return this.lockFilesDir;
        }

        @NotNull
        public final String getLockIdentifier() {
            return this.lockIdentifier;
        }

        @NotNull
        public final String getLockFileName() {
            return this.lockFileName;
        }

        @NotNull
        public final String getRestoreRequestFileName() {
            return this.restoreRequestFileName;
        }

        @NotNull
        public final Path getLockFilePath() {
            return this.lockFilePath;
        }

        @NotNull
        public final Path getRestoreRequestFilePath() {
            return this.restoreRequestFilePath;
        }

        @NotNull
        public final Path component1() {
            return this.lockFilesDir;
        }

        @NotNull
        public final String component2() {
            return this.lockIdentifier;
        }

        @NotNull
        public final Configuration copy(@NotNull Path lockFilesDir, @NotNull String lockIdentifier) {
            Intrinsics.checkNotNullParameter((Object)lockFilesDir, (String)"lockFilesDir");
            Intrinsics.checkNotNullParameter((Object)lockIdentifier, (String)"lockIdentifier");
            return new Configuration(lockFilesDir, lockIdentifier);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, Path path, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                path = configuration.lockFilesDir;
            }
            if ((n & 2) != 0) {
                string2 = configuration.lockIdentifier;
            }
            return configuration.copy(path, string2);
        }

        @NotNull
        public String toString() {
            return "Configuration(lockFilesDir=" + this.lockFilesDir + ", lockIdentifier=" + this.lockIdentifier + ")";
        }

        public int hashCode() {
            int result = ((Object)this.lockFilesDir).hashCode();
            result = result * 31 + this.lockIdentifier.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.lockFilesDir, (Object)configuration.lockFilesDir)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lockIdentifier, (Object)configuration.lockIdentifier);
        }

        public Configuration() {
            this(null, null, 3, null);
        }
    }
}

