/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.utils;

import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.window.WindowPosition;
import androidx.compose.ui.window.WindowPosition_desktopKt;
import com.kdroid.composetray.lib.mac.MacTrayLoader;
import com.kdroid.composetray.lib.mac.MacTrayManager;
import com.kdroid.composetray.lib.windows.WindowsNativeTrayLibrary;
import com.kdroid.composetray.tray.impl.MacTrayInitializer;
import com.kdroid.composetray.utils.AppIdProvider;
import com.kdroid.composetray.utils.TrayClickPosition;
import com.kdroid.composetray.utils.TrayClickTracker;
import com.kdroid.composetray.utils.TrayPosition;
import com.sun.jna.ptr.IntByReference;
import io.github.kdroidfilter.platformtools.LinuxDesktopEnvironment;
import io.github.kdroidfilter.platformtools.LinuxEnvironmentKt;
import io.github.kdroidfilter.platformtools.OperatingSystem;
import io.github.kdroidfilter.platformtools.OsProvider_jvmKt;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0000\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0011\u001a\u00020\u000fH\u0002\u001a\n\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\n\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003H\u0000\u001a \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0003H\u0000\u001a\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u001a\u0012\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\nH\u0000\u001a\u0006\u0010!\u001a\u00020\u0003\u001a*\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0005\u001a2\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0005\u001aP\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002\u001a(\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002\u001a\u0012\u00103\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\nH\u0000\u001a\u0014\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000505H\u0000\u001a\u0006\u00106\u001a\u00020\u0018\u001a\b\u00107\u001a\u00020\u0005H\u0002\u001a\b\u00108\u001a\u00020\u0005H\u0002\u001a\b\u00109\u001a\u00020\u0005H\u0002\u001a\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0000\u001a\u0018\u0010>\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0000\u001a,\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005052\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0002\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"getLogicalScreenSize", "Ljava/awt/Dimension;", "convertPositionToCorner", "Lcom/kdroid/composetray/utils/TrayPosition;", "x", "", "y", "width", "height", "PROPERTIES_FILE", "", "POSITION_KEY", "X_KEY", "Y_KEY", "trayPropertiesFile", "Ljava/io/File;", "legacyPropertiesFile", "oldTmpPropertiesFile", "macCachePropertiesFile", "macCacheDir", "loadPropertiesFrom", "Ljava/util/Properties;", "file", "storePropertiesTo", "", "props", "saveTrayPosition", "position", "saveTrayClickPosition", "loadTrayClickPosition", "Lcom/kdroid/composetray/utils/TrayClickPosition;", "getWindowsTrayPosition", "nativeResult", "getTrayPosition", "getTrayWindowPosition", "Landroidx/compose/ui/window/WindowPosition;", "windowWidth", "windowHeight", "horizontalOffset", "verticalOffset", "getTrayWindowPositionForInstance", "instanceId", "calculateWindowPositionFromClick", "clickX", "clickY", "trayPosition", "screenWidth", "screenHeight", "fallbackCornerPosition", "w", "h", "getMacTrayPosition", "getStatusItemXYForMac", "Lkotlin/Pair;", "debugDeleteTrayPropertiesFiles", "dpiAwareHalfIconOffset", "getWindowsTaskbarHeight", "getSystemBarSize", "isPointWithinMacStatusItem", "", "px", "py", "isPointWithinLinuxStatusItem", "syntheticClickFromCorner", "corner", "screenW", "screenH", "ComposeNativeTray"})
@SourceDebugExtension(value={"SMAP\nTrayPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrayPosition.kt\ncom/kdroid/composetray/utils/TrayPositionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,537:1\n1#2:538\n113#3:539\n113#3:540\n113#3:541\n113#3:542\n113#3:543\n113#3:544\n113#3:545\n113#3:546\n113#3:547\n113#3:548\n113#3:549\n113#3:550\n113#3:551\n113#3:552\n774#4:553\n865#4,2:554\n1869#4,2:556\n*S KotlinDebug\n*F\n+ 1 TrayPosition.kt\ncom/kdroid/composetray/utils/TrayPositionKt\n*L\n292#1:539\n294#1:540\n295#1:541\n298#1:542\n299#1:543\n302#1:544\n303#1:545\n385#1:546\n401#1:547\n415#1:548\n416#1:549\n417#1:550\n419#1:551\n420#1:552\n446#1:553\n446#1:554,2\n446#1:556,2\n*E\n"})
public final class TrayPositionKt {
    @NotNull
    private static final String PROPERTIES_FILE = "tray_position.properties";
    @NotNull
    private static final String POSITION_KEY = "TrayPosition";
    @NotNull
    private static final String X_KEY = "TrayX";
    @NotNull
    private static final String Y_KEY = "TrayY";

    private static final Dimension getLogicalScreenSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getScreenSize(...)");
        return dimension;
    }

    @NotNull
    public static final TrayPosition convertPositionToCorner(int x, int y, int width, int height) {
        int edgeThreshold = 100;
        boolean isNearTop = y < edgeThreshold;
        boolean isNearBottom = y > height - edgeThreshold;
        boolean isNearLeft = x < edgeThreshold;
        boolean isNearRight = x > width - edgeThreshold;
        return isNearTop && isNearLeft ? TrayPosition.TOP_LEFT : (isNearTop && isNearRight ? TrayPosition.TOP_RIGHT : (isNearTop ? TrayPosition.TOP_RIGHT : (isNearBottom && isNearLeft ? TrayPosition.BOTTOM_LEFT : (isNearBottom && isNearRight ? TrayPosition.BOTTOM_RIGHT : (isNearBottom ? TrayPosition.BOTTOM_RIGHT : (x >= width / 2 && y < height / 2 ? TrayPosition.TOP_RIGHT : (x < width / 2 && y < height / 2 ? TrayPosition.TOP_LEFT : (x >= width / 2 ? TrayPosition.BOTTOM_RIGHT : TrayPosition.BOTTOM_LEFT))))))));
    }

    private static final File trayPropertiesFile() {
        String appId = AppIdProvider.INSTANCE.appId();
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2 == null) {
            string2 = ".";
        }
        String tmpBase = string2;
        File tmpDir = new File(new File(tmpBase, "ComposeNativeTray"), appId);
        File file = TrayPositionKt.macCacheDir();
        File macCacheDir = file != null ? FilesKt.resolve((File)file, (String)appId) : null;
        File[] fileArray = new File[]{tmpDir, macCacheDir};
        List candidates = CollectionsKt.listOfNotNull((Object[])fileArray);
        for (File dir : candidates) {
            Object object;
            try {
                boolean bl = false;
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (!dir.exists() || !dir.canWrite()) continue;
            return new File(dir, PROPERTIES_FILE);
        }
        return new File(tmpDir, PROPERTIES_FILE);
    }

    private static final File legacyPropertiesFile() {
        return new File(PROPERTIES_FILE);
    }

    private static final File oldTmpPropertiesFile() {
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2 == null) {
            string2 = ".";
        }
        String tmpBase = string2;
        File oldDir = new File(tmpBase, "ComposeNativeTray");
        return new File(oldDir, PROPERTIES_FILE);
    }

    private static final File macCachePropertiesFile() {
        String appId = AppIdProvider.INSTANCE.appId();
        File file = TrayPositionKt.macCacheDir();
        if (file == null || (file = FilesKt.resolve((File)file, (String)appId)) == null) {
            return null;
        }
        File dir = file;
        return new File(dir, PROPERTIES_FILE);
    }

    private static final File macCacheDir() {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return null;
        }
        String userHome = string2;
        return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(userHome), (String)"Library"), (String)"Caches"), (String)"ComposeNativeTray");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadPropertiesFrom(File file) {
        Object object;
        if (!file.exists()) {
            return null;
        }
        try {
            Properties properties;
            boolean bl = false;
            Properties $this$loadPropertiesFrom_u24lambda_u240_u240 = properties = new Properties();
            boolean bl2 = false;
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)closeable;
                boolean bl3 = false;
                $this$loadPropertiesFrom_u24lambda_u240_u240.load(p0);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)properties);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (Properties)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void storePropertiesTo(File file, Properties props) {
        File file2 = file.getParentFile();
        if (file2 != null) {
            Object $i$a$-runCatching-TrayPositionKt$storePropertiesTo$1$22;
            File it = file2;
            boolean bl = false;
            try {
                boolean $i$a$-runCatching-TrayPositionKt$storePropertiesTo$1$22 = false;
                if (!it.exists()) {
                    it.mkdirs();
                }
                $i$a$-runCatching-TrayPositionKt$storePropertiesTo$1$22 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                $i$a$-runCatching-TrayPositionKt$storePropertiesTo$1$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Result.box-impl((Object)$i$a$-runCatching-TrayPositionKt$storePropertiesTo$1$22);
        }
        try {
            boolean bl = false;
            Closeable closeable = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl2 = false;
                props.store(it, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public static final void saveTrayPosition(@NotNull TrayPosition position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        File preferredFile = TrayPositionKt.trayPropertiesFile();
        Properties properties = TrayPositionKt.loadPropertiesFrom(preferredFile);
        if (properties == null) {
            Properties properties2;
            File file = TrayPositionKt.macCachePropertiesFile();
            if (file != null) {
                File it = file;
                boolean bl = false;
                properties2 = TrayPositionKt.loadPropertiesFrom(it);
            } else {
                properties2 = properties = null;
            }
            if (properties2 == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.oldTmpPropertiesFile())) == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.legacyPropertiesFile())) == null) {
                properties = new Properties();
            }
        }
        Properties properties3 = properties;
        properties3.setProperty(POSITION_KEY, position.name());
        TrayPositionKt.storePropertiesTo(preferredFile, properties3);
    }

    public static final void saveTrayClickPosition(int x, int y, @NotNull TrayPosition position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        File preferredFile = TrayPositionKt.trayPropertiesFile();
        Properties properties = TrayPositionKt.loadPropertiesFrom(preferredFile);
        if (properties == null) {
            Properties properties2;
            File file = TrayPositionKt.macCachePropertiesFile();
            if (file != null) {
                File it = file;
                boolean bl = false;
                properties2 = TrayPositionKt.loadPropertiesFrom(it);
            } else {
                properties2 = properties = null;
            }
            if (properties2 == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.oldTmpPropertiesFile())) == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.legacyPropertiesFile())) == null) {
                properties = new Properties();
            }
        }
        Properties properties3 = properties;
        properties3.setProperty(POSITION_KEY, position.name());
        properties3.setProperty(X_KEY, String.valueOf(x));
        properties3.setProperty(Y_KEY, String.valueOf(y));
        TrayPositionKt.storePropertiesTo(preferredFile, properties3);
    }

    @Nullable
    public static final TrayClickPosition loadTrayClickPosition() {
        TrayClickPosition trayClickPosition;
        Properties properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.trayPropertiesFile());
        if (properties == null) {
            Properties properties2;
            File file = TrayPositionKt.macCachePropertiesFile();
            if (file != null) {
                File it = file;
                boolean bl = false;
                properties2 = TrayPositionKt.loadPropertiesFrom(it);
            } else {
                properties2 = properties = null;
            }
            if (properties2 == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.oldTmpPropertiesFile())) == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.legacyPropertiesFile())) == null) {
                return null;
            }
        }
        Properties props = properties;
        String string2 = props.getProperty(POSITION_KEY);
        if (string2 == null) {
            return null;
        }
        String positionStr = string2;
        Object object = props.getProperty(X_KEY);
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return null;
        }
        int x = (Integer)object;
        Object object2 = props.getProperty(Y_KEY);
        if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
            return null;
        }
        int y = (Integer)object2;
        try {
            trayClickPosition = new TrayClickPosition(x, y, TrayPosition.valueOf(positionStr));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            trayClickPosition = null;
        }
        return trayClickPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final TrayPosition getWindowsTrayPosition(@Nullable String nativeResult) {
        TrayPosition trayPosition;
        block9: {
            block10: {
                String string2;
                String string3 = string2 = nativeResult;
                if (string3 == null) throw new IllegalArgumentException("Returned value is null");
                switch (string3.hashCode()) {
                    case -1314880604: {
                        if (string2.equals("top-right")) break;
                        throw new IllegalArgumentException("Unknown value: " + nativeResult);
                    }
                    case 1163912186: {
                        if (!string2.equals("bottom-right")) {
                            throw new IllegalArgumentException("Unknown value: " + nativeResult);
                        }
                        break block9;
                    }
                    case -655373719: {
                        if (!string2.equals("bottom-left")) {
                            throw new IllegalArgumentException("Unknown value: " + nativeResult);
                        }
                        break block10;
                    }
                    case -1012429441: {
                        if (!string2.equals("top-left")) {
                            throw new IllegalArgumentException("Unknown value: " + nativeResult);
                        }
                    }
                    trayPosition = TrayPosition.TOP_LEFT;
                    return trayPosition;
                }
                trayPosition = TrayPosition.TOP_RIGHT;
                return trayPosition;
            }
            trayPosition = TrayPosition.BOTTOM_LEFT;
            return trayPosition;
        }
        trayPosition = TrayPosition.BOTTOM_RIGHT;
        return trayPosition;
        throw new IllegalArgumentException("Unknown value: " + nativeResult);
    }

    @NotNull
    public static final TrayPosition getTrayPosition() {
        Object object;
        block1 : switch (WhenMappings.$EnumSwitchMapping$1[OsProvider_jvmKt.getOperatingSystem().ordinal()]) {
            case 1: {
                object = TrayPositionKt.getWindowsTrayPosition(WindowsNativeTrayLibrary.tray_get_notification_icons_region());
                break;
            }
            case 2: {
                MacTrayLoader.INSTANCE.getLib();
                object = TrayPositionKt.getMacTrayPosition(MacTrayManager.MacTrayLibrary.tray_get_status_item_region());
                break;
            }
            case 3: {
                TrayPosition trayPosition;
                Properties props;
                Object object2;
                object = TrayClickTracker.INSTANCE.getLastClickPosition();
                if (object != null && (object = ((TrayClickPosition)object).getPosition()) != null) break;
                TrayClickPosition trayClickPosition = TrayPositionKt.loadTrayClickPosition();
                if (trayClickPosition != null) {
                    object = trayClickPosition.getPosition();
                    break;
                }
                boolean bl = false;
                Properties properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.trayPropertiesFile());
                if (properties == null) {
                    Properties properties2;
                    File file = TrayPositionKt.macCachePropertiesFile();
                    if (file != null) {
                        File it = file;
                        boolean bl2 = false;
                        properties2 = TrayPositionKt.loadPropertiesFrom(it);
                    } else {
                        properties2 = properties = null;
                    }
                    if (properties2 == null && (properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.oldTmpPropertiesFile())) == null) {
                        properties = TrayPositionKt.loadPropertiesFrom(TrayPositionKt.legacyPropertiesFile());
                    }
                }
                if ((object2 = (props = properties)) != null && (object2 = ((Properties)object2).getProperty(POSITION_KEY)) != null) {
                    Object object3;
                    Object it = object2;
                    boolean bl3 = false;
                    try {
                        boolean bl4 = false;
                        object3 = Result.constructor-impl((Object)((Object)TrayPosition.valueOf((String)it)));
                    }
                    catch (Throwable throwable) {
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    trayPosition = (TrayPosition)((Object)(Result.isFailure-impl((Object)object3) ? null : object3));
                } else {
                    trayPosition = null;
                }
                object = trayPosition;
                if (trayPosition != null) break;
                LinuxDesktopEnvironment linuxDesktopEnvironment = LinuxEnvironmentKt.detectLinuxDesktopEnvironment();
                switch (linuxDesktopEnvironment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[linuxDesktopEnvironment.ordinal()]) {
                    case 1: {
                        object = TrayPosition.BOTTOM_RIGHT;
                        break block1;
                    }
                    case 2: {
                        object = TrayPosition.BOTTOM_RIGHT;
                        break block1;
                    }
                    case 3: {
                        object = TrayPosition.TOP_RIGHT;
                        break block1;
                    }
                    case 4: {
                        object = TrayPosition.TOP_RIGHT;
                        break block1;
                    }
                    case 5: {
                        object = TrayPosition.TOP_RIGHT;
                        break block1;
                    }
                }
                object = TrayPosition.TOP_RIGHT;
                break;
            }
            case 4: {
                object = TrayPosition.TOP_RIGHT;
                break;
            }
            default: {
                object = TrayPosition.TOP_RIGHT;
            }
        }
        return object;
    }

    @NotNull
    public static final WindowPosition getTrayWindowPosition(int windowWidth, int windowHeight, int horizontalOffset, int verticalOffset) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (OsProvider_jvmKt.getOperatingSystem() == OperatingSystem.WINDOWS) {
            TrayClickPosition freshPos;
            TrayClickPosition trayClickPosition = TrayClickTracker.INSTANCE.getLastClickPosition();
            if (trayClickPosition == null) {
                trayClickPosition = TrayPositionKt.loadTrayClickPosition();
            }
            TrayClickPosition trayClickPosition2 = freshPos = trayClickPosition;
            if (trayClickPosition2 == null) {
                boolean bl = false;
                TrayPosition corner = TrayPositionKt.getTrayPosition();
                Pair<Integer, Integer> pair = TrayPositionKt.syntheticClickFromCorner(corner, screenSize.width, screenSize.height);
                int sx = ((Number)pair.component1()).intValue();
                int sy = ((Number)pair.component2()).intValue();
                return TrayPositionKt.calculateWindowPositionFromClick(sx, sy, corner, windowWidth, windowHeight, screenSize.width, screenSize.height, horizontalOffset, verticalOffset);
            }
            TrayClickPosition posToUse = trayClickPosition2;
            return TrayPositionKt.calculateWindowPositionFromClick(posToUse.getX(), posToUse.getY(), posToUse.getPosition(), windowWidth, windowHeight, screenSize.width, screenSize.height, horizontalOffset, verticalOffset);
        }
        if (OsProvider_jvmKt.getOperatingSystem() == OperatingSystem.MACOS) {
            TrayClickPosition pos;
            Pair<Integer, Integer> freshPos = TrayPositionKt.getStatusItemXYForMac();
            int x0 = ((Number)freshPos.component1()).intValue();
            int y0 = ((Number)freshPos.component2()).intValue();
            if (x0 != 0 || y0 != 0) {
                TrayClickTracker.INSTANCE.setClickPosition(x0, y0, TrayPositionKt.getTrayPosition());
            }
            if ((pos = TrayClickTracker.INSTANCE.getLastClickPosition()) != null) {
                return TrayPositionKt.calculateWindowPositionFromClick(pos.getX(), pos.getY(), pos.getPosition(), windowWidth, windowHeight, screenSize.width, screenSize.height, horizontalOffset, verticalOffset);
            }
        }
        if (OsProvider_jvmKt.getOperatingSystem() == OperatingSystem.LINUX) {
            TrayClickPosition clickPos;
            TrayClickPosition trayClickPosition = TrayClickTracker.INSTANCE.getLastClickPosition();
            if (trayClickPosition == null) {
                trayClickPosition = TrayPositionKt.loadTrayClickPosition();
            }
            if ((clickPos = trayClickPosition) != null) {
                return TrayPositionKt.calculateWindowPositionFromClick(clickPos.getX(), clickPos.getY(), clickPos.getPosition(), windowWidth, windowHeight, screenSize.width, screenSize.height, horizontalOffset, verticalOffset);
            }
        }
        return switch (WhenMappings.$EnumSwitchMapping$2[TrayPositionKt.getTrayPosition().ordinal()]) {
            case 1 -> {
                int $this$dp$iv = 0 + horizontalOffset;
                boolean $i$f$getDp = false;
                float v3 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = 0 + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v3, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            case 2 -> {
                int $this$dp$iv = screenSize.width - windowWidth + horizontalOffset;
                boolean $i$f$getDp = false;
                float v5 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = 0 + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v5, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            case 3 -> {
                int $this$dp$iv = 0 + horizontalOffset;
                boolean $i$f$getDp = false;
                float v6 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = screenSize.height - windowHeight + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v6, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            case 4 -> {
                int $this$dp$iv = screenSize.width - windowWidth + horizontalOffset;
                boolean $i$f$getDp = false;
                float v7 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = screenSize.height - windowHeight + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v7, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ WindowPosition getTrayWindowPosition$default(int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return TrayPositionKt.getTrayWindowPosition(n, n2, n3, n4);
    }

    @NotNull
    public static final WindowPosition getTrayWindowPositionForInstance(@NotNull String instanceId, int windowWidth, int windowHeight, int horizontalOffset, int verticalOffset) {
        WindowPosition windowPosition;
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        OperatingSystem os = OsProvider_jvmKt.getOperatingSystem();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        switch (WhenMappings.$EnumSwitchMapping$1[os.ordinal()]) {
            case 1: {
                TrayClickPosition trayClickPosition = TrayClickTracker.INSTANCE.getLastClickPosition(instanceId);
                if (trayClickPosition == null) {
                    return TrayPositionKt.fallbackCornerPosition(windowWidth, windowHeight, horizontalOffset, verticalOffset);
                }
                TrayClickPosition pos = trayClickPosition;
                windowPosition = TrayPositionKt.calculateWindowPositionFromClick(pos.getX(), pos.getY(), pos.getPosition(), windowWidth, windowHeight, screenSize.width, screenSize.height, horizontalOffset, verticalOffset);
                break;
            }
            case 2: {
                MacTrayManager.MacTray trayStruct = MacTrayInitializer.INSTANCE.getNativeTrayStruct$ComposeNativeTray(instanceId);
                if (trayStruct != null) {
                    boolean bl;
                    IntByReference xRef = new IntByReference();
                    IntByReference yRef = new IntByReference();
                    MacTrayManager.MacTrayLibrary lib = MacTrayLoader.INSTANCE.getLib();
                    try {
                        bl = MacTrayManager.MacTrayLibrary.tray_get_status_item_position_for(trayStruct, xRef, yRef) != 0;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                    boolean precise = bl;
                    int x = xRef.getValue();
                    int y = yRef.getValue();
                    if (precise) {
                        String regionStr;
                        Object $i$a$-runCatching-TrayPositionKt$getTrayWindowPositionForInstance$regionStr$22;
                        try {
                            boolean $i$a$-runCatching-TrayPositionKt$getTrayWindowPositionForInstance$regionStr$22 = false;
                            $i$a$-runCatching-TrayPositionKt$getTrayWindowPositionForInstance$regionStr$22 = Result.constructor-impl((Object)MacTrayManager.MacTrayLibrary.tray_get_status_item_region_for(trayStruct));
                        }
                        catch (Throwable throwable) {
                            $i$a$-runCatching-TrayPositionKt$getTrayWindowPositionForInstance$regionStr$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        String string2 = regionStr = (String)(Result.isFailure-impl((Object)$i$a$-runCatching-TrayPositionKt$getTrayWindowPositionForInstance$regionStr$22) ? null : $i$a$-runCatching-TrayPositionKt$getTrayWindowPositionForInstance$regionStr$22);
                        TrayPosition trayPos = string2 != null ? TrayPositionKt.getMacTrayPosition(string2) : TrayPositionKt.convertPositionToCorner(x, y, screenSize.width, screenSize.height);
                        TrayClickTracker.INSTANCE.setClickPosition(instanceId, x, y, trayPos);
                        return TrayPositionKt.calculateWindowPositionFromClick(x, y, trayPos, windowWidth, windowHeight, screenSize.width, screenSize.height, horizontalOffset, verticalOffset);
                    }
                }
                windowPosition = TrayPositionKt.getTrayWindowPosition(windowWidth, windowHeight, horizontalOffset, verticalOffset);
                break;
            }
            default: {
                windowPosition = TrayPositionKt.getTrayWindowPosition(windowWidth, windowHeight, horizontalOffset, verticalOffset);
            }
        }
        return windowPosition;
    }

    public static /* synthetic */ WindowPosition getTrayWindowPositionForInstance$default(String string2, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        return TrayPositionKt.getTrayWindowPositionForInstance(string2, n, n2, n3, n4);
    }

    private static final WindowPosition calculateWindowPositionFromClick(int clickX, int clickY, TrayPosition trayPosition, int windowWidth, int windowHeight, int screenWidth, int screenHeight, int horizontalOffset, int verticalOffset) {
        WindowPosition windowPosition;
        boolean isRight;
        OperatingSystem os = OsProvider_jvmKt.getOperatingSystem();
        boolean isTop = trayPosition == TrayPosition.TOP_LEFT || trayPosition == TrayPosition.TOP_RIGHT;
        boolean bl = isRight = trayPosition == TrayPosition.TOP_RIGHT || trayPosition == TrayPosition.BOTTOM_RIGHT;
        if (os == OperatingSystem.WINDOWS) {
            int x = clickX - windowWidth / 2;
            int y = isTop ? clickY : clickY - windowHeight;
            y += verticalOffset;
            if ((x += horizontalOffset) < 0) {
                x = 0;
            } else if (x + windowWidth > screenWidth) {
                x = screenWidth - windowWidth;
            }
            if (y < 0) {
                y = 0;
            } else if (y + windowHeight > screenHeight) {
                y = screenHeight - windowHeight;
            }
            int $this$dp$iv = x;
            boolean $i$f$getDp = false;
            float f = Dp.constructor-impl((float)$this$dp$iv);
            $this$dp$iv = y;
            $i$f$getDp = false;
            windowPosition = (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)f, (float)Dp.constructor-impl((float)$this$dp$iv));
        } else {
            int panelGuessPx = 28;
            int x = clickX - windowWidth / 2;
            int anchorY = isTop ? panelGuessPx : screenHeight - panelGuessPx;
            int y = isTop ? anchorY : anchorY - windowHeight;
            y += isTop ? verticalOffset : -verticalOffset;
            if ((x += isRight ? -horizontalOffset : horizontalOffset) < 0) {
                x = 0;
            } else if (x + windowWidth > screenWidth) {
                x = screenWidth - windowWidth;
            }
            if (y < 0) {
                y = 0;
            } else if (y + windowHeight > screenHeight) {
                y = screenHeight - windowHeight;
            }
            int $this$dp$iv = x;
            boolean $i$f$getDp = false;
            float f = Dp.constructor-impl((float)$this$dp$iv);
            $this$dp$iv = y;
            $i$f$getDp = false;
            windowPosition = (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)f, (float)Dp.constructor-impl((float)$this$dp$iv));
        }
        return windowPosition;
    }

    private static final WindowPosition fallbackCornerPosition(int w, int h, int horizontalOffset, int verticalOffset) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        return switch (WhenMappings.$EnumSwitchMapping$2[TrayPositionKt.getTrayPosition().ordinal()]) {
            case 1 -> {
                int $this$dp$iv = 0 + horizontalOffset;
                boolean $i$f$getDp = false;
                float v0 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = 0 + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v0, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            case 2 -> {
                int $this$dp$iv = screen.width - w + horizontalOffset;
                boolean $i$f$getDp = false;
                float v2 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = 0 + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v2, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            case 3 -> {
                int $this$dp$iv = 0 + horizontalOffset;
                boolean $i$f$getDp = false;
                float v3 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = screen.height - h + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v3, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            case 4 -> {
                int $this$dp$iv = screen.width - w + horizontalOffset;
                boolean $i$f$getDp = false;
                float v4 = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = screen.height - h + verticalOffset;
                $i$f$getDp = false;
                yield (WindowPosition)WindowPosition_desktopKt.WindowPosition-YgX7TsA((float)v4, (float)Dp.constructor-impl((float)$this$dp$iv));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final TrayPosition getMacTrayPosition(@Nullable String nativeResult) {
        String string2 = nativeResult;
        return Intrinsics.areEqual((Object)string2, (Object)"top-left") ? TrayPosition.TOP_LEFT : (Intrinsics.areEqual((Object)string2, (Object)"top-right") ? TrayPosition.TOP_RIGHT : TrayPosition.TOP_RIGHT);
    }

    @NotNull
    public static final Pair<Integer, Integer> getStatusItemXYForMac() {
        IntByReference xRef = new IntByReference();
        IntByReference yRef = new IntByReference();
        MacTrayManager.MacTrayLibrary lib = MacTrayLoader.INSTANCE.getLib();
        MacTrayManager.MacTrayLibrary.tray_get_status_item_position(xRef, yRef);
        return TuplesKt.to((Object)xRef.getValue(), (Object)yRef.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static final void debugDeleteTrayPropertiesFiles() {
        void $this$filterTo$iv$iv;
        Object[] objectArray = new File[]{TrayPositionKt.trayPropertiesFile(), TrayPositionKt.legacyPropertiesFile(), TrayPositionKt.oldTmpPropertiesFile(), TrayPositionKt.macCachePropertiesFile()};
        Set files = SetsKt.setOfNotNull((Object[])objectArray);
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!p0.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            File it = (File)element$iv;
            boolean bl = false;
            try {
                boolean bl2 = false;
                object = Result.constructor-impl((Object)it.delete());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private static final int dpiAwareHalfIconOffset() {
        int n;
        try {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            double scale = (double)dpi / 96.0;
            n = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)((double)15 * scale)), (int)0);
        }
        catch (Throwable throwable) {
            n = 15;
        }
        return n;
    }

    private static final int getWindowsTaskbarHeight() {
        int n;
        try {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            double scale = (double)dpi / 96.0;
            n = RangesKt.coerceIn((int)MathKt.roundToInt((double)((double)40 * scale)), (int)32, (int)72);
        }
        catch (Throwable throwable) {
            n = 40;
        }
        return n;
    }

    private static final int getSystemBarSize() {
        return switch (WhenMappings.$EnumSwitchMapping$1[OsProvider_jvmKt.getOperatingSystem().ordinal()]) {
            case 1 -> TrayPositionKt.getWindowsTaskbarHeight();
            case 2 -> 25;
            default -> 28;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPointWithinMacStatusItem(int px, int py) {
        Object $i$a$-runCatching-TrayPositionKt$isPointWithinMacStatusItem$dpi$22;
        if (OsProvider_jvmKt.getOperatingSystem() != OperatingSystem.MACOS) {
            return false;
        }
        Pair<Integer, Integer> pair = TrayPositionKt.getStatusItemXYForMac();
        int ix = ((Number)pair.component1()).intValue();
        int iy = ((Number)pair.component2()).intValue();
        if (ix == 0 && iy == 0) {
            return false;
        }
        try {
            boolean $i$a$-runCatching-TrayPositionKt$isPointWithinMacStatusItem$dpi$22 = false;
            $i$a$-runCatching-TrayPositionKt$isPointWithinMacStatusItem$dpi$22 = Result.constructor-impl((Object)Toolkit.getDefaultToolkit().getScreenResolution());
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-TrayPositionKt$isPointWithinMacStatusItem$dpi$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Integer n = 96;
        int dpi = ((Number)(Result.isFailure-impl((Object)$i$a$-runCatching-TrayPositionKt$isPointWithinMacStatusItem$dpi$22) ? n : $i$a$-runCatching-TrayPositionKt$isPointWithinMacStatusItem$dpi$22)).intValue();
        double scale = (double)dpi / 96.0;
        int half = RangesKt.coerceAtLeast((int)MathKt.roundToInt((double)((double)14 * scale)), (int)8);
        int left = ix - half;
        int right = ix + half;
        int top = iy - half;
        int bottom = iy + half;
        if (left > px) return false;
        if (px > right) return false;
        boolean bl = true;
        if (!bl) return false;
        if (top > py) return false;
        if (py > bottom) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPointWithinLinuxStatusItem(int px, int py) {
        Object $i$a$-runCatching-TrayPositionKt$isPointWithinLinuxStatusItem$dpi$22;
        if (OsProvider_jvmKt.getOperatingSystem() != OperatingSystem.LINUX) {
            return false;
        }
        TrayClickPosition trayClickPosition = TrayClickTracker.INSTANCE.getLastClickPosition();
        if (trayClickPosition == null && (trayClickPosition = TrayPositionKt.loadTrayClickPosition()) == null) {
            return false;
        }
        TrayClickPosition click = trayClickPosition;
        Pair pair = TuplesKt.to((Object)click.getX(), (Object)click.getY());
        int ix = ((Number)pair.component1()).intValue();
        int iy = ((Number)pair.component2()).intValue();
        LinuxDesktopEnvironment linuxDesktopEnvironment = LinuxEnvironmentKt.detectLinuxDesktopEnvironment();
        int baseIconSizeAt1x = switch (linuxDesktopEnvironment == null ? -1 : WhenMappings.$EnumSwitchMapping$0[linuxDesktopEnvironment.ordinal()]) {
            case 1 -> 22;
            case 3 -> 24;
            case 2 -> 24;
            case 4 -> 24;
            case 5 -> 24;
            default -> 24;
        };
        try {
            boolean $i$a$-runCatching-TrayPositionKt$isPointWithinLinuxStatusItem$dpi$22 = false;
            $i$a$-runCatching-TrayPositionKt$isPointWithinLinuxStatusItem$dpi$22 = Result.constructor-impl((Object)Toolkit.getDefaultToolkit().getScreenResolution());
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-TrayPositionKt$isPointWithinLinuxStatusItem$dpi$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Integer n = 96;
        int dpi = ((Number)(Result.isFailure-impl((Object)$i$a$-runCatching-TrayPositionKt$isPointWithinLinuxStatusItem$dpi$22) ? n : $i$a$-runCatching-TrayPositionKt$isPointWithinLinuxStatusItem$dpi$22)).intValue();
        double scale = RangesKt.coerceAtLeast((double)((double)dpi / 96.0), (double)0.5);
        int half = RangesKt.coerceAtLeast((int)((int)((double)baseIconSizeAt1x * 0.5 * scale)), (int)8);
        int fudge = RangesKt.coerceAtLeast((int)((int)((double)4 * scale)), (int)2);
        int left = ix - half - fudge;
        int right = ix + half + fudge;
        int top = iy - half - fudge;
        int bottom = iy + half + fudge;
        if (left > px) return false;
        if (px > right) return false;
        boolean bl = true;
        if (!bl) return false;
        if (top > py) return false;
        if (py > bottom) return false;
        return true;
    }

    private static final Pair<Integer, Integer> syntheticClickFromCorner(TrayPosition corner, int screenW, int screenH) {
        int half = TrayPositionKt.dpiAwareHalfIconOffset();
        int x = corner == TrayPosition.TOP_RIGHT || corner == TrayPosition.BOTTOM_RIGHT ? screenW - half : half;
        int y = corner == TrayPosition.BOTTOM_LEFT || corner == TrayPosition.BOTTOM_RIGHT ? screenH - half : half;
        return TuplesKt.to((Object)x, (Object)y);
    }

    public static final /* synthetic */ Dimension access$getLogicalScreenSize() {
        return TrayPositionKt.getLogicalScreenSize();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[LinuxDesktopEnvironment.values().length];
            try {
                nArray[LinuxDesktopEnvironment.KDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinuxDesktopEnvironment.CINNAMON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinuxDesktopEnvironment.GNOME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinuxDesktopEnvironment.MATE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinuxDesktopEnvironment.XFCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OperatingSystem.values().length];
            try {
                nArray[OperatingSystem.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.MACOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TrayPosition.values().length];
            try {
                nArray[TrayPosition.TOP_LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrayPosition.TOP_RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrayPosition.BOTTOM_LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrayPosition.BOTTOM_RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

