/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Locale;
import org.springframework.core.env.PropertySource;

public final class SanitizableData {
    public static final String SANITIZED_VALUE = "******";
    private final PropertySource<?> propertySource;
    private final String key;
    private String lowerCaseKey;
    private final Object value;

    public SanitizableData(PropertySource<?> propertySource, String key, Object value) {
        this.propertySource = propertySource;
        this.key = key;
        this.value = value;
    }

    public PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    public String getKey() {
        return this.key;
    }

    public String getLowerCaseKey() {
        String result = this.lowerCaseKey;
        if (result == null && this.key != null) {
            this.lowerCaseKey = result = this.key.toLowerCase(Locale.getDefault());
        }
        return result;
    }

    public Object getValue() {
        return this.value;
    }

    public SanitizableData withSanitizedValue() {
        return this.withValue(SANITIZED_VALUE);
    }

    public SanitizableData withValue(Object value) {
        return new SanitizableData(this.propertySource, this.key, value);
    }
}

