/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.lib.mac;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0011\b\u0001\u0018\u00002\u00020\u0001:\u00076789:;<B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0010J\u0016\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&J8\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0010\b\u0002\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010,J\b\u0010-\u001a\u00020\u0007H\u0002J\u0006\u0010.\u001a\u00020\u0007J\b\u0010/\u001a\u00020\u0007H\u0002J\b\u00100\u001a\u00020\u0007H\u0002J\u0018\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0010H\u0002J\b\u00103\u001a\u00020\u0007H\u0002J\u0006\u00104\u001a\u00020\u0007J\b\u00105\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager;", "", "iconPath", "", "tooltip", "onLeftClick", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "trayLib", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTrayLibrary;", "tray", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTray;", "menuItems", "", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$MenuItem;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "trayThread", "Ljava/lang/Thread;", "initLatch", "Ljava/util/concurrent/CountDownLatch;", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "ioScope", "callbackReferences", "nativeMenuItemsReferences", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTrayMenuItem;", "onLeftClickCallback", "Landroidx/compose/runtime/MutableState;", "addMenuItem", "menuItem", "updateMenuItemCheckedState", "label", "isChecked", "", "update", "newIconPath", "newTooltip", "newOnLeftClick", "newMenuItems", "", "recreateMenu", "startTray", "initializeOnLeftClickCallback", "initializeTrayMenu", "initializeNativeMenuItem", "nativeItem", "cleanupTray", "stopTray", "getNativeTrayStruct", "MenuItem", "TrayCallback", "MenuItemCallback", "ThemeCallback", "MacTrayLibrary", "MacTrayMenuItem", "MacTray", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMacTrayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacTrayManager.kt\ncom/kdroid/composetray/lib/mac/MacTrayManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,381:1\n360#2,7:382\n1878#2,3:389\n1878#2,3:392\n*S KotlinDebug\n*F\n+ 1 MacTrayManager.kt\ncom/kdroid/composetray/lib/mac/MacTrayManager\n*L\n61#1:382,7\n215#1:389,3\n257#1:392,3\n*E\n"})
public final class MacTrayManager {
    @NotNull
    private String iconPath;
    @NotNull
    private String tooltip;
    @NotNull
    private final MacTrayLibrary trayLib;
    @Nullable
    private MacTray tray;
    @NotNull
    private final List<MenuItem> menuItems;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private Thread trayThread;
    @NotNull
    private final CountDownLatch initLatch;
    @Nullable
    private CoroutineScope mainScope;
    @Nullable
    private CoroutineScope ioScope;
    @NotNull
    private final List<Object> callbackReferences;
    @NotNull
    private final List<MacTrayMenuItem> nativeMenuItemsReferences;
    @NotNull
    private final MutableState<Function0<Unit>> onLeftClickCallback;
    public static final int $stable = 8;

    public MacTrayManager(@NotNull String iconPath, @NotNull String tooltip, @Nullable Function0<Unit> onLeftClick) {
        Intrinsics.checkNotNullParameter((Object)iconPath, (String)"iconPath");
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        this.iconPath = iconPath;
        this.tooltip = tooltip;
        this.trayLib = MacTrayLibrary.INSTANCE;
        this.menuItems = new ArrayList();
        this.running = new AtomicBoolean(false);
        this.lock = new ReentrantLock();
        this.initLatch = new CountDownLatch(1);
        this.callbackReferences = new ArrayList();
        this.nativeMenuItemsReferences = new ArrayList();
        this.onLeftClickCallback = SnapshotStateKt.mutableStateOf$default(onLeftClick, null, (int)2, null);
    }

    public /* synthetic */ MacTrayManager(String string2, String string3, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        this(string2, string3, (Function0<Unit>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMenuItem(@NotNull MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"menuItem");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.menuItems.add(menuItem);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateMenuItemCheckedState(@NotNull String label, boolean isChecked) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Lock lock = this.lock;
        lock.lock();
        try {
            int index;
            block6: {
                int n;
                boolean bl = false;
                List<MenuItem> $this$indexOfFirst$iv = this.menuItems;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<MenuItem> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    MenuItem item$iv;
                    MenuItem it = item$iv = iterator.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getText(), (Object)label)) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index != -1) {
                this.menuItems.set(index, MenuItem.copy$default(this.menuItems.get(index), null, null, false, false, isChecked, null, null, 111, null));
                this.recreateMenu();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(@NotNull String newIconPath, @NotNull String newTooltip, @Nullable Function0<Unit> newOnLeftClick, @Nullable List<MenuItem> newMenuItems) {
        Intrinsics.checkNotNullParameter((Object)newIconPath, (String)"newIconPath");
        Intrinsics.checkNotNullParameter((Object)newTooltip, (String)"newTooltip");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.running.get() || this.tray == null) {
                return;
            }
            boolean iconChanged = !Intrinsics.areEqual((Object)this.iconPath, (Object)newIconPath);
            boolean tooltipChanged = !Intrinsics.areEqual((Object)this.tooltip, (Object)newTooltip);
            boolean onLeftClickChanged = !Intrinsics.areEqual((Object)this.onLeftClickCallback.getValue(), newOnLeftClick);
            this.iconPath = newIconPath;
            this.tooltip = newTooltip;
            this.onLeftClickCallback.setValue(newOnLeftClick);
            MacTray macTray = this.tray;
            if (macTray != null) {
                MacTray it = macTray;
                boolean bl2 = false;
                if (iconChanged) {
                    it.icon_filepath = newIconPath;
                }
                if (tooltipChanged) {
                    it.tooltip = newTooltip;
                }
                if (onLeftClickChanged) {
                    this.initializeOnLeftClickCallback();
                }
            }
            if (newMenuItems != null) {
                this.menuItems.clear();
                this.menuItems.addAll((Collection<MenuItem>)newMenuItems);
                this.recreateMenu();
            } else if (iconChanged || tooltipChanged || onLeftClickChanged) {
                MacTray macTray2 = this.tray;
                Intrinsics.checkNotNull((Object)((Object)macTray2));
                MacTrayLibrary.tray_update(macTray2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void update$default(MacTrayManager macTrayManager, String string2, String string3, Function0 function0, List list, int n, Object object) {
        if ((n & 8) != 0) {
            list = null;
        }
        macTrayManager.update(string2, string3, (Function0<Unit>)function0, list);
    }

    private final void recreateMenu() {
        if (!this.running.get() || this.tray == null) {
            return;
        }
        this.callbackReferences.clear();
        this.nativeMenuItemsReferences.clear();
        this.initializeTrayMenu();
        MacTray macTray = this.tray;
        Intrinsics.checkNotNull((Object)((Object)macTray));
        MacTrayLibrary.tray_update(macTray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void startTray() {
        Lock lock = this.lock;
        lock.lock();
        try {
            void $this$startTray_u24lambda_u240_u241;
            Thread thread;
            boolean bl = false;
            if (this.running.get()) {
                return;
            }
            this.running.set(true);
            this.mainScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
            this.ioScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
            Thread thread2 = thread = new Thread(() -> MacTrayManager.startTray$lambda$0$0(this));
            MacTrayManager macTrayManager = this;
            boolean bl2 = false;
            $this$startTray_u24lambda_u240_u241.setName("MacTray-Thread");
            $this$startTray_u24lambda_u240_u241.setDaemon(true);
            $this$startTray_u24lambda_u240_u241.start();
            macTrayManager.trayThread = thread;
            try {
                this.initLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void initializeOnLeftClickCallback() {
        MacTray macTray = this.tray;
        if (macTray == null) {
            return;
        }
        MacTray trayObj = macTray;
        if (this.onLeftClickCallback.getValue() != null) {
            TrayCallback trayCallback = trayObj.cb = (TrayCallback)new TrayCallback(this){
                final /* synthetic */ MacTrayManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void invoke(Pointer tray) {
                    block0: {
                        CoroutineScope coroutineScope = MacTrayManager.access$getMainScope$p(this.this$0);
                        if (coroutineScope == null) break block0;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ MacTrayManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        CoroutineScope coroutineScope = MacTrayManager.access$getIoScope$p(this.this$0);
                                        if (coroutineScope != null) {
                                            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                int label;
                                                final /* synthetic */ MacTrayManager this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Function0 function0 = (Function0)MacTrayManager.access$getOnLeftClickCallback$p(this.this$0).getValue();
                                                            if (function0 != null) {
                                                                function0.invoke();
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
            };
            Intrinsics.checkNotNull((Object)trayCallback);
            this.callbackReferences.add(trayCallback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeTrayMenu() {
        MacTray macTray = this.tray;
        if (macTray == null) {
            return;
        }
        MacTray trayObj = macTray;
        if (this.menuItems.isEmpty()) {
            trayObj.menu = null;
            return;
        }
        MacTrayMenuItem menuItemPrototype = new MacTrayMenuItem();
        Structure[] structureArray = menuItemPrototype.toArray(this.menuItems.size() + 1);
        Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.kdroid.composetray.lib.mac.MacTrayManager.MacTrayMenuItem>");
        MacTrayMenuItem[] nativeMenuItems = (MacTrayMenuItem[])structureArray;
        Iterable $this$forEachIndexed$iv = this.menuItems;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MenuItem menuItem = (MenuItem)item$iv;
            int index = n;
            boolean bl = false;
            MacTrayMenuItem nativeItem = nativeMenuItems[index];
            this.initializeNativeMenuItem(nativeItem, (MenuItem)item);
            nativeItem.write();
            this.nativeMenuItemsReferences.add(nativeItem);
        }
        nativeMenuItems[this.menuItems.size()].text = null;
        nativeMenuItems[this.menuItems.size()].write();
        trayObj.menu = nativeMenuItems[0].getPointer();
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeNativeMenuItem(MacTrayMenuItem nativeItem, MenuItem menuItem) {
        nativeItem.text = menuItem.getText();
        nativeItem.icon_filepath = menuItem.getIcon();
        nativeItem.disabled = menuItem.isEnabled() ? 0 : 1;
        nativeItem.checked = menuItem.isChecked() ? 1 : 0;
        Function0<Unit> function0 = menuItem.getOnClick();
        if (function0 != null) {
            Function0<Unit> onClick = function0;
            boolean bl = false;
            MenuItemCallback callback2 = new MenuItemCallback(this, onClick){
                final /* synthetic */ MacTrayManager this$0;
                final /* synthetic */ Function0<Unit> $onClick;
                {
                    this.this$0 = $receiver;
                    this.$onClick = $onClick;
                }

                public void invoke(Pointer item) {
                    block1: {
                        if (!MacTrayManager.access$getRunning$p(this.this$0).get()) {
                            return;
                        }
                        CoroutineScope coroutineScope = MacTrayManager.access$getMainScope$p(this.this$0);
                        if (coroutineScope == null) break block1;
                        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$onClick, null){
                            int label;
                            final /* synthetic */ MacTrayManager this$0;
                            final /* synthetic */ Function0<Unit> $onClick;
                            {
                                this.this$0 = $receiver;
                                this.$onClick = $onClick;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        CoroutineScope coroutineScope = MacTrayManager.access$getIoScope$p(this.this$0);
                                        if (coroutineScope != null) {
                                            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onClick, null){
                                                int label;
                                                final /* synthetic */ Function0<Unit> $onClick;
                                                {
                                                    this.$onClick = $onClick;
                                                    super(2, $completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.$onClick.invoke();
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
            };
            nativeItem.cb = callback2;
            this.callbackReferences.add(callback2);
        }
        if (!((Collection)menuItem.getSubMenuItems()).isEmpty()) {
            MacTrayMenuItem subMenuPrototype = new MacTrayMenuItem();
            Structure[] structureArray = subMenuPrototype.toArray(menuItem.getSubMenuItems().size() + 1);
            Intrinsics.checkNotNull((Object)structureArray, (String)"null cannot be cast to non-null type kotlin.Array<com.kdroid.composetray.lib.mac.MacTrayManager.MacTrayMenuItem>");
            MacTrayMenuItem[] subMenuItemsArray = (MacTrayMenuItem[])structureArray;
            Iterable $this$forEachIndexed$iv = menuItem.getSubMenuItems();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void subItem;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                MenuItem menuItem2 = (MenuItem)item$iv;
                int index = n;
                boolean bl = false;
                this.initializeNativeMenuItem(subMenuItemsArray[index], (MenuItem)subItem);
                subMenuItemsArray[index].write();
                this.nativeMenuItemsReferences.add(subMenuItemsArray[index]);
            }
            subMenuItemsArray[menuItem.getSubMenuItems().size()].text = null;
            subMenuItemsArray[menuItem.getSubMenuItems().size()].write();
            nativeItem.submenu = subMenuItemsArray[0].getPointer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupTray() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            MacTray macTray = this.tray;
            if (macTray != null) {
                MacTray it = macTray;
                boolean bl2 = false;
                try {
                    MacTrayLibrary.tray_dispose(it);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.callbackReferences.clear();
            this.nativeMenuItemsReferences.clear();
            this.menuItems.clear();
            this.tray = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopTray() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.running.get()) {
                return;
            }
            this.running.set(false);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        Thread thread = this.trayThread;
        if (thread != null) {
            Thread thread2 = thread;
            boolean bl = false;
            try {
                thread2.join(5000L);
                if (thread2.isAlive()) {
                    thread2.interrupt();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        CoroutineScope coroutineScope = this.mainScope;
        if (coroutineScope != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
        }
        CoroutineScope coroutineScope2 = this.ioScope;
        if (coroutineScope2 != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope2, null, (int)1, null);
        }
        this.mainScope = null;
        this.ioScope = null;
        this.trayThread = null;
    }

    @Nullable
    public final MacTray getNativeTrayStruct() {
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startTray$lambda$0$0(MacTrayManager this$0) {
        try {
            MacTray macTray;
            MacTray macTray2 = macTray = new MacTray();
            MacTrayManager macTrayManager = this$0;
            boolean bl = false;
            $this$startTray_u24lambda_u240_u240_u240.icon_filepath = this$0.iconPath;
            $this$startTray_u24lambda_u240_u240_u240.tooltip = this$0.tooltip;
            macTrayManager.tray = macTray;
            this$0.initializeOnLeftClickCallback();
            this$0.initializeTrayMenu();
            MacTray macTray3 = this$0.tray;
            Intrinsics.checkNotNull((Object)((Object)macTray3));
            int initResult = MacTrayLibrary.tray_init(macTray3);
            if (initResult != 0) {
                throw new IllegalStateException("Failed to initialize tray: " + initResult);
            }
            this$0.initLatch.countDown();
            while (this$0.running.get()) {
                int result = MacTrayLibrary.tray_loop(0);
                if (result != 0) {
                    break;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this$0.cleanupTray();
        }
    }

    public static final /* synthetic */ CoroutineScope access$getMainScope$p(MacTrayManager $this) {
        return $this.mainScope;
    }

    public static final /* synthetic */ CoroutineScope access$getIoScope$p(MacTrayManager $this) {
        return $this.ioScope;
    }

    public static final /* synthetic */ MutableState access$getOnLeftClickCallback$p(MacTrayManager $this) {
        return $this.onLeftClickCallback;
    }

    public static final /* synthetic */ AtomicBoolean access$getRunning$p(MacTrayManager $this) {
        return $this.running;
    }

    @Structure.FieldOrder(value={"icon_filepath", "tooltip", "menu", "cb"})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0014R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTray;", "Lcom/sun/jna/Structure;", "<init>", "()V", "icon_filepath", "", "tooltip", "menu", "Lcom/sun/jna/Pointer;", "cb", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$TrayCallback;", "getFieldOrder", "", "ComposeNativeTray"})
    @StabilityInferred(parameters=0)
    public static final class MacTray
    extends Structure {
        @JvmField
        @Nullable
        public String icon_filepath;
        @JvmField
        @Nullable
        public String tooltip;
        @JvmField
        @Nullable
        public Pointer menu;
        @JvmField
        @Nullable
        public TrayCallback cb;
        public static final int $stable = 8;

        @NotNull
        protected List<String> getFieldOrder() {
            Object[] objectArray = new String[]{"icon_filepath", "tooltip", "menu", "cb"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 J\u0011\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0087 J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 J\u0011\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 J\t\u0010\r\u001a\u00020\u000bH\u0087 J\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0087 J\t\u0010\u0011\u001a\u00020\u0005H\u0087 J\u0019\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0087 J!\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0087 J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0087 J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0087 \u00a8\u0006\u001a"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTrayLibrary;", "", "<init>", "()V", "tray_init", "", "tray", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTray;", "tray_loop", "blocking", "tray_update", "", "tray_dispose", "tray_exit", "tray_set_theme_callback", "cb", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$ThemeCallback;", "tray_is_menu_dark", "tray_get_status_item_position", "x", "Lcom/sun/jna/ptr/IntByReference;", "y", "tray_get_status_item_position_for", "tray_get_status_item_region", "", "tray_get_status_item_region_for", "ComposeNativeTray"})
    @StabilityInferred(parameters=1)
    public static final class MacTrayLibrary {
        @NotNull
        public static final MacTrayLibrary INSTANCE = new MacTrayLibrary();
        public static final int $stable;

        private MacTrayLibrary() {
        }

        @JvmStatic
        public static final native int tray_init(@NotNull MacTray var0);

        @JvmStatic
        public static final native int tray_loop(int var0);

        @JvmStatic
        public static final native void tray_update(@NotNull MacTray var0);

        @JvmStatic
        public static final native void tray_dispose(@NotNull MacTray var0);

        @JvmStatic
        public static final native void tray_exit();

        @JvmStatic
        public static final native void tray_set_theme_callback(@NotNull ThemeCallback var0);

        @JvmStatic
        public static final native int tray_is_menu_dark();

        @JvmStatic
        public static final native int tray_get_status_item_position(@NotNull IntByReference var0, @NotNull IntByReference var1);

        @JvmStatic
        public static final native int tray_get_status_item_position_for(@NotNull MacTray var0, @NotNull IntByReference var1, @NotNull IntByReference var2);

        @JvmStatic
        @Nullable
        public static final native String tray_get_status_item_region();

        @JvmStatic
        @Nullable
        public static final native String tray_get_status_item_region_for(@NotNull MacTray var0);

        static {
            Native.register((String)"MacTray");
        }
    }

    @Structure.FieldOrder(value={"text", "icon_filepath", "disabled", "checked", "cb", "submenu"})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0014R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$MacTrayMenuItem;", "Lcom/sun/jna/Structure;", "<init>", "()V", "text", "", "icon_filepath", "disabled", "", "checked", "cb", "Lcom/kdroid/composetray/lib/mac/MacTrayManager$MenuItemCallback;", "submenu", "Lcom/sun/jna/Pointer;", "getFieldOrder", "", "ComposeNativeTray"})
    @StabilityInferred(parameters=0)
    public static final class MacTrayMenuItem
    extends Structure {
        @JvmField
        @Nullable
        public String text;
        @JvmField
        @Nullable
        public String icon_filepath;
        @JvmField
        public int disabled;
        @JvmField
        public int checked;
        @JvmField
        @Nullable
        public MenuItemCallback cb;
        @JvmField
        @Nullable
        public Pointer submenu;
        public static final int $stable = 8;

        @NotNull
        protected List<String> getFieldOrder() {
            Object[] objectArray = new String[]{"text", "icon_filepath", "disabled", "checked", "cb", "submenu"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\rH\u00c6\u0003J_\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\rH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$MenuItem;", "", "text", "", "icon", "isEnabled", "", "isCheckable", "isChecked", "onClick", "Lkotlin/Function0;", "", "subMenuItems", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZZLkotlin/jvm/functions/Function0;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "getIcon", "()Z", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "getSubMenuItems", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "ComposeNativeTray"})
    @StabilityInferred(parameters=0)
    public static final class MenuItem {
        @NotNull
        private final String text;
        @Nullable
        private final String icon;
        private final boolean isEnabled;
        private final boolean isCheckable;
        private final boolean isChecked;
        @Nullable
        private final Function0<Unit> onClick;
        @NotNull
        private final List<MenuItem> subMenuItems;
        public static final int $stable = 8;

        public MenuItem(@NotNull String text, @Nullable String icon, boolean isEnabled, boolean isCheckable, boolean isChecked, @Nullable Function0<Unit> onClick, @NotNull List<MenuItem> subMenuItems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(subMenuItems, (String)"subMenuItems");
            this.text = text;
            this.icon = icon;
            this.isEnabled = isEnabled;
            this.isCheckable = isCheckable;
            this.isChecked = isChecked;
            this.onClick = onClick;
            this.subMenuItems = subMenuItems;
        }

        public /* synthetic */ MenuItem(String string2, String string3, boolean bl, boolean bl2, boolean bl3, Function0 function0, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string3 = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                function0 = null;
            }
            if ((n & 0x40) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string2, string3, bl, bl2, bl3, (Function0<Unit>)function0, list);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final String getIcon() {
            return this.icon;
        }

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final boolean isCheckable() {
            return this.isCheckable;
        }

        public final boolean isChecked() {
            return this.isChecked;
        }

        @Nullable
        public final Function0<Unit> getOnClick() {
            return this.onClick;
        }

        @NotNull
        public final List<MenuItem> getSubMenuItems() {
            return this.subMenuItems;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @Nullable
        public final String component2() {
            return this.icon;
        }

        public final boolean component3() {
            return this.isEnabled;
        }

        public final boolean component4() {
            return this.isCheckable;
        }

        public final boolean component5() {
            return this.isChecked;
        }

        @Nullable
        public final Function0<Unit> component6() {
            return this.onClick;
        }

        @NotNull
        public final List<MenuItem> component7() {
            return this.subMenuItems;
        }

        @NotNull
        public final MenuItem copy(@NotNull String text, @Nullable String icon, boolean isEnabled, boolean isCheckable, boolean isChecked, @Nullable Function0<Unit> onClick, @NotNull List<MenuItem> subMenuItems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(subMenuItems, (String)"subMenuItems");
            return new MenuItem(text, icon, isEnabled, isCheckable, isChecked, onClick, subMenuItems);
        }

        public static /* synthetic */ MenuItem copy$default(MenuItem menuItem, String string2, String string3, boolean bl, boolean bl2, boolean bl3, Function0 function0, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = menuItem.text;
            }
            if ((n & 2) != 0) {
                string3 = menuItem.icon;
            }
            if ((n & 4) != 0) {
                bl = menuItem.isEnabled;
            }
            if ((n & 8) != 0) {
                bl2 = menuItem.isCheckable;
            }
            if ((n & 0x10) != 0) {
                bl3 = menuItem.isChecked;
            }
            if ((n & 0x20) != 0) {
                function0 = menuItem.onClick;
            }
            if ((n & 0x40) != 0) {
                list = menuItem.subMenuItems;
            }
            return menuItem.copy(string2, string3, bl, bl2, bl3, function0, list);
        }

        @NotNull
        public String toString() {
            return "MenuItem(text=" + this.text + ", icon=" + this.icon + ", isEnabled=" + this.isEnabled + ", isCheckable=" + this.isCheckable + ", isChecked=" + this.isChecked + ", onClick=" + this.onClick + ", subMenuItems=" + this.subMenuItems + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + (this.icon == null ? 0 : this.icon.hashCode());
            result = result * 31 + Boolean.hashCode(this.isEnabled);
            result = result * 31 + Boolean.hashCode(this.isCheckable);
            result = result * 31 + Boolean.hashCode(this.isChecked);
            result = result * 31 + (this.onClick == null ? 0 : this.onClick.hashCode());
            result = result * 31 + ((Object)this.subMenuItems).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MenuItem)) {
                return false;
            }
            MenuItem menuItem = (MenuItem)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)menuItem.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.icon, (Object)menuItem.icon)) {
                return false;
            }
            if (this.isEnabled != menuItem.isEnabled) {
                return false;
            }
            if (this.isCheckable != menuItem.isCheckable) {
                return false;
            }
            if (this.isChecked != menuItem.isChecked) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onClick, menuItem.onClick)) {
                return false;
            }
            return Intrinsics.areEqual(this.subMenuItems, menuItem.subMenuItems);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$MenuItemCallback;", "Lcom/sun/jna/Callback;", "invoke", "", "item", "Lcom/sun/jna/Pointer;", "ComposeNativeTray"})
    public static interface MenuItemCallback
    extends Callback {
        public void invoke(@Nullable Pointer var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$ThemeCallback;", "Lcom/sun/jna/Callback;", "invoke", "", "isDark", "", "ComposeNativeTray"})
    public static interface ThemeCallback
    extends Callback {
        public void invoke(int var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/kdroid/composetray/lib/mac/MacTrayManager$TrayCallback;", "Lcom/sun/jna/Callback;", "invoke", "", "tray", "Lcom/sun/jna/Pointer;", "ComposeNativeTray"})
    public static interface TrayCallback
    extends Callback {
        public void invoke(@Nullable Pointer var1);
    }
}

