/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.utils;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ImageComposeScene;
import com.kdroid.composetray.utils.DebugLnKt;
import com.kdroid.composetray.utils.IconRenderProperties;
import java.io.File;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.EncodedImageFormat;
import org.jetbrains.skia.FilterMipmap;
import org.jetbrains.skia.FilterMode;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.MipmapMode;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.SamplingMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0011\u0010\b\u001a\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0011\u0010\b\u001a\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0011\u0010\b\u001a\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0011\u0010\b\u001a\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0011\u0010\b\u001a\r\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000bH\u0007\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/kdroid/composetray/utils/ComposableIconUtils;", "", "<init>", "()V", "renderComposableToPngFile", "", "iconRenderProperties", "Lcom/kdroid/composetray/utils/IconRenderProperties;", "content", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "(Lcom/kdroid/composetray/utils/IconRenderProperties;Lkotlin/jvm/functions/Function2;)Ljava/lang/String;", "renderComposableToPngBytes", "", "(Lcom/kdroid/composetray/utils/IconRenderProperties;Lkotlin/jvm/functions/Function2;)[B", "renderComposableToIcoFile", "renderComposableToIcoBytes", "createTempFile", "Ljava/io/File;", "prefix", "suffix", "calculateContentHash", "", "(Lcom/kdroid/composetray/utils/IconRenderProperties;Lkotlin/jvm/functions/Function2;Landroidx/compose/runtime/Composer;I)J", "ComposeNativeTray"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nComposableIconUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableIconUtils.kt\ncom/kdroid/composetray/utils/ComposableIconUtils\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,229:1\n1282#2,6:230\n*S KotlinDebug\n*F\n+ 1 ComposableIconUtils.kt\ncom/kdroid/composetray/utils/ComposableIconUtils\n*L\n224#1:230,6\n*E\n"})
public final class ComposableIconUtils {
    @NotNull
    public static final ComposableIconUtils INSTANCE = new ComposableIconUtils();
    public static final int $stable;

    private ComposableIconUtils() {
    }

    @NotNull
    public final String renderComposableToPngFile(@NotNull IconRenderProperties iconRenderProperties, @NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter((Object)iconRenderProperties, (String)"iconRenderProperties");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        File tempFile = ComposableIconUtils.createTempFile$default(this, null, ".png", 1, null);
        byte[] pngData = this.renderComposableToPngBytes(iconRenderProperties, content);
        FilesKt.writeBytes((File)tempFile, (byte[])pngData);
        String string2 = tempFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] renderComposableToPngBytes(@NotNull IconRenderProperties iconRenderProperties, @NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)iconRenderProperties, (String)"iconRenderProperties");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        ImageComposeScene scene = null;
        Image renderedIcon = null;
        Object scaledBitmap = null;
        Image scaledImage = null;
        try {
            Data data;
            try {
                scene = new ImageComposeScene(iconRenderProperties.getSceneWidth(), iconRenderProperties.getSceneHeight(), iconRenderProperties.getSceneDensity(), (CoroutineContext)Dispatchers.getUnconfined(), (Function2)ComposableLambdaKt.composableLambdaInstance((int)993044516, (boolean)true, (arg_0, arg_1) -> ComposableIconUtils.renderComposableToPngBytes$lambda$0(content, arg_0, arg_1)));
                renderedIcon = ImageComposeScene.render$default((ImageComposeScene)scene, (long)0L, (int)1, null);
            }
            catch (Exception e) {
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "Unknown error";
                }
                String errorMessage = string2;
                DebugLnKt.errorln((Function0<String>)((Function0)() -> ComposableIconUtils.renderComposableToPngBytes$lambda$1(errorMessage)));
                if (StringsKt.contains((CharSequence)errorMessage, (CharSequence)"DirectX12", (boolean)true) || StringsKt.contains((CharSequence)errorMessage, (CharSequence)"Failed to choose DirectX12 adapter", (boolean)true)) {
                    DebugLnKt.errorln((Function0<String>)((Function0)ComposableIconUtils::renderComposableToPngBytes$lambda$2));
                }
                throw e;
            }
            if (iconRenderProperties.getRequiresScaling()) {
                Bitmap $this$renderComposableToPngBytes_u24lambda_u243 = object = new Bitmap();
                boolean bl = false;
                Bitmap.allocN32Pixels$default((Bitmap)$this$renderComposableToPngBytes_u24lambda_u243, (int)iconRenderProperties.getTargetWidth(), (int)iconRenderProperties.getTargetHeight(), (boolean)false, (int)4, null);
                scaledBitmap = object;
                Pixmap pixmap = scaledBitmap.peekPixels();
                Intrinsics.checkNotNull((Object)pixmap);
                renderedIcon.scalePixels(pixmap, (SamplingMode)new FilterMipmap(FilterMode.LINEAR, MipmapMode.LINEAR), true);
                scaledImage = Image.Companion.makeFromBitmap(scaledBitmap);
                data = Image.encodeToData$default((Image)scaledImage, (EncodedImageFormat)EncodedImageFormat.PNG, (int)0, (int)2, null);
                if (data == null) {
                    throw new Exception("Failed to encode scaled image to PNG");
                }
            } else {
                data = Image.encodeToData$default((Image)renderedIcon, (EncodedImageFormat)EncodedImageFormat.PNG, (int)0, (int)2, null);
                if (data == null) {
                    throw new Exception("Failed to encode image to PNG");
                }
            }
            Data iconData = data;
            object = iconData.getBytes();
        }
        catch (Throwable throwable) {
            try {
                Image image = scaledImage;
                if (image != null) {
                    image.close();
                }
                Object object2 = scaledBitmap;
                if (object2 != null) {
                    object2.close();
                }
                Image image2 = renderedIcon;
                if (image2 != null) {
                    image2.close();
                }
                ImageComposeScene imageComposeScene = scene;
                if (imageComposeScene != null) {
                    imageComposeScene.close();
                }
            }
            catch (Exception e) {
                DebugLnKt.debugln((Function0<String>)((Function0)() -> ComposableIconUtils.renderComposableToPngBytes$lambda$4(e)));
            }
            throw throwable;
        }
        try {
            Image image = scaledImage;
            if (image != null) {
                image.close();
            }
            Object object3 = scaledBitmap;
            if (object3 != null) {
                object3.close();
            }
            Image image3 = renderedIcon;
            if (image3 != null) {
                image3.close();
            }
            scene.close();
        }
        catch (Exception e) {
            DebugLnKt.debugln((Function0<String>)((Function0)() -> ComposableIconUtils.renderComposableToPngBytes$lambda$4(e)));
        }
        return object;
    }

    @NotNull
    public final String renderComposableToIcoFile(@NotNull IconRenderProperties iconRenderProperties, @NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter((Object)iconRenderProperties, (String)"iconRenderProperties");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        File tempFile = ComposableIconUtils.createTempFile$default(this, null, ".ico", 1, null);
        byte[] icoData = this.renderComposableToIcoBytes(iconRenderProperties, content);
        FilesKt.writeBytes((File)tempFile, (byte[])icoData);
        String string2 = tempFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    @NotNull
    public final byte[] renderComposableToIcoBytes(@NotNull IconRenderProperties iconRenderProperties, @NotNull Function2<? super Composer, ? super Integer, Unit> content) {
        Intrinsics.checkNotNullParameter((Object)iconRenderProperties, (String)"iconRenderProperties");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        byte[] pngBytes = this.renderComposableToPngBytes(iconRenderProperties, content);
        int icoHeaderSize = 6;
        int icoDirEntrySize = 16;
        byte[] icoData = new byte[icoHeaderSize + icoDirEntrySize + pngBytes.length];
        icoData[0] = 0;
        icoData[1] = 0;
        icoData[2] = 1;
        icoData[3] = 0;
        icoData[4] = 1;
        icoData[5] = 0;
        icoData[6] = (byte)iconRenderProperties.getTargetWidth();
        icoData[7] = (byte)iconRenderProperties.getTargetHeight();
        icoData[8] = 0;
        icoData[9] = 0;
        icoData[10] = 1;
        icoData[11] = 0;
        icoData[12] = 32;
        icoData[13] = 0;
        int dataSize = pngBytes.length;
        icoData[14] = (byte)(dataSize & 0xFF);
        icoData[15] = (byte)(dataSize >> 8 & 0xFF);
        icoData[16] = (byte)(dataSize >> 16 & 0xFF);
        icoData[17] = (byte)(dataSize >> 24 & 0xFF);
        int offset = icoHeaderSize + icoDirEntrySize;
        icoData[18] = (byte)(offset & 0xFF);
        icoData[19] = (byte)(offset >> 8 & 0xFF);
        icoData[20] = (byte)(offset >> 16 & 0xFF);
        icoData[21] = (byte)(offset >> 24 & 0xFF);
        System.arraycopy(pngBytes, 0, icoData, offset, pngBytes.length);
        return icoData;
    }

    private final File createTempFile(String prefix, String suffix) {
        File tempFile = File.createTempFile(prefix, suffix);
        tempFile.deleteOnExit();
        Intrinsics.checkNotNull((Object)tempFile);
        return tempFile;
    }

    static /* synthetic */ File createTempFile$default(ComposableIconUtils composableIconUtils, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "tray_icon_";
        }
        return composableIconUtils.createTempFile(string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    public final long calculateContentHash(@NotNull IconRenderProperties iconRenderProperties, @NotNull Function2<? super Composer, ? super Integer, Unit> content, @Nullable Composer $composer, int $changed) {
        long l;
        Intrinsics.checkNotNullParameter((Object)iconRenderProperties, (String)"iconRenderProperties");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1074501497, (String)"C(calculateContentHash)N(iconRenderProperties,content)223@8929L74:ComposableIconUtils.kt#22pvc5");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1074501497, (int)$changed, (int)-1, (String)"com.kdroid.composetray.utils.ComposableIconUtils.calculateContentHash (ComposableIconUtils.kt:213)");
        }
        try {
            byte[] pngBytes = this.renderComposableToPngBytes(iconRenderProperties, content);
            CRC32 crc = new CRC32();
            crc.update(pngBytes);
            l = crc.getValue();
        }
        catch (Exception e) {
            Object object;
            void $this$cache$iv;
            ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1803772143, (String)"CC(remember):ComposableIconUtils.kt#9igjgp");
            Composer composer = $composer;
            boolean invalid$iv = $composer.changedInstance((Object)e);
            boolean $i$f$cache = false;
            Object it$iv = $this$cache$iv.rememberedValue();
            boolean bl = false;
            if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
                boolean bl2 = false;
                Function0 value$iv = () -> ComposableIconUtils.calculateContentHash$lambda$0$0(e);
                $this$cache$iv.updateRememberedValue((Object)value$iv);
                object = value$iv;
            } else {
                object = it$iv;
            }
            Function0 function0 = (Function0)object;
            ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
            DebugLnKt.errorln((Function0<String>)function0);
            l = System.currentTimeMillis();
        }
        long l2 = l;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return l2;
    }

    @Composable
    private static final Unit renderComposableToPngBytes$lambda$0(Function2 $content, Composer $composer, int $changed) {
        ComposerKt.sourceInformation((Composer)$composer, (String)"C61@2415L9:ComposableIconUtils.kt#22pvc5");
        if ($composer.shouldExecute(($changed & 3) != 2, $changed & 1)) {
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart((int)993044516, (int)$changed, (int)-1, (String)"com.kdroid.composetray.utils.ComposableIconUtils.renderComposableToPngBytes.<anonymous> (ComposableIconUtils.kt:61)");
            }
            $content.invoke((Object)$composer, (Object)0);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
        } else {
            $composer.skipToGroupEnd();
        }
        return Unit.INSTANCE;
    }

    private static final String renderComposableToPngBytes$lambda$1(String $errorMessage) {
        return "[ComposableIconUtils] Failed to render scene: " + $errorMessage;
    }

    private static final String renderComposableToPngBytes$lambda$2() {
        return "[ComposableIconUtils] DirectX12 not available on this system. Scene rendering failed.";
    }

    private static final String renderComposableToPngBytes$lambda$4(Exception $e) {
        return "[ComposableIconUtils] Error during cleanup: " + $e.getMessage();
    }

    private static final String calculateContentHash$lambda$0$0(Exception $e) {
        return "[ComposableIconUtils] Failed to calculate content hash: " + $e.getMessage();
    }
}

