/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdroidfilter.platformtools.darkmodedetector.linux;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import io.github.kdroidfilter.platformtools.LinuxDesktopEnvironment;
import io.github.kdroidfilter.platformtools.LinuxEnvironmentKt;
import io.github.kdroidfilter.platformtools.darkmodedetector.linux.KdeThemeDetector;
import io.github.kdroidfilter.platformtools.darkmodedetector.linux.KdeThemeDetectorKt;
import io.github.kdroidfilter.platformtools.darkmodedetector.linux.KdeThemeState;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0006\u001a\u000f\u0010\u0000\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0002\u001a\r\u0010\u0003\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\"\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a#\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0012\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002\u001a(\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00180\u00182\u0006\u0010\n\u001a\u00020\u0010H\u0002\u001a$\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\bH\u0002\u001a \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0002\u001a/\u0010!\u001a\u0004\u0018\u00010\u00042\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00180\u0018H\u0002\u00a2\u0006\u0002\u0010#\u001a\"\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\b2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002\u001a\u000f\u0010'\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010(\u001a\u000f\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010(\u00a8\u0006*\u00b2\u0006\f\u0010+\u001a\u0004\u0018\u00010\u0001X\u008a\u008e\u0002\u00b2\u0006\f\u0010,\u001a\u0004\u0018\u00010\u0001X\u008a\u0084\u0002"}, d2={"rememberKdeDarkModeState", "Lio/github/kdroidfilter/platformtools/darkmodedetector/linux/KdeThemeState;", "(Landroidx/compose/runtime/Composer;I)Lio/github/kdroidfilter/platformtools/darkmodedetector/linux/KdeThemeState;", "isKdeInDarkMode", "", "(Landroidx/compose/runtime/Composer;I)Z", "isTwilightLaf", "lookAndFeel", "", "runKReadConfig", "file", "group", "key", "normalizePlasmaThemeName", "rawTheme", "firstReadable", "Ljava/io/File;", "paths", "", "([Ljava/lang/String;)Ljava/io/File;", "plasmaThemeDirCandidates", "", "themeName", "parseIni", "", "parseKdeRgb", "Lkotlin/Triple;", "", "value", "isRgbDark", "r", "g", "b", "deriveDarkFromColorsMap", "colors", "(Ljava/util/Map;)Ljava/lang/Boolean;", "resolvePlasmaColorsFile", "visited", "", "detectKdeDarkTheme", "()Ljava/lang/Boolean;", "detectKdePanelDark", "darkmodedetector", "current", "collected"})
@SourceDebugExtension(value={"SMAP\nKdeThemeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KdeThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/linux/KdeThemeDetectorKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 7 Effects.kt\nandroidx/compose/runtime/DisposableEffectScope\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,442:1\n1282#2,6:443\n1282#2,6:449\n1282#2,6:455\n1282#2,6:461\n1#3:467\n1#3:480\n183#4,2:468\n1617#5,9:470\n1869#5:479\n1870#5:481\n1626#5:482\n1869#5,2:483\n295#5,2:485\n295#5,2:487\n1563#5:489\n1634#5,3:490\n774#5:493\n865#5,2:494\n1869#5,2:496\n1374#5:498\n1460#5,5:499\n1563#5:504\n1634#5,3:505\n295#5,2:508\n85#6:510\n117#6,2:511\n85#6:518\n66#7,5:513\n382#8,7:519\n*S KotlinDebug\n*F\n+ 1 KdeThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/linux/KdeThemeDetectorKt\n*L\n219#1:443,6\n222#1:449,6\n237#1:455,6\n239#1:461,6\n334#1:480\n288#1:468,2\n334#1:470,9\n334#1:479\n334#1:481\n334#1:482\n354#1:483,2\n366#1:485,2\n374#1:487,2\n378#1:489\n378#1:490,3\n379#1:493\n379#1:494,2\n380#1:496,2\n400#1:498\n400#1:499,5\n401#1:504\n401#1:505,3\n401#1:508,2\n219#1:510\n219#1:511,2\n238#1:518\n229#1:513,5\n325#1:519,7\n*E\n"})
public final class KdeThemeDetectorKt {
    /*
     * WARNING - void declaration
     */
    @Composable
    @Nullable
    public static final KdeThemeState rememberKdeDarkModeState(@Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        StateFlow<KdeThemeState> stateFlow;
        void $this$cache$iv2;
        Object object2;
        Object object3;
        Object object4;
        MutableState value$iv;
        Composer $this$cache$iv3;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1576231895, (int)$changed, (int)-1, (String)"io.github.kdroidfilter.platformtools.darkmodedetector.linux.rememberKdeDarkModeState (KdeThemeDetector.kt:216)");
        }
        Composer composer = $composer;
        boolean bl = false;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv3.rememberedValue();
        boolean bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            value$iv = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
            $this$cache$iv3.updateRememberedValue((Object)value$iv);
            object4 = value$iv;
        } else {
            object4 = it$iv;
        }
        MutableState current$delegate = (MutableState)object4;
        Unit unit = Unit.INSTANCE;
        $this$cache$iv3 = $composer;
        boolean invalid$iv22 = false;
        $i$f$cache = false;
        it$iv = $this$cache$iv3.rememberedValue();
        bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            object3 = unit;
            boolean bl4 = false;
            unit = object3;
            value$iv = KdeThemeDetectorKt::rememberKdeDarkModeState$lambda$3$0;
            $this$cache$iv3.updateRememberedValue((Object)value$iv);
            object2 = value$iv;
        } else {
            object2 = it$iv;
        }
        EffectsKt.DisposableEffect((Object)unit, (Function1)((Function1)object2), (Composer)$composer, (int)54);
        Composer invalid$iv22 = $composer;
        $i$f$cache = false;
        boolean $i$f$cache2 = false;
        StateFlow<KdeThemeState> it$iv2 = $this$cache$iv2.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (it$iv2 == Composer.Companion.getEmpty()) {
            boolean bl5 = false;
            StateFlow<KdeThemeState> value$iv2 = KdeThemeDetector.INSTANCE.themeState();
            $this$cache$iv2.updateRememberedValue(value$iv2);
            stateFlow = value$iv2;
        } else {
            stateFlow = it$iv2;
        }
        StateFlow flow = (StateFlow)stateFlow;
        State collected$delegate = SnapshotStateKt.collectAsState((Flow)((Flow)flow), null, null, (Composer)$composer, (int)48, (int)2);
        KdeThemeState kdeThemeState = KdeThemeDetectorKt.rememberKdeDarkModeState$lambda$5((State<KdeThemeState>)collected$delegate);
        Composer invalid$iv = $composer;
        boolean invalid$iv3 = $composer.changed((Object)collected$delegate);
        boolean $i$f$cache3 = false;
        Object it$iv3 = $this$cache$iv.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (invalid$iv3 || it$iv3 == Composer.Companion.getEmpty()) {
            object3 = kdeThemeState;
            boolean bl6 = false;
            kdeThemeState = object3;
            Function2 value$iv3 = (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((State<KdeThemeState>)collected$delegate, (MutableState<KdeThemeState>)current$delegate, null){
                int label;
                final /* synthetic */ State<KdeThemeState> $collected$delegate;
                final /* synthetic */ MutableState<KdeThemeState> $current$delegate;
                {
                    this.$collected$delegate = $collected$delegate;
                    this.$current$delegate = $current$delegate;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            KdeThemeDetectorKt.access$rememberKdeDarkModeState$lambda$2(this.$current$delegate, KdeThemeDetectorKt.access$rememberKdeDarkModeState$lambda$5(this.$collected$delegate));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            };
            $this$cache$iv.updateRememberedValue((Object)value$iv3);
            object = value$iv3;
        } else {
            object = it$iv3;
        }
        EffectsKt.LaunchedEffect((Object)kdeThemeState, (Function2)((Function2)object), (Composer)$composer, (int)0);
        KdeThemeState kdeThemeState2 = KdeThemeDetectorKt.rememberKdeDarkModeState$lambda$1((MutableState<KdeThemeState>)current$delegate);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return kdeThemeState2;
    }

    @Composable
    public static final boolean isKdeInDarkMode(@Nullable Composer $composer, int $changed) {
        boolean bl;
        KdeThemeState st;
        Object object;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1890391680, (int)$changed, (int)-1, (String)"io.github.kdroidfilter.platformtools.darkmodedetector.linux.isKdeInDarkMode (KdeThemeDetector.kt:245)");
        }
        if ((object = (st = KdeThemeDetectorKt.rememberKdeDarkModeState($composer, 0))) != null && (object = ((KdeThemeState)object).getWindowTheme()) != null) {
            v1 = (Boolean)object;
        } else {
            KdeThemeState kdeThemeState = st;
            Boolean bl2 = kdeThemeState != null ? kdeThemeState.getPanelTheme() : null;
            v1 = bl = bl2 != null ? bl2 : false;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return bl;
    }

    private static final boolean isTwilightLaf(String lookAndFeel) {
        CharSequence charSequence = lookAndFeel;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return false;
        }
        String string = lookAndFeel.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String s = string;
        return StringsKt.contains$default((CharSequence)s, (CharSequence)"breezetwilight", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)s, (CharSequence)"breeze", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)s, (CharSequence)"twilight", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String runKReadConfig(String file, String group, String key) {
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[]{"kreadconfig6", "--file", file, "--group", group, "--key", key};
        stringArrayArray[0] = stringArray;
        stringArray = new String[]{"kreadconfig5", "--file", file, "--group", group, "--key", key};
        stringArrayArray[1] = stringArray;
        List cmds = CollectionsKt.listOf((Object[])((Object[])stringArrayArray));
        for (String[] cmd : cmds) {
            try {
                String string;
                Process p = new ProcessBuilder(Arrays.copyOf(cmd, cmd.length)).redirectErrorStream(true).start();
                Object object = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)object;
                    boolean bl = false;
                    String string2 = it.readLine();
                    string = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                String out = string;
                p.waitFor(300L, TimeUnit.MILLISECONDS);
                object = out;
                if (object == null || StringsKt.isBlank((CharSequence)object)) continue;
                return out;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static final String normalizePlasmaThemeName(String rawTheme, String lookAndFeel) {
        if (KdeThemeDetectorKt.isTwilightLaf(lookAndFeel)) {
            return "breeze-dark";
        }
        CharSequence charSequence = rawTheme;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || StringsKt.equals((String)rawTheme, (String)"default", (boolean)true)) {
            return "breeze";
        }
        String string = rawTheme.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "breezedark", "org.kde.breezedark.desktop", "breeze-dark" -> "breeze-dark";
            case "breeze", "org.kde.breeze.desktop" -> "breeze";
            default -> rawTheme;
        };
    }

    private static final File firstReadable(String ... paths) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths), (Function1)firstReadable.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!(it.isFile() && it.canRead())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final List<File> plasmaThemeDirCandidates(String themeName) {
        String string = System.getenv("HOME");
        if (string == null) {
            string = System.getProperty("user.home");
        }
        String home = string;
        Object[] objectArray = new String[6];
        objectArray[0] = themeName;
        objectArray[1] = StringsKt.replace$default((String)themeName, (char)' ', (char)'_', (boolean)false, (int)4, null);
        objectArray[2] = StringsKt.replace$default((String)themeName, (char)' ', (char)'-', (boolean)false, (int)4, null);
        Intrinsics.checkNotNullExpressionValue((Object)themeName.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
        String string2 = themeName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        objectArray[4] = StringsKt.replace$default((String)string2, (char)' ', (char)'_', (boolean)false, (int)4, null);
        String string3 = themeName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        objectArray[5] = StringsKt.replace$default((String)string3, (char)' ', (char)'-', (boolean)false, (int)4, null);
        List variants = CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])objectArray));
        Object[] objectArray2 = new String[]{home + "/.local/share/plasma/desktoptheme", "/usr/share/plasma/desktoptheme"};
        List roots = CollectionsKt.listOf((Object[])objectArray2);
        List dirs = new ArrayList();
        for (String v : variants) {
            for (String r : roots) {
                ((Collection)dirs).add(new File(r + "/" + v));
            }
        }
        return dirs;
    }

    private static final Map<String, Map<String, String>> parseIni(File file) {
        Map result = new LinkedHashMap();
        Ref.ObjectRef section = new Ref.ObjectRef();
        section.element = "";
        FilesKt.forEachLine$default((File)file, null, arg_0 -> KdeThemeDetectorKt.parseIni$lambda$0(section, result, arg_0), (int)1, null);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final Triple<Integer, Integer, Integer> parseKdeRgb(String value) {
        void $this$mapNotNullTo$iv$iv;
        char[] cArray = new char[]{',', ' '};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)it)).toString()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nums = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3);
        return nums.size() == 3 ? new Triple((Object)RangesKt.coerceIn((int)((Number)nums.get(0)).intValue(), (int)0, (int)255), (Object)RangesKt.coerceIn((int)((Number)nums.get(1)).intValue(), (int)0, (int)255), (Object)RangesKt.coerceIn((int)((Number)nums.get(2)).intValue(), (int)0, (int)255)) : null;
    }

    private static final boolean isRgbDark(int r, int g, int b) {
        double lum = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
        return lum < 140.0;
    }

    private static final Boolean deriveDarkFromColorsMap(Map<String, ? extends Map<String, String>> colors) {
        String[] stringArray = new String[]{"Colors:Panel", "Colors:Window", "Colors:View", "Colors:Button"};
        List sectionsInPriority = CollectionsKt.listOf((Object[])stringArray);
        for (String sec : sectionsInPriority) {
            Map<String, String> map = colors.get(sec);
            if (map == null || (map = map.get("BackgroundNormal")) == null) continue;
            Map<String, String> bg = map;
            Triple<Integer, Integer, Integer> triple = KdeThemeDetectorKt.parseKdeRgb((String)((Object)bg));
            if (triple == null) continue;
            Triple<Integer, Integer, Integer> rgb = triple;
            return KdeThemeDetectorKt.isRgbDark(((Number)rgb.getFirst()).intValue(), ((Number)rgb.getSecond()).intValue(), ((Number)rgb.getThird()).intValue());
        }
        Iterable $this$forEach$iv = colors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String v;
            Map section = (Map)element$iv;
            boolean bl = false;
            if ((String)section.get("BackgroundNormal") == null) continue;
            boolean bl2 = false;
            Triple<Integer, Integer, Integer> triple = KdeThemeDetectorKt.parseKdeRgb(v);
            if (triple == null) continue;
            Triple<Integer, Integer, Integer> triple2 = triple;
            boolean bl3 = false;
            int r = ((Number)triple2.component1()).intValue();
            int g = ((Number)triple2.component2()).intValue();
            int b = ((Number)triple2.component3()).intValue();
            return KdeThemeDetectorKt.isRgbDark(r, g, b);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final File resolvePlasmaColorsFile(String themeName, Set<String> visited) {
        File meta;
        File directColors;
        File file;
        File dir;
        Object v1;
        String[] it;
        block14: {
            String string = themeName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String key = string;
            if (!visited.add(key)) {
                return null;
            }
            Iterable $this$firstOrNull$iv = KdeThemeDetectorKt.plasmaThemeDirCandidates(themeName);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (String[])element$iv;
                boolean bl2 = false;
                if (!(it.isDirectory() && it.canRead())) continue;
                v1 = element$iv;
                break block14;
            }
            v1 = null;
        }
        File file2 = dir = (File)v1;
        if (file2 != null) {
            File it2 = file2;
            boolean bl = false;
            it = new String[]{it2.getPath() + "/colors"};
            file = KdeThemeDetectorKt.firstReadable(it);
        } else {
            file = null;
        }
        File file3 = directColors = file;
        if (file3 != null) {
            return file3;
        }
        File file4 = dir;
        if (file4 != null) {
            File it3 = file4;
            boolean bl = false;
            String[] bl2 = new String[]{it3.getPath() + "/metadata.desktop"};
            v6 = KdeThemeDetectorKt.firstReadable(bl2);
        } else {
            v6 = meta = null;
        }
        if (meta != null) {
            Object object;
            block16: {
                Map<String, Map<String, String>> ini = KdeThemeDetectorKt.parseIni(meta);
                for (Object map : (Iterable)ini.values()) {
                    Object v7;
                    block15: {
                        boolean bl = false;
                        Iterable $this$firstOrNull$iv = map.entrySet();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl3 = false;
                            String k = (String)entry.getKey();
                            if (!(StringsKt.equals((String)k, (String)"Inherits", (boolean)true) || StringsKt.equals((String)k, (String)"inherits", (boolean)true))) continue;
                            v7 = element$iv;
                            break block15;
                        }
                        v7 = null;
                    }
                    Map.Entry entry = v7;
                    map = entry != null ? (String)entry.getValue() : null;
                    if (map == null) continue;
                    object = map;
                    break block16;
                }
                object = null;
            }
            Object inherits = object;
            Object bl = (CharSequence)inherits;
            if (!(bl == null || StringsKt.isBlank((CharSequence)bl))) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String it4;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object map;
                bl = new char[2];
                bl[0] = 44;
                bl[1] = 59;
                bl = StringsKt.split$default((CharSequence)((CharSequence)inherits), (char[])bl, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Object element$iv;
                    element$iv = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it4)).toString());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it4 = (String)element$iv$iv;
                    boolean bl5 = false;
                    boolean bl6 = ((CharSequence)it4).length() > 0;
                    if (!bl6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String parent = (String)element$iv;
                    boolean bl7 = false;
                    File file5 = KdeThemeDetectorKt.resolvePlasmaColorsFile(parent, visited);
                    if (file5 == null) continue;
                    File it5 = file5;
                    boolean bl8 = false;
                    return it5;
                }
            }
        }
        return null;
    }

    static /* synthetic */ File resolvePlasmaColorsFile$default(String string, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return KdeThemeDetectorKt.resolvePlasmaColorsFile(string, set);
    }

    /*
     * WARNING - void declaration
     */
    private static final Boolean detectKdeDarkTheme() {
        Boolean bl;
        if (LinuxEnvironmentKt.detectLinuxDesktopEnvironment() != LinuxDesktopEnvironment.KDE) {
            return null;
        }
        try {
            Object v4;
            block11: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object list$iv$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                String string = KdeThemeDetectorKt.runKReadConfig("kdeglobals", "General", "ColorScheme");
                if (string == null) {
                    return null;
                }
                String scheme = string;
                String string2 = System.getenv("HOME");
                if (string2 == null) {
                    string2 = System.getProperty("user.home");
                }
                String home = string2;
                Object[] objectArray = new String[6];
                objectArray[0] = scheme;
                objectArray[1] = StringsKt.replace$default((String)scheme, (char)' ', (char)'_', (boolean)false, (int)4, null);
                objectArray[2] = StringsKt.replace$default((String)scheme, (char)' ', (char)'-', (boolean)false, (int)4, null);
                Intrinsics.checkNotNullExpressionValue((Object)scheme.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                String string3 = scheme.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                objectArray[4] = StringsKt.replace$default((String)string3, (char)' ', (char)'_', (boolean)false, (int)4, null);
                String string4 = scheme.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                objectArray[5] = StringsKt.replace$default((String)string4, (char)' ', (char)'-', (boolean)false, (int)4, null);
                List variants = CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])objectArray));
                Iterable iterable = variants;
                boolean $i$f$flatMap = false;
                Iterator iterator = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    String v = (String)element$iv$iv;
                    boolean bl2 = false;
                    Object[] objectArray2 = new String[]{home + "/.local/share/color-schemes/" + v + ".colors", "/usr/share/color-schemes/" + v + ".colors"};
                    list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    list$iv$iv = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(new File((String)p0));
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl4 = false;
                    if (!(it.isFile() && it.canRead())) continue;
                    v4 = element$iv;
                    break block11;
                }
                v4 = null;
            }
            File file = v4;
            if (file == null) {
                return null;
            }
            File schemeFile = file;
            Map<String, Map<String, String>> colors = KdeThemeDetectorKt.parseIni(schemeFile);
            bl = KdeThemeDetectorKt.deriveDarkFromColorsMap(colors);
        }
        catch (Exception exception) {
            Boolean bl5;
            try {
                String laf;
                String string = laf = KdeThemeDetectorKt.runKReadConfig("kdeglobals", "KDE", "LookAndFeelPackage");
                bl5 = string != null ? Boolean.valueOf(StringsKt.contains((CharSequence)string, (CharSequence)"dark", (boolean)true)) : null;
            }
            catch (Exception exception2) {
                bl5 = null;
            }
            bl = bl5;
        }
        return bl;
    }

    private static final Boolean detectKdePanelDark() {
        Boolean bl;
        if (LinuxEnvironmentKt.detectLinuxDesktopEnvironment() != LinuxDesktopEnvironment.KDE) {
            return null;
        }
        try {
            Boolean bl2;
            Map<String, Map<String, String>> colors;
            Boolean derived;
            String string = KdeThemeDetectorKt.runKReadConfig("plasmarc", "Theme", "name");
            if (string == null) {
                string = KdeThemeDetectorKt.runKReadConfig("plasmashellrc", "Theme", "name");
            }
            String rawTheme = string;
            String lookAndFeel = KdeThemeDetectorKt.runKReadConfig("kdeglobals", "KDE", "LookAndFeelPackage");
            String string2 = KdeThemeDetectorKt.normalizePlasmaThemeName(rawTheme, lookAndFeel);
            if (string2 == null) {
                return null;
            }
            String theme = string2;
            File colorsFile = KdeThemeDetectorKt.resolvePlasmaColorsFile$default(theme, null, 2, null);
            if (colorsFile != null && (derived = KdeThemeDetectorKt.deriveDarkFromColorsMap(colors = KdeThemeDetectorKt.parseIni(colorsFile))) != null) {
                return derived;
            }
            String scheme = KdeThemeDetectorKt.runKReadConfig("kdeglobals", "General", "ColorScheme");
            String string3 = scheme;
            boolean bl3 = string3 != null ? StringsKt.contains((CharSequence)string3, (CharSequence)"dark", (boolean)true) : false;
            if (bl3) {
                bl2 = true;
            } else {
                String string4 = scheme;
                boolean bl4 = string4 != null ? StringsKt.contains((CharSequence)string4, (CharSequence)"light", (boolean)true) : false;
                if (bl4) {
                    bl2 = false;
                } else {
                    String string5 = lookAndFeel;
                    boolean bl5 = string5 != null ? StringsKt.contains((CharSequence)string5, (CharSequence)"dark", (boolean)true) : false;
                    if (bl5) {
                        bl2 = true;
                    } else {
                        String string6 = lookAndFeel;
                        bl2 = (string6 != null ? StringsKt.contains((CharSequence)string6, (CharSequence)"light", (boolean)true) : false) ? Boolean.valueOf(false) : null;
                    }
                }
            }
            bl = bl2;
        }
        catch (Exception exception) {
            bl = null;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final KdeThemeState rememberKdeDarkModeState$lambda$1(MutableState<KdeThemeState> $current$delegate) {
        void $this$getValue$iv;
        State state = (State)$current$delegate;
        Object var2_2 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (KdeThemeState)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final void rememberKdeDarkModeState$lambda$2(MutableState<KdeThemeState> $current$delegate, KdeThemeState kdeThemeState) {
        void $this$setValue$iv;
        MutableState<KdeThemeState> mutableState = $current$delegate;
        Object var3_3 = null;
        Object var4_4 = null;
        KdeThemeState value$iv = kdeThemeState;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    private static final DisposableEffectResult rememberKdeDarkModeState$lambda$3$0(DisposableEffectScope $this$DisposableEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
        Ref.BooleanRef disposed = new Ref.BooleanRef();
        CompletableJob job = JobKt.Job$default(null, (int)1, null);
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)job));
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = KdeThemeDetector.INSTANCE.startIfNeeded((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        DisposableEffectScope this_$iv = $this$DisposableEffect;
        boolean $i$f$onDispose = false;
        return new DisposableEffectResult(disposed, job){
            final /* synthetic */ Ref.BooleanRef $disposed$inlined;
            final /* synthetic */ CompletableJob $job$inlined;
            {
                this.$disposed$inlined = booleanRef;
                this.$job$inlined = completableJob;
            }

            public void dispose() {
                boolean bl = false;
                this.$disposed$inlined.element = true;
                Job.DefaultImpls.cancel$default((Job)((Job)this.$job$inlined), null, (int)1, null);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final KdeThemeState rememberKdeDarkModeState$lambda$5(State<KdeThemeState> $collected$delegate) {
        void $this$getValue$iv;
        State<KdeThemeState> state = $collected$delegate;
        Object var2_2 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (KdeThemeState)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit parseIni$lambda$0(Ref.ObjectRef $section, Map $result, String raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        String line = ((Object)StringsKt.trim((CharSequence)raw)).toString();
        if (((CharSequence)line).length() == 0 || StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)";", (boolean)false, (int)2, null)) {
            return Unit.INSTANCE;
        }
        if (StringsKt.startsWith$default((String)line, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)line, (String)"]", (boolean)false, (int)2, null)) {
            String string = line.substring(1, line.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $section.element = string;
            $result.putIfAbsent($section.element, (Map)new LinkedHashMap());
        } else {
            int idx = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (idx > 0) {
                Object object;
                void $this$getOrPut$iv;
                String string = line.substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String k = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string2 = line.substring(idx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String v = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                Map map = $result;
                Object key$iv = $section.element;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Map)object).put(k, v);
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Boolean access$detectKdeDarkTheme() {
        return KdeThemeDetectorKt.detectKdeDarkTheme();
    }

    public static final /* synthetic */ Boolean access$detectKdePanelDark() {
        return KdeThemeDetectorKt.detectKdePanelDark();
    }

    public static final /* synthetic */ void access$rememberKdeDarkModeState$lambda$2(MutableState $current$delegate, KdeThemeState kdeThemeState) {
        KdeThemeDetectorKt.rememberKdeDarkModeState$lambda$2((MutableState<KdeThemeState>)$current$delegate, kdeThemeState);
    }

    public static final /* synthetic */ KdeThemeState access$rememberKdeDarkModeState$lambda$5(State $collected$delegate) {
        return KdeThemeDetectorKt.rememberKdeDarkModeState$lambda$5((State<KdeThemeState>)$collected$delegate);
    }
}

