/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client;

import com.swisscom.health.des.cdr.client.CdrClientApplication;
import com.swisscom.health.des.cdr.client.common.UtilKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.SpringApplication;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\b\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\n\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\n\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DEFAULT_CUSTOMER_CONFIG_FILE", "", "SERVICE_LOGBACK_FILE", "SPRING_BOOT_ADDITIONAL_CONFIG_FILE_LOCATION_PROPERTY", "LOGBACK_CONFIGURATION_FILE_PROPERTY", "SPRING_BOOT_LOGBACK_CONFIG_LOCATION_PROPERTY", "main", "", "args", "", "([Ljava/lang/String;)V", "initConfig", "initSpringBootConfig", "initLogbackConfig", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nCdrClientApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdrClientApplication.kt\ncom/swisscom/health/des/cdr/client/CdrClientApplicationKt\n+ 2 SpringApplicationExtensions.kt\norg/springframework/boot/SpringApplicationExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n34#2:183\n1#3:184\n*S KotlinDebug\n*F\n+ 1 CdrClientApplication.kt\ncom/swisscom/health/des/cdr/client/CdrClientApplicationKt\n*L\n37#1:183\n*E\n"})
public final class CdrClientApplicationKt {
    @NotNull
    private static final String DEFAULT_CUSTOMER_CONFIG_FILE = "default-application-customer.yaml";
    @NotNull
    private static final String SERVICE_LOGBACK_FILE = "logback-service.xml";
    @NotNull
    private static final String SPRING_BOOT_ADDITIONAL_CONFIG_FILE_LOCATION_PROPERTY = "spring.config.additional-location";
    @NotNull
    private static final String LOGBACK_CONFIGURATION_FILE_PROPERTY = "logback.configurationFile";
    @NotNull
    private static final String SPRING_BOOT_LOGBACK_CONFIG_LOCATION_PROPERTY = "logging.config";

    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CdrClientApplicationKt.initConfig();
        String[] args$iv = Arrays.copyOf(args, args.length);
        boolean $i$f$runApplication = false;
        Intrinsics.checkNotNullExpressionValue((Object)SpringApplication.run(CdrClientApplication.class, (String[])Arrays.copyOf(args$iv, args$iv.length)), (String)"run(T::class.java, *args)");
    }

    private static final void initConfig() {
        CdrClientApplicationKt.initLogbackConfig();
        CdrClientApplicationKt.initSpringBootConfig();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String initSpringBootConfig() {
        Path path;
        Path path2;
        String string = System.getProperty(SPRING_BOOT_ADDITIONAL_CONFIG_FILE_LOCATION_PROPERTY);
        if (string == null) return null;
        String additionalConfigLocation = string;
        boolean bl = false;
        Path additionalConfigPath = Path.of(additionalConfigLocation, new String[0]);
        if (!additionalConfigPath.isAbsolute()) {
            String string2 = System.getProperty("user.home");
            if (string2 == null) {
                boolean $i$a$-requireNotNull-CdrClientApplicationKt$initSpringBootConfig$1$userHome$22 = false;
                String $i$a$-requireNotNull-CdrClientApplicationKt$initSpringBootConfig$1$userHome$22 = "User home directory is not set but is required to resolve the relative configuration path '" + additionalConfigLocation + "'";
                throw new IllegalArgumentException($i$a$-requireNotNull-CdrClientApplicationKt$initSpringBootConfig$1$userHome$22.toString());
            }
            String p0 = string2;
            boolean bl2 = false;
            Path path3 = Path.of(p0, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"run(...)");
            Path userHome = path3;
            path2 = userHome.resolve(Path.of(additionalConfigLocation, new String[0]));
        } else {
            path2 = additionalConfigPath;
        }
        if ((path = path2) == null) return null;
        Path path4 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toAbsolutePath(...)");
        Path path5 = path4;
        if (path5 == null) return null;
        Path customerConfigFile = path5;
        boolean bl3 = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(customerConfigFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!(Files.isRegularFile(customerConfigFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Files.isReadable(customerConfigFile))) {
                boolean $i$a$-check-CdrClientApplicationKt$initSpringBootConfig$2$32 = false;
                String $i$a$-check-CdrClientApplicationKt$initSpringBootConfig$2$32 = "The customer configuration file path '" + customerConfigFile + "' exists but does not point to a readable regular file.";
                throw new IllegalStateException($i$a$-check-CdrClientApplicationKt$initSpringBootConfig$2$32.toString());
            }
            System.out.println((Object)("customer application config file '" + customerConfigFile + "' exists, skipping creation of default configuration file"));
        } else {
            String string3;
            System.out.println((Object)("config file '" + customerConfigFile + "' does not exist, creating default customer configuration file"));
            String string4 = ProcessHandle.current().info().command().get();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"get(...)");
            String cdrServiceCmd = string4;
            boolean bl4 = false;
            Path path6 = Path.of(cdrServiceCmd, new String[0]).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"getParent(...)");
            Path path7 = path6.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"toAbsolutePath(...)");
            Path pwd = path7;
            List defaultCustomerConfigFile = UtilKt.escalatingFind((String)DEFAULT_CUSTOMER_CONFIG_FILE, (Path)pwd);
            if (!(defaultCustomerConfigFile.size() == 1)) {
                boolean $i$a$-check-CdrClientApplicationKt$initSpringBootConfig$2$42 = false;
                String $i$a$-check-CdrClientApplicationKt$initSpringBootConfig$2$42 = "Expected exactly one default customer configuration file with name 'default-application-customer.yaml', but found '" + defaultCustomerConfigFile.size() + "' files: '" + defaultCustomerConfigFile + "'; search started in '" + pwd + "'";
                throw new IllegalStateException($i$a$-check-CdrClientApplicationKt$initSpringBootConfig$2$42.toString());
            }
            System.out.println((Object)("found customer configuration template at: '" + CollectionsKt.first((List)defaultCustomerConfigFile) + "'"));
            String defaultConfigContents = string3 = PathsKt.readText$default((Path)((Path)CollectionsKt.first((List)defaultCustomerConfigFile)), null, (int)1, null);
            boolean bl5 = false;
            PathsKt.createParentDirectories((Path)customerConfigFile, (FileAttribute[])new FileAttribute[0]);
            PathsKt.writeText$default((Path)customerConfigFile, (CharSequence)defaultConfigContents, null, (OpenOption[])new OpenOption[0], (int)2, null);
            System.out.println((Object)"default customer configuration file created at");
        }
        boolean bl6 = false;
        String string5 = System.setProperty(SPRING_BOOT_ADDITIONAL_CONFIG_FILE_LOCATION_PROPERTY, ((Object)customerConfigFile).toString());
        return string5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String initLogbackConfig() {
        Path path;
        Path path2;
        String string = System.getProperty(SPRING_BOOT_LOGBACK_CONFIG_LOCATION_PROPERTY);
        if (string == null) return null;
        String logbackConfigLocation = string;
        boolean bl = false;
        Path logbackConfigPath = Path.of(logbackConfigLocation, new String[0]);
        if (!logbackConfigPath.isAbsolute()) {
            String string2 = System.getProperty("user.home");
            if (string2 == null) {
                boolean $i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$1$userHome$22 = false;
                String $i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$1$userHome$22 = "User home directory is not set but is required to resolve the relative logback configuration path '" + logbackConfigLocation + "'";
                throw new IllegalArgumentException($i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$1$userHome$22.toString());
            }
            String p0 = string2;
            boolean bl2 = false;
            Path path3 = Path.of(p0, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"run(...)");
            Path userHome = path3;
            path2 = userHome.resolve(Path.of(logbackConfigLocation, new String[0]));
        } else {
            path2 = logbackConfigPath;
        }
        if ((path = path2) == null) return null;
        Path path4 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toAbsolutePath(...)");
        Path path5 = path4;
        if (path5 == null) return null;
        Path logbackConfigFile = path5;
        boolean bl3 = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(logbackConfigFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!(Files.isRegularFile(logbackConfigFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && Files.isReadable(logbackConfigFile))) {
                boolean $i$a$-check-CdrClientApplicationKt$initLogbackConfig$2$32 = false;
                String $i$a$-check-CdrClientApplicationKt$initLogbackConfig$2$32 = "The logback configuration file path '" + logbackConfigFile + "' exists but does not point to a readable regular file.";
                throw new IllegalStateException($i$a$-check-CdrClientApplicationKt$initLogbackConfig$2$32.toString());
            }
            System.out.println((Object)("logback config file '" + logbackConfigFile + "' exists, skipping creation of default configuration file"));
        } else {
            String string3;
            Path path6;
            System.out.println((Object)("logback config file '" + logbackConfigFile + "' does not exist, creating default logback configuration file"));
            String string4 = ProcessHandle.current().info().command().get();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"get(...)");
            String cdrServiceCmd = string4;
            boolean bl4 = false;
            Path path7 = Path.of(cdrServiceCmd, new String[0]).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"getParent(...)");
            Path path8 = path7.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"toAbsolutePath(...)");
            Path pwd = path8;
            List defaultLogbackConfigFile = UtilKt.escalatingFind((String)SERVICE_LOGBACK_FILE, (Path)pwd);
            if (!(defaultLogbackConfigFile.size() == 1)) {
                boolean bl5 = false;
                String string5 = "Expected exactly one default logback configuration file with name 'logback-service.xml', but found '" + defaultLogbackConfigFile.size() + "' files: '" + defaultLogbackConfigFile + "'; search started in '" + pwd + "'";
                throw new IllegalStateException(string5.toString());
            }
            System.out.println((Object)("found logback configuration template at: '" + CollectionsKt.first((List)defaultLogbackConfigFile) + "'"));
            String string6 = System.getProperty("cdr.client.log.directory");
            if (string6 == null) {
                boolean $i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$2$logDir$22 = false;
                String $i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$2$logDir$22 = "log directory system property 'cdr.client.log.directory' is not set";
                throw new IllegalArgumentException($i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$2$logDir$22.toString());
            }
            String p0 = string6;
            boolean bl6 = false;
            Path $this$initLogbackConfig_u24lambda_u241_u244 = Path.of(p0, new String[0]);
            boolean bl7 = false;
            if ($this$initLogbackConfig_u24lambda_u241_u244.isAbsolute()) {
                path6 = $this$initLogbackConfig_u24lambda_u241_u244;
            } else {
                String string7 = System.getProperty("user.home");
                if (string7 == null) {
                    boolean $i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$2$logDir$3$22 = false;
                    String $i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$2$logDir$3$22 = "User home directory is not set but is required to resolve the relative log directory '" + $this$initLogbackConfig_u24lambda_u241_u244 + "'";
                    throw new IllegalArgumentException($i$a$-requireNotNull-CdrClientApplicationKt$initLogbackConfig$2$logDir$3$22.toString());
                }
                String p02 = string7;
                boolean bl8 = false;
                Path path9 = Path.of(p02, new String[0]).resolve($this$initLogbackConfig_u24lambda_u241_u244);
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"resolve(...)");
                Path path10 = path9.toAbsolutePath();
                path6 = path10;
                Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"toAbsolutePath(...)");
            }
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"run(...)");
            Path logDir = path6;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(logDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            String defaultConfigContents = string3 = StringsKt.replace$default((String)PathsKt.readText$default((Path)((Path)CollectionsKt.first((List)defaultLogbackConfigFile)), null, (int)1, null), (String)"@@LOG_DIR@@", (String)((Object)logDir).toString(), (boolean)false, (int)4, null);
            boolean bl9 = false;
            PathsKt.createParentDirectories((Path)logbackConfigFile, (FileAttribute[])new FileAttribute[0]);
            PathsKt.writeText$default((Path)logbackConfigFile, (CharSequence)defaultConfigContents, null, (OpenOption[])new OpenOption[0], (int)2, null);
            System.out.println((Object)("default logback configuration file created at: '" + logbackConfigFile + "'"));
        }
        boolean bl10 = false;
        System.setProperty(SPRING_BOOT_LOGBACK_CONFIG_LOCATION_PROPERTY, ((Object)logbackConfigFile).toString());
        String string8 = System.setProperty(LOGBACK_CONFIGURATION_FILE_PROPERTY, ((Object)logbackConfigFile).toString());
        return string8;
    }
}

