/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.config;

import com.mayakapps.kache.InMemoryKache;
import com.mayakapps.kache.InMemoryKacheKt;
import com.mayakapps.kache.KacheStrategy;
import com.mayakapps.kache.ObjectKache;
import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.CdrClientContextKt;
import com.swisscom.health.des.cdr.client.config.FileBusyTester;
import com.swisscom.health.des.cdr.client.config.HttpServerErrorException;
import com.swisscom.health.des.cdr.client.config.OAuth2AuthNService;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0011\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000bH\u0017J\n\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J0\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u001cH\u0017J\u0012\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020\u001cH\u0017J\b\u0010#\u001a\u00020!H\u0017J\b\u0010$\u001a\u00020!H\u0017J\b\u0010%\u001a\u00020!H\u0017\u00a8\u0006&"}, d2={"Lcom/swisscom/health/des/cdr/client/config/CdrClientContext;", "", "<init>", "()V", "okHttpClient", "Lokhttp3/OkHttpClient;", "builder", "Lokhttp3/OkHttpClient$Builder;", "oAuth2AuthNService", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService;", "timeout", "", "readTimeout", "okHttpClientBuilder", "limitedParallelCdrUploadsDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "config", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "limitedParallelCdrDownloadsDispatcher", "processingInProgressCache", "Lcom/mayakapps/kache/ObjectKache;", "", "Ljava/nio/file/Path;", "retryIOExceptionsAndServerErrorsTemplate", "Lorg/springframework/retry/support/RetryTemplate;", "retries", "", "initialDelay", "Ljava/time/Duration;", "multiplier", "", "maxDelay", "fileSizeChanged", "Lcom/swisscom/health/des/cdr/client/config/FileBusyTester;", "testInterval", "alwaysBusyFileTester", "neverBusyFileTester", "defaultBusyFileTester", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nCdrClientContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdrClientContext.kt\ncom/swisscom/health/des/cdr/client/config/CdrClientContext\n+ 2 OkHttpClient.kt\nokhttp3/OkHttpClient$Builder\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n698#2:233\n698#2:234\n1#3:235\n*S KotlinDebug\n*F\n+ 1 CdrClientContext.kt\ncom/swisscom/health/des/cdr/client/config/CdrClientContext\n*L\n51#1:233\n74#1:234\n*E\n"})
public class CdrClientContext {
    @Bean
    @NotNull
    public OkHttpClient okHttpClient(@NotNull OkHttpClient.Builder builder, @NotNull OAuth2AuthNService oAuth2AuthNService, @Value(value="${client.connection-timeout-ms}") long timeout, @Value(value="${client.read-timeout-ms}") long readTimeout) {
        OkHttpClient.Builder this_$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)oAuth2AuthNService, (String)"oAuth2AuthNService");
        OkHttpClient.Builder builder2 = builder.connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS);
        boolean bl = false;
        this_$iv = this_$iv.addInterceptor(new Interceptor(oAuth2AuthNService){
            final /* synthetic */ OAuth2AuthNService $oAuth2AuthNService$inlined;
            {
                this.$oAuth2AuthNService$inlined = oAuth2AuthNService;
            }

            public final Response intercept(Interceptor.Chain chain) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                OAuth2AuthNService.AuthNResponse authNResponse = this.$oAuth2AuthNService$inlined.getAccessToken$cdr_client_service();
                boolean bl2 = false;
                if (authNResponse instanceof OAuth2AuthNService.AuthNResponse.Success) {
                    Request.Builder $this$okHttpClient_u24lambda_u240_u240_u240 = chain2.request().newBuilder();
                    boolean bl3 = false;
                    $this$okHttpClient_u24lambda_u240_u240_u240.header("Authorization", "Bearer " + ((OAuth2AuthNService.AuthNResponse.Success)authNResponse).getResponse().getTokens().getAccessToken().getValue());
                    Request authenticatedRequest = $this$okHttpClient_u24lambda_u240_u240_u240.build();
                    boolean bl4 = false;
                    response = chain2.proceed(authenticatedRequest);
                } else {
                    Response response2 = chain2.proceed(chain2.request());
                    boolean bl5 = false;
                    CdrClientContextKt.access$getLogger$p().warn((Function0)new Function0<Object>(authNResponse){
                        final /* synthetic */ OAuth2AuthNService.AuthNResponse $authNResponse;
                        {
                            this.$authNResponse = $authNResponse;
                        }

                        public final Object invoke() {
                            return "Authentication failed, proceeding unauthenticated; authentication response: '" + this.$authNResponse + "'";
                        }
                    });
                    response = response2;
                }
                return response;
            }
        });
        bl = false;
        return this_$iv.addInterceptor(new Interceptor(){

            public final Response intercept(Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Response response = chain2.proceed(chain2.request());
                int n = response.code();
                boolean bl2 = 500 <= n ? n < 600 : false;
                if (bl2) {
                    throw new HttpServerErrorException("Received error status code '" + response.code() + "'.", response.code(), response.body().string());
                }
                return response;
            }
        }).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @Nullable
    public OkHttpClient.Builder okHttpClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Bean(name={"limitedParallelismCdrUploadsDispatcher"})
    @NotNull
    public CoroutineDispatcher limitedParallelCdrUploadsDispatcher(@NotNull CdrClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return Dispatchers.getIO().limitedParallelism(config.getPushThreadPoolSize());
    }

    @Bean(name={"limitedParallelismCdrDownloadsDispatcher"})
    @NotNull
    public CoroutineDispatcher limitedParallelCdrDownloadsDispatcher(@NotNull CdrClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return Dispatchers.getIO().limitedParallelism(config.getPullThreadPoolSize());
    }

    @Bean
    @NotNull
    public ObjectKache<String, Path> processingInProgressCache(@NotNull CdrClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (ObjectKache)InMemoryKacheKt.InMemoryKache((long)config.getFilesInProgressCacheSize().toBytes(), CdrClientContext::processingInProgressCache$lambda$0);
    }

    @Bean(name={"retryIoAndServerErrors"})
    @NotNull
    public RetryTemplate retryIOExceptionsAndServerErrorsTemplate(@Value(value="${client.retry-template.retries}") int retries, @Value(value="${client.retry-template.initial-delay}") @NotNull Duration initialDelay, @Value(value="${client.retry-template.multiplier}") double multiplier, @Value(value="${client.retry-template.max-delay}") @NotNull Duration maxDelay) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)maxDelay, (String)"maxDelay");
        RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(retries).exponentialBackoff(initialDelay, multiplier, maxDelay, true).retryOn(IOException.class).retryOn(HttpServerErrorException.class).traversingCauses().build();
        Intrinsics.checkNotNullExpressionValue((Object)retryTemplate, (String)"build(...)");
        return retryTemplate;
    }

    @Bean
    @ConditionalOnProperty(prefix="client", name={"file-busy-test-strategy"}, havingValue="FILE_SIZE_CHANGED")
    @NotNull
    public FileBusyTester fileSizeChanged(@Value(value="${client.file-size-busy-test-interval:PT0.25S}") @NotNull Duration testInterval) {
        FileBusyTester.FileSizeChanged fileSizeChanged;
        Intrinsics.checkNotNullParameter((Object)testInterval, (String)"testInterval");
        if (!(!testInterval.isZero() && !testInterval.isNegative())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Unit $this$fileSizeChanged_u24lambda_u240 = Unit.INSTANCE;
        boolean bl = false;
        FileBusyTester.FileSizeChanged it = fileSizeChanged = new FileBusyTester.FileSizeChanged(testInterval);
        boolean bl2 = false;
        CdrClientContextKt.access$getLogger$p().info(() -> CdrClientContext.fileSizeChanged$lambda$0$0$0(testInterval));
        return fileSizeChanged;
    }

    @Bean
    @ConditionalOnProperty(prefix="client", name={"file-busy-test-strategy"}, havingValue="ALWAYS_BUSY")
    @NotNull
    public FileBusyTester alwaysBusyFileTester() {
        FileBusyTester.AlwaysBusy alwaysBusy;
        FileBusyTester.AlwaysBusy it = alwaysBusy = FileBusyTester.AlwaysBusy.INSTANCE;
        boolean bl = false;
        CdrClientContextKt.access$getLogger$p().info(CdrClientContext::alwaysBusyFileTester$lambda$0$0);
        return alwaysBusy;
    }

    @Bean
    @ConditionalOnProperty(prefix="client", name={"file-busy-test-strategy"}, havingValue="NEVER_BUSY")
    @NotNull
    public FileBusyTester neverBusyFileTester() {
        FileBusyTester.NeverBusy neverBusy;
        FileBusyTester.NeverBusy it = neverBusy = FileBusyTester.NeverBusy.INSTANCE;
        boolean bl = false;
        CdrClientContextKt.access$getLogger$p().info(CdrClientContext::neverBusyFileTester$lambda$0$0);
        return neverBusy;
    }

    @Bean
    @ConditionalOnMissingBean(value={FileBusyTester.class})
    @NotNull
    public FileBusyTester defaultBusyFileTester() {
        FileBusyTester.NeverBusy neverBusy;
        FileBusyTester.NeverBusy it = neverBusy = FileBusyTester.NeverBusy.INSTANCE;
        boolean bl = false;
        CdrClientContextKt.access$getLogger$p().warn(CdrClientContext::defaultBusyFileTester$lambda$0$0);
        return neverBusy;
    }

    private static final Unit processingInProgressCache$lambda$0(InMemoryKache.Configuration $this$InMemoryKache) {
        Intrinsics.checkNotNullParameter((Object)$this$InMemoryKache, (String)"$this$InMemoryKache");
        $this$InMemoryKache.setStrategy(KacheStrategy.LRU);
        $this$InMemoryKache.setOnEntryRemoved(CdrClientContext::processingInProgressCache$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit processingInProgressCache$lambda$0$0(boolean evicted, String key, Path path, Path path2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)path, (String)"<unused var>");
        if (evicted) {
            CdrClientContextKt.access$getLogger$p().warn(() -> CdrClientContext.processingInProgressCache$lambda$0$0$0(key));
        }
        return Unit.INSTANCE;
    }

    private static final Object processingInProgressCache$lambda$0$0$0(String $key) {
        return "The file object with key '" + $key + "' has been evicted from the processing cache because the capacity limit of the cache has been reached; this indicates a very large number of files in the source directories that cannot be processed. Please investigate. ";
    }

    private static final Object fileSizeChanged$lambda$0$0$0(Duration $testInterval) {
        return "Using file-busy-test strategy 'FILE_SIZE_CHANGED', sampling file at interval '" + $testInterval + "'";
    }

    private static final Object alwaysBusyFileTester$lambda$0$0() {
        return "Using file-busy-test strategy 'ALWAYS_BUSY'";
    }

    private static final Object neverBusyFileTester$lambda$0$0() {
        return "Using file-busy-test strategy 'NEVER_BUSY'";
    }

    private static final Object defaultBusyFileTester$lambda$0$0() {
        return "No file-busy-test strategy defined, defaulting to 'NEVER_BUSY'";
    }
}

