/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.config;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.ClientId;
import com.swisscom.health.des.cdr.client.config.IdpCredentials;
import com.swisscom.health.des.cdr.client.config.OAuth2AuthNServiceKt;
import com.swisscom.health.des.cdr.client.config.WrongCredentialsException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0011\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0010\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\u0013J'\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService;", "", "config", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "retryIoErrors", "Lorg/springframework/retry/support/RetryTemplate;", "clock", "Lkotlin/time/Clock;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lorg/springframework/retry/support/RetryTemplate;Lkotlin/time/Clock;)V", "accessTokenAuthNResponse", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "tokenLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "cachedAuthNState", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNState;", "currentAuthNStateNonBlocking", "currentAuthNStateNonBlocking$cdr_client_service", "getAccessToken", "getAccessToken$cdr_client_service", "getNewAccessToken", "idpCredentials", "Lcom/swisscom/health/des/cdr/client/config/IdpCredentials;", "idpEndpoint", "Ljava/net/URL;", "shouldRetry", "", "getNewAccessToken$cdr_client_service", "AuthNState", "AuthNResponse", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nOAuth2AuthNService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2AuthNService.kt\ncom/swisscom/health/des/cdr/client/config/OAuth2AuthNService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public class OAuth2AuthNService {
    @NotNull
    private final CdrClientConfig config;
    @NotNull
    private final RetryTemplate retryIoErrors;
    @NotNull
    private final Clock clock;
    @NotNull
    private AuthNResponse accessTokenAuthNResponse;
    @NotNull
    private final ReentrantReadWriteLock tokenLock;
    @NotNull
    private volatile AuthNState cachedAuthNState;

    public OAuth2AuthNService(@NotNull CdrClientConfig config, @NotNull RetryTemplate retryIoErrors, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)retryIoErrors, (String)"retryIoErrors");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.config = config;
        this.retryIoErrors = retryIoErrors;
        this.clock = clock;
        this.accessTokenAuthNResponse = AuthNResponse.NotAuthenticated.INSTANCE;
        this.tokenLock = new ReentrantReadWriteLock();
        this.cachedAuthNState = AuthNState.UNKNOWN;
    }

    public /* synthetic */ OAuth2AuthNService(CdrClientConfig cdrClientConfig, RetryTemplate retryTemplate, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clock = (Clock)Clock.System.INSTANCE;
        }
        this(cdrClientConfig, retryTemplate, clock);
    }

    @NotNull
    public AuthNState currentAuthNStateNonBlocking$cdr_client_service() {
        return this.cachedAuthNState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AuthNResponse getAccessToken$cdr_client_service() {
        AuthNResponse authNResponse;
        ReentrantReadWriteLock.ReadLock readLock = this.tokenLock.readLock();
        readLock.lock();
        try {
            Long expiresOn;
            boolean bl = false;
            AuthNResponse currentTokenResponse = this.accessTokenAuthNResponse;
            if (currentTokenResponse instanceof AuthNResponse.Success && (expiresOn = (Long)((AuthNResponse.Success)currentTokenResponse).getResponse().getCustomParameters().get("expires_on")) != null && this.clock.now().getEpochSeconds() <= expiresOn) {
                AuthNResponse authNResponse2 = currentTokenResponse;
                return authNResponse2;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock reentrantReadWriteLock = this.tokenLock;
        readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            AuthNResponse authNResponse3;
            Long expiresOn;
            boolean bl = false;
            AuthNResponse currentTokenResponse = this.accessTokenAuthNResponse;
            if (currentTokenResponse instanceof AuthNResponse.Success && (expiresOn = (Long)((AuthNResponse.Success)currentTokenResponse).getResponse().getCustomParameters().get("expires_on")) != null && this.clock.now().getEpochSeconds() <= expiresOn) {
                authNResponse3 = currentTokenResponse;
            } else {
                AuthNState authNState;
                AuthNResponse newResponse;
                AuthNResponse authNResponse4 = currentTokenResponse;
                this.accessTokenAuthNResponse = newResponse = authNResponse4 instanceof AuthNResponse.Deny || authNResponse4 instanceof AuthNResponse.Failed ? currentTokenResponse : OAuth2AuthNService.getNewAccessToken$cdr_client_service$default(this, this.config.getIdpCredentials(), this.config.getIdpEndpoint(), false, 4, null);
                authNResponse4 = newResponse;
                if (authNResponse4 instanceof AuthNResponse.Success) {
                    authNState = AuthNState.AUTHENTICATED;
                } else if (authNResponse4 instanceof AuthNResponse.RetryableFailure) {
                    authNState = AuthNState.RETRYABLE_FAILURE;
                } else if (authNResponse4 instanceof AuthNResponse.Failed) {
                    authNState = AuthNState.FAILED;
                } else if (authNResponse4 instanceof AuthNResponse.Deny) {
                    authNState = AuthNState.DENIED;
                } else if (authNResponse4 instanceof AuthNResponse.NotAuthenticated) {
                    authNState = AuthNState.UNAUTHENTICATED;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.cachedAuthNState = authNState;
                authNResponse3 = newResponse;
            }
            authNResponse = authNResponse3;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return authNResponse;
    }

    @NotNull
    public AuthNResponse getNewAccessToken$cdr_client_service(@NotNull IdpCredentials idpCredentials, @NotNull URL idpEndpoint, boolean shouldRetry) {
        AuthNResponse authNResponse;
        Object $this$getNewAccessToken_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)idpCredentials, (String)"idpCredentials");
        Intrinsics.checkNotNullParameter((Object)idpEndpoint, (String)"idpEndpoint");
        AuthorizationGrant clientGrant = (AuthorizationGrant)new ClientCredentialsGrant();
        ClientID clientID = new ClientID(idpCredentials.getClientId-uOZoI7s());
        Secret clientSecret = new Secret(idpCredentials.getClientSecret-y9TYiAY());
        ClientAuthentication clientAuth = (ClientAuthentication)new ClientSecretPost(clientID, clientSecret);
        String[] stringArray = new String[]{idpCredentials.getScope-jn13-x4()};
        Scope scope = new Scope(stringArray);
        URI uRI = idpEndpoint.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        URI tokenEndpoint = uRI;
        TokenRequest request = new TokenRequest(tokenEndpoint, clientAuth, clientGrant, scope);
        Object object = this;
        try {
            TokenResponse tokenResponse;
            $this$getNewAccessToken_u24lambda_u240 = object;
            boolean bl = false;
            if (shouldRetry) {
                HTTPResponse $this$getNewAccessToken_u24lambda_u240_u241 = (HTTPResponse)((OAuth2AuthNService)$this$getNewAccessToken_u24lambda_u240).retryIoErrors.execute(arg_0 -> OAuth2AuthNService.getNewAccessToken$lambda$0$0(request, arg_0));
                boolean bl2 = false;
                tokenResponse = TokenResponse.parse((HTTPResponse)$this$getNewAccessToken_u24lambda_u240_u241);
            } else {
                HTTPResponse $this$getNewAccessToken_u24lambda_u240_u242 = request.toHTTPRequest().send();
                boolean bl3 = false;
                tokenResponse = TokenResponse.parse((HTTPResponse)$this$getNewAccessToken_u24lambda_u240_u242);
            }
            $this$getNewAccessToken_u24lambda_u240 = Result.constructor-impl((Object)tokenResponse);
        }
        catch (Throwable bl) {
            $this$getNewAccessToken_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getNewAccessToken_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            TokenResponse httpResponse = (TokenResponse)object;
            boolean bl = false;
            if (httpResponse.indicatesSuccess()) {
                AccessTokenResponse accessTokenResponse = httpResponse.toSuccessResponse();
                Intrinsics.checkNotNullExpressionValue((Object)accessTokenResponse, (String)"toSuccessResponse(...)");
                authNResponse = new AuthNResponse.Success(accessTokenResponse);
            } else {
                authNResponse = new AuthNResponse.Deny(new WrongCredentialsException("Failed to login; client id: '" + ClientId.toString-impl(idpCredentials.getClientId-uOZoI7s()) + "'; IdP endpoint: '" + idpEndpoint + "'; message: '" + httpResponse.toErrorResponse().toJSONObject() + "'"));
            }
        } else {
            Throwable t = throwable;
            boolean bl = false;
            OAuth2AuthNServiceKt.access$getLogger$p().debug(() -> OAuth2AuthNService.getNewAccessToken$lambda$2$0(idpEndpoint, idpCredentials, t));
            authNResponse = t instanceof IOException ? (AuthNResponse)new AuthNResponse.RetryableFailure((IOException)t) : (AuthNResponse)new AuthNResponse.Failed(new IllegalStateException("Failed to login; client id: '" + ClientId.toString-impl(idpCredentials.getClientId-uOZoI7s()) + "'; IdP endpoint: '" + idpEndpoint + "'; root cause: '" + t + "'", t));
        }
        AuthNResponse authNResponse2 = authNResponse;
        return authNResponse2;
    }

    public static /* synthetic */ AuthNResponse getNewAccessToken$cdr_client_service$default(OAuth2AuthNService oAuth2AuthNService, IdpCredentials idpCredentials, URL uRL, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNewAccessToken");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return oAuth2AuthNService.getNewAccessToken$cdr_client_service(idpCredentials, uRL, bl);
    }

    private static final HTTPResponse getNewAccessToken$lambda$0$0(TokenRequest $request, RetryContext retryContext) {
        return $request.toHTTPRequest().send();
    }

    private static final Object getNewAccessToken$lambda$2$0(URL $idpEndpoint, IdpCredentials $idpCredentials, Throwable $t) {
        return "Error while trying to get access token from IdP at '" + $idpEndpoint + "' for client id '" + ClientId.toString-impl($idpCredentials.getClientId-uOZoI7s()) + "': " + $t;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0005\u0007\b\t\n\u000b\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "", "Success", "Deny", "RetryableFailure", "Failed", "NotAuthenticated", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$Deny;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$Failed;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$NotAuthenticated;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$RetryableFailure;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$Success;", "cdr-client-service"})
    public static sealed interface AuthNResponse {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$Deny;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "error", "Lcom/swisscom/health/des/cdr/client/config/WrongCredentialsException;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/WrongCredentialsException;)V", "getError", "()Lcom/swisscom/health/des/cdr/client/config/WrongCredentialsException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cdr-client-service"})
        public static final class Deny
        implements AuthNResponse {
            @NotNull
            private final WrongCredentialsException error;

            public Deny(@NotNull WrongCredentialsException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.error = error;
            }

            @NotNull
            public final WrongCredentialsException getError() {
                return this.error;
            }

            @NotNull
            public final WrongCredentialsException component1() {
                return this.error;
            }

            @NotNull
            public final Deny copy(@NotNull WrongCredentialsException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new Deny(error);
            }

            public static /* synthetic */ Deny copy$default(Deny deny, WrongCredentialsException wrongCredentialsException, int n, Object object) {
                if ((n & 1) != 0) {
                    wrongCredentialsException = deny.error;
                }
                return deny.copy(wrongCredentialsException);
            }

            @NotNull
            public String toString() {
                return "Deny(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Deny)) {
                    return false;
                }
                Deny deny = (Deny)other;
                return Intrinsics.areEqual((Object)this.error, (Object)deny.error);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$Failed;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "error", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "<init>", "(Ljava/lang/IllegalStateException;)V", "getError", "()Ljava/lang/IllegalStateException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cdr-client-service"})
        public static final class Failed
        implements AuthNResponse {
            @NotNull
            private final IllegalStateException error;

            public Failed(@NotNull IllegalStateException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.error = error;
            }

            @NotNull
            public final IllegalStateException getError() {
                return this.error;
            }

            @NotNull
            public final IllegalStateException component1() {
                return this.error;
            }

            @NotNull
            public final Failed copy(@NotNull IllegalStateException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new Failed(error);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, IllegalStateException illegalStateException, int n, Object object) {
                if ((n & 1) != 0) {
                    illegalStateException = failed.error;
                }
                return failed.copy(illegalStateException);
            }

            @NotNull
            public String toString() {
                return "Failed(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failed.error);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$NotAuthenticated;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "<init>", "()V", "cdr-client-service"})
        public static final class NotAuthenticated
        implements AuthNResponse {
            @NotNull
            public static final NotAuthenticated INSTANCE = new NotAuthenticated();

            private NotAuthenticated() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$RetryableFailure;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "error", "Ljava/io/IOException;", "<init>", "(Ljava/io/IOException;)V", "getError", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cdr-client-service"})
        public static final class RetryableFailure
        implements AuthNResponse {
            @NotNull
            private final IOException error;

            public RetryableFailure(@NotNull IOException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.error = error;
            }

            @NotNull
            public final IOException getError() {
                return this.error;
            }

            @NotNull
            public final IOException component1() {
                return this.error;
            }

            @NotNull
            public final RetryableFailure copy(@NotNull IOException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new RetryableFailure(error);
            }

            public static /* synthetic */ RetryableFailure copy$default(RetryableFailure retryableFailure, IOException iOException, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = retryableFailure.error;
                }
                return retryableFailure.copy(iOException);
            }

            @NotNull
            public String toString() {
                return "RetryableFailure(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RetryableFailure)) {
                    return false;
                }
                RetryableFailure retryableFailure = (RetryableFailure)other;
                return Intrinsics.areEqual((Object)this.error, (Object)retryableFailure.error);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse$Success;", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNResponse;", "response", "Lcom/nimbusds/oauth2/sdk/AccessTokenResponse;", "<init>", "(Lcom/nimbusds/oauth2/sdk/AccessTokenResponse;)V", "getResponse", "()Lcom/nimbusds/oauth2/sdk/AccessTokenResponse;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cdr-client-service"})
        public static final class Success
        implements AuthNResponse {
            @NotNull
            private final AccessTokenResponse response;

            public Success(@NotNull AccessTokenResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.response = response;
            }

            @NotNull
            public final AccessTokenResponse getResponse() {
                return this.response;
            }

            @NotNull
            public final AccessTokenResponse component1() {
                return this.response;
            }

            @NotNull
            public final Success copy(@NotNull AccessTokenResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return new Success(response);
            }

            public static /* synthetic */ Success copy$default(Success success, AccessTokenResponse accessTokenResponse, int n, Object object) {
                if ((n & 1) != 0) {
                    accessTokenResponse = success.response;
                }
                return success.copy(accessTokenResponse);
            }

            @NotNull
            public String toString() {
                return "Success(response=" + this.response + ")";
            }

            public int hashCode() {
                return this.response.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.response, (Object)success.response);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService$AuthNState;", "", "<init>", "(Ljava/lang/String;I)V", "AUTHENTICATED", "UNAUTHENTICATED", "RETRYABLE_FAILURE", "FAILED", "DENIED", "UNKNOWN", "cdr-client-service"})
    public static final class AuthNState
    extends Enum<AuthNState> {
        public static final /* enum */ AuthNState AUTHENTICATED = new AuthNState();
        public static final /* enum */ AuthNState UNAUTHENTICATED = new AuthNState();
        public static final /* enum */ AuthNState RETRYABLE_FAILURE = new AuthNState();
        public static final /* enum */ AuthNState FAILED = new AuthNState();
        public static final /* enum */ AuthNState DENIED = new AuthNState();
        public static final /* enum */ AuthNState UNKNOWN = new AuthNState();
        private static final /* synthetic */ AuthNState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AuthNState[] values() {
            return (AuthNState[])$VALUES.clone();
        }

        public static AuthNState valueOf(String value) {
            return Enum.valueOf(AuthNState.class, value);
        }

        @NotNull
        public static EnumEntries<AuthNState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = authNStateArray = new AuthNState[]{AuthNState.AUTHENTICATED, AuthNState.UNAUTHENTICATED, AuthNState.RETRYABLE_FAILURE, AuthNState.FAILED, AuthNState.DENIED, AuthNState.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

