/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.swisscom.health.des.cdr.client.common.Constants;
import com.swisscom.health.des.cdr.client.common.DTOs;
import com.swisscom.health.des.cdr.client.common.DomainObjects;
import com.swisscom.health.des.cdr.client.common.UtilKt;
import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.ConfigConverterKt;
import com.swisscom.health.des.cdr.client.config.IdpCredentials;
import com.swisscom.health.des.cdr.client.config.OAuth2AuthNService;
import com.swisscom.health.des.cdr.client.handler.ConfigValidationService;
import com.swisscom.health.des.cdr.client.handler.ConfigurationWriter;
import com.swisscom.health.des.cdr.client.handler.ShutdownService;
import com.swisscom.health.des.cdr.client.http.WebOperationsAdvice;
import com.swisscom.health.des.cdr.client.http.WebOperationsKt;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.SystemHealth;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0011\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u000e\b\u0001\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0091@\u00a2\u0006\u0004\b\u001c\u0010\u001dJ(\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00180\u00152\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0091@\u00a2\u0006\u0004\b\"\u0010#J:\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0001\u0010\n\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020'2\u000e\b\u0001\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0091@\u00a2\u0006\u0004\b(\u0010)J \u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0001\u0010+\u001a\u00020,H\u0091@\u00a2\u0006\u0004\b-\u0010.J\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020%0\u0015H\u0097@\u00a2\u0006\u0002\u00102J \u00103\u001a\b\u0012\u0004\u0012\u00020%0\u00152\b\b\u0001\u0010\n\u001a\u00020%H\u0091@\u00a2\u0006\u0004\b4\u00105J\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0015H\u0091@\u00a2\u0006\u0004\b8\u00102J\"\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00152\n\b\u0001\u0010;\u001a\u0004\u0018\u00010!H\u0091@\u00a2\u0006\u0004\b<\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/swisscom/health/des/cdr/client/http/WebOperations;", "", "healthEndpoint", "Lorg/springframework/boot/actuate/health/HealthEndpoint;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "shutdownService", "Lcom/swisscom/health/des/cdr/client/handler/ShutdownService;", "configWriter", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;", "config", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "configValidationService", "Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;", "retryIOExceptionsAndServerErrors", "Lorg/springframework/retry/support/RetryTemplate;", "authService", "Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService;", "<init>", "(Lorg/springframework/boot/actuate/health/HealthEndpoint;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/swisscom/health/des/cdr/client/handler/ShutdownService;Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;Lorg/springframework/retry/support/RetryTemplate;Lcom/swisscom/health/des/cdr/client/config/OAuth2AuthNService;)V", "validateConnectorMode", "Lorg/springframework/http/ResponseEntity;", "Lcom/swisscom/health/des/cdr/client/common/DTOs$ValidationResult;", "connectors", "", "Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig$Connector;", "validations", "Lcom/swisscom/health/des/cdr/client/common/DomainObjects$ValidationType;", "validateConnectorMode$cdr_client_service", "(Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateIsNotBlankAndNotPlaceholder", "Lcom/swisscom/health/des/cdr/client/common/DTOs$ValidationMessageKey;", "value", "", "validateIsNotBlankAndNotPlaceholder$cdr_client_service", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateDirectory", "Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig;", "directory", "Ljava/nio/file/Path;", "validateDirectory$cdr_client_service", "(Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig;Ljava/nio/file/Path;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateCredentials", "idpCredentials", "Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig$IdpCredentials;", "validateCredentials$cdr_client_service", "(Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig$IdpCredentials;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "credentialValidationFailure", "Lcom/swisscom/health/des/cdr/client/common/DTOs$ValidationResult$Failure;", "getServiceConfiguration", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateServiceConfiguration", "updateServiceConfiguration$cdr_client_service", "(Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "status", "Lcom/swisscom/health/des/cdr/client/common/DTOs$StatusResponse;", "status$cdr_client_service", "shutdown", "Lcom/swisscom/health/des/cdr/client/common/DTOs$ShutdownResponse;", "reason", "shutdown$cdr_client_service", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nWebOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebOperations.kt\ncom/swisscom/health/des/cdr/client/http/WebOperations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n1563#2:387\n1634#2,3:388\n1#3:391\n*S KotlinDebug\n*F\n+ 1 WebOperations.kt\ncom/swisscom/health/des/cdr/client/http/WebOperations\n*L\n123#1:387\n123#1:388,3\n*E\n"})
public class WebOperations {
    @NotNull
    private final HealthEndpoint healthEndpoint;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ShutdownService shutdownService;
    @NotNull
    private final ConfigurationWriter configWriter;
    @NotNull
    private final CdrClientConfig config;
    @NotNull
    private final ConfigValidationService configValidationService;
    @NotNull
    private final RetryTemplate retryIOExceptionsAndServerErrors;
    @NotNull
    private final OAuth2AuthNService authService;
    @NotNull
    private final DTOs.ValidationResult.Failure credentialValidationFailure;

    public WebOperations(@NotNull HealthEndpoint healthEndpoint, @NotNull ObjectMapper objectMapper, @NotNull ShutdownService shutdownService, @NotNull ConfigurationWriter configWriter, @NotNull CdrClientConfig config, @NotNull ConfigValidationService configValidationService, @Qualifier(value="retryIoAndServerErrors") @NotNull RetryTemplate retryIOExceptionsAndServerErrors, @NotNull OAuth2AuthNService authService) {
        Intrinsics.checkNotNullParameter((Object)healthEndpoint, (String)"healthEndpoint");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)shutdownService, (String)"shutdownService");
        Intrinsics.checkNotNullParameter((Object)configWriter, (String)"configWriter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)configValidationService, (String)"configValidationService");
        Intrinsics.checkNotNullParameter((Object)retryIOExceptionsAndServerErrors, (String)"retryIOExceptionsAndServerErrors");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        this.healthEndpoint = healthEndpoint;
        this.objectMapper = objectMapper;
        this.shutdownService = shutdownService;
        this.configWriter = configWriter;
        this.config = config;
        this.configValidationService = configValidationService;
        this.retryIOExceptionsAndServerErrors = retryIOExceptionsAndServerErrors;
        this.authService = authService;
        this.credentialValidationFailure = new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConfigItemDetail(DomainObjects.ConfigurationItem.UNKNOWN, DTOs.ValidationMessageKey.CREDENTIAL_VALIDATION_FAILED)));
    }

    @PutMapping(value={"api/validate-connector-mode"})
    @Nullable
    public Object validateConnectorMode$cdr_client_service(@RequestBody @NotNull List<DTOs.CdrClientConfig.Connector> connectors, @RequestParam(name="validation") @NotNull List<? extends DomainObjects.ValidationType> validations, @NotNull Continuation<? super ResponseEntity<DTOs.ValidationResult>> $completion) {
        return WebOperations.validateConnectorMode$suspendImpl(this, connectors, validations, $completion);
    }

    @PutMapping(value={"api/validate-connector-mode"})
    static /* synthetic */ Object validateConnectorMode$suspendImpl(WebOperations $this, @RequestBody List<DTOs.CdrClientConfig.Connector> connectors, @RequestParam(name="validation") List<? extends DomainObjects.ValidationType> validations, Continuation<? super ResponseEntity<DTOs.ValidationResult>> $completion) {
        boolean bl2;
        Object $this$validateConnectorMode_u24lambda_u240;
        Object object = $this;
        try {
            $this$validateConnectorMode_u24lambda_u240 = object;
            bl2 = false;
            WebOperationsKt.access$getLogger$p().debug(() -> WebOperations.validateConnectorMode$lambda$0$0(connectors));
            DTOs.ValidationResult validationResult = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
            for (DomainObjects.ValidationType validationType : validations) {
                validationResult = validationResult.plus(switch (WhenMappings.$EnumSwitchMapping$0[validationType.ordinal()]) {
                    case 1 -> ((WebOperations)$this$validateConnectorMode_u24lambda_u240).configValidationService.validateModeValue(connectors);
                    case 2 -> ((WebOperations)$this$validateConnectorMode_u24lambda_u240).configValidationService.validateModeOverlap(connectors);
                    default -> throw new WebOperationsAdvice.BadRequest("Unsupported validation type: '" + validationType + "'", null, null, 6, null);
                });
            }
            $this$validateConnectorMode_u24lambda_u240 = Result.constructor-impl((Object)ResponseEntity.ok((Object)validationResult));
        }
        catch (Throwable bl2) {
            $this$validateConnectorMode_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = $this$validateConnectorMode_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            bl2 = false;
            Throwable throwable2 = error;
            if (throwable2 instanceof WebOperationsAdvice.ServerError || throwable2 instanceof WebOperationsAdvice.BadRequest) {
                throw error;
            }
            throw new WebOperationsAdvice.ServerError("Failed to validate mode for connectors: '" + connectors + "'", error);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return object2;
    }

    @GetMapping(value={"api/validate-not-blank-and-not-placeholder"})
    @Nullable
    public Object validateIsNotBlankAndNotPlaceholder$cdr_client_service(@RequestParam(name="value") @Nullable String value, @NotNull Continuation<? super ResponseEntity<List<DTOs.ValidationMessageKey>>> $completion) {
        return WebOperations.validateIsNotBlankAndNotPlaceholder$suspendImpl(this, value, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"api/validate-not-blank-and-not-placeholder"})
    static /* synthetic */ Object validateIsNotBlankAndNotPlaceholder$suspendImpl(WebOperations $this, @RequestParam(name="value") String value, Continuation<? super ResponseEntity<List<DTOs.ValidationMessageKey>>> $completion) {
        Object $this$validateIsNotBlankAndNotPlaceholder_u24lambda_u240;
        Object object = $this;
        try {
            List list;
            $this$validateIsNotBlankAndNotPlaceholder_u24lambda_u240 = object;
            boolean bl = false;
            WebOperationsKt.access$getLogger$p().trace(() -> WebOperations.validateIsNotBlankAndNotPlaceholder$lambda$0$0(value));
            DTOs.ValidationResult validationResult = ((WebOperations)$this$validateIsNotBlankAndNotPlaceholder_u24lambda_u240).configValidationService.validateIsNotBlankOrPlaceholder(value, DomainObjects.ConfigurationItem.UNKNOWN);
            if (validationResult instanceof DTOs.ValidationResult.Failure) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((DTOs.ValidationResult.Failure)validationResult).getValidationDetails();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DTOs.ValidationDetail validationDetail = (DTOs.ValidationDetail)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getMessageKey());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$validateIsNotBlankAndNotPlaceholder_u24lambda_u240 = Result.constructor-impl((Object)ResponseEntity.ok((Object)list));
        }
        catch (Throwable bl) {
            $this$validateIsNotBlankAndNotPlaceholder_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$validateIsNotBlankAndNotPlaceholder_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            Throwable throwable2 = error;
            if (throwable2 instanceof WebOperationsAdvice.ServerError || throwable2 instanceof WebOperationsAdvice.BadRequest) {
                throw error;
            }
            throw new WebOperationsAdvice.ServerError("Failed to validate value '" + value + "': '" + error + "'", error);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return object2;
    }

    @PutMapping(value={"api/validate-directory"})
    @Nullable
    public Object validateDirectory$cdr_client_service(@RequestBody @NotNull DTOs.CdrClientConfig config, @RequestParam(name="dir") @NotNull Path directory, @RequestParam(name="validation") @NotNull List<? extends DomainObjects.ValidationType> validations, @NotNull Continuation<? super ResponseEntity<DTOs.ValidationResult>> $completion) {
        return WebOperations.validateDirectory$suspendImpl(this, config, directory, validations, $completion);
    }

    @PutMapping(value={"api/validate-directory"})
    static /* synthetic */ Object validateDirectory$suspendImpl(WebOperations $this, @RequestBody DTOs.CdrClientConfig config, @RequestParam(name="dir") Path directory, @RequestParam(name="validation") List<? extends DomainObjects.ValidationType> validations, Continuation<? super ResponseEntity<DTOs.ValidationResult>> $completion) {
        boolean bl2;
        Object $this$validateDirectory_u24lambda_u240;
        Object object = $this;
        try {
            $this$validateDirectory_u24lambda_u240 = object;
            bl2 = false;
            WebOperationsKt.access$getLogger$p().debug(() -> WebOperations.validateDirectory$lambda$0$0(directory, validations));
            DTOs.ValidationResult validationResult = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
            for (DomainObjects.ValidationType validationType : validations) {
                validationResult = validationResult.plus(switch (WhenMappings.$EnumSwitchMapping$0[validationType.ordinal()]) {
                    case 3 -> ((WebOperations)$this$validateDirectory_u24lambda_u240).configValidationService.validateDirectoryIsReadWritable(directory);
                    case 4 -> ((WebOperations)$this$validateDirectory_u24lambda_u240).configValidationService.validateDirectoryOverlap(config);
                    default -> throw new WebOperationsAdvice.BadRequest("Unsupported validation type: '" + validationType + "'", null, null, 6, null);
                });
            }
            $this$validateDirectory_u24lambda_u240 = Result.constructor-impl((Object)ResponseEntity.ok((Object)validationResult));
        }
        catch (Throwable bl2) {
            $this$validateDirectory_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = $this$validateDirectory_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            bl2 = false;
            Throwable throwable2 = error;
            if (throwable2 instanceof WebOperationsAdvice.ServerError || throwable2 instanceof WebOperationsAdvice.BadRequest) {
                throw error;
            }
            throw new WebOperationsAdvice.ServerError("Failed to validate directory: '" + directory + "'", error);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return object2;
    }

    @PutMapping(value={"api/validate-credentials"})
    @Nullable
    public Object validateCredentials$cdr_client_service(@RequestBody @NotNull DTOs.CdrClientConfig.IdpCredentials idpCredentials, @NotNull Continuation<? super ResponseEntity<DTOs.ValidationResult>> $completion) {
        return WebOperations.validateCredentials$suspendImpl(this, idpCredentials, $completion);
    }

    @PutMapping(value={"api/validate-credentials"})
    static /* synthetic */ Object validateCredentials$suspendImpl(WebOperations $this, @RequestBody DTOs.CdrClientConfig.IdpCredentials idpCredentials, Continuation<? super ResponseEntity<DTOs.ValidationResult>> $completion) {
        ResponseEntity responseEntity;
        Object $this$validateCredentials_u24lambda_u240;
        Object object = $this;
        try {
            $this$validateCredentials_u24lambda_u240 = object;
            boolean bl = false;
            WebOperationsKt.access$getLogger$p().debug(() -> WebOperations.validateCredentials$lambda$0$0(idpCredentials));
            $this$validateCredentials_u24lambda_u240 = Result.constructor-impl((Object)((OAuth2AuthNService.AuthNResponse)((WebOperations)$this$validateCredentials_u24lambda_u240).retryIOExceptionsAndServerErrors.execute(arg_0 -> WebOperations.validateCredentials$lambda$0$1((WebOperations)$this$validateCredentials_u24lambda_u240, idpCredentials, arg_0))));
        }
        catch (Throwable bl) {
            $this$validateCredentials_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$validateCredentials_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            OAuth2AuthNService.AuthNResponse authNResponse = (OAuth2AuthNService.AuthNResponse)object;
            boolean bl = false;
            Ref.ObjectRef validationResult = new Ref.ObjectRef();
            validationResult.element = DTOs.ValidationResult.Success.INSTANCE;
            if (!(authNResponse instanceof OAuth2AuthNService.AuthNResponse.Success)) {
                validationResult.element = ((DTOs.ValidationResult)validationResult.element).plus((DTOs.ValidationResult)$this.credentialValidationFailure);
            }
            WebOperationsKt.access$getLogger$p().debug(() -> WebOperations.validateCredentials$lambda$1$0(validationResult));
            responseEntity = ResponseEntity.ok((Object)validationResult.element);
        } else {
            Throwable e = throwable;
            boolean bl = false;
            WebOperationsKt.access$getLogger$p().error(() -> WebOperations.validateCredentials$lambda$2$0(e));
            responseEntity = ResponseEntity.ok((Object)$this.credentialValidationFailure);
        }
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"fold(...)");
        return responseEntity;
    }

    @GetMapping(value={"api/service-configuration"})
    @Nullable
    public Object getServiceConfiguration(@NotNull Continuation<? super ResponseEntity<DTOs.CdrClientConfig>> $completion) {
        return WebOperations.getServiceConfiguration$suspendImpl(this, $completion);
    }

    @GetMapping(value={"api/service-configuration"})
    static /* synthetic */ Object getServiceConfiguration$suspendImpl(WebOperations $this, Continuation<? super ResponseEntity<DTOs.CdrClientConfig>> $completion) {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ConfigConverterKt.toDto($this.config));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @PutMapping(value={"api/service-configuration"})
    @Nullable
    public Object updateServiceConfiguration$cdr_client_service(@RequestBody @NotNull DTOs.CdrClientConfig config, @NotNull Continuation<? super ResponseEntity<DTOs.CdrClientConfig>> $completion) {
        return WebOperations.updateServiceConfiguration$suspendImpl(this, config, $completion);
    }

    @PutMapping(value={"api/service-configuration"})
    static /* synthetic */ Object updateServiceConfiguration$suspendImpl(WebOperations $this, @RequestBody DTOs.CdrClientConfig config, Continuation<? super ResponseEntity<DTOs.CdrClientConfig>> $completion) {
        Object $this$updateServiceConfiguration_u24lambda_u240;
        Object object = $this;
        try {
            $this$updateServiceConfiguration_u24lambda_u240 = object;
            boolean bl = false;
            WebOperationsKt.access$getLogger$p().trace(() -> WebOperations.updateServiceConfiguration$lambda$0$0(config));
            ConfigurationWriter.UpdateResult result = ((WebOperations)$this$updateServiceConfiguration_u24lambda_u240).configWriter.updateClientServiceConfiguration(ConfigConverterKt.toCdrClientConfig(config));
            boolean bl2 = false;
            ConfigurationWriter.UpdateResult updateResult = result;
            if (!(updateResult instanceof ConfigurationWriter.UpdateResult.Success)) {
                if (updateResult instanceof ConfigurationWriter.UpdateResult.Failure) {
                    throw new WebOperationsAdvice.BadRequest("Invalid configuration", null, ((ConfigurationWriter.UpdateResult.Failure)result).getErrors(), 2, null);
                }
                throw new NoWhenBranchMatchedException();
            }
            $this$updateServiceConfiguration_u24lambda_u240 = Result.constructor-impl((Object)ResponseEntity.ok((Object)config));
        }
        catch (Throwable bl) {
            $this$updateServiceConfiguration_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$updateServiceConfiguration_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl = false;
            Throwable throwable2 = error;
            if (throwable2 instanceof WebOperationsAdvice.ServerError || throwable2 instanceof WebOperationsAdvice.BadRequest) {
                throw error;
            }
            throw new WebOperationsAdvice.ServerError("Failed to update service configuration: " + error, error);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return object2;
    }

    @GetMapping(value={"api/status"})
    @Nullable
    public Object status$cdr_client_service(@NotNull Continuation<? super ResponseEntity<DTOs.StatusResponse>> $completion) {
        return WebOperations.status$suspendImpl(this, $completion);
    }

    @GetMapping(value={"api/status"})
    static /* synthetic */ Object status$suspendImpl(WebOperations $this, Continuation<? super ResponseEntity<DTOs.StatusResponse>> $completion) {
        Object object = $this;
        try {
            DTOs.StatusResponse.StatusCode statusCode;
            block18: {
                CharSequence charSequence;
                String syncStatus;
                block19: {
                    String authNStatus;
                    block17: {
                        WebOperations $this$status_u24lambda_u240 = object;
                        boolean bl = false;
                        HealthComponent healthComponent = $this$status_u24lambda_u240.healthEndpoint.health();
                        Intrinsics.checkNotNull((Object)healthComponent, (String)"null cannot be cast to non-null type org.springframework.boot.actuate.health.SystemHealth");
                        SystemHealth healthStatus = (SystemHealth)healthComponent;
                        WebOperationsKt.access$getLogger$p().debug(() -> WebOperations.status$lambda$0$0($this$status_u24lambda_u240, healthStatus));
                        HealthComponent healthComponent2 = (HealthComponent)healthStatus.getComponents().get("config");
                        String configStatus = healthComponent2 != null && (healthComponent2 = healthComponent2.getStatus()) != null ? healthComponent2.getCode() : null;
                        HealthComponent healthComponent3 = (HealthComponent)healthStatus.getComponents().get("fileSynchronization");
                        syncStatus = healthComponent3 != null && (healthComponent3 = healthComponent3.getStatus()) != null ? healthComponent3.getCode() : null;
                        HealthComponent healthComponent4 = (HealthComponent)healthStatus.getComponents().get("authN");
                        authNStatus = healthComponent4 != null && (healthComponent4 = healthComponent4.getStatus()) != null ? healthComponent4.getCode() : null;
                        charSequence = configStatus;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)configStatus, (Object)"OK")) break block17;
                        charSequence = configStatus;
                        statusCode = Intrinsics.areEqual((Object)charSequence, (Object)"BROKEN") ? DTOs.StatusResponse.StatusCode.BROKEN : (Intrinsics.areEqual((Object)charSequence, (Object)"ERROR") ? DTOs.StatusResponse.StatusCode.ERROR : DTOs.StatusResponse.StatusCode.UNKNOWN);
                        break block18;
                    }
                    charSequence = authNStatus;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)authNStatus, (Object)"AUTHENTICATED") || Intrinsics.areEqual((Object)authNStatus, (Object)"UNAUTHENTICATED")) break block19;
                    switch (authNStatus) {
                        case "DENIED": {
                            statusCode = DTOs.StatusResponse.StatusCode.AUTHN_DENIED;
                            break;
                        }
                        case "COMMUNICATION_ERROR": {
                            statusCode = DTOs.StatusResponse.StatusCode.AUTHN_COMMUNICATION_ERROR;
                            break;
                        }
                        case "UNKNOWN_ERROR": {
                            statusCode = DTOs.StatusResponse.StatusCode.AUTHN_UNKNOWN_ERROR;
                            break;
                        }
                        default: {
                            statusCode = DTOs.StatusResponse.StatusCode.UNKNOWN;
                            break;
                        }
                    }
                    break block18;
                }
                charSequence = syncStatus;
                statusCode = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? (Intrinsics.areEqual((Object)(charSequence = syncStatus), (Object)"ENABLED") ? DTOs.StatusResponse.StatusCode.SYNCHRONIZING : (Intrinsics.areEqual((Object)charSequence, (Object)"DISABLED") ? DTOs.StatusResponse.StatusCode.DISABLED : DTOs.StatusResponse.StatusCode.UNKNOWN)) : DTOs.StatusResponse.StatusCode.UNKNOWN;
            }
            DTOs.StatusResponse.StatusCode status = statusCode;
            ResponseEntity responseEntity = ResponseEntity.ok((Object)new DTOs.StatusResponse(status, null, 2, null));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
            return responseEntity;
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable error = throwable;
                boolean bl2 = false;
                Throwable throwable2 = error;
                if (throwable2 instanceof WebOperationsAdvice.ServerError || throwable2 instanceof WebOperationsAdvice.BadRequest) {
                    throw error;
                }
                throw new WebOperationsAdvice.ServerError("Failed to retrieve service status: " + error, error);
            }
            throw new KotlinNothingValueException();
        }
    }

    @GetMapping(value={"/api/shutdown"})
    @Nullable
    public Object shutdown$cdr_client_service(@RequestParam(name="reason") @Nullable String reason, @NotNull Continuation<? super ResponseEntity<DTOs.ShutdownResponse>> $completion) {
        return WebOperations.shutdown$suspendImpl(this, reason, $completion);
    }

    @GetMapping(value={"/api/shutdown"})
    static /* synthetic */ Object shutdown$suspendImpl(WebOperations $this, @RequestParam(name="reason") String reason, Continuation<? super ResponseEntity<DTOs.ShutdownResponse>> $completion) {
        Object object = $this;
        try {
            ResponseEntity responseEntity;
            ShutdownService.ShutdownTrigger shutdownTrigger;
            WebOperations $this$shutdown_u24lambda_u240 = object;
            boolean bl = false;
            CharSequence charSequence = reason;
            ShutdownService.ShutdownTrigger shutdownTrigger2 = shutdownTrigger = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ShutdownService.ShutdownTrigger.UNKNOWN : ShutdownService.ShutdownTrigger.Companion.fromReason(reason);
            if (WhenMappings.$EnumSwitchMapping$1[shutdownTrigger.ordinal()] == 1) {
                throw new WebOperationsAdvice.BadRequest("Invalid shutdown reason: '" + reason + "'", null, null, 6, null);
            }
            Instant instant = Instant.now().plus(Constants.getSHUTDOWN_DELAY());
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
            ResponseEntity it = responseEntity = ResponseEntity.ok((Object)new DTOs.ShutdownResponse(null, instant, shutdownTrigger.name(), shutdownTrigger.getExitCode(), 1, null));
            boolean bl2 = false;
            $this$shutdown_u24lambda_u240.shutdownService.scheduleShutdown$cdr_client_service(shutdownTrigger);
            ResponseEntity responseEntity2 = responseEntity;
            Intrinsics.checkNotNull((Object)responseEntity2);
            ResponseEntity response = responseEntity2;
            return response;
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable error = throwable;
                boolean bl3 = false;
                Throwable throwable2 = error;
                if (throwable2 instanceof WebOperationsAdvice.ServerError || throwable2 instanceof WebOperationsAdvice.BadRequest) {
                    throw error;
                }
                throw new WebOperationsAdvice.ServerError("Failed to schedule shutdown: " + error, error);
            }
            throw new KotlinNothingValueException();
        }
    }

    private static final Object validateConnectorMode$lambda$0$0(List $connectors) {
        return "validating mode for connectors: '" + $connectors + "'";
    }

    private static final Object validateIsNotBlankAndNotPlaceholder$lambda$0$0(String $value) {
        return "validating string value: '" + $value + "'";
    }

    private static final Object validateDirectory$lambda$0$0(Path $directory, List $validations) {
        return "validating dir: '" + $directory + "', validations: '" + $validations + "'";
    }

    private static final Object validateCredentials$lambda$0$0(DTOs.CdrClientConfig.IdpCredentials $idpCredentials) {
        return "validating credentials for tenant id: '" + $idpCredentials.getTenantId() + "'";
    }

    private static final OAuth2AuthNService.AuthNResponse validateCredentials$lambda$0$1(WebOperations $this_runCatching, DTOs.CdrClientConfig.IdpCredentials $idpCredentials, RetryContext retry) {
        String correctedIdpEndpoint;
        Intrinsics.checkNotNullParameter((Object)retry, (String)"retry");
        String string = $this_runCatching.config.getIdpEndpoint().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String idpEndpoint = string;
        if (Intrinsics.areEqual((Object)$this_runCatching.config.getIdpCredentials().getTenantId-h8-mLP8(), (Object)$idpCredentials.getTenantId())) {
            v1 = idpEndpoint;
        } else {
            CharSequence charSequence = idpEndpoint;
            Regex regex = new Regex("(http[s]?://[^/]+/)[^/]+");
            String string2 = "$1" + $idpCredentials.getTenantId();
            v1 = correctedIdpEndpoint = regex.replace(charSequence, string2);
        }
        if (retry.getRetryCount() > 0) {
            WebOperationsKt.access$getLogger$p().debug(() -> WebOperations.validateCredentials$lambda$0$1$0(correctedIdpEndpoint, retry));
            WebOperationsKt.access$getLogger$p().info(() -> WebOperations.validateCredentials$lambda$0$1$1(retry, correctedIdpEndpoint));
        }
        WebOperationsKt.access$getLogger$p().trace(WebOperations::validateCredentials$lambda$0$1$2);
        OAuth2AuthNService oAuth2AuthNService = $this_runCatching.authService;
        IdpCredentials idpCredentials = ConfigConverterKt.toCdrClientConfig($idpCredentials);
        URL uRL = new URI(correctedIdpEndpoint).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return oAuth2AuthNService.getNewAccessToken$cdr_client_service(idpCredentials, uRL, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object validateCredentials$lambda$0$1$0(String $correctedIdpEndpoint, RetryContext $retry) {
        Class<?> clazz;
        String string = $correctedIdpEndpoint;
        Throwable throwable = $retry.getLastThrowable();
        if (throwable != null) {
            void it;
            Throwable throwable2 = throwable;
            String string2 = string;
            boolean bl = false;
            clazz = UtilKt.getRootestCause((Throwable)it).getClass();
            string = string2;
        } else {
            clazz = null;
        }
        Throwable throwable3 = $retry.getLastThrowable();
        return "Operation targeting '" + string + "' has failed; exception: '" + clazz + "'; message: '" + (throwable3 != null ? throwable3.getMessage() : null) + "'";
    }

    private static final Object validateCredentials$lambda$0$1$1(RetryContext $retry, String $correctedIdpEndpoint) {
        return "Retry attempt '#" + $retry.getRetryCount() + "' of 'validate credentials' operation targeting '" + $correctedIdpEndpoint + "'";
    }

    private static final Object validateCredentials$lambda$0$1$2() {
        return "validating credentials";
    }

    private static final Object validateCredentials$lambda$1$0(Ref.ObjectRef $validationResult) {
        return "Credentials validation completed with result: '" + $validationResult.element + "'";
    }

    private static final Object validateCredentials$lambda$2$0(Throwable $e) {
        return "Failed to validate credentials: " + $e;
    }

    private static final Object updateServiceConfiguration$lambda$0$0(DTOs.CdrClientConfig $config) {
        return "received DTOs.CdrClientConfig: '" + $config + "'";
    }

    private static final Object status$lambda$0$0(WebOperations $this_runCatching, SystemHealth $healthStatus) {
        return "Health endpoint response: '" + $this_runCatching.objectMapper.writeValueAsString((Object)$healthStatus) + "'";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DomainObjects.ValidationType.values().length];
            try {
                nArray[DomainObjects.ValidationType.MODE_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DomainObjects.ValidationType.MODE_OVERLAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DomainObjects.ValidationType.DIR_READ_WRITABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DomainObjects.ValidationType.DIR_SINGLE_USE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ShutdownService.ShutdownTrigger.values().length];
            try {
                nArray[ShutdownService.ShutdownTrigger.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

