/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.ui;

import com.sun.jna.Platform;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u001a(\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\b\u0010\f\u001a\u00020\rH\u0000\u001a\b\u0010\u000e\u001a\u00020\tH\u0000\u001a\b\u0010\u000f\u001a\u00020\tH\u0000\u001a\b\u0010\u0010\u001a\u00020\tH\u0000\u001a\b\u0010\u0011\u001a\u00020\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "logInfo", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "Lkotlin/Function0;", "", "findClientServiceExecutable", "Ljava/nio/file/Path;", "uiIsServiceController", "", "clientServiceExecutableForPlatform", "clientUiExecutableForPlatform", "javaExecutableForPlatform", "javawExecutableForPlatform", "LINUX_CLIENT_SERVICE_NAME", "WINDOWS_CLIENT_SERVICE_NAME", "LINUX_CLIENT_UI_NAME", "WINDOWS_CLIENT_UI_NAME", "LINUX_JAVA_EXECUTABLE_NAME", "WINDOWS_JAVA_EXECUTABLE_NAME", "LINUX_JAVAW_EXECUTABLE_NAME", "WINDOWS_JAVAW_EXECUTABLE_NAME", "cdr-client-ui"})
public final class ClientServiceUtilKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ClientServiceUtilKt::logger$lambda$0);
    @NotNull
    private static final String LINUX_CLIENT_SERVICE_NAME = "cdr-client-service";
    @NotNull
    private static final String WINDOWS_CLIENT_SERVICE_NAME = "cdr-client-service.exe";
    @NotNull
    private static final String LINUX_CLIENT_UI_NAME = "cdr-client-ui";
    @NotNull
    private static final String WINDOWS_CLIENT_UI_NAME = "cdr-client-ui.exe";
    @NotNull
    private static final String LINUX_JAVA_EXECUTABLE_NAME = "java";
    @NotNull
    private static final String WINDOWS_JAVA_EXECUTABLE_NAME = "javaw.exe";
    @NotNull
    private static final String LINUX_JAVAW_EXECUTABLE_NAME = "javaw";
    @NotNull
    private static final String WINDOWS_JAVAW_EXECUTABLE_NAME = "javaw.exe";

    public static final void logInfo(@Nullable Exception e, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        logger.info((Throwable)e, () -> ClientServiceUtilKt.logInfo$lambda$0(message));
    }

    public static /* synthetic */ void logInfo$default(Exception exception, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            exception = null;
        }
        ClientServiceUtilKt.logInfo(exception, (Function0<String>)function0);
    }

    @Nullable
    public static final Path findClientServiceExecutable() {
        Path cdrServiceCmd;
        Path path;
        Path cdrServiceCmd2;
        Path path2;
        String string2 = ProcessHandle.current().info().command().get();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        String cdrUiCmd = string2;
        boolean bl = false;
        logger.debug(() -> ClientServiceUtilKt.findClientServiceExecutable$lambda$0$0(cdrUiCmd));
        if (StringsKt.endsWith$default((String)cdrUiCmd, (String)ClientServiceUtilKt.javaExecutableForPlatform(), (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)cdrUiCmd, (String)ClientServiceUtilKt.javawExecutableForPlatform(), (boolean)false, (int)2, null)) {
            logger.debug(ClientServiceUtilKt::findClientServiceExecutable$lambda$0$1);
            path2 = Path.of(ClientServiceUtilKt.clientUiExecutableForPlatform(), new String[0]);
        } else if (StringsKt.endsWith$default((String)cdrUiCmd, (String)ClientServiceUtilKt.clientUiExecutableForPlatform(), (boolean)false, (int)2, null)) {
            cdrServiceCmd2 = Path.of(cdrUiCmd, new String[0]).resolveSibling(ClientServiceUtilKt.clientServiceExecutableForPlatform());
            boolean bl2 = false;
            if (Files.exists(cdrServiceCmd2, new LinkOption[0]) && Files.isExecutable(cdrServiceCmd2)) {
                logger.debug(ClientServiceUtilKt::findClientServiceExecutable$lambda$0$2$0);
                path2 = cdrServiceCmd2;
            } else {
                logger.debug(() -> ClientServiceUtilKt.findClientServiceExecutable$lambda$0$2$1(cdrServiceCmd2));
                path2 = Path.of(ClientServiceUtilKt.clientUiExecutableForPlatform(), new String[0]);
            }
        } else {
            logger.warn(() -> ClientServiceUtilKt.findClientServiceExecutable$lambda$0$3(cdrUiCmd));
            path2 = null;
        }
        cdrServiceCmd2 = path = (cdrServiceCmd = path2);
        boolean bl3 = false;
        if (cdrServiceCmd2 != null) {
            logger.debug(() -> ClientServiceUtilKt.findClientServiceExecutable$lambda$0$4$0(cdrServiceCmd2));
        } else {
            logger.warn(() -> ClientServiceUtilKt.findClientServiceExecutable$lambda$0$4$1(cdrUiCmd));
        }
        return path;
    }

    public static final boolean uiIsServiceController() {
        boolean bl;
        boolean it = bl = Boolean.parseBoolean(System.getProperty("cdr.client.ui.isServiceController", "false"));
        boolean bl2 = false;
        logger.info(() -> ClientServiceUtilKt.uiIsServiceController$lambda$0$0(it));
        return bl;
    }

    @NotNull
    public static final String clientServiceExecutableForPlatform() {
        String string2;
        if (Platform.isLinux() || Platform.isMac()) {
            string2 = LINUX_CLIENT_SERVICE_NAME;
        } else if (Platform.isWindows()) {
            string2 = WINDOWS_CLIENT_SERVICE_NAME;
        } else {
            throw new IllegalStateException(("Unsupported platform: '" + Platform.getOSType() + "'").toString());
        }
        return string2;
    }

    @NotNull
    public static final String clientUiExecutableForPlatform() {
        String string2;
        if (Platform.isLinux() || Platform.isMac()) {
            string2 = LINUX_CLIENT_UI_NAME;
        } else if (Platform.isWindows()) {
            string2 = WINDOWS_CLIENT_UI_NAME;
        } else {
            throw new IllegalStateException(("Unsupported platform: '" + Platform.getOSType() + "'").toString());
        }
        return string2;
    }

    @NotNull
    public static final String javaExecutableForPlatform() {
        String string2;
        if (Platform.isLinux() || Platform.isMac()) {
            string2 = LINUX_JAVA_EXECUTABLE_NAME;
        } else if (Platform.isWindows()) {
            string2 = "javaw.exe";
        } else {
            throw new IllegalStateException(("Unsupported platform: '" + Platform.getOSType() + "'").toString());
        }
        return string2;
    }

    @NotNull
    public static final String javawExecutableForPlatform() {
        String string2;
        if (Platform.isLinux() || Platform.isMac()) {
            string2 = LINUX_JAVAW_EXECUTABLE_NAME;
        } else if (Platform.isWindows()) {
            string2 = "javaw.exe";
        } else {
            throw new IllegalStateException(("Unsupported platform: '" + Platform.getOSType() + "'").toString());
        }
        return string2;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object logInfo$lambda$0(Function0 $message) {
        return $message.invoke();
    }

    private static final Object findClientServiceExecutable$lambda$0$0(String $cdrUiCmd) {
        return "cdr-client-ui command: '" + $cdrUiCmd + "'";
    }

    private static final Object findClientServiceExecutable$lambda$0$1() {
        return "UI run via java cmd; assuming UI is run from the IDE and the service is available on the user's '$PATH'";
    }

    private static final Object findClientServiceExecutable$lambda$0$2$0() {
        return "The CDR client service executable was found relative to the client UI executable.";
    }

    private static final Object findClientServiceExecutable$lambda$0$2$1(Path $cdrServiceCmd) {
        return "The CDR client service executable '" + $cdrServiceCmd + "' could not be resolved relative to the client UI executable. Assuming the service executable is available on the '$PATH'.";
    }

    private static final Object findClientServiceExecutable$lambda$0$3(String $cdrUiCmd) {
        return "Don't know how to derive 'cdr-client-service' cmd from cdr-client-ui cmd '" + $cdrUiCmd + "' ";
    }

    private static final Object findClientServiceExecutable$lambda$0$4$0(Path $cdrServiceCmd) {
        return "cdr-client-service command: '" + $cdrServiceCmd + "'";
    }

    private static final Object findClientServiceExecutable$lambda$0$4$1(String $cdrUiCmd) {
        return "Could not derive cdr-client-service command from cdr-client-ui command '" + $cdrUiCmd + "'";
    }

    private static final Object uiIsServiceController$lambda$0$0(boolean $it) {
        return "cdr.client.ui.isServiceController = '" + $it + "'";
    }
}

