/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.lib.mac;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kdroid.composetray.lib.mac.ObjectiveC;
import com.kdroid.composetray.utils.DebugLnKt;
import com.sun.jna.Pointer;
import io.github.kdroidfilter.platformtools.OperatingSystem;
import io.github.kdroidfilter.platformtools.OsProvider_jvmKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0005H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/kdroid/composetray/lib/mac/MacOSWindowManager;", "", "<init>", "()V", "isMacOs", "", "objc", "Lcom/kdroid/composetray/lib/mac/ObjectiveC;", "getObjc", "()Lcom/kdroid/composetray/lib/mac/ObjectiveC;", "objc$delegate", "Lkotlin/Lazy;", "nsApplicationInstance", "Lcom/sun/jna/Pointer;", "ensureNSApplicationInitialized", "getNSApplication", "showInDock", "hideFromDock", "canHideFromDock", "Companion", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
public final class MacOSWindowManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isMacOs = OsProvider_jvmKt.getOperatingSystem() == OperatingSystem.MACOS;
    @NotNull
    private final Lazy objc$delegate = LazyKt.lazy(() -> MacOSWindowManager.objc_delegate$lambda$0(this));
    @Nullable
    private Pointer nsApplicationInstance;
    public static final int $stable = 8;
    public static final long NSApplicationActivationPolicyRegular = 0L;
    public static final long NSApplicationActivationPolicyAccessory = 1L;
    public static final long NSApplicationActivationPolicyProhibited = 2L;
    public static final long NSNormalWindowLevel = 0L;
    public static final long NSFloatingWindowLevel = 3L;
    public static final long NSModalPanelWindowLevel = 8L;

    private final ObjectiveC getObjc() {
        Lazy lazy = this.objc$delegate;
        return (ObjectiveC)lazy.getValue();
    }

    private final boolean ensureNSApplicationInitialized() {
        boolean bl;
        if (!this.isMacOs) {
            return false;
        }
        if (this.nsApplicationInstance != null && !Intrinsics.areEqual((Object)this.nsApplicationInstance, (Object)Pointer.NULL)) {
            return true;
        }
        ObjectiveC objectiveC = this.getObjc();
        if (objectiveC == null) {
            return false;
        }
        ObjectiveC localObjc = objectiveC;
        try {
            DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::ensureNSApplicationInitialized$lambda$0));
            Pointer nsApplicationClass = localObjc.objc_getClass("NSApplication");
            if (Intrinsics.areEqual((Object)nsApplicationClass, (Object)Pointer.NULL)) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::ensureNSApplicationInitialized$lambda$1));
                return false;
            }
            Pointer sharedApplicationSelector = localObjc.sel_registerName("sharedApplication");
            if (Intrinsics.areEqual((Object)sharedApplicationSelector, (Object)Pointer.NULL)) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::ensureNSApplicationInitialized$lambda$2));
                return false;
            }
            this.nsApplicationInstance = localObjc.objc_msgSend(nsApplicationClass, sharedApplicationSelector);
            if (Intrinsics.areEqual((Object)this.nsApplicationInstance, (Object)Pointer.NULL)) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::ensureNSApplicationInitialized$lambda$3));
                this.nsApplicationInstance = null;
                return false;
            }
            DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::ensureNSApplicationInitialized$lambda$4));
            bl = true;
        }
        catch (Exception e) {
            DebugLnKt.debugln((Function0<String>)((Function0)() -> MacOSWindowManager.ensureNSApplicationInitialized$lambda$5(e)));
            e.printStackTrace();
            this.nsApplicationInstance = null;
            bl = false;
        }
        return bl;
    }

    private final Pointer getNSApplication() {
        if (!this.ensureNSApplicationInitialized()) {
            return null;
        }
        return this.nsApplicationInstance;
    }

    public final boolean showInDock() {
        boolean bl;
        if (!this.isMacOs) {
            DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::showInDock$lambda$0));
            return true;
        }
        ObjectiveC objectiveC = this.getObjc();
        if (objectiveC == null) {
            return false;
        }
        ObjectiveC localObjc = objectiveC;
        try {
            Pointer nsApp = this.getNSApplication();
            if (nsApp == null) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::showInDock$lambda$1));
                return false;
            }
            Pointer setActivationPolicySelector = localObjc.sel_registerName("setActivationPolicy:");
            if (Intrinsics.areEqual((Object)setActivationPolicySelector, (Object)Pointer.NULL)) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::showInDock$lambda$2));
                return false;
            }
            localObjc.objc_msgSend(nsApp, setActivationPolicySelector, 0L);
            DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::showInDock$lambda$3));
            bl = true;
        }
        catch (Exception e) {
            DebugLnKt.debugln((Function0<String>)((Function0)() -> MacOSWindowManager.showInDock$lambda$4(e)));
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public final boolean hideFromDock() {
        boolean bl;
        if (!this.isMacOs) {
            DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::hideFromDock$lambda$0));
            return true;
        }
        ObjectiveC objectiveC = this.getObjc();
        if (objectiveC == null) {
            return false;
        }
        ObjectiveC localObjc = objectiveC;
        try {
            Pointer nsApp = this.getNSApplication();
            if (nsApp == null) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::hideFromDock$lambda$1));
                return false;
            }
            Pointer setActivationPolicySelector = localObjc.sel_registerName("setActivationPolicy:");
            if (Intrinsics.areEqual((Object)setActivationPolicySelector, (Object)Pointer.NULL)) {
                DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::hideFromDock$lambda$2));
                return false;
            }
            localObjc.objc_msgSend(nsApp, setActivationPolicySelector, 1L);
            DebugLnKt.debugln((Function0<String>)((Function0)MacOSWindowManager::hideFromDock$lambda$3));
            bl = true;
        }
        catch (Exception e) {
            DebugLnKt.debugln((Function0<String>)((Function0)() -> MacOSWindowManager.hideFromDock$lambda$4(e)));
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public final boolean canHideFromDock() {
        if (!this.isMacOs) {
            return false;
        }
        return this.getNSApplication() != null;
    }

    private static final ObjectiveC objc_delegate$lambda$0(MacOSWindowManager this$0) {
        ObjectiveC objectiveC;
        if (!this$0.isMacOs) {
            return null;
        }
        try {
            objectiveC = ObjectiveC.Companion.getINSTANCE();
        }
        catch (Throwable t) {
            DebugLnKt.debugln((Function0<String>)((Function0)() -> MacOSWindowManager.objc_delegate$lambda$0$0(t)));
            objectiveC = null;
        }
        return objectiveC;
    }

    private static final String objc_delegate$lambda$0$0(Throwable $t) {
        return "Failed to load Objective-C runtime: " + $t.getMessage();
    }

    private static final String ensureNSApplicationInitialized$lambda$0() {
        return "Initializing NSApplication...";
    }

    private static final String ensureNSApplicationInitialized$lambda$1() {
        return "Unable to get NSApplication class";
    }

    private static final String ensureNSApplicationInitialized$lambda$2() {
        return "Unable to get sharedApplication selector";
    }

    private static final String ensureNSApplicationInitialized$lambda$3() {
        return "Unable to get NSApplication instance";
    }

    private static final String ensureNSApplicationInitialized$lambda$4() {
        return "NSApplication initialized successfully";
    }

    private static final String ensureNSApplicationInitialized$lambda$5(Exception $e) {
        return "Error while initializing NSApplication: " + $e.getMessage();
    }

    private static final String showInDock$lambda$0() {
        return "showInDock(): non-macOS platform detected, no action performed";
    }

    private static final String showInDock$lambda$1() {
        return "NSApplication not available";
    }

    private static final String showInDock$lambda$2() {
        return "Unable to get setActivationPolicy: selector";
    }

    private static final String showInDock$lambda$3() {
        return "Application restored in the Dock";
    }

    private static final String showInDock$lambda$4(Exception $e) {
        return "Error while restoring in Dock: " + $e.getMessage();
    }

    private static final String hideFromDock$lambda$0() {
        return "hideFromDock(): non-macOS platform detected, no action performed";
    }

    private static final String hideFromDock$lambda$1() {
        return "NSApplication not available";
    }

    private static final String hideFromDock$lambda$2() {
        return "Unable to get setActivationPolicy: selector";
    }

    private static final String hideFromDock$lambda$3() {
        return "Application set as accessory";
    }

    private static final String hideFromDock$lambda$4(Exception $e) {
        return "Error while setting as accessory: " + $e.getMessage();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/kdroid/composetray/lib/mac/MacOSWindowManager$Companion;", "", "<init>", "()V", "NSApplicationActivationPolicyRegular", "", "NSApplicationActivationPolicyAccessory", "NSApplicationActivationPolicyProhibited", "NSNormalWindowLevel", "NSFloatingWindowLevel", "NSModalPanelWindowLevel", "ComposeNativeTray"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

