/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.abbreviator;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.core.spi.LifeCycle;
import net.logstash.logback.abbreviator.CachingAbbreviator;
import net.logstash.logback.abbreviator.NullAbbreviator;

public class DefaultTargetLengthAbbreviator
implements Abbreviator,
LifeCycle {
    private boolean started;
    private int targetLength = -1;
    private Abbreviator delegate;

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        if (!this.isStarted()) {
            this.delegate = this.createAbbreviator();
            this.started = true;
        }
    }

    private Abbreviator createAbbreviator() {
        if (this.targetLength < 0 || this.targetLength == Integer.MAX_VALUE) {
            return NullAbbreviator.INSTANCE;
        }
        Object abbreviator = this.targetLength == 0 ? new ClassNameOnlyAbbreviator() : new TargetLengthBasedClassNameAbbreviator(this.targetLength);
        return new CachingAbbreviator((Abbreviator)abbreviator);
    }

    public void stop() {
        if (this.isStarted()) {
            this.started = false;
            this.delegate = null;
        }
    }

    public String abbreviate(String in) {
        this.assertStarted();
        return this.delegate.abbreviate(in);
    }

    public void setTargetLength(int targetLength) {
        this.targetLength = targetLength;
    }

    public int getTargetLength() {
        return this.targetLength;
    }

    protected void assertStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Component is not started");
        }
    }
}

