/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdroidfilter.platformtools.darkmodedetector.linux;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import io.github.kdroidfilter.platformtools.darkmodedetector.linux.GnomeThemeDetector;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u000f\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\r\u0010\u0005\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\u0010\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"gnomeLogger", "Lco/touchlab/kermit/Logger;", "detectGnomeDarkTheme", "", "()Ljava/lang/Boolean;", "isGnomeInDarkMode", "(Landroidx/compose/runtime/Composer;I)Z", "darkmodedetector"})
@SourceDebugExtension(value={"SMAP\nGnomeThemeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GnomeThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/linux/GnomeThemeDetectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 Logger.kt\nco/touchlab/kermit/Logger\n+ 5 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 6 Effects.kt\nandroidx/compose/runtime/DisposableEffectScope\n*L\n1#1,158:1\n1#2:159\n1282#3,6:160\n1282#3,6:166\n31#4,3:172\n34#4:184\n31#4,3:190\n34#4:202\n31#5,9:175\n31#5,9:193\n66#6,5:185\n*S KotlinDebug\n*F\n+ 1 GnomeThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/linux/GnomeThemeDetectorKt\n*L\n142#1:160,6\n144#1:166,6\n145#1:172,3\n145#1:184\n147#1:190,3\n147#1:202\n145#1:175,9\n147#1:193,9\n151#1:185,5\n*E\n"})
public final class GnomeThemeDetectorKt {
    @NotNull
    private static final Logger gnomeLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Boolean detectGnomeDarkTheme() {
        try {
            Object object;
            char[] cArray;
            String[] stringArray = new String[]{"gsettings", "get", "org.gnome.desktop.interface", "gtk-theme"};
            Process p1 = Runtime.getRuntime().exec(stringArray);
            Object object2 = new BufferedReader(new InputStreamReader(p1.getInputStream()));
            String[] stringArray2 = null;
            try {
                String string;
                BufferedReader it = (BufferedReader)object2;
                boolean bl = false;
                String string2 = it.readLine();
                if (string2 != null) {
                    cArray = new char[]{'\'', '\"'};
                    string = StringsKt.trim((String)string2, (char[])cArray);
                } else {
                    string = null;
                }
                object = string;
            }
            catch (Throwable object3) {
                stringArray2 = object3;
                throw object3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)stringArray2);
            }
            String theme = object;
            object2 = theme;
            if (!(object2 == null || StringsKt.isBlank((CharSequence)object2)) && StringsKt.contains((CharSequence)theme, (CharSequence)"dark", (boolean)true)) {
                return true;
            }
            stringArray2 = new String[]{"gsettings", "get", "org.gnome.desktop.interface", "color-scheme"};
            Process p2 = Runtime.getRuntime().exec(stringArray2);
            object = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            Throwable throwable = null;
            try {
                String string;
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                String string3 = it.readLine();
                if (string3 != null) {
                    char[] cArray2 = new char[]{'\'', '\"'};
                    string = StringsKt.trim((String)string3, (char[])cArray2);
                } else {
                    string = null;
                }
                cArray = string;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            char[] scheme = cArray;
            if (scheme == null) return null;
            String string = scheme.toLowerCase(Locale.ROOT);
            String string4 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            object = string4;
            if (object == null) return null;
            int n = -1;
            switch (((String)object).hashCode()) {
                case -48746727: {
                    if (((String)object).equals("prefer-light")) {
                        n = 1;
                    }
                    break;
                }
                case 1937844499: {
                    if (((String)object).equals("prefer-dark")) {
                        n = 2;
                    }
                    break;
                }
                case 1544803905: {
                    if (((String)object).equals("default")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    Boolean bl = true;
                    return bl;
                }
                case 1: {
                    Boolean bl = false;
                    return bl;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Composable
    public static final boolean isGnomeInDarkMode(@Nullable Composer $composer, int $changed) {
        Object object;
        Object object2;
        Composer $this$cache$iv;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-426724056, (int)$changed, (int)-1, (String)"io.github.kdroidfilter.platformtools.darkmodedetector.linux.isGnomeInDarkMode (GnomeThemeDetector.kt:140)");
        }
        Composer composer = $composer;
        boolean bl = false;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            MutableState value$iv = SnapshotStateKt.mutableStateOf$default((Object)GnomeThemeDetector.INSTANCE.isDark(), null, (int)2, null);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object2 = value$iv;
        } else {
            object2 = it$iv;
        }
        MutableState darkModeState = (MutableState)object2;
        Unit unit = Unit.INSTANCE;
        $this$cache$iv = $composer;
        boolean invalid$iv = false;
        $i$f$cache = false;
        it$iv = $this$cache$iv.rememberedValue();
        bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            Unit unit2 = unit;
            boolean bl4 = false;
            unit = unit2;
            Function1 value$iv = arg_0 -> GnomeThemeDetectorKt.isGnomeInDarkMode$lambda$1$0(darkModeState, arg_0);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        EffectsKt.DisposableEffect((Object)unit, (Function1)((Function1)object), (Composer)$composer, (int)54);
        boolean bl5 = (Boolean)darkModeState.getValue();
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return bl5;
    }

    /*
     * WARNING - void declaration
     */
    private static final DisposableEffectResult isGnomeInDarkMode$lambda$1$0(MutableState $darkModeState, DisposableEffectScope $this$DisposableEffect) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
        Logger $this$iv = gnomeLogger;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$logBlock = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            Throwable throwable = throwable$iv;
            String string = tag$iv;
            Severity severity = severity$iv$iv;
            void var10_13 = this_$iv$iv;
            boolean bl = false;
            String string2 = "Registering GNOME dark mode listener in Compose";
            var10_13.processLog(severity, string, throwable, string2);
        }
        Consumer<Boolean> listener = arg_0 -> GnomeThemeDetectorKt.isGnomeInDarkMode$lambda$1$0$1($darkModeState, arg_0);
        GnomeThemeDetector.INSTANCE.registerListener(listener);
        DisposableEffectScope this_$iv = $this$DisposableEffect;
        boolean $i$f$onDispose = false;
        return new DisposableEffectResult(listener){
            final /* synthetic */ Consumer $listener$inlined;
            {
                this.$listener$inlined = consumer;
            }

            /*
             * WARNING - void declaration
             */
            public void dispose() {
                void this_$iv$iv;
                boolean bl = false;
                Logger $this$iv = GnomeThemeDetectorKt.access$getGnomeLogger$p();
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var12_12 = this_$iv$iv;
                    boolean bl2 = false;
                    String string2 = "Removing GNOME dark mode listener in Compose";
                    var12_12.processLog(severity, string, throwable, string2);
                }
                GnomeThemeDetector.INSTANCE.removeListener(this.$listener$inlined);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final void isGnomeInDarkMode$lambda$1$0$1(MutableState $darkModeState, Boolean newValue) {
        void this_$iv$iv;
        Logger $this$iv = gnomeLogger;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$logBlock = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            Throwable throwable = throwable$iv;
            String string = tag$iv;
            Severity severity = severity$iv$iv;
            void var10_12 = this_$iv$iv;
            boolean bl = false;
            String string2 = "GNOME dark mode updated: " + newValue;
            var10_12.processLog(severity, string, throwable, string2);
        }
        Intrinsics.checkNotNull((Object)newValue);
        $darkModeState.setValue((Object)newValue);
    }

    public static final /* synthetic */ Logger access$getGnomeLogger$p() {
        return gnomeLogger;
    }

    static {
        Logger logger;
        Logger $this$gnomeLogger_u24lambda_u240 = logger = Logger.Companion.withTag("GnomeThemeDetector");
        boolean bl = false;
        Logger.Companion.setMinSeverity(Severity.Warn);
        gnomeLogger = logger;
    }
}

