/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdroidfilter.platformtools.darkmodedetector.windows;

import androidx.compose.runtime.internal.StabilityInferred;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Severity;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import io.github.kdroidfilter.platformtools.darkmodedetector.windows.WindowsThemeDetectorKt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\b\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/github/kdroidfilter/platformtools/darkmodedetector/windows/WindowsThemeDetector;", "", "<init>", "()V", "REGISTRY_PATH", "", "REGISTRY_VALUE", "listeners", "", "Ljava/util/function/Consumer;", "", "detectorThread", "Ljava/lang/Thread;", "isDark", "registerListener", "", "listener", "removeListener", "startMonitoringThread", "darkmodedetector"})
@StabilityInferred(parameters=0)
public final class WindowsThemeDetector {
    @NotNull
    public static final WindowsThemeDetector INSTANCE = new WindowsThemeDetector();
    @NotNull
    private static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    @NotNull
    private static final String REGISTRY_VALUE = "AppsUseLightTheme";
    @NotNull
    private static final Set<Consumer<Boolean>> listeners;
    @Nullable
    private static volatile Thread detectorThread;
    public static final int $stable;

    private WindowsThemeDetector() {
    }

    public final boolean isDark() {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        WindowsThemeDetector windowsThemeDetector = this;
        synchronized (windowsThemeDetector) {
            block7: {
                block6: {
                    boolean bl = false;
                    listeners.add(listener);
                    if (listeners.size() == 1) break block6;
                    Thread thread2 = detectorThread;
                    boolean bl2 = thread2 != null ? thread2.isInterrupted() : false;
                    if (!bl2) break block7;
                }
                INSTANCE.startMonitoringThread();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull Consumer<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        WindowsThemeDetector windowsThemeDetector = this;
        synchronized (windowsThemeDetector) {
            boolean bl = false;
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                Thread thread2 = detectorThread;
                if (thread2 != null) {
                    thread2.interrupt();
                }
                detectorThread = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void startMonitoringThread() {
        Thread thread2 = new Thread(){
            private boolean lastValue;
            {
                this.lastValue = WindowsThemeDetector.INSTANCE.isDark();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block16: {
                    block15: {
                        $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                        throwable$iv = null;
                        tag$iv = $this$iv.getTag();
                        $i$f$d = false;
                        var5_9 = (BaseLogger)$this$iv;
                        severity$iv$iv = Severity.Debug;
                        $i$f$logBlock = false;
                        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                            var21_21 = throwable$iv;
                            var20_22 = tag$iv;
                            var19_23 = severity$iv$iv;
                            var18_24 = this_$iv$iv;
                            $i$a$-d$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$1 = false;
                            var22_30 = "Windows theme monitor thread started";
                            var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                        }
                        hKeyRef = new WinReg.HKEYByReference();
                        openErr = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", 0, 131097, hKeyRef);
                        if (openErr != 0) {
                            $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                            throwable$iv = null;
                            tag$iv = $this$iv.getTag();
                            $i$f$e = false;
                            $i$f$logBlock = (BaseLogger)$this$iv;
                            severity$iv$iv = Severity.Error;
                            $i$f$logBlock = false;
                            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) return;
                            var21_21 = throwable$iv;
                            var20_22 = tag$iv;
                            var19_23 = severity$iv$iv;
                            var18_24 = this_$iv$iv;
                            $i$a$-e$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$2 = false;
                            var22_30 = "RegOpenKeyEx failed with code " + openErr;
                            var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                            return;
                        }
                        v0 = hKeyRef.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getValue(...)");
                        hKey = v0;
                        try {
lbl44:
                            // 3 sources

                            while (!this.isInterrupted()) {
                                notifyErr = Advapi32.INSTANCE.RegNotifyChangeKeyValue(hKey, false, 4, null, false);
                                if (notifyErr != 0) {
                                    $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                                    throwable$iv = null;
                                    tag$iv = $this$iv.getTag();
                                    $i$f$e = false;
                                    $i$f$logBlock = (BaseLogger)$this$iv;
                                    severity$iv$iv = Severity.Error;
                                    $i$f$logBlock = false;
                                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                                        var21_21 = throwable$iv;
                                        var20_22 = tag$iv;
                                        var19_23 = severity$iv$iv;
                                        var18_24 = this_$iv$iv;
                                        $i$a$-e$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$3 = false;
                                        var22_30 = "RegNotifyChangeKeyValue failed with code " + notifyErr;
                                        var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                                    }
                                    break block15;
                                }
                                ** GOTO lbl-1000
                            }
                            break block16;
                        }
                        catch (Throwable var4_8) {
                            $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                            throwable$iv = null;
                            tag$iv = $this$iv.getTag();
                            $i$f$d = false;
                            severity$iv$iv = (BaseLogger)$this$iv;
                            severity$iv$iv = Severity.Debug;
                            $i$f$logBlock = false;
                            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                                var21_21 = throwable$iv;
                                var20_22 = tag$iv;
                                var19_23 = severity$iv$iv;
                                var18_24 = this_$iv$iv;
                                $i$a$-d$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$6 = false;
                                var22_30 = "Detector thread closing registry key";
                                var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                            }
                            Advapi32Util.registryCloseKey((WinReg.HKEY)hKey);
                            throw var4_8;
                        }
                    }
                    $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                    throwable$iv = null;
                    tag$iv = $this$iv.getTag();
                    $i$f$d = false;
                    this_$iv$iv = (BaseLogger)$this$iv;
                    severity$iv$iv = Severity.Debug;
                    $i$f$logBlock = false;
                    if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                        var21_21 = throwable$iv;
                        var20_22 = tag$iv;
                        var19_23 = severity$iv$iv;
                        var18_24 = this_$iv$iv;
                        $i$a$-d$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$6 = false;
                        var22_30 = "Detector thread closing registry key";
                        var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                    }
                    Advapi32Util.registryCloseKey((WinReg.HKEY)hKey);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        currentValue = WindowsThemeDetector.INSTANCE.isDark();
                        if (currentValue == this.lastValue) ** GOTO lbl44
                        this.lastValue = currentValue;
                        $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                        throwable$iv = null;
                        tag$iv = $this$iv.getTag();
                        $i$f$d = false;
                        severity$iv$iv = (BaseLogger)$this$iv;
                        severity$iv$iv = Severity.Debug;
                        $i$f$logBlock = false;
                        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                            var21_21 = throwable$iv;
                            var20_22 = tag$iv;
                            var19_23 = severity$iv$iv;
                            var18_24 = this_$iv$iv;
                            $i$a$-d$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$4 = false;
                            var22_30 = "Windows theme changed => dark: " + currentValue;
                            var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                        }
                        snapshot = CollectionsKt.toList((Iterable)WindowsThemeDetector.access$getListeners$p());
                        for (Consumer l : snapshot) {
                            try {
                                l.accept(currentValue);
                            }
                            catch (RuntimeException e) {
                                this_$iv$iv = WindowsThemeDetectorKt.getWindowsLogger();
                                throwable$iv = e;
                                tag$iv = $this$iv.getTag();
                                $i$f$e = false;
                                var14_50 = (BaseLogger)$this$iv;
                                severity$iv$iv = Severity.Error;
                                $i$f$logBlock = false;
                                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) continue;
                                var21_21 = throwable$iv;
                                var20_22 = tag$iv;
                                var19_23 = severity$iv$iv;
                                var18_24 = this_$iv$iv;
                                $i$a$-e$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$5 = false;
                                var22_30 = "Error while notifying listener";
                                var18_24.processLog(var19_23, var20_22, (Throwable)var21_21, (String)var22_30);
                            }
                        }
                        ** GOTO lbl44
                    }
                }
                $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                throwable$iv = null;
                tag$iv = $this$iv.getTag();
                $i$f$d = false;
                l = (BaseLogger)$this$iv;
                severity$iv$iv = Severity.Debug;
                $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    var21_21 = throwable$iv;
                    var20_22 = tag$iv;
                    var19_23 = severity$iv$iv;
                    var18_24 = this_$iv$iv;
                    $i$a$-d$default-WindowsThemeDetector$startMonitoringThread$thread$1$run$6 = false;
                    var22_30 = "Detector thread closing registry key";
                    var18_24.processLog(var19_23, var20_22, var21_21, (String)var22_30);
                }
                Advapi32Util.registryCloseKey((WinReg.HKEY)hKey);
            }
        };
        thread2.setDaemon(true);
        detectorThread = thread2;
        thread2.start();
    }

    public static final /* synthetic */ Set access$getListeners$p() {
        return listeners;
    }

    static {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        listeners = keySetView;
        $stable = 8;
    }
}

