/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.swisscom.health.des.cdr.client.common.UtilKt;
import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.ClientId;
import com.swisscom.health.des.cdr.client.config.HttpServerErrorException;
import com.swisscom.health.des.cdr.client.handler.CdrApiClientKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0011\u0018\u0000 02\u00020\u0001:\u000501234B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0 H\u0012J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000fH\u0012J \u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\f\u0010%\u001a\u00020&*\u00020'H\u0012J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020$H\u0012J\u0018\u0010.\u001a\u00020)2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020$H\u0012J\u0018\u0010/\u001a\u00020)2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020$H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;", "", "cdrClientConfig", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "httpClient", "Lokhttp3/OkHttpClient;", "retryIOExceptionsAndServerErrors", "Lorg/springframework/retry/support/RetryTemplate;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lokhttp3/OkHttpClient;Lorg/springframework/retry/support/RetryTemplate;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "renewClientCredential", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult;", "traceId", "", "uploadDocument", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult;", "contentType", "file", "Ljava/nio/file/Path;", "connectorId", "mode", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig$Mode;", "downloadDocument", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult;", "acknowledgeDocumentDownload", "downloadId", "buildDocumentTargetUrl", "Ljava/net/URL;", "path", "queryParameters", "Lorg/springframework/util/MultiValueMap;", "buildClientCredentialUrl", "clientId", "buildBaseHeaders", "Lokhttp3/Headers;", "isNoContentFound", "", "Lokhttp3/Response;", "createPostRequest", "Lokhttp3/Request;", "requestBody", "Lokhttp3/RequestBody;", "to", "headers", "createGetRequest", "createDeleteRequest", "Companion", "DownloadDocumentResult", "UploadDocumentResult", "RenewClientSecretResult", "CdrClientAppRegistrationDto", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nCdrApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdrApiClient.kt\ncom/swisscom/health/des/cdr/client/handler/CdrApiClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,434:1\n1869#2,2:435\n1#3:437\n*S KotlinDebug\n*F\n+ 1 CdrApiClient.kt\ncom/swisscom/health/des/cdr/client/handler/CdrApiClient\n*L\n95#1:435,2\n*E\n"})
public class CdrApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CdrClientConfig cdrClientConfig;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final RetryTemplate retryIOExceptionsAndServerErrors;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    public static final String CONNECTOR_ID_HEADER = "cdr-connector-id";
    @NotNull
    public static final String CDR_PROCESSING_MODE_HEADER = "cdr-processing-mode";
    @NotNull
    public static final String AZURE_TRACE_ID_HEADER = "x-ms-request-id";
    @NotNull
    public static final String CLIENT_TYPE_HEADER = "SWISSCOM-CLIENT-TYPE";
    @NotNull
    public static final String CLIENT_VERSION_HEADER = "SWISSCOM-CLIENT-VERSION";
    @Nullable
    private static final String clientType = CdrApiClient.class.getPackage().getImplementationTitle();
    @Nullable
    private static final String clientVersion = CdrApiClient.class.getPackage().getImplementationVersion();

    public CdrApiClient(@NotNull CdrClientConfig cdrClientConfig, @NotNull OkHttpClient httpClient, @Qualifier(value="retryIoAndServerErrors") @NotNull RetryTemplate retryIOExceptionsAndServerErrors, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)cdrClientConfig, (String)"cdrClientConfig");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)retryIOExceptionsAndServerErrors, (String)"retryIOExceptionsAndServerErrors");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.cdrClientConfig = cdrClientConfig;
        this.httpClient = httpClient;
        this.retryIOExceptionsAndServerErrors = retryIOExceptionsAndServerErrors;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RenewClientSecretResult renewClientCredential(@NotNull String traceId) {
        RenewClientSecretResult renewClientSecretResult;
        Object object;
        Object $this$renewClientCredential_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Object object2 = this;
        try {
            Object response;
            $this$renewClientCredential_u24lambda_u240 = object2;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().debug(CdrApiClient::renewClientCredential$lambda$0$0);
            object = (Closeable)((CdrApiClient)$this$renewClientCredential_u24lambda_u240).retryIOExceptionsAndServerErrors.execute(arg_0 -> CdrApiClient.renewClientCredential$lambda$0$1((CdrApiClient)$this$renewClientCredential_u24lambda_u240, traceId, arg_0));
            Throwable throwable = null;
            try {
                RenewClientSecretResult renewClientSecretResult2;
                response = (Response)object;
                boolean bl2 = false;
                if (response.isSuccessful()) {
                    String string = Response.header$default((Response)response, (String)"Content-Type", null, (int)2, null);
                    if (string == null) {
                        boolean $i$a$-requireNotNull-CdrApiClient$renewClientCredential$1$3$22 = false;
                        String $i$a$-requireNotNull-CdrApiClient$renewClientCredential$1$3$22 = "Client credential renewal response has no content type";
                        throw new IllegalArgumentException($i$a$-requireNotNull-CdrApiClient$renewClientCredential$1$3$22.toString());
                    }
                    String mediaTypeString = string;
                    boolean bl3 = false;
                    if (!MediaType.parseMediaType((String)"application/*+json").isCompatibleWith(MediaType.parseMediaType((String)mediaTypeString))) {
                        boolean bl4 = false;
                        String string2 = "Client credential renewal response is not a JSON content type; received content type: '" + mediaTypeString + "'";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    CdrClientAppRegistrationDto appRegistration = (CdrClientAppRegistrationDto)((CdrApiClient)$this$renewClientCredential_u24lambda_u240).objectMapper.readValue(response.body().byteStream(), CdrClientAppRegistrationDto.class);
                    Iterable $this$forEach$iv = appRegistration.getWarnings();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String warning = (String)element$iv;
                        boolean bl5 = false;
                        CdrApiClientKt.access$getLogger$p().warn(() -> CdrApiClient.renewClientCredential$lambda$0$2$2$0(warning));
                    }
                    if (!Intrinsics.areEqual((Object)((CdrApiClient)$this$renewClientCredential_u24lambda_u240).cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s(), (Object)appRegistration.getClientId())) {
                        boolean $i$a$-require-CdrApiClient$renewClientCredential$1$3$52 = false;
                        String $i$a$-require-CdrApiClient$renewClientCredential$1$3$52 = "Client id in credential renewal response does not match local client id; local: '" + ClientId.toString-impl(((CdrApiClient)$this$renewClientCredential_u24lambda_u240).cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s()) + "', received: '" + appRegistration.getClientId() + "'";
                        throw new IllegalArgumentException($i$a$-require-CdrApiClient$renewClientCredential$1$3$52.toString());
                    }
                    String clientSecret = appRegistration.getClientSecret();
                    RenewClientSecretResult.Success $i$a$-require-CdrApiClient$renewClientCredential$1$3$52 = new RenewClientSecretResult.Success(((CdrApiClient)$this$renewClientCredential_u24lambda_u240).cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s(), clientSecret);
                    boolean bl6 = false;
                    CdrApiClientKt.access$getLogger$p().debug(CdrApiClient::renewClientCredential$lambda$0$2$4$0);
                    renewClientSecretResult2 = $i$a$-require-CdrApiClient$renewClientCredential$1$3$52;
                } else {
                    RenewClientSecretResult.RenewHttpErrorResponse renewHttpErrorResponse;
                    RenewClientSecretResult.RenewHttpErrorResponse result = renewHttpErrorResponse = new RenewClientSecretResult.RenewHttpErrorResponse(response.code(), response.body().string());
                    boolean bl7 = false;
                    CdrApiClientKt.access$getLogger$p().warn(() -> CdrApiClient.renewClientCredential$lambda$0$2$5$0(result));
                    CdrApiClientKt.access$getLogger$p().trace(() -> CdrApiClient.renewClientCredential$lambda$0$2$5$1(result));
                    renewClientSecretResult2 = renewHttpErrorResponse;
                }
                response = renewClientSecretResult2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            $this$renewClientCredential_u24lambda_u240 = Result.constructor-impl((Object)response);
        }
        catch (Throwable bl) {
            $this$renewClientCredential_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$renewClientCredential_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            RenewClientSecretResult it = (RenewClientSecretResult)object2;
            boolean bl = false;
            renewClientSecretResult = it;
        } else {
            Throwable t = throwable;
            boolean bl = false;
            if (t instanceof HttpServerErrorException) {
                Object it = object = new RenewClientSecretResult.RenewHttpErrorResponse(((HttpServerErrorException)t).getStatusCode(), ((HttpServerErrorException)t).getResponseBody());
                boolean bl8 = false;
                CdrApiClientKt.access$getLogger$p().warn(() -> CdrApiClient.renewClientCredential$lambda$2$0$0(t));
                CdrApiClientKt.access$getLogger$p().trace(() -> CdrApiClient.renewClientCredential$lambda$2$0$1(t));
                renewClientSecretResult = (RenewClientSecretResult)object;
            } else {
                CdrApiClientKt.access$getLogger$p().error(() -> CdrApiClient.renewClientCredential$lambda$2$1(this, t));
                String string = t.getMessage();
                if (string == null) {
                    string = "Unknown error";
                }
                renewClientSecretResult = new RenewClientSecretResult.RenewError(string, t);
            }
        }
        return renewClientSecretResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UploadDocumentResult uploadDocument(@NotNull String contentType, @NotNull Path file, @NotNull String connectorId, @NotNull CdrClientConfig.Mode mode, @NotNull String traceId) {
        UploadDocumentResult uploadDocumentResult;
        Object $this$uploadDocument_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Object object = this;
        try {
            UploadDocumentResult uploadDocumentResult2;
            $this$uploadDocument_u24lambda_u240 = object;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().debug(() -> CdrApiClient.uploadDocument$lambda$0$0(file));
            OkHttpClient okHttpClient2 = ((CdrApiClient)$this$uploadDocument_u24lambda_u240).httpClient;
            byte[] byArray = Files.readAllBytes(file);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            Closeable closeable = (Closeable)okHttpClient2.newCall(super.createPostRequest(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (okhttp3.MediaType)okhttp3.MediaType.Companion.get(contentType), (int)0, (int)0, (int)6, null), CdrApiClient.buildDocumentTargetUrl$default((CdrApiClient)$this$uploadDocument_u24lambda_u240, ((CdrApiClient)$this$uploadDocument_u24lambda_u240).cdrClientConfig.getCdrApi().getBasePath(), null, 2, null), super.buildBaseHeaders(connectorId, mode, traceId))).execute();
            Throwable throwable = null;
            try {
                UploadDocumentResult uploadDocumentResult3;
                Response response = (Response)closeable;
                boolean bl2 = false;
                if (response.isSuccessful()) {
                    UploadDocumentResult.Success success = UploadDocumentResult.Success.INSTANCE;
                    boolean bl3 = false;
                    CdrApiClientKt.access$getLogger$p().debug(() -> CdrApiClient.uploadDocument$lambda$0$1$0$0(file));
                    uploadDocumentResult3 = success;
                } else {
                    int n = response.code();
                    boolean bl4 = 400 <= n ? n < 500 : false;
                    if (bl4) {
                        UploadDocumentResult.UploadClientErrorResponse uploadClientErrorResponse;
                        UploadDocumentResult.UploadClientErrorResponse result = uploadClientErrorResponse = new UploadDocumentResult.UploadClientErrorResponse(response.code(), response.body().string());
                        boolean bl5 = false;
                        CdrApiClientKt.access$getLogger$p().info(() -> CdrApiClient.uploadDocument$lambda$0$1$1$0(file, result));
                        uploadDocumentResult3 = uploadClientErrorResponse;
                    } else {
                        UploadDocumentResult.UploadServerErrorResponse uploadServerErrorResponse;
                        UploadDocumentResult.UploadServerErrorResponse result = uploadServerErrorResponse = new UploadDocumentResult.UploadServerErrorResponse(response.code(), response.body().string());
                        boolean bl6 = false;
                        CdrApiClientKt.access$getLogger$p().info(() -> CdrApiClient.uploadDocument$lambda$0$1$2$0(file, result));
                        uploadDocumentResult3 = uploadServerErrorResponse;
                    }
                }
                uploadDocumentResult2 = uploadDocumentResult3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$uploadDocument_u24lambda_u240 = Result.constructor-impl((Object)uploadDocumentResult2);
        }
        catch (Throwable bl) {
            $this$uploadDocument_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$uploadDocument_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            UploadDocumentResult it = (UploadDocumentResult)object;
            boolean bl = false;
            uploadDocumentResult = it;
        } else {
            Throwable t = throwable;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().error(() -> CdrApiClient.uploadDocument$lambda$2$0(file, t));
            String string = t.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            uploadDocumentResult = new UploadDocumentResult.UploadError(string, t);
        }
        return uploadDocumentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DownloadDocumentResult downloadDocument(@NotNull String connectorId, @NotNull CdrClientConfig.Mode mode, @NotNull String traceId) {
        DownloadDocumentResult downloadDocumentResult;
        Object $this$downloadDocument_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Object object = this;
        try {
            DownloadDocumentResult downloadDocumentResult2;
            Object object2;
            $this$downloadDocument_u24lambda_u240 = object;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().debug(CdrApiClient::downloadDocument$lambda$0$0);
            LinkedMultiValueMap $this$downloadDocument_u24lambda_u240_u241 = object2 = new LinkedMultiValueMap();
            boolean bl2 = false;
            $this$downloadDocument_u24lambda_u240_u241.add((Object)"limit", (Object)"1");
            LinkedMultiValueMap queryParameters = object2;
            object2 = (Closeable)((CdrApiClient)$this$downloadDocument_u24lambda_u240).httpClient.newCall(super.createGetRequest(super.buildDocumentTargetUrl(((CdrApiClient)$this$downloadDocument_u24lambda_u240).cdrClientConfig.getCdrApi().getBasePath(), (MultiValueMap<String, String>)((MultiValueMap)queryParameters)), super.buildBaseHeaders(connectorId, mode, traceId))).execute();
            Throwable throwable = null;
            try {
                DownloadDocumentResult downloadDocumentResult3;
                Response response = (Response)object2;
                boolean bl3 = false;
                if (super.isNoContentFound(response)) {
                    DownloadDocumentResult.NoDocumentPending noDocumentPending = DownloadDocumentResult.NoDocumentPending.INSTANCE;
                    boolean bl4 = false;
                    CdrApiClientKt.access$getLogger$p().debug(CdrApiClient::downloadDocument$lambda$0$2$0$0);
                    downloadDocumentResult3 = noDocumentPending;
                } else if (response.isSuccessful()) {
                    Path path;
                    String string = Response.header$default((Response)response, (String)"cdr-document-uuid", null, (int)2, null);
                    if (string == null) {
                        boolean bl5 = false;
                        throw new IllegalStateException("No pull result id found in response".toString());
                    }
                    String pullResultId = string;
                    Path $this$downloadDocument_u24lambda_u240_u242_u242 = path = ((CdrApiClient)$this$downloadDocument_u24lambda_u240).cdrClientConfig.getLocalFolder-b8d0ih4().resolve(pullResultId + ".tmp");
                    boolean bl6 = false;
                    Intrinsics.checkNotNull((Object)$this$downloadDocument_u24lambda_u240_u242_u242);
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream($this$downloadDocument_u24lambda_u240_u242_u242, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    Closeable closeable = outputStream;
                    Throwable throwable2 = null;
                    try {
                        OutputStream os = (OutputStream)closeable;
                        boolean bl7 = false;
                        Closeable closeable2 = response.body().byteStream();
                        Throwable throwable3 = null;
                        try {
                            InputStream iss = (InputStream)closeable2;
                            boolean bl8 = false;
                            ByteStreamsKt.copyTo$default((InputStream)iss, (OutputStream)os, (int)0, (int)2, null);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    Path path2 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"apply(...)");
                    Path tmpFile = path2;
                    DownloadDocumentResult.DownloadSuccess bl5 = new DownloadDocumentResult.DownloadSuccess(pullResultId, tmpFile);
                    boolean bl9 = false;
                    CdrApiClientKt.access$getLogger$p().debug(CdrApiClient::downloadDocument$lambda$0$2$3$0);
                    downloadDocumentResult3 = bl5;
                } else {
                    DownloadDocumentResult.Error error;
                    DownloadDocumentResult.Error result = error = new DownloadDocumentResult.Error(response.code(), response.body().string(), null, 4, null);
                    boolean bl10 = false;
                    CdrApiClientKt.access$getLogger$p().warn(() -> CdrApiClient.downloadDocument$lambda$0$2$4$0(result));
                    downloadDocumentResult3 = error;
                }
                downloadDocumentResult2 = downloadDocumentResult3;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            $this$downloadDocument_u24lambda_u240 = Result.constructor-impl((Object)downloadDocumentResult2);
        }
        catch (Throwable bl) {
            $this$downloadDocument_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$downloadDocument_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            DownloadDocumentResult it = (DownloadDocumentResult)object;
            boolean bl = false;
            downloadDocumentResult = it;
        } else {
            Throwable t = throwable;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().error(() -> CdrApiClient.downloadDocument$lambda$2$0(t));
            String string = t.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            downloadDocumentResult = new DownloadDocumentResult.Error(null, string, t, 1, null);
        }
        return downloadDocumentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DownloadDocumentResult acknowledgeDocumentDownload(@NotNull String connectorId, @NotNull CdrClientConfig.Mode mode, @NotNull String downloadId, @NotNull String traceId) {
        DownloadDocumentResult downloadDocumentResult;
        Object $this$acknowledgeDocumentDownload_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)downloadId, (String)"downloadId");
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        Object object = this;
        try {
            DownloadDocumentResult downloadDocumentResult2;
            $this$acknowledgeDocumentDownload_u24lambda_u240 = object;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().debug(() -> CdrApiClient.acknowledgeDocumentDownload$lambda$0$0(downloadId));
            Closeable closeable = (Closeable)((CdrApiClient)$this$acknowledgeDocumentDownload_u24lambda_u240).httpClient.newCall(super.createDeleteRequest(CdrApiClient.buildDocumentTargetUrl$default((CdrApiClient)$this$acknowledgeDocumentDownload_u24lambda_u240, ((CdrApiClient)$this$acknowledgeDocumentDownload_u24lambda_u240).cdrClientConfig.getCdrApi().getBasePath() + "/" + downloadId, null, 2, null), super.buildBaseHeaders(connectorId, mode, traceId))).execute();
            Throwable throwable = null;
            try {
                DownloadDocumentResult downloadDocumentResult3;
                Response response = (Response)closeable;
                boolean bl2 = false;
                if (response.isSuccessful()) {
                    DownloadDocumentResult.AcknowledgeSuccess acknowledgeSuccess = new DownloadDocumentResult.AcknowledgeSuccess(downloadId);
                    boolean bl3 = false;
                    CdrApiClientKt.access$getLogger$p().debug(() -> CdrApiClient.acknowledgeDocumentDownload$lambda$0$1$0$0(downloadId));
                    downloadDocumentResult3 = acknowledgeSuccess;
                } else {
                    DownloadDocumentResult.Error error;
                    DownloadDocumentResult.Error result = error = new DownloadDocumentResult.Error(response.code(), response.body().string(), null, 4, null);
                    boolean bl4 = false;
                    CdrApiClientKt.access$getLogger$p().info(() -> CdrApiClient.acknowledgeDocumentDownload$lambda$0$1$1$0(downloadId, result));
                    downloadDocumentResult3 = error;
                }
                downloadDocumentResult2 = downloadDocumentResult3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$acknowledgeDocumentDownload_u24lambda_u240 = Result.constructor-impl((Object)downloadDocumentResult2);
        }
        catch (Throwable bl) {
            $this$acknowledgeDocumentDownload_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$acknowledgeDocumentDownload_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            DownloadDocumentResult it = (DownloadDocumentResult)object;
            boolean bl = false;
            downloadDocumentResult = it;
        } else {
            Throwable t = throwable;
            boolean bl = false;
            CdrApiClientKt.access$getLogger$p().error(() -> CdrApiClient.acknowledgeDocumentDownload$lambda$2$0(downloadId, t));
            String string = t.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            downloadDocumentResult = new DownloadDocumentResult.Error(null, string, t, 1, null);
        }
        return downloadDocumentResult;
    }

    private URL buildDocumentTargetUrl(String path, MultiValueMap<String, String> queryParameters) {
        URL uRL = UriComponentsBuilder.newInstance().scheme(this.cdrClientConfig.getCdrApi().getScheme()).host(this.cdrClientConfig.getCdrApi().getHost-GrDm_Do()).port(this.cdrClientConfig.getCdrApi().getPort()).path(path).queryParams(queryParameters).build().toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    static /* synthetic */ URL buildDocumentTargetUrl$default(CdrApiClient cdrApiClient, String string, MultiValueMap multiValueMap, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildDocumentTargetUrl");
        }
        if ((n & 2) != 0) {
            multiValueMap = (MultiValueMap)new LinkedMultiValueMap();
        }
        return cdrApiClient.buildDocumentTargetUrl(string, (MultiValueMap<String, String>)multiValueMap);
    }

    private URL buildClientCredentialUrl(String clientId) {
        String[] stringArray = new String[]{this.cdrClientConfig.getCredentialApi().getBasePath(), clientId};
        URL uRL = UriComponentsBuilder.newInstance().scheme(this.cdrClientConfig.getCredentialApi().getScheme()).host(this.cdrClientConfig.getCredentialApi().getHost-GrDm_Do()).port(this.cdrClientConfig.getCredentialApi().getPort()).pathSegment(stringArray).build().toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    private Headers buildBaseHeaders(String connectorId, CdrClientConfig.Mode mode, String traceId) {
        Headers.Builder $this$buildBaseHeaders_u24lambda_u240 = new Headers.Builder();
        boolean bl = false;
        $this$buildBaseHeaders_u24lambda_u240.set(CONNECTOR_ID_HEADER, connectorId);
        $this$buildBaseHeaders_u24lambda_u240.set(CDR_PROCESSING_MODE_HEADER, mode.getValue());
        $this$buildBaseHeaders_u24lambda_u240.set(AZURE_TRACE_ID_HEADER, traceId);
        String string = clientType;
        if (string == null) {
            string = "cdr-client";
        }
        $this$buildBaseHeaders_u24lambda_u240.set(CLIENT_TYPE_HEADER, string);
        String string2 = clientVersion;
        if (string2 == null) {
            string2 = "unknown";
        }
        $this$buildBaseHeaders_u24lambda_u240.set(CLIENT_VERSION_HEADER, string2);
        return $this$buildBaseHeaders_u24lambda_u240.build();
    }

    private boolean isNoContentFound(Response $this$isNoContentFound) {
        return $this$isNoContentFound.code() == HttpStatus.NO_CONTENT.value();
    }

    private Request createPostRequest(RequestBody requestBody, URL to, Headers headers) {
        return new Request.Builder().url(to).headers(headers).post(requestBody).build();
    }

    private Request createGetRequest(URL to, Headers headers) {
        return new Request.Builder().url(to).headers(headers).get().build();
    }

    private Request createDeleteRequest(URL to, Headers headers) {
        return Request.Builder.delete$default((Request.Builder)new Request.Builder().url(to).headers(headers), null, (int)1, null).build();
    }

    private static final Object renewClientCredential$lambda$0$0() {
        return "Renewing client secret";
    }

    /*
     * WARNING - void declaration
     */
    private static final Response renewClientCredential$lambda$0$1(CdrApiClient $this_runCatching, String $traceId, RetryContext retry) {
        void $this$renewClientCredential_u24lambda_u240_u241_u242;
        Intrinsics.checkNotNullParameter((Object)retry, (String)"retry");
        if (retry.getRetryCount() > 0) {
            CdrApiClientKt.access$getLogger$p().debug(() -> CdrApiClient.renewClientCredential$lambda$0$1$0($this_runCatching, retry));
            CdrApiClientKt.access$getLogger$p().info(() -> CdrApiClient.renewClientCredential$lambda$0$1$1(retry, $this_runCatching));
        }
        Headers.Builder builder = new Headers.Builder();
        Request.Builder builder2 = new Request.Builder().url($this_runCatching.buildClientCredentialUrl($this_runCatching.cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s()));
        OkHttpClient okHttpClient2 = $this_runCatching.httpClient;
        boolean bl = false;
        $this$renewClientCredential_u24lambda_u240_u241_u242.set(AZURE_TRACE_ID_HEADER, $traceId);
        Headers headers = $this$renewClientCredential_u24lambda_u240_u241_u242.build();
        return okHttpClient2.newCall(builder2.headers(headers).patch(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])new byte[0], null, (int)0, (int)0, (int)7, null)).build()).execute();
    }

    /*
     * WARNING - void declaration
     */
    private static final Object renewClientCredential$lambda$0$1$0(CdrApiClient $this_runCatching, RetryContext $retry) {
        Class<?> clazz;
        URL uRL = $this_runCatching.buildClientCredentialUrl($this_runCatching.cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s());
        Throwable throwable = $retry.getLastThrowable();
        if (throwable != null) {
            void it;
            Throwable throwable2 = throwable;
            URL uRL2 = uRL;
            boolean bl = false;
            clazz = UtilKt.getRootestCause((Throwable)it).getClass();
            uRL = uRL2;
        } else {
            clazz = null;
        }
        Throwable throwable3 = $retry.getLastThrowable();
        return "Operation targeting '" + uRL + "' has failed; exception: '" + clazz + "'; message: '" + (throwable3 != null ? throwable3.getMessage() : null) + "'";
    }

    private static final Object renewClientCredential$lambda$0$1$1(RetryContext $retry, CdrApiClient $this_runCatching) {
        return "Retry attempt '#" + $retry.getRetryCount() + "' of 'renew client credential' operation targeting '" + $this_runCatching.buildClientCredentialUrl($this_runCatching.cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s()) + "'";
    }

    private static final Object renewClientCredential$lambda$0$2$2$0(String $warning) {
        return "Client secret renewal server-side warning: '" + $warning + "'";
    }

    private static final Object renewClientCredential$lambda$0$2$4$0() {
        return "Renewing client secret done";
    }

    private static final Object renewClientCredential$lambda$0$2$5$0(RenewClientSecretResult.RenewHttpErrorResponse $result) {
        return "Renewing client secret encountered client error; status code: '" + $result.getCode() + "'";
    }

    private static final Object renewClientCredential$lambda$0$2$5$1(RenewClientSecretResult.RenewHttpErrorResponse $result) {
        return "Response body: '" + $result.getResponseBody() + "'";
    }

    private static final Object renewClientCredential$lambda$2$0$0(Throwable $t) {
        return "Renewing client secret encountered server error; status code: '" + ((HttpServerErrorException)$t).getStatusCode() + "'";
    }

    private static final Object renewClientCredential$lambda$2$0$1(Throwable $t) {
        return "Response body: '" + ((HttpServerErrorException)$t).getResponseBody() + "'";
    }

    private static final Object renewClientCredential$lambda$2$1(CdrApiClient this$0, Throwable $t) {
        return "Renewing client secret for client id '" + ClientId.toString-impl(this$0.cdrClientConfig.getIdpCredentials().getClientId-uOZoI7s()) + "' failed: '" + $t + "'";
    }

    private static final Object uploadDocument$lambda$0$0(Path $file) {
        return "Upload '" + $file + "' start";
    }

    private static final Object uploadDocument$lambda$0$1$0$0(Path $file) {
        return "Upload '" + $file + "' done";
    }

    private static final Object uploadDocument$lambda$0$1$1$0(Path $file, UploadDocumentResult.UploadClientErrorResponse $result) {
        return "Upload '" + $file + "' encountered client error: '" + $result + "'";
    }

    private static final Object uploadDocument$lambda$0$1$2$0(Path $file, UploadDocumentResult.UploadServerErrorResponse $result) {
        return "Upload '" + $file + "' encountered server error: '" + $result + "'";
    }

    private static final Object uploadDocument$lambda$2$0(Path $file, Throwable $t) {
        return "Upload file '" + $file + "' failed: " + $t.getMessage();
    }

    private static final Object downloadDocument$lambda$0$0() {
        return "Request file start";
    }

    private static final Object downloadDocument$lambda$0$2$0$0() {
        return "Request file done - no document pending";
    }

    private static final Object downloadDocument$lambda$0$2$3$0() {
        return "Request file done - file stream opened";
    }

    private static final Object downloadDocument$lambda$0$2$4$0(DownloadDocumentResult.Error $result) {
        return "Request file encountered error: '" + $result + "'";
    }

    private static final Object downloadDocument$lambda$2$0(Throwable $t) {
        return "Request file failed: " + $t;
    }

    private static final Object acknowledgeDocumentDownload$lambda$0$0(String $downloadId) {
        return "Acknowledging pulled file with id '" + $downloadId + "' start";
    }

    private static final Object acknowledgeDocumentDownload$lambda$0$1$0$0(String $downloadId) {
        return "Pulled file with id '" + $downloadId + "' acknowledged";
    }

    private static final Object acknowledgeDocumentDownload$lambda$0$1$1$0(String $downloadId, DownloadDocumentResult.Error $result) {
        return "Acknowledging pulled file with id '" + $downloadId + "' encountered a http error: '" + $result + "'";
    }

    private static final Object acknowledgeDocumentDownload$lambda$2$0(String $downloadId, Throwable $t) {
        return "Acknowledging pulled file with id '" + $downloadId + "' failed: '" + $t + "'";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003JU\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$CdrClientAppRegistrationDto;", "", "id", "", "displayName", "clientId", "clientSecret", "notOnOrAfter", "orgId", "warnings", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getId", "()Ljava/lang/String;", "getDisplayName", "getClientId", "getClientSecret", "getNotOnOrAfter", "getOrgId", "getWarnings", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "cdr-client-service"})
    public static final class CdrClientAppRegistrationDto {
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        @NotNull
        private final String clientId;
        @NotNull
        private final String clientSecret;
        @NotNull
        private final String notOnOrAfter;
        @NotNull
        private final String orgId;
        @NotNull
        private final List<String> warnings;

        public CdrClientAppRegistrationDto(@NotNull String id, @NotNull String displayName, @NotNull String clientId, @NotNull String clientSecret, @NotNull String notOnOrAfter, @NotNull String orgId, @NotNull List<String> warnings) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)notOnOrAfter, (String)"notOnOrAfter");
            Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
            Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
            this.id = id;
            this.displayName = displayName;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.notOnOrAfter = notOnOrAfter;
            this.orgId = orgId;
            this.warnings = warnings;
        }

        public /* synthetic */ CdrClientAppRegistrationDto(String string, String string2, String string3, String string4, String string5, String string6, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            if ((n & 0x10) != 0) {
                string5 = "";
            }
            if ((n & 0x20) != 0) {
                string6 = "";
            }
            if ((n & 0x40) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, string2, string3, string4, string5, string6, list);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public final String getNotOnOrAfter() {
            return this.notOnOrAfter;
        }

        @NotNull
        public final String getOrgId() {
            return this.orgId;
        }

        @NotNull
        public final List<String> getWarnings() {
            return this.warnings;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.displayName;
        }

        @NotNull
        public final String component3() {
            return this.clientId;
        }

        @NotNull
        public final String component4() {
            return this.clientSecret;
        }

        @NotNull
        public final String component5() {
            return this.notOnOrAfter;
        }

        @NotNull
        public final String component6() {
            return this.orgId;
        }

        @NotNull
        public final List<String> component7() {
            return this.warnings;
        }

        @NotNull
        public final CdrClientAppRegistrationDto copy(@NotNull String id, @NotNull String displayName, @NotNull String clientId, @NotNull String clientSecret, @NotNull String notOnOrAfter, @NotNull String orgId, @NotNull List<String> warnings) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)notOnOrAfter, (String)"notOnOrAfter");
            Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
            Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
            return new CdrClientAppRegistrationDto(id, displayName, clientId, clientSecret, notOnOrAfter, orgId, warnings);
        }

        public static /* synthetic */ CdrClientAppRegistrationDto copy$default(CdrClientAppRegistrationDto cdrClientAppRegistrationDto, String string, String string2, String string3, String string4, String string5, String string6, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = cdrClientAppRegistrationDto.id;
            }
            if ((n & 2) != 0) {
                string2 = cdrClientAppRegistrationDto.displayName;
            }
            if ((n & 4) != 0) {
                string3 = cdrClientAppRegistrationDto.clientId;
            }
            if ((n & 8) != 0) {
                string4 = cdrClientAppRegistrationDto.clientSecret;
            }
            if ((n & 0x10) != 0) {
                string5 = cdrClientAppRegistrationDto.notOnOrAfter;
            }
            if ((n & 0x20) != 0) {
                string6 = cdrClientAppRegistrationDto.orgId;
            }
            if ((n & 0x40) != 0) {
                list = cdrClientAppRegistrationDto.warnings;
            }
            return cdrClientAppRegistrationDto.copy(string, string2, string3, string4, string5, string6, list);
        }

        @NotNull
        public String toString() {
            return "CdrClientAppRegistrationDto(id=" + this.id + ", displayName=" + this.displayName + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", notOnOrAfter=" + this.notOnOrAfter + ", orgId=" + this.orgId + ", warnings=" + this.warnings + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.displayName.hashCode();
            result = result * 31 + this.clientId.hashCode();
            result = result * 31 + this.clientSecret.hashCode();
            result = result * 31 + this.notOnOrAfter.hashCode();
            result = result * 31 + this.orgId.hashCode();
            result = result * 31 + ((Object)this.warnings).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CdrClientAppRegistrationDto)) {
                return false;
            }
            CdrClientAppRegistrationDto cdrClientAppRegistrationDto = (CdrClientAppRegistrationDto)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)cdrClientAppRegistrationDto.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)cdrClientAppRegistrationDto.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)cdrClientAppRegistrationDto.clientId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)cdrClientAppRegistrationDto.clientSecret)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.notOnOrAfter, (Object)cdrClientAppRegistrationDto.notOnOrAfter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.orgId, (Object)cdrClientAppRegistrationDto.orgId)) {
                return false;
            }
            return Intrinsics.areEqual(this.warnings, cdrClientAppRegistrationDto.warnings);
        }

        public CdrClientAppRegistrationDto() {
            this(null, null, null, null, null, null, null, 127, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$Companion;", "", "<init>", "()V", "CONNECTOR_ID_HEADER", "", "CDR_PROCESSING_MODE_HEADER", "AZURE_TRACE_ID_HEADER", "CLIENT_TYPE_HEADER", "CLIENT_VERSION_HEADER", "clientType", "getClientType", "()Ljava/lang/String;", "clientVersion", "getClientVersion", "cdr-client-service"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getClientType() {
            return clientType;
        }

        @Nullable
        public final String getClientVersion() {
            return clientVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult;", "", "NoDocumentPending", "Success", "DownloadSuccess", "AcknowledgeSuccess", "Error", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Error;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$NoDocumentPending;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Success;", "cdr-client-service"})
    public static sealed interface DownloadDocumentResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$AcknowledgeSuccess;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Success;", "pullResultId", "", "<init>", "(Ljava/lang/String;)V", "getPullResultId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class AcknowledgeSuccess
        extends Success {
            @NotNull
            private final String pullResultId;

            public AcknowledgeSuccess(@NotNull String pullResultId) {
                Intrinsics.checkNotNullParameter((Object)pullResultId, (String)"pullResultId");
                super(null);
                this.pullResultId = pullResultId;
            }

            @NotNull
            public final String getPullResultId() {
                return this.pullResultId;
            }

            @NotNull
            public final String component1() {
                return this.pullResultId;
            }

            @NotNull
            public final AcknowledgeSuccess copy(@NotNull String pullResultId) {
                Intrinsics.checkNotNullParameter((Object)pullResultId, (String)"pullResultId");
                return new AcknowledgeSuccess(pullResultId);
            }

            public static /* synthetic */ AcknowledgeSuccess copy$default(AcknowledgeSuccess acknowledgeSuccess, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = acknowledgeSuccess.pullResultId;
                }
                return acknowledgeSuccess.copy(string);
            }

            @NotNull
            public String toString() {
                return "AcknowledgeSuccess(pullResultId=" + this.pullResultId + ")";
            }

            public int hashCode() {
                return this.pullResultId.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AcknowledgeSuccess)) {
                    return false;
                }
                AcknowledgeSuccess acknowledgeSuccess = (AcknowledgeSuccess)other;
                return Intrinsics.areEqual((Object)this.pullResultId, (Object)acknowledgeSuccess.pullResultId);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$DownloadSuccess;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Success;", "pullResultId", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getPullResultId", "()Ljava/lang/String;", "getFile", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class DownloadSuccess
        extends Success {
            @NotNull
            private final String pullResultId;
            @NotNull
            private final Path file;

            public DownloadSuccess(@NotNull String pullResultId, @NotNull Path file) {
                Intrinsics.checkNotNullParameter((Object)pullResultId, (String)"pullResultId");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                super(null);
                this.pullResultId = pullResultId;
                this.file = file;
            }

            @NotNull
            public final String getPullResultId() {
                return this.pullResultId;
            }

            @NotNull
            public final Path getFile() {
                return this.file;
            }

            @NotNull
            public final String component1() {
                return this.pullResultId;
            }

            @NotNull
            public final Path component2() {
                return this.file;
            }

            @NotNull
            public final DownloadSuccess copy(@NotNull String pullResultId, @NotNull Path file) {
                Intrinsics.checkNotNullParameter((Object)pullResultId, (String)"pullResultId");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new DownloadSuccess(pullResultId, file);
            }

            public static /* synthetic */ DownloadSuccess copy$default(DownloadSuccess downloadSuccess, String string, Path path, int n, Object object) {
                if ((n & 1) != 0) {
                    string = downloadSuccess.pullResultId;
                }
                if ((n & 2) != 0) {
                    path = downloadSuccess.file;
                }
                return downloadSuccess.copy(string, path);
            }

            @NotNull
            public String toString() {
                return "DownloadSuccess(pullResultId=" + this.pullResultId + ", file=" + this.file + ")";
            }

            public int hashCode() {
                int result = this.pullResultId.hashCode();
                result = result * 31 + ((Object)this.file).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DownloadSuccess)) {
                    return false;
                }
                DownloadSuccess downloadSuccess = (DownloadSuccess)other;
                if (!Intrinsics.areEqual((Object)this.pullResultId, (Object)downloadSuccess.pullResultId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.file, (Object)downloadSuccess.file);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J0\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Error;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult;", "code", "", "message", "", "t", "", "<init>", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Throwable;)V", "getCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMessage", "()Ljava/lang/String;", "getT", "()Ljava/lang/Throwable;", "component1", "component2", "component3", "copy", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Throwable;)Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Error;", "equals", "", "other", "", "hashCode", "toString", "cdr-client-service"})
        public static final class Error
        implements DownloadDocumentResult {
            @Nullable
            private final Integer code;
            @NotNull
            private final String message;
            @Nullable
            private final Throwable t;

            public Error(@Nullable Integer code, @NotNull String message, @Nullable Throwable t) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.code = code;
                this.message = message;
                this.t = t;
            }

            public /* synthetic */ Error(Integer n, String string, Throwable throwable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 1) != 0) {
                    n = null;
                }
                if ((n2 & 4) != 0) {
                    throwable = null;
                }
                this(n, string, throwable);
            }

            @Nullable
            public final Integer getCode() {
                return this.code;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @Nullable
            public final Throwable getT() {
                return this.t;
            }

            @Nullable
            public final Integer component1() {
                return this.code;
            }

            @NotNull
            public final String component2() {
                return this.message;
            }

            @Nullable
            public final Throwable component3() {
                return this.t;
            }

            @NotNull
            public final Error copy(@Nullable Integer code, @NotNull String message, @Nullable Throwable t) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(code, message, t);
            }

            public static /* synthetic */ Error copy$default(Error error, Integer n, String string, Throwable throwable, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = error.code;
                }
                if ((n2 & 2) != 0) {
                    string = error.message;
                }
                if ((n2 & 4) != 0) {
                    throwable = error.t;
                }
                return error.copy(n, string, throwable);
            }

            @NotNull
            public String toString() {
                return "Error(code=" + this.code + ", message=" + this.message + ", t=" + this.t + ")";
            }

            public int hashCode() {
                int result = this.code == null ? 0 : ((Object)this.code).hashCode();
                result = result * 31 + this.message.hashCode();
                result = result * 31 + (this.t == null ? 0 : this.t.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                if (!Intrinsics.areEqual((Object)this.code, (Object)error.code)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.message, (Object)error.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.t, (Object)error.t);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$NoDocumentPending;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult;", "<init>", "()V", "cdr-client-service"})
        public static final class NoDocumentPending
        implements DownloadDocumentResult {
            @NotNull
            public static final NoDocumentPending INSTANCE = new NoDocumentPending();

            private NoDocumentPending() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$Success;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult;", "<init>", "()V", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$AcknowledgeSuccess;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult$DownloadSuccess;", "cdr-client-service"})
        public static abstract sealed class Success
        implements DownloadDocumentResult
        permits AcknowledgeSuccess, DownloadSuccess {
            private Success() {
            }

            public /* synthetic */ Success(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult;", "", "Success", "RenewHttpErrorResponse", "RenewError", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult$RenewError;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult$RenewHttpErrorResponse;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult$Success;", "cdr-client-service"})
    public static sealed interface RenewClientSecretResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult$RenewError;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getMessage", "()Ljava/lang/String;", "getCause", "()Ljava/lang/Throwable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class RenewError
        implements RenewClientSecretResult {
            @NotNull
            private final String message;
            @NotNull
            private final Throwable cause;

            public RenewError(@NotNull String message, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.message = message;
                this.cause = cause;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final Throwable getCause() {
                return this.cause;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Throwable component2() {
                return this.cause;
            }

            @NotNull
            public final RenewError copy(@NotNull String message, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                return new RenewError(message, cause);
            }

            public static /* synthetic */ RenewError copy$default(RenewError renewError, String string, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    string = renewError.message;
                }
                if ((n & 2) != 0) {
                    throwable = renewError.cause;
                }
                return renewError.copy(string, throwable);
            }

            @NotNull
            public String toString() {
                return "RenewError(message=" + this.message + ", cause=" + this.cause + ")";
            }

            public int hashCode() {
                int result = this.message.hashCode();
                result = result * 31 + this.cause.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RenewError)) {
                    return false;
                }
                RenewError renewError = (RenewError)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)renewError.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cause, (Object)renewError.cause);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult$RenewHttpErrorResponse;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult;", "code", "", "responseBody", "", "<init>", "(ILjava/lang/String;)V", "getCode", "()I", "getResponseBody", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "cdr-client-service"})
        public static final class RenewHttpErrorResponse
        implements RenewClientSecretResult {
            private final int code;
            @NotNull
            private final String responseBody;

            public RenewHttpErrorResponse(int code, @NotNull String responseBody) {
                Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
                this.code = code;
                this.responseBody = responseBody;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final String getResponseBody() {
                return this.responseBody;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final String component2() {
                return this.responseBody;
            }

            @NotNull
            public final RenewHttpErrorResponse copy(int code, @NotNull String responseBody) {
                Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
                return new RenewHttpErrorResponse(code, responseBody);
            }

            public static /* synthetic */ RenewHttpErrorResponse copy$default(RenewHttpErrorResponse renewHttpErrorResponse, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = renewHttpErrorResponse.code;
                }
                if ((n2 & 2) != 0) {
                    string = renewHttpErrorResponse.responseBody;
                }
                return renewHttpErrorResponse.copy(n, string);
            }

            @NotNull
            public String toString() {
                return "RenewHttpErrorResponse(code=" + this.code + ", responseBody=" + this.responseBody + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.code);
                result = result * 31 + this.responseBody.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RenewHttpErrorResponse)) {
                    return false;
                }
                RenewHttpErrorResponse renewHttpErrorResponse = (RenewHttpErrorResponse)other;
                if (this.code != renewHttpErrorResponse.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.responseBody, (Object)renewHttpErrorResponse.responseBody);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult$Success;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$RenewClientSecretResult;", "clientId", "", "clientSecret", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "getClientSecret", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class Success
        implements RenewClientSecretResult {
            @NotNull
            private final String clientId;
            @NotNull
            private final String clientSecret;

            public Success(@NotNull String clientId, @NotNull String clientSecret) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                this.clientId = clientId;
                this.clientSecret = clientSecret;
            }

            @NotNull
            public final String getClientId() {
                return this.clientId;
            }

            @NotNull
            public final String getClientSecret() {
                return this.clientSecret;
            }

            @NotNull
            public final String component1() {
                return this.clientId;
            }

            @NotNull
            public final String component2() {
                return this.clientSecret;
            }

            @NotNull
            public final Success copy(@NotNull String clientId, @NotNull String clientSecret) {
                Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                return new Success(clientId, clientSecret);
            }

            public static /* synthetic */ Success copy$default(Success success, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = success.clientId;
                }
                if ((n & 2) != 0) {
                    string2 = success.clientSecret;
                }
                return success.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Success(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ")";
            }

            public int hashCode() {
                int result = this.clientId.hashCode();
                result = result * 31 + this.clientSecret.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.clientId, (Object)success.clientId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.clientSecret, (Object)success.clientSecret);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult;", "", "Success", "UploadClientErrorResponse", "UploadServerErrorResponse", "UploadError", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$Success;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$UploadClientErrorResponse;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$UploadError;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$UploadServerErrorResponse;", "cdr-client-service"})
    public static sealed interface UploadDocumentResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$Success;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult;", "<init>", "()V", "cdr-client-service"})
        public static final class Success
        implements UploadDocumentResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$UploadClientErrorResponse;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult;", "code", "", "responseBody", "", "<init>", "(ILjava/lang/String;)V", "getCode", "()I", "getResponseBody", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "cdr-client-service"})
        public static final class UploadClientErrorResponse
        implements UploadDocumentResult {
            private final int code;
            @NotNull
            private final String responseBody;

            public UploadClientErrorResponse(int code, @NotNull String responseBody) {
                Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
                this.code = code;
                this.responseBody = responseBody;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final String getResponseBody() {
                return this.responseBody;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final String component2() {
                return this.responseBody;
            }

            @NotNull
            public final UploadClientErrorResponse copy(int code, @NotNull String responseBody) {
                Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
                return new UploadClientErrorResponse(code, responseBody);
            }

            public static /* synthetic */ UploadClientErrorResponse copy$default(UploadClientErrorResponse uploadClientErrorResponse, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = uploadClientErrorResponse.code;
                }
                if ((n2 & 2) != 0) {
                    string = uploadClientErrorResponse.responseBody;
                }
                return uploadClientErrorResponse.copy(n, string);
            }

            @NotNull
            public String toString() {
                return "UploadClientErrorResponse(code=" + this.code + ", responseBody=" + this.responseBody + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.code);
                result = result * 31 + this.responseBody.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UploadClientErrorResponse)) {
                    return false;
                }
                UploadClientErrorResponse uploadClientErrorResponse = (UploadClientErrorResponse)other;
                if (this.code != uploadClientErrorResponse.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.responseBody, (Object)uploadClientErrorResponse.responseBody);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$UploadError;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult;", "message", "", "t", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getMessage", "()Ljava/lang/String;", "getT", "()Ljava/lang/Throwable;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class UploadError
        implements UploadDocumentResult {
            @NotNull
            private final String message;
            @Nullable
            private final Throwable t;

            public UploadError(@NotNull String message, @Nullable Throwable t) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message = message;
                this.t = t;
            }

            public /* synthetic */ UploadError(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    throwable = null;
                }
                this(string, throwable);
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @Nullable
            public final Throwable getT() {
                return this.t;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @Nullable
            public final Throwable component2() {
                return this.t;
            }

            @NotNull
            public final UploadError copy(@NotNull String message, @Nullable Throwable t) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new UploadError(message, t);
            }

            public static /* synthetic */ UploadError copy$default(UploadError uploadError, String string, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    string = uploadError.message;
                }
                if ((n & 2) != 0) {
                    throwable = uploadError.t;
                }
                return uploadError.copy(string, throwable);
            }

            @NotNull
            public String toString() {
                return "UploadError(message=" + this.message + ", t=" + this.t + ")";
            }

            public int hashCode() {
                int result = this.message.hashCode();
                result = result * 31 + (this.t == null ? 0 : this.t.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UploadError)) {
                    return false;
                }
                UploadError uploadError = (UploadError)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)uploadError.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.t, (Object)uploadError.t);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult$UploadServerErrorResponse;", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$UploadDocumentResult;", "code", "", "responseBody", "", "<init>", "(ILjava/lang/String;)V", "getCode", "()I", "getResponseBody", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "cdr-client-service"})
        public static final class UploadServerErrorResponse
        implements UploadDocumentResult {
            private final int code;
            @NotNull
            private final String responseBody;

            public UploadServerErrorResponse(int code, @NotNull String responseBody) {
                Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
                this.code = code;
                this.responseBody = responseBody;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final String getResponseBody() {
                return this.responseBody;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final String component2() {
                return this.responseBody;
            }

            @NotNull
            public final UploadServerErrorResponse copy(int code, @NotNull String responseBody) {
                Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
                return new UploadServerErrorResponse(code, responseBody);
            }

            public static /* synthetic */ UploadServerErrorResponse copy$default(UploadServerErrorResponse uploadServerErrorResponse, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = uploadServerErrorResponse.code;
                }
                if ((n2 & 2) != 0) {
                    string = uploadServerErrorResponse.responseBody;
                }
                return uploadServerErrorResponse.copy(n, string);
            }

            @NotNull
            public String toString() {
                return "UploadServerErrorResponse(code=" + this.code + ", responseBody=" + this.responseBody + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.code);
                result = result * 31 + this.responseBody.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UploadServerErrorResponse)) {
                    return false;
                }
                UploadServerErrorResponse uploadServerErrorResponse = (UploadServerErrorResponse)other;
                if (this.code != uploadServerErrorResponse.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.responseBody, (Object)uploadServerErrorResponse.responseBody);
            }
        }
    }
}

