/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.ClientSecret;
import com.swisscom.health.des.cdr.client.config.IdpCredentials;
import com.swisscom.health.des.cdr.client.config.LastCredentialRenewalTime;
import com.swisscom.health.des.cdr.client.handler.CdrApiClient;
import com.swisscom.health.des.cdr.client.handler.ClientSecretRenewalServiceKt;
import com.swisscom.health.des.cdr.client.handler.ConfigurationWriter;
import io.micrometer.tracing.Tracer;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0011\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0011H\u0012J\b\u0010\u0014\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService;", "", "config", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "configurationWriter", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;", "cdrApiClient", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;", "tracer", "Lio/micrometer/tracing/Tracer;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;Lio/micrometer/tracing/Tracer;)V", "renewClientSecret", "Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult;", "ensureConfigItemIsWritable", "", "property", "", "writeNewSecret", "secret", "getNewSecret", "RenewClientSecretResult", "Companion", "cdr-client-service"})
public class ClientSecretRenewalService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CdrClientConfig config;
    @NotNull
    private final ConfigurationWriter configurationWriter;
    @NotNull
    private final CdrApiClient cdrApiClient;
    @NotNull
    private final Tracer tracer;
    @NotNull
    public static final String CLIENT_PROPERTY = "client";
    @NotNull
    public static final String IDP_CREDENTIALS_PROPERTY = "idp-credentials";
    @NotNull
    public static final String CLIENT_SECRET_PROPERTY = "client-secret";
    @NotNull
    public static final String CLIENT_SECRET_LAST_UPDATE_PROPERTY = "last-credential-renewal-time";
    @NotNull
    public static final String CLIENT_SECRET_PROPERTY_PATH = "client.idp-credentials.client-secret";
    @NotNull
    public static final String CLIENT_SECRET_LAST_UPDATE_PROPERTY_PATH = "client.idp-credentials.last-credential-renewal-time";

    public ClientSecretRenewalService(@NotNull CdrClientConfig config, @NotNull ConfigurationWriter configurationWriter, @NotNull CdrApiClient cdrApiClient, @NotNull Tracer tracer) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)configurationWriter, (String)"configurationWriter");
        Intrinsics.checkNotNullParameter((Object)cdrApiClient, (String)"cdrApiClient");
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        this.config = config;
        this.configurationWriter = configurationWriter;
        this.cdrApiClient = cdrApiClient;
        this.tracer = tracer;
    }

    @NotNull
    public RenewClientSecretResult renewClientSecret() {
        RenewClientSecretResult renewClientSecretResult;
        Object $this$renewClientSecret_u24lambda_u240;
        Object object = this;
        try {
            $this$renewClientSecret_u24lambda_u240 = object;
            boolean bl = false;
            boolean secretIsWritable = super.ensureConfigItemIsWritable(CLIENT_SECRET_PROPERTY_PATH);
            boolean timestampIsWritable = super.ensureConfigItemIsWritable(CLIENT_SECRET_LAST_UPDATE_PROPERTY_PATH);
            $this$renewClientSecret_u24lambda_u240 = Result.constructor-impl((Object)(secretIsWritable && timestampIsWritable ? super.writeNewSecret(super.getNewSecret()) : (RenewClientSecretResult)RenewClientSecretResult.Failure.INSTANCE));
        }
        catch (Throwable bl) {
            $this$renewClientSecret_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$renewClientSecret_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            RenewClientSecretResult it = (RenewClientSecretResult)object;
            boolean bl = false;
            renewClientSecretResult = it;
        } else {
            RenewClientSecretResult.Failure failure;
            Throwable error = throwable;
            boolean bl = false;
            RenewClientSecretResult.Failure it = failure = RenewClientSecretResult.Failure.INSTANCE;
            boolean bl2 = false;
            ClientSecretRenewalServiceKt.access$getLogger$p().error(error, () -> ClientSecretRenewalService.renewClientSecret$lambda$2$0$0(error));
            renewClientSecretResult = failure;
        }
        return renewClientSecretResult;
    }

    private boolean ensureConfigItemIsWritable(String property) {
        boolean bl;
        ConfigurationWriter.ConfigLookupResult configLookupResult = this.configurationWriter.isWritableConfigurationItem(property);
        if (configLookupResult instanceof ConfigurationWriter.ConfigLookupResult.Writable) {
            bl = true;
        } else if (configLookupResult instanceof ConfigurationWriter.ConfigLookupResult.NotFound) {
            boolean bl2;
            boolean it = bl2 = false;
            boolean bl3 = false;
            ClientSecretRenewalServiceKt.access$getLogger$p().info(() -> ClientSecretRenewalService.ensureConfigItemIsWritable$lambda$0$0(property));
            bl = bl2;
        } else if (configLookupResult instanceof ConfigurationWriter.ConfigLookupResult.NotWritable) {
            boolean bl4;
            boolean it = bl4 = false;
            boolean bl5 = false;
            ClientSecretRenewalServiceKt.access$getLogger$p().info(() -> ClientSecretRenewalService.ensureConfigItemIsWritable$lambda$1$0(property));
            bl = bl4;
        } else if (configLookupResult instanceof ConfigurationWriter.ConfigLookupResult.Ambiguous) {
            boolean bl6;
            boolean it = bl6 = false;
            boolean bl7 = false;
            ClientSecretRenewalServiceKt.access$getLogger$p().info(() -> ClientSecretRenewalService.ensureConfigItemIsWritable$lambda$2$0(property));
            bl = bl6;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private RenewClientSecretResult writeNewSecret(String secret) {
        RenewClientSecretResult renewClientSecretResult;
        IdpCredentials idpCredentials = this.config.getIdpCredentials();
        String string = ClientSecret.constructor-impl(secret);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        IdpCredentials newIdpCredentials = IdpCredentials.copy-G9X303Q$default(idpCredentials, null, null, string, null, false, null, LastCredentialRenewalTime.constructor-impl(instant), 59, null);
        CdrClientConfig newCdrConfig = CdrClientConfig.copy-gWPMQoA$default(this.config, false, null, null, null, newIdpCredentials, null, null, 0, 0, null, null, null, null, null, null, null, 65519, null);
        ConfigurationWriter.UpdateResult updateResult = this.configurationWriter.updateClientServiceConfiguration(newCdrConfig);
        boolean bl = false;
        ConfigurationWriter.UpdateResult updateResult2 = updateResult;
        if (updateResult2 instanceof ConfigurationWriter.UpdateResult.Failure) {
            RenewClientSecretResult.Failure failure;
            RenewClientSecretResult.Failure it = failure = RenewClientSecretResult.Failure.INSTANCE;
            boolean bl2 = false;
            ClientSecretRenewalServiceKt.access$getLogger$p().error(() -> ClientSecretRenewalService.writeNewSecret$lambda$0$0$0(updateResult));
            renewClientSecretResult = failure;
        } else if (updateResult2 instanceof ConfigurationWriter.UpdateResult.Success) {
            renewClientSecretResult = RenewClientSecretResult.Success.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return renewClientSecretResult;
    }

    private String getNewSecret() {
        Object object = this.tracer.currentSpan();
        if (object == null || (object = object.context()) == null || (object = object.traceId()) == null) {
            object = "";
        }
        CdrApiClient.RenewClientSecretResult $this$getNewSecret_u24lambda_u240 = this.cdrApiClient.renewClientCredential((String)object);
        boolean bl = false;
        CdrApiClient.RenewClientSecretResult renewClientSecretResult = $this$getNewSecret_u24lambda_u240;
        if (!(renewClientSecretResult instanceof CdrApiClient.RenewClientSecretResult.Success)) {
            if (renewClientSecretResult instanceof CdrApiClient.RenewClientSecretResult.RenewHttpErrorResponse) {
                throw new IllegalStateException(("http error; status code: " + ((CdrApiClient.RenewClientSecretResult.RenewHttpErrorResponse)$this$getNewSecret_u24lambda_u240).getCode()).toString());
            }
            if (renewClientSecretResult instanceof CdrApiClient.RenewClientSecretResult.RenewError) {
                throw ((CdrApiClient.RenewClientSecretResult.RenewError)$this$getNewSecret_u24lambda_u240).getCause();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((CdrApiClient.RenewClientSecretResult.Success)$this$getNewSecret_u24lambda_u240).getClientSecret();
    }

    private static final Object renewClientSecret$lambda$2$0$0(Throwable $error) {
        return "Exception while trying to renew secret: " + $error;
    }

    private static final Object ensureConfigItemIsWritable$lambda$0$0(String $property) {
        return "No updatable configuration item found with property path '" + $property + "'";
    }

    private static final Object ensureConfigItemIsWritable$lambda$1$0(String $property) {
        return "Configuration item with property path '" + $property + "' is not sourced from a writable resource.'";
    }

    private static final Object ensureConfigItemIsWritable$lambda$2$0(String $property) {
        return "Configuration item with property path '" + $property + "' has multiple origins.'";
    }

    private static final Object writeNewSecret$lambda$0$0$0(ConfigurationWriter.UpdateResult $updateResult) {
        return "Failed to update client service configuration with new client secret: '" + ((ConfigurationWriter.UpdateResult.Failure)$updateResult).getErrors() + "'\nYour previous secret has already been expired. You must create a new secret on the CDR Website and then set the retrieved secret value via the 'CDR Client Admin' app.";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$Companion;", "", "<init>", "()V", "CLIENT_PROPERTY", "", "IDP_CREDENTIALS_PROPERTY", "CLIENT_SECRET_PROPERTY", "CLIENT_SECRET_LAST_UPDATE_PROPERTY", "CLIENT_SECRET_PROPERTY_PATH", "CLIENT_SECRET_LAST_UPDATE_PROPERTY_PATH", "cdr-client-service"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult;", "", "Success", "Failure", "Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult$Failure;", "Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult$Success;", "cdr-client-service"})
    public static sealed interface RenewClientSecretResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult$Failure;", "Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult;", "<init>", "()V", "cdr-client-service"})
        public static final class Failure
        implements RenewClientSecretResult {
            @NotNull
            public static final Failure INSTANCE = new Failure();

            private Failure() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult$Success;", "Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService$RenewClientSecretResult;", "<init>", "()V", "cdr-client-service"})
        public static final class Success
        implements RenewClientSecretResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
            }
        }
    }
}

