/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.swisscom.health.des.cdr.client.common.DTOs;
import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.ConfigConverterKt;
import com.swisscom.health.des.cdr.client.config.PropertyNameAware;
import com.swisscom.health.des.cdr.client.handler.ConfigValidationService;
import com.swisscom.health.des.cdr.client.handler.ConfigurationWriterKt;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.unit.DataSize;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0011\u0018\u00002\u00020\u0001:\u000534567B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0001H\u0012J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0010\u00a2\u0006\u0002\b\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\u0006\u0010\f\u001a\u00020\rH\u0012J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0012J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0003H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u0004\u0018\u00010)*\u00020!8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u0004\u0018\u00010\u001e*\u00020)8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u0004\u0018\u000100*\u00020)8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00068"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter;", "", "currentConfig", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "context", "Lorg/springframework/context/ConfigurableApplicationContext;", "configValidationService", "Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;Lorg/springframework/context/ConfigurableApplicationContext;Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;)V", "isWritableConfigurationItem", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult;", "propertyPath", "", "updateClientServiceConfiguration", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult;", "newConfig", "updateYamlSource", "", "changedConfigItem", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$WritableSource;", "unbox", "collectUpdatableConfigurationItems", "", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem;", "currentConfigItem", "Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "newConfigItem", "collectUpdatableConfigurationItems$cdr_client_service", "getPropertySources", "Lorg/springframework/core/io/WritableResource;", "findPropertyOrigin", "", "Lorg/springframework/boot/origin/Origin;", "getPropertyNameAwareChildren", "value", "validate", "", "Lcom/swisscom/health/des/cdr/client/common/DTOs$ValidationMessageKey;", "config", "fileBackedResource", "Lorg/springframework/core/io/Resource;", "getFileBackedResource", "(Lorg/springframework/boot/origin/Origin;)Lorg/springframework/core/io/Resource;", "writeableResource", "getWriteableResource", "(Lorg/springframework/core/io/Resource;)Lorg/springframework/core/io/WritableResource;", "fileTypeFromExtension", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$FileType;", "getFileTypeFromExtension", "(Lorg/springframework/core/io/Resource;)Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$FileType;", "ConfigLookupResult", "UpdateResult", "FileType", "NamedConfigurationItem", "UpdatableConfigurationItem", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nConfigurationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationWriter.kt\ncom/swisscom/health/des/cdr/client/handler/ConfigurationWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,622:1\n295#2,2:623\n774#2:625\n865#2,2:626\n774#2:628\n865#2,2:629\n1563#2:631\n1634#2,3:632\n1869#2,2:635\n1563#2:638\n1634#2,3:639\n1617#2,9:642\n1869#2:651\n1870#2:653\n1626#2:654\n1617#2,9:655\n1869#2:664\n1870#2:666\n1626#2:667\n1617#2,9:668\n1869#2:677\n1870#2:679\n1626#2:680\n1617#2,9:681\n1869#2:690\n1870#2:692\n1626#2:693\n1563#2:694\n1634#2,3:695\n1617#2,9:698\n1869#2:707\n1870#2:709\n1626#2:710\n774#2:711\n865#2,2:712\n1563#2:714\n1634#2,3:715\n1193#2,2:718\n1267#2,4:720\n1878#2,3:724\n1#3:637\n1#3:652\n1#3:665\n1#3:678\n1#3:691\n1#3:708\n*S KotlinDebug\n*F\n+ 1 ConfigurationWriter.kt\ncom/swisscom/health/des/cdr/client/handler/ConfigurationWriter\n*L\n85#1:623,2\n127#1:625\n127#1:626,2\n129#1:628\n129#1:629,2\n142#1:631\n142#1:632,3\n144#1:635,2\n181#1:638\n181#1:639,3\n352#1:642,9\n352#1:651\n352#1:653\n352#1:654\n354#1:655,9\n354#1:664\n354#1:666\n354#1:667\n372#1:668,9\n372#1:677\n372#1:679\n372#1:680\n373#1:681,9\n373#1:690\n373#1:692\n373#1:693\n376#1:694\n376#1:695,3\n409#1:698,9\n409#1:707\n409#1:709\n409#1:710\n410#1:711\n410#1:712,2\n411#1:714\n411#1:715,3\n421#1:718,2\n421#1:720,4\n313#1:724,3\n352#1:652\n354#1:665\n372#1:678\n373#1:691\n409#1:708\n*E\n"})
public class ConfigurationWriter {
    @NotNull
    private final CdrClientConfig currentConfig;
    @NotNull
    private final ConfigurableApplicationContext context;
    @NotNull
    private final ConfigValidationService configValidationService;

    public ConfigurationWriter(@NotNull CdrClientConfig currentConfig, @NotNull ConfigurableApplicationContext context, @NotNull ConfigValidationService configValidationService) {
        Intrinsics.checkNotNullParameter((Object)currentConfig, (String)"currentConfig");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configValidationService, (String)"configValidationService");
        this.currentConfig = currentConfig;
        this.context = context;
        this.configValidationService = configValidationService;
    }

    @NotNull
    public ConfigLookupResult isWritableConfigurationItem(@NotNull String propertyPath) {
        ConfigLookupResult configLookupResult;
        Object v0;
        block9: {
            Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
            Iterable $this$firstOrNull$iv = this.collectUpdatableConfigurationItems$cdr_client_service(this.currentConfig, this.currentConfig);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UpdatableConfigurationItem it = (UpdatableConfigurationItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPropertyPath(), (Object)propertyPath)) continue;
                v0 = element$iv;
                break block9;
            }
            v0 = null;
        }
        UpdatableConfigurationItem updatableConfigItem = v0;
        boolean bl = false;
        UpdatableConfigurationItem updatableConfigurationItem = updatableConfigItem;
        if (updatableConfigurationItem == null) {
            configLookupResult = ConfigLookupResult.NotFound.INSTANCE;
        } else if (updatableConfigurationItem instanceof UpdatableConfigurationItem.UnknownSource) {
            configLookupResult = ConfigLookupResult.NotWritable.INSTANCE;
        } else if (updatableConfigurationItem instanceof UpdatableConfigurationItem.WritableSource) {
            configLookupResult = new ConfigLookupResult.Writable((Resource)((UpdatableConfigurationItem.WritableSource)updatableConfigItem).getWritableResource());
        } else if (updatableConfigurationItem instanceof UpdatableConfigurationItem.AmbiguousWritableSource) {
            configLookupResult = new ConfigLookupResult.Ambiguous(((UpdatableConfigurationItem.AmbiguousWritableSource)updatableConfigItem).getWritableResources());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return configLookupResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public UpdateResult updateClientServiceConfiguration(@NotNull CdrClientConfig newConfig) {
        Object object;
        Object $this$updateClientServiceConfiguration_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        Object object2 = this;
        try {
            UpdateResult updateResult;
            $this$updateClientServiceConfiguration_u24lambda_u240 = object2;
            boolean bl = false;
            ConfigurationWriterKt.access$getLogger$p().trace(() -> ConfigurationWriter.updateClientServiceConfiguration$lambda$0$0(newConfig));
            Map<String, DTOs.ValidationMessageKey> validationErrors = super.validate(newConfig);
            boolean bl2 = false;
            if (!validationErrors.isEmpty()) {
                updateResult = new UpdateResult.Failure(validationErrors);
            } else {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                UpdatableConfigurationItem changedConfigItem;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                List<UpdatableConfigurationItem> updatableItems = ((ConfigurationWriter)$this$updateClientServiceConfiguration_u24lambda_u240).collectUpdatableConfigurationItems$cdr_client_service(((ConfigurationWriter)$this$updateClientServiceConfiguration_u24lambda_u240).currentConfig, newConfig);
                ConfigurationWriterKt.access$getLogger$p().trace(() -> ConfigurationWriter.updateClientServiceConfiguration$lambda$0$1$0(updatableItems));
                Iterable iterable = updatableItems;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UpdatableConfigurationItem updatableConfigItem = (UpdatableConfigurationItem)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual((Object)updatableConfigItem.getNewValue(), (Object)updatableConfigItem.getCurrentValue()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl4;
                    changedConfigItem = (UpdatableConfigurationItem)element$iv$iv;
                    boolean bl5 = false;
                    boolean isWritable = bl4 = changedConfigItem instanceof UpdatableConfigurationItem.WritableSource;
                    boolean bl6 = false;
                    if (!isWritable) {
                        ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter.updateClientServiceConfiguration$lambda$0$1$2$0$0(changedConfigItem));
                    }
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void changedWritableConfigItem;
                    changedConfigItem = (UpdatableConfigurationItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull((Object)changedWritableConfigItem, (String)"null cannot be cast to non-null type com.swisscom.health.des.cdr.client.handler.ConfigurationWriter.UpdatableConfigurationItem.WritableSource");
                    collection.add((UpdatableConfigurationItem.WritableSource)changedWritableConfigItem);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UpdatableConfigurationItem.WritableSource changedWritableConfigItem = (UpdatableConfigurationItem.WritableSource)element$iv;
                    boolean bl8 = false;
                    ConfigurationWriterKt.access$getLogger$p().info(() -> ConfigurationWriter.updateClientServiceConfiguration$lambda$0$1$4$0(changedWritableConfigItem));
                    ConfigurationWriterKt.access$getLogger$p().trace(() -> ConfigurationWriter.updateClientServiceConfiguration$lambda$0$1$4$1(changedWritableConfigItem));
                    FileType fileType = super.getFileTypeFromExtension((Resource)changedWritableConfigItem.getWritableResource());
                    switch (fileType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fileType.ordinal()]) {
                        case 1: {
                            super.updateYamlSource(changedWritableConfigItem);
                            break;
                        }
                        case 2: {
                            throw new NotImplementedError(null, 1, null);
                        }
                        case -1: {
                            ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter.updateClientServiceConfiguration$lambda$0$1$4$2(changedWritableConfigItem));
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                updateResult = UpdateResult.Success.INSTANCE;
            }
            $this$updateClientServiceConfiguration_u24lambda_u240 = Result.constructor-impl((Object)updateResult);
        }
        catch (Throwable bl) {
            $this$updateClientServiceConfiguration_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$updateClientServiceConfiguration_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            UpdateResult.Failure failure;
            Throwable exception = throwable;
            boolean bl = false;
            String string = exception.getMessage();
            UpdateResult.Failure it = failure = new UpdateResult.Failure(MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)(string != null ? (Serializable)((Object)string) : (Serializable)exception))));
            boolean bl9 = false;
            ConfigurationWriterKt.access$getLogger$p().error(exception, ConfigurationWriter::updateClientServiceConfiguration$lambda$1$0$0);
            object = failure;
        }
        return (UpdateResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private void updateYamlSource(UpdatableConfigurationItem.WritableSource changedConfigItem) {
        void $this$mapTo$iv$iv;
        YAMLMapper.Builder $this$updateYamlSource_u24lambda_u240 = new YAMLMapper.Builder(new YAMLMapper(new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)));
        boolean bl = false;
        $this$updateYamlSource_u24lambda_u240.addModule((Module)ExtensionsKt.kotlinModule$default(null, (int)1, null));
        ObjectMapper objectMapper = $this$updateYamlSource_u24lambda_u240.build();
        YAMLMapper $this$updateYamlSource_u24lambda_u240_u240 = (YAMLMapper)objectMapper;
        boolean $i$a$-apply-ConfigurationWriter$updateYamlSource$1$22 = false;
        $this$updateYamlSource_u24lambda_u240_u240.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
        YAMLMapper $this$updateYamlSource_u24lambda_u241 = (YAMLMapper)objectMapper;
        boolean bl2 = false;
        JsonNode jsonNode = $this$updateYamlSource_u24lambda_u241.readTree(changedConfigItem.getWritableResource().getInputStream());
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        JsonNode yamlNode = jsonNode;
        Intrinsics.checkNotNull((Object)yamlNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode tmpNode = (ObjectNode)yamlNode;
        String[] $i$a$-apply-ConfigurationWriter$updateYamlSource$1$22 = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)changedConfigItem.getPropertyPath(), (String[])$i$a$-apply-ConfigurationWriter$updateYamlSource$1$22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(StringsKt.replace$default((String)it, (String)"\\[\\d+]$", (String)"", (boolean)false, (int)4, null));
        }
        Collection collection = (List)destination$iv$iv;
        ArrayDeque remainingNodeNames = new ArrayDeque(collection);
        String toBeUpdatedNodeName = (String)remainingNodeNames.removeLast();
        while (!((Collection)remainingNodeNames).isEmpty()) {
            JsonNode jsonNode2 = tmpNode.get((String)remainingNodeNames.removeFirst());
            Intrinsics.checkNotNull((Object)jsonNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            tmpNode = (ObjectNode)jsonNode2;
        }
        Object newValue = Reflection.getOrCreateKotlinClass(changedConfigItem.getNewValue().getClass()).isValue() ? this.unbox(changedConfigItem.getNewValue()) : changedConfigItem.getNewValue();
        object = tmpNode;
        Iterable $this$updateYamlSource_u24lambda_u241_u241 = object;
        boolean bl4 = false;
        Object object2 = newValue;
        if (object2 instanceof Collection) {
            JsonNode jsonNode3 = $this$updateYamlSource_u24lambda_u241.valueToTree(newValue);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"valueToTree(...)");
            ArrayNode arrayNode = (ArrayNode)jsonNode3;
            $this$updateYamlSource_u24lambda_u241_u241.set(toBeUpdatedNodeName, (JsonNode)arrayNode);
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$0(changedConfigItem, arrayNode));
        } else if (object2 instanceof String) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, (String)newValue);
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$1(changedConfigItem, newValue));
        } else if (object2 instanceof Boolean) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, (Boolean)newValue);
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$2(changedConfigItem, newValue));
        } else if (object2 instanceof Integer) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, ((Number)newValue).intValue());
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$3(changedConfigItem, newValue));
        } else if (object2 instanceof Long) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, ((Number)newValue).longValue());
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$4(changedConfigItem, newValue));
        } else if (object2 instanceof Float) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, ((Number)newValue).floatValue());
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$5(changedConfigItem, newValue));
        } else if (object2 instanceof Double) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, ((Number)newValue).doubleValue());
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$6(changedConfigItem, newValue));
        } else if (object2 instanceof Enum) {
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, ((Enum)newValue).name());
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$7(changedConfigItem, newValue));
        } else if (object2 instanceof Duration || object2 instanceof DataSize || object2 instanceof Instant || object2 instanceof URL || object2 instanceof Path || object2 instanceof MediaType) {
            String stringValue = newValue.toString();
            boolean bl5 = false;
            $this$updateYamlSource_u24lambda_u241_u241.put(toBeUpdatedNodeName, stringValue);
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.updateYamlSource$lambda$1$1$8$0(changedConfigItem, stringValue));
        } else {
            throw new IllegalStateException(("Unsupported type for configuration item '" + changedConfigItem.getPropertyPath() + "': '" + Reflection.getOrCreateKotlinClass(newValue.getClass()) + "'").toString());
        }
        OutputStream outputStream = changedConfigItem.getWritableResource().getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        object = outputStream;
        Charset charset = Charsets.UTF_8;
        $this$updateYamlSource_u24lambda_u241.writeValue((Writer)new OutputStreamWriter((OutputStream)object, charset), (Object)yamlNode);
    }

    private Object unbox(Object $this$unbox) {
        Object object;
        if (Reflection.getOrCreateKotlinClass($this$unbox.getClass()).isValue()) {
            Object object2 = $this$unbox.getClass().getMethod("unbox-impl", new Class[0]).invoke($this$unbox, new Object[0]);
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"invoke(...)");
        } else {
            object = $this$unbox;
        }
        return object;
    }

    @NotNull
    public List<UpdatableConfigurationItem> collectUpdatableConfigurationItems$cdr_client_service(@NotNull PropertyNameAware currentConfigItem, @NotNull PropertyNameAware newConfigItem) {
        Intrinsics.checkNotNullParameter((Object)currentConfigItem, (String)"currentConfigItem");
        Intrinsics.checkNotNullParameter((Object)newConfigItem, (String)"newConfigItem");
        if (!(!(currentConfigItem instanceof Collection))) {
            boolean bl = false;
            String string = "The top-level configuration item must not be a collection, but was: '" + Reflection.getOrCreateKotlinClass(currentConfigItem.getClass()) + "'";
            throw new IllegalArgumentException(string.toString());
        }
        List updatableConfigItems = new ArrayList();
        ConfigurationWriter.collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree(this, (ArrayDeque<NamedConfigurationItem>)new ArrayDeque((Collection)CollectionsKt.listOf((Object)new NamedConfigurationItem.SinglePath(currentConfigItem, newConfigItem, CollectionsKt.listOf((Object)currentConfigItem.getPropertyName())))), updatableConfigItems);
        return updatableConfigItems;
    }

    private List<WritableResource> getPropertySources(String propertyPath) {
        Object object;
        Resource it$iv$iv;
        boolean bl;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Collection destination$iv$iv;
        boolean $i$f$mapNotNull;
        Iterable $this$mapNotNull$iv;
        Object object2;
        Object object3 = this;
        try {
            ConfigurationWriter $this$getPropertySources_u24lambda_u240 = object3;
            boolean bl3 = false;
            object2 = Result.constructor-impl($this$getPropertySources_u24lambda_u240.findPropertyOrigin(propertyPath));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object2;
        if (Result.isSuccess-impl((Object)object3)) {
            Object object4;
            object2 = object3;
            try {
                object4 = object2;
                Set origins = (Set)object4;
                boolean bl4 = false;
                $this$mapNotNull$iv = origins;
                $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    Origin origin = (Origin)element$iv$iv;
                    boolean bl5 = false;
                    if (this.getFileBackedResource(origin) == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                object4 = Result.constructor-impl((Object)((List)destination$iv$iv));
            }
            catch (Throwable origins) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)origins));
            }
            v0 = object4;
        } else {
            v0 = object3 = Result.constructor-impl((Object)object3);
        }
        if (Result.isSuccess-impl((Object)object3)) {
            Object object5;
            object2 = object3;
            try {
                object5 = object2;
                List resources = (List)object5;
                boolean bl6 = false;
                $this$mapNotNull$iv = resources;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    bl2 = false;
                    Resource resource = (Resource)element$iv$iv;
                    boolean bl7 = false;
                    if (this.getWriteableResource(resource) == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                object5 = Result.constructor-impl((Object)((List)destination$iv$iv));
            }
            catch (Throwable throwable) {
                object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object5;
        } else {
            object = Result.constructor-impl((Object)object3);
        }
        object3 = object;
        ResultKt.throwOnFailure((Object)object3);
        List origin = (List)object3;
        return origin;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Origin> findPropertyOrigin(String propertyPath) {
        void $this$mapTo$iv$iv;
        boolean bl;
        OriginLookup it$iv$iv;
        PropertySource it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        MutablePropertySources mutablePropertySources = this.context.getEnvironment().getPropertySources();
        Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"getPropertySources(...)");
        Iterable $this$mapNotNull$iv = (Iterable)mutablePropertySources;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Origin origin = $this$forEach$iv$iv$iv.iterator();
        while (origin.hasNext()) {
            element$iv$iv = element$iv$iv$iv = origin.next();
            bl2 = false;
            it = (PropertySource)element$iv$iv;
            boolean bl3 = false;
            if ((it instanceof OriginLookup ? (OriginLookup)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        origin = $this$forEach$iv$iv$iv.iterator();
        while (origin.hasNext()) {
            element$iv$iv = element$iv$iv$iv = origin.next();
            bl2 = false;
            it = (OriginLookup)element$iv$iv;
            boolean bl4 = false;
            if (it.getOrigin((Object)propertyPath) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            origin = (Origin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it2 instanceof PropertySourceOrigin ? ((PropertySourceOrigin)it2).getOrigin() : it2);
        }
        Set origins = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (origins.isEmpty()) {
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.findPropertyOrigin$lambda$3(propertyPath));
        } else if (origins.size() > 1) {
            ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.findPropertyOrigin$lambda$4(propertyPath));
        }
        return origins;
    }

    /*
     * WARNING - void declaration
     */
    private List<PropertyNameAware> getPropertyNameAwareChildren(Object value) {
        Object object;
        block6: {
            void $this$mapTo$iv$iv;
            Object propertyValue;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            block7: {
                block8: {
                    Object object2;
                    block5: {
                        object2 = value;
                        if (object2 != null) break block5;
                        object = CollectionsKt.emptyList();
                        break block6;
                    }
                    if (!(object2 instanceof Collection)) break block7;
                    object = CollectionsKt.firstOrNull((Iterable)((Iterable)value));
                    if (object == null) break block8;
                    List it = object;
                    boolean bl = false;
                    List list = this.getPropertyNameAwareChildren(it);
                    object = list;
                    if (list != null) break block6;
                }
                object = CollectionsKt.emptyList();
                break block6;
            }
            Iterable $this$mapNotNull$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(value.getClass()));
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KProperty1 kProperty = (KProperty1)element$iv$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{value};
                if (kProperty.call(objectArray) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                propertyValue = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(propertyValue instanceof PropertyNameAware)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object item$iv$iv;
                propertyValue = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(propertyValue, (String)"null cannot be cast to non-null type com.swisscom.health.des.cdr.client.config.PropertyNameAware");
                collection.add((PropertyNameAware)propertyValue);
            }
            object = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, DTOs.ValidationMessageKey> validate(CdrClientConfig config) {
        Map map2;
        DTOs.ValidationResult validateAllConfigurationItems;
        ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.validate$lambda$0(config));
        DTOs.ValidationResult validationResult = validateAllConfigurationItems = this.configValidationService.validateAllConfigurationItems(ConfigConverterKt.toDto(config));
        if (validationResult instanceof DTOs.ValidationResult.Success) {
            map2 = MapsKt.emptyMap();
        } else if (validationResult instanceof DTOs.ValidationResult.Failure) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((DTOs.ValidationResult.Failure)validateAllConfigurationItems).getValidationDetails();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Pair pair;
                Map map3 = destination$iv$iv;
                DTOs.ValidationDetail detail = (DTOs.ValidationDetail)element$iv$iv;
                boolean bl = false;
                DTOs.ValidationDetail validationDetail = detail;
                if (validationDetail instanceof DTOs.ValidationDetail.ConfigItemDetail) {
                    pair = TuplesKt.to((Object)String.valueOf(((DTOs.ValidationDetail.ConfigItemDetail)detail).getConfigItem()), (Object)((DTOs.ValidationDetail.ConfigItemDetail)detail).getMessageKey());
                } else if (validationDetail instanceof DTOs.ValidationDetail.ConnectorDetail) {
                    pair = TuplesKt.to((Object)(((DTOs.ValidationDetail.ConnectorDetail)detail).getConfigItem() + " - " + ((DTOs.ValidationDetail.ConnectorDetail)detail).getConnectorId()), (Object)((DTOs.ValidationDetail.ConnectorDetail)detail).getMessageKey());
                } else if (validationDetail instanceof DTOs.ValidationDetail.PathDetail) {
                    pair = TuplesKt.to((Object)((DTOs.ValidationDetail.PathDetail)detail).getPath(), (Object)((DTOs.ValidationDetail.PathDetail)detail).getMessageKey());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Pair pair2 = pair;
                map3.put(pair2.getFirst(), pair2.getSecond());
            }
            map2 = destination$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map2;
    }

    private Resource getFileBackedResource(Origin $this$fileBackedResource) {
        Resource resource;
        if ($this$fileBackedResource instanceof TextResourceOrigin) {
            resource = ((TextResourceOrigin)$this$fileBackedResource).getResource();
        } else {
            Object var2_2;
            Object it = var2_2 = null;
            boolean bl = false;
            ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter._get_fileBackedResource_$lambda$0$0($this$fileBackedResource));
            resource = var2_2;
        }
        return resource;
    }

    private WritableResource getWriteableResource(Resource $this$writeableResource) {
        FileSystemResource fileSystemResource;
        Object $this$_get_writeableResource__u24lambda_u240;
        Resource resource = $this$writeableResource;
        try {
            FileSystemResource fileSystemResource2;
            $this$_get_writeableResource__u24lambda_u240 = resource;
            boolean bl = false;
            FileSystemResource $this$_get_writeableResource__u24lambda_u240_u240 = new FileSystemResource($this$_get_writeableResource__u24lambda_u240.getFile());
            boolean bl2 = false;
            boolean bl3 = $this$_get_writeableResource__u24lambda_u240_u240.isWritable();
            if (bl3) {
                FileSystemResource fileSystemResource3;
                FileSystemResource it = fileSystemResource3 = $this$_get_writeableResource__u24lambda_u240_u240;
                boolean bl4 = false;
                ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter._get_writeableResource_$lambda$0$0$0$0($this$_get_writeableResource__u24lambda_u240_u240));
                fileSystemResource2 = fileSystemResource3;
            } else if (!bl3) {
                Object var8_11;
                Object it = var8_11 = null;
                boolean bl5 = false;
                ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter._get_writeableResource_$lambda$0$0$1$0($this$_get_writeableResource__u24lambda_u240_u240));
                fileSystemResource2 = var8_11;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            $this$_get_writeableResource__u24lambda_u240 = Result.constructor-impl((Object)fileSystemResource2);
        }
        catch (Throwable bl) {
            $this$_get_writeableResource__u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        resource = $this$_get_writeableResource__u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)resource);
        if (throwable == null) {
            FileSystemResource it = (FileSystemResource)resource;
            boolean bl = false;
            fileSystemResource = it;
        } else {
            Object var5_6;
            Throwable exception = throwable;
            boolean bl = false;
            Object it = var5_6 = null;
            boolean bl6 = false;
            ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter._get_writeableResource_$lambda$2$0$0($this$writeableResource, exception));
            fileSystemResource = var5_6;
        }
        return (WritableResource)fileSystemResource;
    }

    /*
     * Unable to fully structure code
     */
    private FileType getFileTypeFromExtension(Resource $this$fileTypeFromExtension) {
        block6: {
            v0 = $this$fileTypeFromExtension.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getFile(...)");
            var2_2 = FilesKt.getExtension((File)v0);
            switch (var2_2.hashCode()) {
                case 119768: {
                    if (!var2_2.equals("yml")) {
                        ** break;
                    }
                    ** GOTO lbl14
                }
                case -926053069: {
                    if (var2_2.equals("properties")) break;
                    ** break;
                }
                case 3701415: {
                    if (!var2_2.equals("yaml")) ** break;
lbl14:
                    // 2 sources

                    v1 = FileType.YAML;
                    break block6;
                }
            }
            v1 = FileType.PROPERTIES;
            break block6;
lbl18:
            // 4 sources

            it = var3_3 = null;
            $i$a$-also-ConfigurationWriter$fileTypeFromExtension$1 = false;
            ConfigurationWriterKt.access$getLogger$p().warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, _get_fileTypeFromExtension_$lambda$0$0(org.springframework.core.io.Resource ), ()Ljava/lang/Object;)((Resource)$this$fileTypeFromExtension));
            v1 = var3_3;
        }
        return v1;
    }

    private static final Object updateClientServiceConfiguration$lambda$0$0(CdrClientConfig $newConfig) {
        return "New CDR client config: '" + $newConfig + "'";
    }

    private static final Object updateClientServiceConfiguration$lambda$0$1$0(List $updatableItems) {
        return "Updatable configuration items found: '" + $updatableItems + "'";
    }

    private static final Object updateClientServiceConfiguration$lambda$0$1$2$0$0(UpdatableConfigurationItem $changedConfigItem) {
        return "Configuration item '" + $changedConfigItem.getPropertyPath() + "' was changed, but is not writable! Skipping update for this item!";
    }

    private static final Object updateClientServiceConfiguration$lambda$0$1$4$0(UpdatableConfigurationItem.WritableSource $changedWritableConfigItem) {
        return "Updating configuration item: '" + $changedWritableConfigItem.getPropertyPath() + "'";
    }

    private static final Object updateClientServiceConfiguration$lambda$0$1$4$1(UpdatableConfigurationItem.WritableSource $changedWritableConfigItem) {
        return "Configuration item details: '" + $changedWritableConfigItem + "'";
    }

    private static final Object updateClientServiceConfiguration$lambda$0$1$4$2(UpdatableConfigurationItem.WritableSource $changedWritableConfigItem) {
        return "Property source has unknown file extension: " + $changedWritableConfigItem.getWritableResource().getFilename();
    }

    private static final Object updateClientServiceConfiguration$lambda$1$0$0() {
        return "Failed to update configuration items";
    }

    private static final Object updateYamlSource$lambda$1$1$0(UpdatableConfigurationItem.WritableSource $changedConfigItem, ArrayNode $arrayNode) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $arrayNode + "' as type '" + Reflection.getOrCreateKotlinClass($arrayNode.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$1(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $newValue + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$2(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $newValue + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$3(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $newValue + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$4(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $newValue + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$5(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $newValue + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$6(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $newValue + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$7(UpdatableConfigurationItem.WritableSource $changedConfigItem, Object $newValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + ((Enum)$newValue).name() + "' as type '" + Reflection.getOrCreateKotlinClass($newValue.getClass()) + "'";
    }

    private static final Object updateYamlSource$lambda$1$1$8$0(UpdatableConfigurationItem.WritableSource $changedConfigItem, String $stringValue) {
        return "set '" + $changedConfigItem.getPropertyPath() + "' to '" + $stringValue + "' as type '" + Reflection.getOrCreateKotlinClass($stringValue.getClass()) + "'";
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree(ConfigurationWriter this$0, ArrayDeque<NamedConfigurationItem> configItems, List<UpdatableConfigurationItem> updatableConfigItemCollector) {
        while (!configItems.isEmpty()) {
            NamedConfigurationItem currentConfigItem = (NamedConfigurationItem)configItems.removeLast();
            List<PropertyNameAware> currentNamedChildren = this$0.getPropertyNameAwareChildren(currentConfigItem.getCurrentValue());
            if (currentNamedChildren.isEmpty()) {
                NamedConfigurationItem.SinglePath singlePath;
                String propertyPathString = CollectionsKt.joinToString$default((Iterable)currentConfigItem.getPropertyPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                Object object = currentConfigItem;
                if (object instanceof NamedConfigurationItem.SinglePath) {
                    singlePath = (NamedConfigurationItem.SinglePath)currentConfigItem;
                } else if (object instanceof NamedConfigurationItem.MultiPath) {
                    singlePath = ((NamedConfigurationItem.MultiPath)currentConfigItem).getSinglePathItem();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                NamedConfigurationItem.SinglePath configItemToUpdate = singlePath;
                Object it = object = configItemToUpdate.toUpdatableConfigurationItem(this$0.getPropertySources(propertyPathString));
                boolean bl = false;
                Object object2 = it;
                if (object2 instanceof UpdatableConfigurationItem.UnknownSource) {
                    ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter.collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree$lambda$0$0((UpdatableConfigurationItem)it));
                } else if (object2 instanceof UpdatableConfigurationItem.WritableSource) {
                    ConfigurationWriterKt.access$getLogger$p().debug(() -> ConfigurationWriter.collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree$lambda$0$1((UpdatableConfigurationItem)it));
                } else if (object2 instanceof UpdatableConfigurationItem.AmbiguousWritableSource) {
                    ConfigurationWriterKt.access$getLogger$p().warn(() -> ConfigurationWriter.collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree$lambda$0$2((UpdatableConfigurationItem)it));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                updatableConfigItemCollector.add((UpdatableConfigurationItem)it);
            } else {
                List<PropertyNameAware> newNamedChildren = this$0.getPropertyNameAwareChildren(currentConfigItem.getNewValue());
                Iterable $this$forEachIndexed$iv = currentNamedChildren;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void currentChild;
                    NamedConfigurationItem namedConfigurationItem;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    PropertyNameAware propertyNameAware = (PropertyNameAware)item$iv;
                    int idx = n;
                    boolean bl = false;
                    NamedConfigurationItem it = namedConfigurationItem = currentConfigItem.newChild((PropertyNameAware)currentChild, (PropertyNameAware)CollectionsKt.getOrNull(newNamedChildren, (int)idx));
                    boolean bl2 = false;
                    configItems.add((Object)it);
                }
            }
            ArrayDeque<NamedConfigurationItem> arrayDeque = configItems;
            List<UpdatableConfigurationItem> list = updatableConfigItemCollector;
            configItems = arrayDeque;
            updatableConfigItemCollector = list;
        }
        return;
    }

    private static final Object collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree$lambda$0$0(UpdatableConfigurationItem $it) {
        return "No writable resource found for configuration item '" + ((UpdatableConfigurationItem.UnknownSource)$it).getPropertyPath() + "'";
    }

    private static final Object collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree$lambda$0$1(UpdatableConfigurationItem $it) {
        return "Writable resource found for configuration item '" + ((UpdatableConfigurationItem.WritableSource)$it).getPropertyPath() + "': '" + ((UpdatableConfigurationItem.WritableSource)$it).getWritableResource() + "'";
    }

    private static final Object collectUpdatableConfigurationItems$walkUpdatableConfigurationItemTree$lambda$0$2(UpdatableConfigurationItem $it) {
        return "Multiple writable resources found for configuration item '" + ((UpdatableConfigurationItem.AmbiguousWritableSource)$it).getPropertyPath() + "': '" + ((UpdatableConfigurationItem.AmbiguousWritableSource)$it).getWritableResources() + "'";
    }

    private static final Object findPropertyOrigin$lambda$3(String $propertyPath) {
        return "No origin found for property `" + $propertyPath + "`";
    }

    private static final Object findPropertyOrigin$lambda$4(String $propertyPath) {
        return "Multiple origins found for property `" + $propertyPath + "`";
    }

    private static final Object validate$lambda$0(CdrClientConfig $config) {
        return "config to validate: '" + $config + "'";
    }

    private static final Object _get_fileBackedResource_$lambda$0$0(Origin $this_fileBackedResource) {
        return "Don't know how to get file resource for origin type: '" + Reflection.getOrCreateKotlinClass($this_fileBackedResource.getClass()).getQualifiedName() + "'";
    }

    private static final Object _get_writeableResource_$lambda$0$0$0$0(FileSystemResource $this_run) {
        return "Resource is writable: '" + $this_run + "'";
    }

    private static final Object _get_writeableResource_$lambda$0$0$1$0(FileSystemResource $this_run) {
        return "Resource is not writable: '" + $this_run + "'";
    }

    private static final Object _get_writeableResource_$lambda$2$0$0(Resource $this_writeableResource, Throwable $exception) {
        return "Resource is not writable: '" + $this_writeableResource + "'; reason: '" + $exception + "'";
    }

    private static final Object _get_fileTypeFromExtension_$lambda$0$0(Resource $this_fileTypeFromExtension) {
        File file = $this_fileTypeFromExtension.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        return "Don't know file type for extension: '" + FilesKt.getExtension((File)file) + "'; resource: '" + $this_fileTypeFromExtension + "'";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult;", "", "NotFound", "NotWritable", "Writable", "Ambiguous", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$Ambiguous;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$NotFound;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$NotWritable;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$Writable;", "cdr-client-service"})
    public static sealed interface ConfigLookupResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$Ambiguous;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult;", "resources", "", "Lorg/springframework/core/io/Resource;", "<init>", "(Ljava/util/List;)V", "getResources", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cdr-client-service"})
        public static final class Ambiguous
        implements ConfigLookupResult {
            @NotNull
            private final List<Resource> resources;

            public Ambiguous(@NotNull List<? extends Resource> resources) {
                Intrinsics.checkNotNullParameter(resources, (String)"resources");
                this.resources = resources;
            }

            @NotNull
            public final List<Resource> getResources() {
                return this.resources;
            }

            @NotNull
            public final List<Resource> component1() {
                return this.resources;
            }

            @NotNull
            public final Ambiguous copy(@NotNull List<? extends Resource> resources) {
                Intrinsics.checkNotNullParameter(resources, (String)"resources");
                return new Ambiguous(resources);
            }

            public static /* synthetic */ Ambiguous copy$default(Ambiguous ambiguous, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = ambiguous.resources;
                }
                return ambiguous.copy(list);
            }

            @NotNull
            public String toString() {
                return "Ambiguous(resources=" + this.resources + ")";
            }

            public int hashCode() {
                return ((Object)this.resources).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ambiguous)) {
                    return false;
                }
                Ambiguous ambiguous = (Ambiguous)other;
                return Intrinsics.areEqual(this.resources, ambiguous.resources);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$NotFound;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult;", "<init>", "()V", "cdr-client-service"})
        public static final class NotFound
        implements ConfigLookupResult {
            @NotNull
            public static final NotFound INSTANCE = new NotFound();

            private NotFound() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$NotWritable;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult;", "<init>", "()V", "cdr-client-service"})
        public static final class NotWritable
        implements ConfigLookupResult {
            @NotNull
            public static final NotWritable INSTANCE = new NotWritable();

            private NotWritable() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult$Writable;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$ConfigLookupResult;", "resource", "Lorg/springframework/core/io/Resource;", "<init>", "(Lorg/springframework/core/io/Resource;)V", "getResource", "()Lorg/springframework/core/io/Resource;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cdr-client-service"})
        public static final class Writable
        implements ConfigLookupResult {
            @NotNull
            private final Resource resource;

            public Writable(@NotNull Resource resource) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                this.resource = resource;
            }

            @NotNull
            public final Resource getResource() {
                return this.resource;
            }

            @NotNull
            public final Resource component1() {
                return this.resource;
            }

            @NotNull
            public final Writable copy(@NotNull Resource resource) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                return new Writable(resource);
            }

            public static /* synthetic */ Writable copy$default(Writable writable, Resource resource, int n, Object object) {
                if ((n & 1) != 0) {
                    resource = writable.resource;
                }
                return writable.copy(resource);
            }

            @NotNull
            public String toString() {
                return "Writable(resource=" + this.resource + ")";
            }

            public int hashCode() {
                return this.resource.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Writable)) {
                    return false;
                }
                Writable writable = (Writable)other;
                return Intrinsics.areEqual((Object)this.resource, (Object)writable.resource);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$FileType;", "", "<init>", "(Ljava/lang/String;I)V", "YAML", "PROPERTIES", "cdr-client-service"})
    private static final class FileType
    extends Enum<FileType> {
        public static final /* enum */ FileType YAML = new FileType();
        public static final /* enum */ FileType PROPERTIES = new FileType();
        private static final /* synthetic */ FileType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String value) {
            return Enum.valueOf(FileType.class, value);
        }

        @NotNull
        public static EnumEntries<FileType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fileTypeArray = new FileType[]{FileType.YAML, FileType.PROPERTIES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0012\u0013\u0014J\u001c\u0010\r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H&J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0001\u0015\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem;", "", "currentValue", "Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "getCurrentValue", "()Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "newValue", "getNewValue", "propertyPath", "", "", "getPropertyPath", "()Ljava/util/List;", "newChild", "toUpdatableConfigurationItem", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem;", "writableResources", "Lorg/springframework/core/io/WritableResource;", "ValidatedItem", "SinglePath", "MultiPath", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$ValidatedItem;", "cdr-client-service"})
    private static sealed interface NamedConfigurationItem {
        @NotNull
        public PropertyNameAware getCurrentValue();

        @Nullable
        public PropertyNameAware getNewValue();

        @NotNull
        public List<String> getPropertyPath();

        @NotNull
        public NamedConfigurationItem newChild(@NotNull PropertyNameAware var1, @Nullable PropertyNameAware var2);

        public static /* synthetic */ NamedConfigurationItem newChild$default(NamedConfigurationItem namedConfigurationItem, PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newChild");
            }
            if ((n & 2) != 0) {
                propertyNameAware2 = null;
            }
            return namedConfigurationItem.newChild(propertyNameAware, propertyNameAware2);
        }

        @NotNull
        default public UpdatableConfigurationItem toUpdatableConfigurationItem(@NotNull List<? extends WritableResource> writableResources) {
            SinglePath singlePath;
            Intrinsics.checkNotNullParameter(writableResources, (String)"writableResources");
            NamedConfigurationItem namedConfigurationItem = this;
            if (namedConfigurationItem instanceof SinglePath) {
                singlePath = (SinglePath)this;
            } else if (namedConfigurationItem instanceof MultiPath) {
                singlePath = ((MultiPath)this).getSinglePathItem();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            SinglePath singlePathValue = singlePath;
            UpdatableConfigurationItem updatableConfigItem = switch (writableResources.size()) {
                case 0 -> {
                    String v1 = CollectionsKt.joinToString$default((Iterable)singlePathValue.getPropertyPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                    PropertyNameAware v2 = singlePathValue.getCurrentValue();
                    PropertyNameAware v3 = singlePathValue.getNewValue();
                    Intrinsics.checkNotNull((Object)v3);
                    yield new UpdatableConfigurationItem.UnknownSource(v1, v2, v3);
                }
                case 1 -> {
                    String v5 = CollectionsKt.joinToString$default((Iterable)singlePathValue.getPropertyPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                    PropertyNameAware v6 = singlePathValue.getCurrentValue();
                    PropertyNameAware v7 = singlePathValue.getNewValue();
                    Intrinsics.checkNotNull((Object)v7);
                    yield new UpdatableConfigurationItem.WritableSource(v5, v6, v7, (WritableResource)CollectionsKt.first(writableResources));
                }
                default -> {
                    String v8 = CollectionsKt.joinToString$default((Iterable)singlePathValue.getPropertyPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                    PropertyNameAware v9 = singlePathValue.getCurrentValue();
                    PropertyNameAware v10 = singlePathValue.getNewValue();
                    Intrinsics.checkNotNull((Object)v10);
                    yield new UpdatableConfigurationItem.AmbiguousWritableSource(v8, v9, v10, writableResources);
                }
            };
            return updatableConfigItem;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ NamedConfigurationItem newChild$default(NamedConfigurationItem namedConfigurationItem, PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, int n, Object object) {
                return NamedConfigurationItem.newChild$default(namedConfigurationItem, propertyNameAware, propertyNameAware2, n, object);
            }

            @Deprecated
            @NotNull
            public static UpdatableConfigurationItem toUpdatableConfigurationItem(@NotNull NamedConfigurationItem $this, @NotNull List<? extends WritableResource> writableResources) {
                Intrinsics.checkNotNullParameter(writableResources, (String)"writableResources");
                return $this.toUpdatableConfigurationItem(writableResources);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$MultiPath;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$ValidatedItem;", "currentValue", "Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "newValue", "propertyPath", "", "", "singlePathItem", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$SinglePath;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;Ljava/util/List;Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$SinglePath;)V", "getCurrentValue", "()Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "getNewValue", "getPropertyPath", "()Ljava/util/List;", "getSinglePathItem", "()Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$SinglePath;", "newChild", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class MultiPath
        extends ValidatedItem {
            @NotNull
            private final PropertyNameAware currentValue;
            @Nullable
            private final PropertyNameAware newValue;
            @NotNull
            private final List<String> propertyPath;
            @NotNull
            private final SinglePath singlePathItem;

            public MultiPath(@NotNull PropertyNameAware currentValue, @Nullable PropertyNameAware newValue, @NotNull List<String> propertyPath, @NotNull SinglePath singlePathItem) {
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter(propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)singlePathItem, (String)"singlePathItem");
                super(currentValue, newValue, propertyPath, null);
                this.currentValue = currentValue;
                this.newValue = newValue;
                this.propertyPath = propertyPath;
                this.singlePathItem = singlePathItem;
            }

            public /* synthetic */ MultiPath(PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, List list, SinglePath singlePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    propertyNameAware2 = null;
                }
                this(propertyNameAware, propertyNameAware2, (List<String>)list, singlePath);
            }

            @Override
            @NotNull
            public PropertyNameAware getCurrentValue() {
                return this.currentValue;
            }

            @Override
            @Nullable
            public PropertyNameAware getNewValue() {
                return this.newValue;
            }

            @Override
            @NotNull
            public List<String> getPropertyPath() {
                return this.propertyPath;
            }

            @NotNull
            public final SinglePath getSinglePathItem() {
                return this.singlePathItem;
            }

            @Override
            @NotNull
            public NamedConfigurationItem newChild(@NotNull PropertyNameAware currentValue, @Nullable PropertyNameAware newValue) {
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                return MultiPath.copy$default(this, currentValue, newValue, CollectionsKt.plus((Collection)this.getPropertyPath(), (Object)ConfigurationWriterKt.access$getCollectionItemPropertyName(currentValue)), null, 8, null);
            }

            @NotNull
            public final PropertyNameAware component1() {
                return this.currentValue;
            }

            @Nullable
            public final PropertyNameAware component2() {
                return this.newValue;
            }

            @NotNull
            public final List<String> component3() {
                return this.propertyPath;
            }

            @NotNull
            public final SinglePath component4() {
                return this.singlePathItem;
            }

            @NotNull
            public final MultiPath copy(@NotNull PropertyNameAware currentValue, @Nullable PropertyNameAware newValue, @NotNull List<String> propertyPath, @NotNull SinglePath singlePathItem) {
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter(propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)singlePathItem, (String)"singlePathItem");
                return new MultiPath(currentValue, newValue, propertyPath, singlePathItem);
            }

            public static /* synthetic */ MultiPath copy$default(MultiPath multiPath, PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, List list, SinglePath singlePath, int n, Object object) {
                if ((n & 1) != 0) {
                    propertyNameAware = multiPath.currentValue;
                }
                if ((n & 2) != 0) {
                    propertyNameAware2 = multiPath.newValue;
                }
                if ((n & 4) != 0) {
                    list = multiPath.propertyPath;
                }
                if ((n & 8) != 0) {
                    singlePath = multiPath.singlePathItem;
                }
                return multiPath.copy(propertyNameAware, propertyNameAware2, list, singlePath);
            }

            @NotNull
            public String toString() {
                return "MultiPath(currentValue=" + this.currentValue + ", newValue=" + this.newValue + ", propertyPath=" + this.propertyPath + ", singlePathItem=" + this.singlePathItem + ")";
            }

            public int hashCode() {
                int result = this.currentValue.hashCode();
                result = result * 31 + (this.newValue == null ? 0 : this.newValue.hashCode());
                result = result * 31 + ((Object)this.propertyPath).hashCode();
                result = result * 31 + this.singlePathItem.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MultiPath)) {
                    return false;
                }
                MultiPath multiPath = (MultiPath)other;
                if (!Intrinsics.areEqual((Object)this.currentValue, (Object)multiPath.currentValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.newValue, (Object)multiPath.newValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.propertyPath, multiPath.propertyPath)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.singlePathItem, (Object)multiPath.singlePathItem);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J/\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$SinglePath;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$ValidatedItem;", "currentValue", "Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "newValue", "propertyPath", "", "", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;Ljava/util/List;)V", "getCurrentValue", "()Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "getNewValue", "getPropertyPath", "()Ljava/util/List;", "newChild", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "cdr-client-service"})
        public static final class SinglePath
        extends ValidatedItem {
            @NotNull
            private final PropertyNameAware currentValue;
            @Nullable
            private final PropertyNameAware newValue;
            @NotNull
            private final List<String> propertyPath;

            public SinglePath(@NotNull PropertyNameAware currentValue, @Nullable PropertyNameAware newValue, @NotNull List<String> propertyPath) {
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter(propertyPath, (String)"propertyPath");
                super(currentValue, newValue, propertyPath, null);
                this.currentValue = currentValue;
                this.newValue = newValue;
                this.propertyPath = propertyPath;
            }

            public /* synthetic */ SinglePath(PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    propertyNameAware2 = null;
                }
                this(propertyNameAware, propertyNameAware2, list);
            }

            @Override
            @NotNull
            public PropertyNameAware getCurrentValue() {
                return this.currentValue;
            }

            @Override
            @Nullable
            public PropertyNameAware getNewValue() {
                return this.newValue;
            }

            @Override
            @NotNull
            public List<String> getPropertyPath() {
                return this.propertyPath;
            }

            @Override
            @NotNull
            public NamedConfigurationItem newChild(@NotNull PropertyNameAware currentValue, @Nullable PropertyNameAware newValue) {
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                if (currentValue instanceof Collection) {
                    return new MultiPath(currentValue, newValue, (List<String>)CollectionsKt.plus((Collection)this.getPropertyPath(), (Object)ConfigurationWriterKt.access$getCollectionItemPropertyName(currentValue)), new SinglePath(currentValue, newValue, CollectionsKt.plus((Collection)this.getPropertyPath(), (Object)currentValue.getPropertyName())));
                }
                return new SinglePath(currentValue, newValue, CollectionsKt.plus((Collection)this.getPropertyPath(), (Object)ConfigurationWriterKt.access$getCollectionItemPropertyName(currentValue)));
            }

            @NotNull
            public final PropertyNameAware component1() {
                return this.currentValue;
            }

            @Nullable
            public final PropertyNameAware component2() {
                return this.newValue;
            }

            @NotNull
            public final List<String> component3() {
                return this.propertyPath;
            }

            @NotNull
            public final SinglePath copy(@NotNull PropertyNameAware currentValue, @Nullable PropertyNameAware newValue, @NotNull List<String> propertyPath) {
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter(propertyPath, (String)"propertyPath");
                return new SinglePath(currentValue, newValue, propertyPath);
            }

            public static /* synthetic */ SinglePath copy$default(SinglePath singlePath, PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    propertyNameAware = singlePath.currentValue;
                }
                if ((n & 2) != 0) {
                    propertyNameAware2 = singlePath.newValue;
                }
                if ((n & 4) != 0) {
                    list = singlePath.propertyPath;
                }
                return singlePath.copy(propertyNameAware, propertyNameAware2, list);
            }

            @NotNull
            public String toString() {
                return "SinglePath(currentValue=" + this.currentValue + ", newValue=" + this.newValue + ", propertyPath=" + this.propertyPath + ")";
            }

            public int hashCode() {
                int result = this.currentValue.hashCode();
                result = result * 31 + (this.newValue == null ? 0 : this.newValue.hashCode());
                result = result * 31 + ((Object)this.propertyPath).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SinglePath)) {
                    return false;
                }
                SinglePath singlePath = (SinglePath)other;
                if (!Intrinsics.areEqual((Object)this.currentValue, (Object)singlePath.currentValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.newValue, (Object)singlePath.newValue)) {
                    return false;
                }
                return Intrinsics.areEqual(this.propertyPath, singlePath.propertyPath);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$ValidatedItem;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem;", "currentValue", "Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "newValue", "propertyPath", "", "", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;Ljava/util/List;)V", "getCurrentValue", "()Lcom/swisscom/health/des/cdr/client/config/PropertyNameAware;", "getNewValue", "getPropertyPath", "()Ljava/util/List;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$MultiPath;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$NamedConfigurationItem$SinglePath;", "cdr-client-service"})
        public static abstract sealed class ValidatedItem
        implements NamedConfigurationItem
        permits MultiPath, SinglePath {
            @NotNull
            private final PropertyNameAware currentValue;
            @Nullable
            private final PropertyNameAware newValue;
            @NotNull
            private final List<String> propertyPath;

            /*
             * Unable to fully structure code
             */
            private ValidatedItem(PropertyNameAware currentValue, PropertyNameAware newValue, List<String> propertyPath) {
                super();
                this.currentValue = currentValue;
                this.newValue = newValue;
                this.propertyPath = propertyPath;
                if (this.getNewValue() == null) ** GOTO lbl-1000
                v0 = this.getCurrentValue().getClass();
                v1 = this.getNewValue();
                Intrinsics.checkNotNull((Object)v1);
                if (v0 == v1.getClass()) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!v2) {
                    $i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$1 = false;
                    v3 = Reflection.getOrCreateKotlinClass(this.getCurrentValue().getClass());
                    v4 = this.getNewValue();
                    Intrinsics.checkNotNull((Object)v4);
                    $i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$1 = "Current and new configuration items must be of the same type: '" + v3 + "' vs '" + Reflection.getOrCreateKotlinClass(v4.getClass()) + "'";
                    throw new IllegalArgumentException($i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$1.toString());
                }
                if (this.getNewValue() == null) ** GOTO lbl-1000
                v5 = this.getCurrentValue().getPropertyName();
                v6 = this.getNewValue();
                Intrinsics.checkNotNull((Object)v6);
                if (Intrinsics.areEqual((Object)v5, (Object)v6.getPropertyName())) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else {
                    v7 = false;
                }
                if (!v7) {
                    $i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$2 = false;
                    v8 = this.getCurrentValue().getPropertyName();
                    v9 = this.getNewValue();
                    Intrinsics.checkNotNull((Object)v9);
                    $i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$2 = "Current and new configuration items must have the same property name: '" + v8 + "' vs '" + v9.getPropertyName() + "'";
                    throw new IllegalArgumentException($i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$2.toString());
                }
                if (this.getNewValue() == null) ** GOTO lbl-1000
                v10 = this.getCurrentValue().getPropertyName();
                v11 = this.getNewValue();
                Intrinsics.checkNotNull((Object)v11);
                if (Intrinsics.areEqual((Object)v10, (Object)v11.getPropertyName())) lbl-1000:
                // 2 sources

                {
                    v12 = true;
                } else {
                    v12 = false;
                }
                if (!v12) {
                    $i$a$-require-ConfigurationWriter$NamedConfigurationItem$ValidatedItem$3 = false;
                    v13 = this.getCurrentValue().getPropertyName();
                    v14 = this.getNewValue();
                    Intrinsics.checkNotNull((Object)v14);
                    var4_9 = "Current and new configuration items must have the same property name but are: current: '" + v13 + "'; new '" + v14.getPropertyName() + "'";
                    throw new IllegalArgumentException(var4_9.toString());
                }
            }

            public /* synthetic */ ValidatedItem(PropertyNameAware propertyNameAware, PropertyNameAware propertyNameAware2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    propertyNameAware2 = null;
                }
                this(propertyNameAware, propertyNameAware2, list, null);
            }

            @Override
            @NotNull
            public PropertyNameAware getCurrentValue() {
                return this.currentValue;
            }

            @Override
            @Nullable
            public PropertyNameAware getNewValue() {
                return this.newValue;
            }

            @Override
            @NotNull
            public List<String> getPropertyPath() {
                return this.propertyPath;
            }

            public /* synthetic */ ValidatedItem(PropertyNameAware currentValue, PropertyNameAware newValue, List propertyPath, DefaultConstructorMarker $constructor_marker) {
                this(currentValue, newValue, propertyPath);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0003\u000b\f\rR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem;", "", "propertyPath", "", "getPropertyPath", "()Ljava/lang/String;", "currentValue", "getCurrentValue", "()Ljava/lang/Object;", "newValue", "getNewValue", "WritableSource", "AmbiguousWritableSource", "UnknownSource", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$AmbiguousWritableSource;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$UnknownSource;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$WritableSource;", "cdr-client-service"})
    public static sealed interface UpdatableConfigurationItem {
        @NotNull
        public String getPropertyPath();

        @NotNull
        public Object getCurrentValue();

        @NotNull
        public Object getNewValue();

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$AmbiguousWritableSource;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem;", "propertyPath", "", "currentValue", "", "newValue", "writableResources", "", "Lorg/springframework/core/io/WritableResource;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/List;)V", "getPropertyPath", "()Ljava/lang/String;", "getCurrentValue", "()Ljava/lang/Object;", "getNewValue", "getWritableResources", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "cdr-client-service"})
        @SourceDebugExtension(value={"SMAP\nConfigurationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationWriter.kt\ncom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$AmbiguousWritableSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,622:1\n1#2:623\n*E\n"})
        public static final class AmbiguousWritableSource
        implements UpdatableConfigurationItem {
            @NotNull
            private final String propertyPath;
            @NotNull
            private final Object currentValue;
            @NotNull
            private final Object newValue;
            @NotNull
            private final List<WritableResource> writableResources;

            public AmbiguousWritableSource(@NotNull String propertyPath, @NotNull Object currentValue, @NotNull Object newValue, @NotNull List<? extends WritableResource> writableResources) {
                Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter(writableResources, (String)"writableResources");
                this.propertyPath = propertyPath;
                this.currentValue = currentValue;
                this.newValue = newValue;
                this.writableResources = writableResources;
                if (!(this.writableResources.size() > 1)) {
                    boolean bl = false;
                    String string = "This type is used for multiple writable resources, but only one was provided";
                    throw new IllegalArgumentException(string.toString());
                }
            }

            @Override
            @NotNull
            public String getPropertyPath() {
                return this.propertyPath;
            }

            @Override
            @NotNull
            public Object getCurrentValue() {
                return this.currentValue;
            }

            @Override
            @NotNull
            public Object getNewValue() {
                return this.newValue;
            }

            @NotNull
            public final List<WritableResource> getWritableResources() {
                return this.writableResources;
            }

            @NotNull
            public final String component1() {
                return this.propertyPath;
            }

            @NotNull
            public final Object component2() {
                return this.currentValue;
            }

            @NotNull
            public final Object component3() {
                return this.newValue;
            }

            @NotNull
            public final List<WritableResource> component4() {
                return this.writableResources;
            }

            @NotNull
            public final AmbiguousWritableSource copy(@NotNull String propertyPath, @NotNull Object currentValue, @NotNull Object newValue, @NotNull List<? extends WritableResource> writableResources) {
                Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter(writableResources, (String)"writableResources");
                return new AmbiguousWritableSource(propertyPath, currentValue, newValue, writableResources);
            }

            public static /* synthetic */ AmbiguousWritableSource copy$default(AmbiguousWritableSource ambiguousWritableSource, String string, Object object, Object object2, List list, int n, Object object3) {
                if ((n & 1) != 0) {
                    string = ambiguousWritableSource.propertyPath;
                }
                if ((n & 2) != 0) {
                    object = ambiguousWritableSource.currentValue;
                }
                if ((n & 4) != 0) {
                    object2 = ambiguousWritableSource.newValue;
                }
                if ((n & 8) != 0) {
                    list = ambiguousWritableSource.writableResources;
                }
                return ambiguousWritableSource.copy(string, object, object2, list);
            }

            @NotNull
            public String toString() {
                return "AmbiguousWritableSource(propertyPath=" + this.propertyPath + ", currentValue=" + this.currentValue + ", newValue=" + this.newValue + ", writableResources=" + this.writableResources + ")";
            }

            public int hashCode() {
                int result = this.propertyPath.hashCode();
                result = result * 31 + this.currentValue.hashCode();
                result = result * 31 + this.newValue.hashCode();
                result = result * 31 + ((Object)this.writableResources).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AmbiguousWritableSource)) {
                    return false;
                }
                AmbiguousWritableSource ambiguousWritableSource = (AmbiguousWritableSource)other;
                if (!Intrinsics.areEqual((Object)this.propertyPath, (Object)ambiguousWritableSource.propertyPath)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.currentValue, (Object)ambiguousWritableSource.currentValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.newValue, (Object)ambiguousWritableSource.newValue)) {
                    return false;
                }
                return Intrinsics.areEqual(this.writableResources, ambiguousWritableSource.writableResources);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$UnknownSource;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem;", "propertyPath", "", "currentValue", "", "newValue", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "getPropertyPath", "()Ljava/lang/String;", "getCurrentValue", "()Ljava/lang/Object;", "getNewValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "cdr-client-service"})
        public static final class UnknownSource
        implements UpdatableConfigurationItem {
            @NotNull
            private final String propertyPath;
            @NotNull
            private final Object currentValue;
            @NotNull
            private final Object newValue;

            public UnknownSource(@NotNull String propertyPath, @NotNull Object currentValue, @NotNull Object newValue) {
                Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                this.propertyPath = propertyPath;
                this.currentValue = currentValue;
                this.newValue = newValue;
            }

            @Override
            @NotNull
            public String getPropertyPath() {
                return this.propertyPath;
            }

            @Override
            @NotNull
            public Object getCurrentValue() {
                return this.currentValue;
            }

            @Override
            @NotNull
            public Object getNewValue() {
                return this.newValue;
            }

            @NotNull
            public final String component1() {
                return this.propertyPath;
            }

            @NotNull
            public final Object component2() {
                return this.currentValue;
            }

            @NotNull
            public final Object component3() {
                return this.newValue;
            }

            @NotNull
            public final UnknownSource copy(@NotNull String propertyPath, @NotNull Object currentValue, @NotNull Object newValue) {
                Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                return new UnknownSource(propertyPath, currentValue, newValue);
            }

            public static /* synthetic */ UnknownSource copy$default(UnknownSource unknownSource, String string, Object object, Object object2, int n, Object object3) {
                if ((n & 1) != 0) {
                    string = unknownSource.propertyPath;
                }
                if ((n & 2) != 0) {
                    object = unknownSource.currentValue;
                }
                if ((n & 4) != 0) {
                    object2 = unknownSource.newValue;
                }
                return unknownSource.copy(string, object, object2);
            }

            @NotNull
            public String toString() {
                return "UnknownSource(propertyPath=" + this.propertyPath + ", currentValue=" + this.currentValue + ", newValue=" + this.newValue + ")";
            }

            public int hashCode() {
                int result = this.propertyPath.hashCode();
                result = result * 31 + this.currentValue.hashCode();
                result = result * 31 + this.newValue.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnknownSource)) {
                    return false;
                }
                UnknownSource unknownSource = (UnknownSource)other;
                if (!Intrinsics.areEqual((Object)this.propertyPath, (Object)unknownSource.propertyPath)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.currentValue, (Object)unknownSource.currentValue)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.newValue, (Object)unknownSource.newValue);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem$WritableSource;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdatableConfigurationItem;", "propertyPath", "", "currentValue", "", "newValue", "writableResource", "Lorg/springframework/core/io/WritableResource;", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Lorg/springframework/core/io/WritableResource;)V", "getPropertyPath", "()Ljava/lang/String;", "getCurrentValue", "()Ljava/lang/Object;", "getNewValue", "getWritableResource", "()Lorg/springframework/core/io/WritableResource;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "cdr-client-service"})
        public static final class WritableSource
        implements UpdatableConfigurationItem {
            @NotNull
            private final String propertyPath;
            @NotNull
            private final Object currentValue;
            @NotNull
            private final Object newValue;
            @NotNull
            private final WritableResource writableResource;

            public WritableSource(@NotNull String propertyPath, @NotNull Object currentValue, @NotNull Object newValue, @NotNull WritableResource writableResource) {
                Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter((Object)writableResource, (String)"writableResource");
                this.propertyPath = propertyPath;
                this.currentValue = currentValue;
                this.newValue = newValue;
                this.writableResource = writableResource;
            }

            @Override
            @NotNull
            public String getPropertyPath() {
                return this.propertyPath;
            }

            @Override
            @NotNull
            public Object getCurrentValue() {
                return this.currentValue;
            }

            @Override
            @NotNull
            public Object getNewValue() {
                return this.newValue;
            }

            @NotNull
            public final WritableResource getWritableResource() {
                return this.writableResource;
            }

            @NotNull
            public final String component1() {
                return this.propertyPath;
            }

            @NotNull
            public final Object component2() {
                return this.currentValue;
            }

            @NotNull
            public final Object component3() {
                return this.newValue;
            }

            @NotNull
            public final WritableResource component4() {
                return this.writableResource;
            }

            @NotNull
            public final WritableSource copy(@NotNull String propertyPath, @NotNull Object currentValue, @NotNull Object newValue, @NotNull WritableResource writableResource) {
                Intrinsics.checkNotNullParameter((Object)propertyPath, (String)"propertyPath");
                Intrinsics.checkNotNullParameter((Object)currentValue, (String)"currentValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter((Object)writableResource, (String)"writableResource");
                return new WritableSource(propertyPath, currentValue, newValue, writableResource);
            }

            public static /* synthetic */ WritableSource copy$default(WritableSource writableSource, String string, Object object, Object object2, WritableResource writableResource, int n, Object object3) {
                if ((n & 1) != 0) {
                    string = writableSource.propertyPath;
                }
                if ((n & 2) != 0) {
                    object = writableSource.currentValue;
                }
                if ((n & 4) != 0) {
                    object2 = writableSource.newValue;
                }
                if ((n & 8) != 0) {
                    writableResource = writableSource.writableResource;
                }
                return writableSource.copy(string, object, object2, writableResource);
            }

            @NotNull
            public String toString() {
                return "WritableSource(propertyPath=" + this.propertyPath + ", currentValue=" + this.currentValue + ", newValue=" + this.newValue + ", writableResource=" + this.writableResource + ")";
            }

            public int hashCode() {
                int result = this.propertyPath.hashCode();
                result = result * 31 + this.currentValue.hashCode();
                result = result * 31 + this.newValue.hashCode();
                result = result * 31 + this.writableResource.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WritableSource)) {
                    return false;
                }
                WritableSource writableSource = (WritableSource)other;
                if (!Intrinsics.areEqual((Object)this.propertyPath, (Object)writableSource.propertyPath)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.currentValue, (Object)writableSource.currentValue)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.newValue, (Object)writableSource.newValue)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.writableResource, (Object)writableSource.writableResource);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult;", "", "Success", "Failure", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult$Failure;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult$Success;", "cdr-client-service"})
    public static sealed interface UpdateResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult$Failure;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult;", "errors", "", "", "", "<init>", "(Ljava/util/Map;)V", "getErrors", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "cdr-client-service"})
        public static final class Failure
        implements UpdateResult {
            @NotNull
            private final Map<String, Object> errors;

            public Failure(@NotNull Map<String, ? extends Object> errors) {
                Intrinsics.checkNotNullParameter(errors, (String)"errors");
                this.errors = errors;
            }

            @NotNull
            public final Map<String, Object> getErrors() {
                return this.errors;
            }

            @NotNull
            public final Map<String, Object> component1() {
                return this.errors;
            }

            @NotNull
            public final Failure copy(@NotNull Map<String, ? extends Object> errors) {
                Intrinsics.checkNotNullParameter(errors, (String)"errors");
                return new Failure(errors);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, Map map2, int n, Object object) {
                if ((n & 1) != 0) {
                    map2 = failure.errors;
                }
                return failure.copy(map2);
            }

            @NotNull
            public String toString() {
                return "Failure(errors=" + this.errors + ")";
            }

            public int hashCode() {
                return ((Object)this.errors).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                return Intrinsics.areEqual(this.errors, failure.errors);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult$Success;", "Lcom/swisscom/health/des/cdr/client/handler/ConfigurationWriter$UpdateResult;", "<init>", "()V", "cdr-client-service"})
        public static final class Success
        implements UpdateResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileType.values().length];
            try {
                nArray[FileType.YAML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileType.PROPERTIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

