/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.scheduling;

import com.swisscom.health.des.cdr.client.handler.ClientSecretRenewalService;
import com.swisscom.health.des.cdr.client.handler.SchedulingValidationService;
import com.swisscom.health.des.cdr.client.handler.ShutdownService;
import com.swisscom.health.des.cdr.client.scheduling.ClientSecretRenewalSchedulerKt;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="client.idp-credentials", name={"renew-credential"}, havingValue="true")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0013J\b\u0010\u000e\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/swisscom/health/des/cdr/client/scheduling/ClientSecretRenewalScheduler;", "", "clientSecretRenewalService", "Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService;", "schedulingValidationService", "Lcom/swisscom/health/des/cdr/client/handler/SchedulingValidationService;", "shutdownService", "Lcom/swisscom/health/des/cdr/client/handler/ShutdownService;", "tracer", "Lio/micrometer/tracing/Tracer;", "<init>", "(Lcom/swisscom/health/des/cdr/client/handler/ClientSecretRenewalService;Lcom/swisscom/health/des/cdr/client/handler/SchedulingValidationService;Lcom/swisscom/health/des/cdr/client/handler/ShutdownService;Lio/micrometer/tracing/Tracer;)V", "reportIn", "", "renewClientSecret", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nClientSecretRenewalScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSecretRenewalScheduler.kt\ncom/swisscom/health/des/cdr/client/scheduling/ClientSecretRenewalScheduler\n+ 2 FileHandlingBase.kt\ncom/swisscom/health/des/cdr/client/handler/FileHandlingBaseKt\n*L\n1#1,62:1\n28#2,3:63\n*S KotlinDebug\n*F\n+ 1 ClientSecretRenewalScheduler.kt\ncom/swisscom/health/des/cdr/client/scheduling/ClientSecretRenewalScheduler\n*L\n43#1:63,3\n*E\n"})
public class ClientSecretRenewalScheduler {
    @NotNull
    private final ClientSecretRenewalService clientSecretRenewalService;
    @NotNull
    private final SchedulingValidationService schedulingValidationService;
    @NotNull
    private final ShutdownService shutdownService;
    @NotNull
    private final Tracer tracer;

    public ClientSecretRenewalScheduler(@NotNull ClientSecretRenewalService clientSecretRenewalService, @NotNull SchedulingValidationService schedulingValidationService, @NotNull ShutdownService shutdownService, @NotNull Tracer tracer) {
        Intrinsics.checkNotNullParameter((Object)clientSecretRenewalService, (String)"clientSecretRenewalService");
        Intrinsics.checkNotNullParameter((Object)schedulingValidationService, (String)"schedulingValidationService");
        Intrinsics.checkNotNullParameter((Object)shutdownService, (String)"shutdownService");
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        this.clientSecretRenewalService = clientSecretRenewalService;
        this.schedulingValidationService = schedulingValidationService;
        this.shutdownService = shutdownService;
        this.tracer = tracer;
    }

    @PostConstruct
    private void reportIn() {
        ClientSecretRenewalSchedulerKt.access$getLogger$p().info(ClientSecretRenewalScheduler::reportIn$lambda$0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Scheduled(fixedDelayString="#{ @'client-com.swisscom.health.des.cdr.client.config.CdrClientConfig'.getIdpCredentials().getMaxCredentialAge().toMillis() }", initialDelayString="#{ @'client-com.swisscom.health.des.cdr.client.config.CdrClientConfig'.getIdpCredentials().getMillisUntilNextCredentialRenewal() }")
    public void renewClientSecret() {
        void $this$withSpan$iv;
        Tracer tracer = this.tracer;
        String spanName$iv = "Renew Client Secret";
        boolean $i$f$withSpan = false;
        Span span = $this$withSpan$iv.spanBuilder().name(spanName$iv).start();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"start(...)");
        Span newSpan$iv = span;
        Closeable closeable = (Closeable)$this$withSpan$iv.withSpan(newSpan$iv);
        Throwable throwable = null;
        try {
            Tracer.SpanInScope it$iv = (Tracer.SpanInScope)closeable;
            boolean bl = false;
            boolean bl2 = false;
            if (this.schedulingValidationService.isSchedulingAllowed()) {
                ClientSecretRenewalService.RenewClientSecretResult result;
                ClientSecretRenewalSchedulerKt.access$getLogger$p().info(ClientSecretRenewalScheduler::renewClientSecret$lambda$0$0);
                ClientSecretRenewalService.RenewClientSecretResult renewClientSecretResult = result = this.clientSecretRenewalService.renewClientSecret();
                if (renewClientSecretResult instanceof ClientSecretRenewalService.RenewClientSecretResult.Success) {
                    ClientSecretRenewalSchedulerKt.access$getLogger$p().debug(ClientSecretRenewalScheduler::renewClientSecret$lambda$0$1);
                    ClientSecretRenewalSchedulerKt.access$getLogger$p().info(ClientSecretRenewalScheduler::renewClientSecret$lambda$0$2);
                    this.shutdownService.scheduleShutdown$cdr_client_service(ShutdownService.ShutdownTrigger.CONFIG_CHANGE);
                } else if (renewClientSecretResult instanceof ClientSecretRenewalService.RenewClientSecretResult.Failure) {
                    ClientSecretRenewalSchedulerKt.access$getLogger$p().error(ClientSecretRenewalScheduler::renewClientSecret$lambda$0$3);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Object reportIn$lambda$0() {
        return "Automatic client secret renewal is active!";
    }

    private static final Object renewClientSecret$lambda$0$0() {
        return "Renewing client secret...";
    }

    private static final Object renewClientSecret$lambda$0$1() {
        return "Refreshing Spring context due to configuration update";
    }

    private static final Object renewClientSecret$lambda$0$2() {
        return "Renewing client secret done.";
    }

    private static final Object renewClientSecret$lambda$0$3() {
        return "Failed to renew client secret";
    }
}

