/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.swisscom.health.des.cdr.client.common.DTOs;
import com.swisscom.health.des.cdr.client.common.DomainObjects;
import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.ConfigConverterKt;
import com.swisscom.health.des.cdr.client.handler.ConfigValidationServiceKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0011\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u0016\u0010\u0019\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010\u001a\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0012\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010)\u001a\u00020\u0011H\u0012J\u001a\u0010*\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\"H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0006\u0010\b\u00a8\u0006."}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService;", "", "config", "Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;", "<init>", "(Lcom/swisscom/health/des/cdr/client/config/CdrClientConfig;)V", "isConfigValid", "", "()Z", "isConfigValid$delegate", "Lkotlin/Lazy;", "validateAllConfigurationItems", "Lcom/swisscom/health/des/cdr/client/common/DTOs$ValidationResult;", "Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig;", "validateAvailableDiskspace", "connectors", "", "Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig$Connector;", "validateConnectorIsPresent", "customer", "validateConnectorIdIsPresent", "validateFileBusyTestTimeout", "fileBusyTestTimeout", "Ljava/time/Duration;", "fileBusyTestInterval", "validateModeValue", "validateModeOverlap", "validateDirectoryIsReadWritable", "path", "Ljava/nio/file/Path;", "validateIsNotBlankOrPlaceholder", "value", "", "configItem", "Lcom/swisscom/health/des/cdr/client/common/DomainObjects$ConfigurationItem;", "validateIsNotBlank", "validateDirectoryOverlap", "validateCredentialValues", "credentials", "Lcom/swisscom/health/des/cdr/client/common/DTOs$CdrClientConfig$IdpCredentials;", "validateConnectorFolders", "connector", "validateNotRequiredFolder", "folder", "configurationItem", "Companion", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nConfigValidationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigValidationService.kt\ncom/swisscom/health/des/cdr/client/handler/ConfigValidationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,422:1\n1869#2,2:423\n1803#2,3:425\n1761#2,3:428\n1803#2,3:431\n1491#2:434\n1516#2,3:435\n1519#2,3:445\n1550#2:458\n1803#2,3:463\n1563#2:466\n1634#2,3:467\n1563#2:470\n1634#2,3:471\n1550#2:474\n1563#2:482\n1634#2,3:483\n1563#2:486\n1634#2,3:487\n1803#2,3:491\n1563#2:500\n1634#2,3:501\n1563#2:504\n1634#2,3:505\n1563#2:508\n1634#2,3:509\n1374#2:512\n1460#2,2:513\n1617#2,9:515\n1869#2:524\n1870#2:526\n1626#2:527\n1462#2,3:528\n1563#2:531\n1634#2,3:532\n1374#2:535\n1460#2,2:536\n1617#2,9:538\n1869#2:547\n1870#2:549\n1626#2:550\n1462#2,3:551\n1374#2:554\n1460#2,5:555\n1563#2:560\n1634#2,3:561\n382#3,7:438\n536#3:448\n521#3,6:449\n536#3:475\n521#3,6:476\n126#4:455\n153#4,2:456\n188#4,3:459\n155#4:462\n77#4:494\n97#4,5:495\n1#5:490\n1#5:525\n1#5:548\n*S KotlinDebug\n*F\n+ 1 ConfigValidationService.kt\ncom/swisscom/health/des/cdr/client/handler/ConfigValidationService\n*L\n55#1:423,2\n59#1:425,3\n100#1:428,3\n128#1:431,3\n150#1:434\n150#1:435,3\n150#1:445,3\n153#1:458\n166#1:463,3\n277#1:466\n277#1:467,3\n292#1:470\n292#1:471,3\n306#1:474\n313#1:482\n313#1:483,3\n335#1:486\n335#1:487,3\n367#1:491,3\n213#1:500\n213#1:501,3\n220#1:504\n220#1:505,3\n234#1:508\n234#1:509,3\n240#1:512\n240#1:513,2\n241#1:515,9\n241#1:524\n241#1:526\n241#1:527\n240#1:528,3\n247#1:531\n247#1:532,3\n248#1:535\n248#1:536,2\n249#1:538,9\n249#1:547\n249#1:549\n249#1:550\n248#1:551,3\n255#1:554\n255#1:555,5\n264#1:560\n264#1:561,3\n150#1:438,7\n151#1:448\n151#1:449,6\n308#1:475\n308#1:476,6\n152#1:455\n152#1:456,2\n153#1:459,3\n152#1:462\n401#1:494\n401#1:495,5\n241#1:525\n249#1:548\n*E\n"})
public class ConfigValidationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CdrClientConfig config;
    @NotNull
    private final Lazy isConfigValid$delegate;
    @NotNull
    private static final String PLACEHOLDER_VALUE = "value-required";

    public ConfigValidationService(@NotNull CdrClientConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.isConfigValid$delegate = LazyKt.lazy(() -> ConfigValidationService.isConfigValid_delegate$lambda$0(this));
    }

    public boolean isConfigValid() {
        Lazy lazy = this.isConfigValid$delegate;
        return (Boolean)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DTOs.ValidationResult validateAllConfigurationItems(@NotNull DTOs.CdrClientConfig config) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List validations = new ArrayList();
        validations.add(this.validateDirectoryIsReadWritable(Path.of(config.getLocalFolder(), new String[0])));
        validations.add(this.validateDirectoryOverlap(config));
        validations.add(this.validateModeValue(config.getCustomer()));
        validations.add(this.validateModeOverlap(config.getCustomer()));
        validations.add(this.validateFileBusyTestTimeout(config.getFileBusyTestTimeout(), config.getFileBusyTestInterval()));
        validations.add(this.validateConnectorIsPresent(config.getCustomer()));
        validations.add(this.validateCredentialValues(config.getIdpCredentials()));
        validations.add(this.validateConnectorIdIsPresent(config.getCustomer()));
        Iterable $this$forEach$iv = config.getCustomer();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            DTOs.CdrClientConfig.Connector it = (DTOs.CdrClientConfig.Connector)element$iv;
            boolean bl = false;
            validations.addAll((Collection)this.validateConnectorFolders(it));
        }
        $this$forEach$iv = validations;
        DTOs.ValidationResult.Success $i$f$forEach22 = DTOs.ValidationResult.Success.INSTANCE;
        boolean $i$f$fold = false;
        DTOs.ValidationResult accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void validationResult;
            DTOs.ValidationResult validationResult2 = (DTOs.ValidationResult)element$iv;
            DTOs.ValidationResult acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus((DTOs.ValidationResult)validationResult);
        }
        void var3_3 = accumulator$iv;
        DTOs.ValidationResult it = (DTOs.ValidationResult)var3_3;
        boolean bl = false;
        if (it instanceof DTOs.ValidationResult.Failure) {
            ConfigValidationServiceKt.access$getLogger$p().warn(() -> ConfigValidationService.validateAllConfigurationItems$lambda$2$0(it));
        }
        return (DTOs.ValidationResult)var3_3;
    }

    @NotNull
    public DTOs.ValidationResult validateAvailableDiskspace(@NotNull List<DTOs.CdrClientConfig.Connector> connectors) {
        Intrinsics.checkNotNullParameter(connectors, (String)"connectors");
        ConfigValidationServiceKt.access$getLogger$p().trace(() -> ConfigValidationService.validateAvailableDiskspace$lambda$0(connectors));
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public DTOs.ValidationResult validateConnectorIsPresent(@Nullable List<DTOs.CdrClientConfig.Connector> customer) {
        Collection collection = customer;
        return collection == null || collection.isEmpty() ? (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConfigItemDetail(DomainObjects.ConfigurationItem.CONNECTOR, DTOs.ValidationMessageKey.NO_CONNECTOR_CONFIGURED))) : (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DTOs.ValidationResult validateConnectorIdIsPresent(@Nullable List<DTOs.CdrClientConfig.Connector> customer) {
        DTOs.ValidationResult validationResult;
        if (customer != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = customer;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DTOs.CdrClientConfig.Connector it = (DTOs.CdrClientConfig.Connector)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.isBlank((CharSequence)it.getConnectorId())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                validationResult = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConfigItemDetail(DomainObjects.ConfigurationItem.CONNECTOR, DTOs.ValidationMessageKey.NO_CONNECTOR_CONFIGURED)));
                return validationResult;
            }
        }
        validationResult = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        return validationResult;
    }

    @NotNull
    public DTOs.ValidationResult validateFileBusyTestTimeout(@NotNull Duration fileBusyTestTimeout, @NotNull Duration fileBusyTestInterval) {
        Intrinsics.checkNotNullParameter((Object)fileBusyTestTimeout, (String)"fileBusyTestTimeout");
        Intrinsics.checkNotNullParameter((Object)fileBusyTestInterval, (String)"fileBusyTestInterval");
        return fileBusyTestTimeout.compareTo(fileBusyTestInterval) <= 0 ? (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConfigItemDetail(DomainObjects.ConfigurationItem.FILE_BUSY_TEST_TIMEOUT, DTOs.ValidationMessageKey.FILE_BUSY_TEST_TIMEOUT_TOO_LONG))) : (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DTOs.ValidationResult validateModeValue(@NotNull List<DTOs.CdrClientConfig.Connector> connectors) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(connectors, (String)"connectors");
        Iterable iterable = connectors;
        DTOs.ValidationResult.Success initial$iv = DTOs.ValidationResult.Success.INSTANCE;
        boolean $i$f$fold = false;
        DTOs.ValidationResult.Success accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void connector;
            DTOs.CdrClientConfig.Connector connector2 = (DTOs.CdrClientConfig.Connector)element$iv;
            DTOs.ValidationResult acc = (DTOs.ValidationResult)accumulator$iv;
            boolean bl = false;
            accumulator$iv = switch (WhenMappings.$EnumSwitchMapping$0[connector.getMode().ordinal()]) {
                case 1, 2 -> acc;
                case 3 -> acc.plus((DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConnectorDetail(connector.getConnectorId(), DomainObjects.ConfigurationItem.CONNECTOR_MODE, DTOs.ValidationMessageKey.ILLEGAL_MODE))));
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return (DTOs.ValidationResult)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DTOs.ValidationResult validateModeOverlap(@NotNull List<DTOs.CdrClientConfig.Connector> connectors) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Map.Entry cd;
        Map $this$filterTo$iv$iv;
        boolean bl;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(connectors, (String)"connectors");
        Iterable $this$groupBy$iv = connectors;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object t = iterator.next();
            DTOs.CdrClientConfig.Connector it = (DTOs.CdrClientConfig.Connector)t;
            bl = false;
            String key$iv$iv = it.getConnectorId();
            Map map2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            cd = entry = (Map.Entry)iterator.next();
            bl = false;
            if (!(((List)cd.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            String connectorId;
            Object object;
            block9: {
                Map.Entry entry;
                cd = entry = (Map.Entry)iterator.next();
                object = destination$iv$iv;
                boolean bl3 = false;
                connectorId = (String)cd.getKey();
                List connectors2 = (List)cd.getValue();
                Iterable $this$groupingBy$iv = connectors2;
                boolean $i$f$groupingBy = false;
                Map $this$any$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<DTOs.CdrClientConfig.Connector, DTOs.CdrClientConfig.Mode>($this$groupingBy$iv){
                    final /* synthetic */ Iterable $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    public Iterator<DTOs.CdrClientConfig.Connector> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        DTOs.CdrClientConfig.Connector connector = (DTOs.CdrClientConfig.Connector)element;
                        boolean bl = false;
                        return connector.getMode();
                    }
                }));
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator2.next();
                        boolean bl4 = false;
                        if (!(((Number)it.getValue()).intValue() > 1)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            object.add(bl2 ? (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConnectorDetail(connectorId, DomainObjects.ConfigurationItem.CONNECTOR_MODE, DTOs.ValidationMessageKey.DUPLICATE_MODE))) : (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE);
        }
        $this$map$iv = (List)destination$iv$iv;
        DTOs.ValidationResult.Success initial$iv = DTOs.ValidationResult.Success.INSTANCE;
        boolean $i$f$fold = false;
        DTOs.ValidationResult.Success accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            DTOs.ValidationResult validationResult = (DTOs.ValidationResult)element$iv;
            DTOs.ValidationResult acc = (DTOs.ValidationResult)accumulator$iv;
            bl = false;
            accumulator$iv = acc.plus(validationResult);
        }
        return (DTOs.ValidationResult)accumulator$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public DTOs.ValidationResult validateDirectoryIsReadWritable(@Nullable Path path) {
        DTOs.ValidationResult validationResult;
        block6: {
            block5: {
                if (path == null) break block5;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block6;
            }
            validationResult = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.PathDetail(String.valueOf(path), DTOs.ValidationMessageKey.DIRECTORY_NOT_FOUND)));
            return validationResult;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            validationResult = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.PathDetail(((Object)path).toString(), DTOs.ValidationMessageKey.NOT_A_DIRECTORY)));
            return validationResult;
        }
        if (Files.isReadable(path) && Files.isWritable(path)) {
            validationResult = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
            return validationResult;
        }
        validationResult = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.PathDetail(((Object)path).toString(), DTOs.ValidationMessageKey.NOT_READ_WRITABLE)));
        return validationResult;
    }

    @NotNull
    public DTOs.ValidationResult validateIsNotBlankOrPlaceholder(@Nullable String value, @NotNull DomainObjects.ConfigurationItem configItem) {
        DTOs.ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)configItem, (String)"configItem");
        DTOs.ValidationResult valueIsNotBlank = this.validateIsNotBlank(value, configItem);
        if (valueIsNotBlank instanceof DTOs.ValidationResult.Success) {
            validationResult = Intrinsics.areEqual((Object)value, (Object)PLACEHOLDER_VALUE) ? (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConfigItemDetail(configItem, DTOs.ValidationMessageKey.VALUE_IS_PLACEHOLDER))) : (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        } else if (valueIsNotBlank instanceof DTOs.ValidationResult.Failure) {
            validationResult = valueIsNotBlank;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return validationResult;
    }

    @NotNull
    public DTOs.ValidationResult validateIsNotBlank(@Nullable String value, @NotNull DomainObjects.ConfigurationItem configItem) {
        Intrinsics.checkNotNullParameter((Object)configItem, (String)"configItem");
        CharSequence charSequence = value;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(CollectionsKt.listOf((Object)new DTOs.ValidationDetail.ConfigItemDetail(configItem, DTOs.ValidationMessageKey.VALUE_IS_BLANK))) : (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DTOs.ValidationResult validateDirectoryOverlap(@NotNull DTOs.CdrClientConfig config) {
        DTOs.ValidationResult validationResult;
        DTOs.ValidationResult validationResult2;
        Iterable iterable;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Map $this$groupingBy$iv;
        DTOs.ValidationResult validationResult3;
        DTOs.ValidationResult localDirSourceDirsOverlap;
        Iterable<DTOs.ValidationDetail.PathDetail> iterable2;
        Object object;
        Iterable<DTOs.ValidationDetail.PathDetail> destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List localDirectory = CollectionsKt.listOf((Object)Path.of(config.getLocalFolder(), new String[0]));
        List<Path> baseSourceFolders = ConfigValidationService.validateDirectoryOverlap$getAllBaseSourceFolders(config);
        List<Path> allSourceTypeFolders = ConfigValidationService.validateDirectoryOverlap$getAllSourceDocTypeFolders(config);
        List<Path> archiveAndErrorFolders = ConfigValidationService.validateDirectoryOverlap$getSourceArchiveAndErrorFolders(config);
        List<Path> baseTargetFolders = ConfigValidationService.validateDirectoryOverlap$getAllBaseTargetFolders(config);
        List<Path> allTargetTypeFolders = ConfigValidationService.validateDirectoryOverlap$getAllTargetDocTypeFolders(config);
        if (CollectionsKt.plus((Collection)baseSourceFolders, (Iterable)allSourceTypeFolders).containsAll(localDirectory)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = localDirectory;
            boolean $i$f$map = false;
            Iterable iterable3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                object = (Path)item$iv$iv;
                iterable2 = destination$iv$iv;
                boolean bl = false;
                iterable2.add(new DTOs.ValidationDetail.PathDetail(path.toString(), DTOs.ValidationMessageKey.LOCAL_DIR_OVERLAPS_WITH_SOURCE_DIRS));
            }
            List list = (List)destination$iv$iv;
            v0 = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(list);
        } else {
            v0 = localDirSourceDirsOverlap = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        }
        if (CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)baseTargetFolders, (Iterable)allTargetTypeFolders), (Iterable)archiveAndErrorFolders).containsAll(localDirectory)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = localDirectory;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                Path bl = (Path)item$iv$iv;
                iterable2 = destination$iv$iv2;
                boolean bl2 = false;
                iterable2.add((DTOs.ValidationDetail.PathDetail)new DTOs.ValidationDetail.PathDetail(path.toString(), DTOs.ValidationMessageKey.LOCAL_DIR_OVERLAPS_WITH_TARGET_DIRS));
            }
            List list = (List)destination$iv$iv2;
            validationResult3 = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(list);
        } else {
            validationResult3 = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        }
        DTOs.ValidationResult localDirTargetDirsOverlap = validationResult3;
        Iterable $i$f$map = CollectionsKt.plus((Collection)baseSourceFolders, (Iterable)allSourceTypeFolders);
        boolean $i$f$groupingBy = false;
        $this$groupingBy$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Path, Path>((Iterable)((Object)$this$groupingBy$iv)){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<Path> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                Path it = (Path)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filter = false;
        void destination$iv$iv2 = $this$filter$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        object = $this$filterTo$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = (Map.Entry)object.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 1)) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map duplicateSources = destination$iv$iv3;
        boolean bl = false;
        if (!duplicateSources.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = duplicateSources.keySet();
            boolean $i$f$map2 = false;
            Iterable it = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                Path path2 = (Path)item$iv$iv;
                iterable = destination$iv$iv4;
                boolean bl3 = false;
                iterable.add(new DTOs.ValidationDetail.PathDetail(path.toString(), DTOs.ValidationMessageKey.DUPLICATE_SOURCE_DIRS));
            }
            List list = (List)destination$iv$iv4;
            validationResult2 = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(list);
        } else {
            validationResult2 = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        }
        DTOs.ValidationResult sourceDirsOverlap = validationResult2;
        Set overlappingDirs = CollectionsKt.intersect((Iterable)CollectionsKt.plus((Collection)baseSourceFolders, (Iterable)allSourceTypeFolders), (Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)baseTargetFolders, (Iterable)allTargetTypeFolders), (Iterable)archiveAndErrorFolders));
        boolean bl4 = false;
        if (!((Collection)overlappingDirs).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = overlappingDirs;
            boolean $i$f$map3 = false;
            Iterable destination$iv$iv4 = $this$map$iv;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                iterable = (Path)item$iv$iv;
                Collection collection = destination$iv$iv5;
                boolean bl5 = false;
                collection.add(new DTOs.ValidationDetail.PathDetail(path.toString(), DTOs.ValidationMessageKey.TARGET_DIR_OVERLAPS_SOURCE_DIRS));
            }
            List list = (List)destination$iv$iv5;
            validationResult = (DTOs.ValidationResult)new DTOs.ValidationResult.Failure(list);
        } else {
            validationResult = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        }
        DTOs.ValidationResult targetDirsOverlapWithSourceDirs = validationResult;
        return localDirSourceDirsOverlap.plus(localDirTargetDirsOverlap).plus(sourceDirsOverlap).plus(targetDirsOverlapWithSourceDirs);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DTOs.ValidationResult validateCredentialValues(@NotNull DTOs.CdrClientConfig.IdpCredentials credentials) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        List validations = new ArrayList();
        DTOs.ValidationResult it = this.validateIsNotBlankOrPlaceholder(credentials.getClientId(), DomainObjects.ConfigurationItem.IDP_CLIENT_ID);
        boolean bl = false;
        validations.add(it);
        it = this.validateIsNotBlankOrPlaceholder(credentials.getClientSecret(), DomainObjects.ConfigurationItem.IDP_CLIENT_PASSWORD);
        boolean bl2 = false;
        validations.add(it);
        it = this.validateIsNotBlankOrPlaceholder(credentials.getTenantId(), DomainObjects.ConfigurationItem.IDP_TENANT_ID);
        boolean bl3 = false;
        validations.add(it);
        Iterable iterable = validations;
        it = DTOs.ValidationResult.Success.INSTANCE;
        boolean $i$f$fold = false;
        DTOs.ValidationResult accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void validationResult;
            DTOs.ValidationResult validationResult2 = (DTOs.ValidationResult)element$iv;
            DTOs.ValidationResult acc = accumulator$iv;
            boolean bl4 = false;
            accumulator$iv = acc.plus((DTOs.ValidationResult)validationResult);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<DTOs.ValidationResult> validateConnectorFolders(DTOs.CdrClientConfig.Connector connector) {
        void $this$flatMapTo$iv$iv;
        List list;
        Object[] objectArray = new DTOs.ValidationResult[]{this.validateDirectoryIsReadWritable(Path.of(connector.getSourceFolder(), new String[0])), this.validateDirectoryIsReadWritable(Path.of(connector.getTargetFolder(), new String[0]))};
        List baseValidations = CollectionsKt.listOf((Object[])objectArray);
        if (connector.getSourceArchiveEnabled()) {
            List list2;
            DTOs.ValidationResult placeholderValidation = this.validateIsNotBlankOrPlaceholder(connector.getSourceArchiveFolder(), DomainObjects.ConfigurationItem.ARCHIVE_DIRECTORY);
            Collection collection = CollectionsKt.listOf((Object)placeholderValidation);
            if (placeholderValidation instanceof DTOs.ValidationResult.Success) {
                String string = connector.getSourceArchiveFolder();
                Intrinsics.checkNotNull((Object)string);
                list2 = CollectionsKt.listOf((Object)this.validateDirectoryIsReadWritable(Path.of(string, new String[0])));
            } else {
                list2 = CollectionsKt.emptyList();
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        } else {
            list = CollectionsKt.emptyList();
        }
        List archiveValidations = list;
        List errorValidation = CollectionsKt.listOf((Object)this.validateNotRequiredFolder(connector.getSourceErrorFolder(), DomainObjects.ConfigurationItem.ERROR_DIRECTORY));
        Map $this$flatMap$iv = connector.getDocTypeFolders();
        boolean $i$f$flatMap = false;
        Map map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            DTOs.CdrClientConfig.Connector.DocTypeFolders docTypeFolder = (DTOs.CdrClientConfig.Connector.DocTypeFolders)entry.getValue();
            Object[] objectArray2 = new DTOs.ValidationResult[]{this.validateNotRequiredFolder(docTypeFolder.getSourceFolder(), DomainObjects.ConfigurationItem.DOC_TYPE_SOURCE_DIRECTORY), this.validateNotRequiredFolder(docTypeFolder.getTargetFolder(), DomainObjects.ConfigurationItem.DOC_TYPE_TARGET_DIRECTORY)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List docTypeValidations = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)baseValidations, (Iterable)archiveValidations), (Iterable)errorValidation), (Iterable)docTypeValidations);
    }

    private DTOs.ValidationResult validateNotRequiredFolder(String folder, DomainObjects.ConfigurationItem configurationItem) {
        DTOs.ValidationResult validationResult;
        DTOs.ValidationResult validationResult2 = this.validateIsNotBlank(folder, configurationItem);
        if (validationResult2 instanceof DTOs.ValidationResult.Success) {
            String string = folder;
            Intrinsics.checkNotNull((Object)string);
            validationResult = this.validateDirectoryIsReadWritable(Path.of(string, new String[0]));
        } else if (validationResult2 instanceof DTOs.ValidationResult.Failure) {
            validationResult = (DTOs.ValidationResult)DTOs.ValidationResult.Success.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return validationResult;
    }

    private static final boolean isConfigValid_delegate$lambda$0(ConfigValidationService this$0) {
        return this$0.validateAllConfigurationItems(ConfigConverterKt.toDto(this$0.config)) instanceof DTOs.ValidationResult.Success;
    }

    private static final Object validateAllConfigurationItems$lambda$2$0(DTOs.ValidationResult $it) {
        return StringsKt.trimMargin$default((String)("\n                    |#############################################################################################\n                    |#############################################################################################\n                    |No file upload/download will be possible due to configuration validation failure.\n                    |Details: " + ((DTOs.ValidationResult.Failure)$it).getValidationDetails() + ".\n                    |#############################################################################################\n                    |#############################################################################################\n                    |"), null, (int)1, null);
    }

    private static final Object validateAvailableDiskspace$lambda$0(List $connectors) {
        return "Validating available disk space for connectors: " + $connectors;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> validateDirectoryOverlap$getAllBaseSourceFolders(DTOs.CdrClientConfig $config) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $config.getCustomer();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void connector;
            Path path;
            DTOs.CdrClientConfig.Connector connector2 = (DTOs.CdrClientConfig.Connector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path it = path = Path.of(connector.getSourceFolder(), new String[0]);
            boolean bl2 = false;
            ConfigValidationServiceKt.access$getLogger$p().debug(() -> ConfigValidationService.validateDirectoryOverlap$getAllBaseSourceFolders$lambda$0$0$0((DTOs.CdrClientConfig.Connector)connector));
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    private static final Object validateDirectoryOverlap$getAllBaseSourceFolders$lambda$0$0$0(DTOs.CdrClientConfig.Connector $connector) {
        return "connector [" + $connector.getConnectorId() + "-" + $connector.getMode() + "] base source folder: [" + $connector.getSourceFolder() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> validateDirectoryOverlap$getAllBaseTargetFolders(DTOs.CdrClientConfig $config) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $config.getCustomer();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void connector;
            Path path;
            DTOs.CdrClientConfig.Connector connector2 = (DTOs.CdrClientConfig.Connector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path it = path = Path.of(connector.getTargetFolder(), new String[0]);
            boolean bl2 = false;
            ConfigValidationServiceKt.access$getLogger$p().debug(() -> ConfigValidationService.validateDirectoryOverlap$getAllBaseTargetFolders$lambda$1$0$0((DTOs.CdrClientConfig.Connector)connector));
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    private static final Object validateDirectoryOverlap$getAllBaseTargetFolders$lambda$1$0$0(DTOs.CdrClientConfig.Connector $connector) {
        return "connector [" + $connector.getConnectorId() + "-" + $connector.getMode() + "] base target folder: [" + $connector.getTargetFolder() + "]";
    }

    private static final Path validateDirectoryOverlap$effectiveSourceFolder(DTOs.CdrClientConfig.Connector.DocTypeFolders docTypeFolders, Path sourceFolder) {
        Path path;
        String string = docTypeFolders.getSourceFolder();
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = sourceFolder.resolve(it);
        } else {
            path = null;
        }
        return path;
    }

    private static final Path validateDirectoryOverlap$effectiveTargetFolder(DTOs.CdrClientConfig.Connector.DocTypeFolders docTypeFolders, Path targetFolder) {
        Path path;
        String string = docTypeFolders.getTargetFolder();
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = targetFolder.resolve(it);
        } else {
            path = null;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> validateDirectoryOverlap$getAllSourceDocTypeFolders(DTOs.CdrClientConfig $config) {
        void $this$flatMapTo$iv$iv;
        Pair connector;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $config.getCustomer();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            DTOs.CdrClientConfig.Connector connector2 = (DTOs.CdrClientConfig.Connector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair it = pair = TuplesKt.to((Object)connector.getSourceFolder(), connector.getDocTypeFolders().values());
            boolean bl2 = false;
            ConfigValidationServiceKt.access$getLogger$p().debug(() -> ConfigValidationService.validateDirectoryOverlap$getAllSourceDocTypeFolders$lambda$4$0$0((DTOs.CdrClientConfig.Connector)connector));
            collection.add(pair);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            connector = (Pair)element$iv$iv;
            boolean bl = false;
            String sourceFolder = (String)connector.component1();
            Collection docTypeFolders = (Collection)connector.component2();
            Iterable $this$mapNotNull$iv = docTypeFolders;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Path it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                DTOs.CdrClientConfig.Connector.DocTypeFolders it = (DTOs.CdrClientConfig.Connector.DocTypeFolders)element$iv$iv2;
                boolean bl4 = false;
                Path path = Path.of(sourceFolder, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                if (ConfigValidationService.validateDirectoryOverlap$effectiveSourceFolder(it, path) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Object validateDirectoryOverlap$getAllSourceDocTypeFolders$lambda$4$0$0(DTOs.CdrClientConfig.Connector $connector) {
        return "connector [" + $connector.getConnectorId() + "-" + $connector.getMode() + "] doctype directories: [" + $connector.getDocTypeFolders() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> validateDirectoryOverlap$getAllTargetDocTypeFolders(DTOs.CdrClientConfig $config) {
        void $this$flatMapTo$iv$iv;
        Pair connector;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = $config.getCustomer();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DTOs.CdrClientConfig.Connector connector2 = (DTOs.CdrClientConfig.Connector)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)connector.getTargetFolder(), connector.getDocTypeFolders().values()));
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            connector = (Pair)element$iv$iv;
            boolean bl = false;
            String targetFolder = (String)connector.component1();
            Collection docTypeFolders = (Collection)connector.component2();
            Iterable $this$mapNotNull$iv = docTypeFolders;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Path it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                DTOs.CdrClientConfig.Connector.DocTypeFolders it = (DTOs.CdrClientConfig.Connector.DocTypeFolders)element$iv$iv2;
                boolean bl3 = false;
                Path path = Path.of(targetFolder, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                if (ConfigValidationService.validateDirectoryOverlap$effectiveTargetFolder(it, path) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> validateDirectoryOverlap$getSourceArchiveAndErrorFolders(DTOs.CdrClientConfig $config) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $config.getCustomer();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DTOs.CdrClientConfig.Connector connector = (DTOs.CdrClientConfig.Connector)element$iv$iv;
            boolean bl = false;
            Object object = new String[]{connector.getSourceArchiveFolder(), connector.getSourceErrorFolder()};
            Object it = object = CollectionsKt.listOf((Object[])object);
            boolean bl2 = false;
            ConfigValidationServiceKt.access$getLogger$p().debug(() -> ConfigValidationService.validateDirectoryOverlap$getSourceArchiveAndErrorFolders$lambda$8$0$0(connector));
            list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it;
            if (string == null) {
                string = "";
            }
            collection.add(Path.of(string, new String[0]));
        }
        return (List)destination$iv$iv;
    }

    private static final Object validateDirectoryOverlap$getSourceArchiveAndErrorFolders$lambda$8$0$0(DTOs.CdrClientConfig.Connector $connector) {
        return "connector [" + $connector.getConnectorId() + "-" + $connector.getMode() + "] source archive folder: [" + $connector.getSourceArchiveFolder() + "], source error folder: [" + $connector.getSourceErrorFolder() + "]";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/ConfigValidationService$Companion;", "", "<init>", "()V", "PLACEHOLDER_VALUE", "", "cdr-client-service"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DTOs.CdrClientConfig.Mode.values().length];
            try {
                nArray[DTOs.CdrClientConfig.Mode.TEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DTOs.CdrClientConfig.Mode.PRODUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DTOs.CdrClientConfig.Mode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

