/*
 * Decompiled with CFR 0.152.
 */
package com.swisscom.health.des.cdr.client.handler;

import com.swisscom.health.des.cdr.client.config.CdrClientConfig;
import com.swisscom.health.des.cdr.client.config.Connector;
import com.swisscom.health.des.cdr.client.config.ConnectorId;
import com.swisscom.health.des.cdr.client.handler.CdrApiClient;
import com.swisscom.health.des.cdr.client.handler.FileHandlingBaseKt;
import com.swisscom.health.des.cdr.client.handler.PullFileHandlingKt;
import com.swisscom.health.des.cdr.client.xml.DocumentType;
import com.swisscom.health.des.cdr.client.xml.XmlUtil;
import com.swisscom.health.des.cdr.client.xml.XmlUtilKt;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0012J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/swisscom/health/des/cdr/client/handler/PullFileHandling;", "", "tracer", "Lio/micrometer/tracing/Tracer;", "cdrApiClient", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;", "xmlParser", "Lcom/swisscom/health/des/cdr/client/xml/XmlUtil;", "<init>", "(Lio/micrometer/tracing/Tracer;Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient;Lcom/swisscom/health/des/cdr/client/xml/XmlUtil;)V", "pullSyncConnector", "", "connector", "Lcom/swisscom/health/des/cdr/client/config/Connector;", "(Lcom/swisscom/health/des/cdr/client/config/Connector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryDownloadNextDocument", "Lcom/swisscom/health/des/cdr/client/handler/CdrApiClient$DownloadDocumentResult;", "moveFileToClientDirectory", "file", "Ljava/nio/file/Path;", "cdr-client-service"})
@SourceDebugExtension(value={"SMAP\nPullFileHandling.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PullFileHandling.kt\ncom/swisscom/health/des/cdr/client/handler/PullFileHandling\n+ 2 FileHandlingBase.kt\ncom/swisscom/health/des/cdr/client/handler/FileHandlingBaseKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n28#2,3:150\n1#3:153\n*S KotlinDebug\n*F\n+ 1 PullFileHandling.kt\ncom/swisscom/health/des/cdr/client/handler/PullFileHandling\n*L\n39#1:150,3\n*E\n"})
public class PullFileHandling {
    @NotNull
    private final Tracer tracer;
    @NotNull
    private final CdrApiClient cdrApiClient;
    @NotNull
    private final XmlUtil xmlParser;

    public PullFileHandling(@NotNull Tracer tracer, @NotNull CdrApiClient cdrApiClient, @NotNull XmlUtil xmlParser) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        Intrinsics.checkNotNullParameter((Object)cdrApiClient, (String)"cdrApiClient");
        Intrinsics.checkNotNullParameter((Object)xmlParser, (String)"xmlParser");
        this.tracer = tracer;
        this.cdrApiClient = cdrApiClient;
        this.xmlParser = xmlParser;
    }

    @Nullable
    public Object pullSyncConnector(@NotNull Connector connector, @NotNull Continuation<? super Unit> $completion) {
        return PullFileHandling.pullSyncConnector$suspendImpl(this, connector, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ Object pullSyncConnector$suspendImpl(PullFileHandling $this, Connector connector, Continuation<? super Unit> $completion) {
        void $this$withSpan$iv;
        Tracer tracer = $this.tracer;
        String spanName$iv = "Pull Sync Connector " + ConnectorId.toString-impl(connector.getConnectorId-3VxJTic());
        boolean $i$f$withSpan = false;
        Span span = $this$withSpan$iv.spanBuilder().name(spanName$iv).start();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"start(...)");
        Span newSpan$iv = span;
        Closeable closeable = (Closeable)$this$withSpan$iv.withSpan(newSpan$iv);
        Throwable throwable = null;
        try {
            Object $this$pullSyncConnector_u24lambda_u240_u241;
            Tracer.SpanInScope it$iv = (Tracer.SpanInScope)closeable;
            boolean bl = false;
            boolean bl2 = false;
            PullFileHandlingKt.access$getLogger$p().info(() -> PullFileHandling.pullSyncConnector$lambda$0$0(connector));
            Ref.IntRef counter = new Ref.IntRef();
            Object object = $this;
            try {
                CdrApiClient.DownloadDocumentResult result;
                $this$pullSyncConnector_u24lambda_u240_u241 = object;
                boolean bl3 = false;
                while (true) {
                    if (!FileHandlingBaseKt.pathIsDirectoryAndWritable(connector.getTargetFolder(), "pulled", PullFileHandlingKt.access$getLogger$p())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    result = super.tryDownloadNextDocument(connector);
                    if (!(result instanceof CdrApiClient.DownloadDocumentResult.Success)) break;
                    int n = counter.element;
                    counter.element = n + 1;
                }
                if (!(result instanceof CdrApiClient.DownloadDocumentResult.NoDocumentPending)) {
                    if (result instanceof CdrApiClient.DownloadDocumentResult.Error) {
                        throw new IllegalStateException("Error while downloading file for connector '" + ConnectorId.toString-impl(connector.getConnectorId-3VxJTic()) + "'", ((CdrApiClient.DownloadDocumentResult.Error)result).getT());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                $this$pullSyncConnector_u24lambda_u240_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                $this$pullSyncConnector_u24lambda_u240_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object = $this$pullSyncConnector_u24lambda_u240_u241;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) {
                it = (Unit)object;
                boolean bl4 = false;
                PullFileHandlingKt.access$getLogger$p().info(() -> PullFileHandling.pullSyncConnector$lambda$0$2$0(counter));
            } else {
                it = throwable2;
                boolean bl5 = false;
                PullFileHandlingKt.access$getLogger$p().info(() -> PullFileHandling.pullSyncConnector$lambda$0$3$0(counter));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private CdrApiClient.DownloadDocumentResult tryDownloadNextDocument(Connector connector) {
        CdrApiClient.DownloadDocumentResult downloadDocumentResult;
        String string = connector.getConnectorId-3VxJTic();
        CdrClientConfig.Mode mode = connector.getMode();
        Object object = this.tracer.currentSpan();
        if (object == null || (object = object.context()) == null || (object = object.traceId()) == null) {
            object = "";
        }
        CdrApiClient.DownloadDocumentResult downloadResult = this.cdrApiClient.downloadDocument(string, mode, (String)object);
        boolean bl = false;
        if (downloadResult instanceof CdrApiClient.DownloadDocumentResult.DownloadSuccess) {
            String string2 = connector.getConnectorId-3VxJTic();
            CdrClientConfig.Mode mode2 = connector.getMode();
            String string3 = ((CdrApiClient.DownloadDocumentResult.DownloadSuccess)downloadResult).getPullResultId();
            Object object2 = this.tracer.currentSpan();
            if (object2 == null || (object2 = object2.context()) == null || (object2 = object2.traceId()) == null) {
                object2 = "";
            }
            CdrApiClient.DownloadDocumentResult ackResult = this.cdrApiClient.acknowledgeDocumentDownload(string2, mode2, string3, (String)object2);
            boolean bl2 = false;
            if (ackResult instanceof CdrApiClient.DownloadDocumentResult.AcknowledgeSuccess) {
                this.moveFileToClientDirectory(connector, ((CdrApiClient.DownloadDocumentResult.DownloadSuccess)downloadResult).getFile());
            }
            downloadDocumentResult = ackResult;
        } else {
            downloadDocumentResult = downloadResult;
        }
        return downloadDocumentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFileToClientDirectory(Connector connector, Path file) {
        Object object;
        Object $this$moveFileToClientDirectory_u24lambda_u246;
        Object it;
        Object it2;
        CopyOption[] copyOptionArray;
        Object object2;
        Object object3;
        block23: {
            DocumentType documentType;
            block24: {
                DocumentType documentType2;
                Object $this$moveFileToClientDirectory_u24lambda_u241;
                block22: {
                    PullFileHandlingKt.access$getLogger$p().debug(PullFileHandling::moveFileToClientDirectory$lambda$0);
                    if (!connector.getEffectiveDocTypeFolders().isEmpty()) break block22;
                    object3 = connector.getTargetFolder();
                    break block23;
                }
                object2 = this;
                try {
                    Document document;
                    $this$moveFileToClientDirectory_u24lambda_u241 = object2;
                    boolean bl = false;
                    XmlUtil xmlUtil = ((PullFileHandling)$this$moveFileToClientDirectory_u24lambda_u241).xmlParser;
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    Closeable closeable = inputStream;
                    XmlUtil xmlUtil2 = xmlUtil;
                    copyOptionArray = null;
                    try {
                        InputStream it3 = (InputStream)closeable;
                        boolean bl2 = false;
                        document = XmlUtilKt.toDom(it3);
                    }
                    catch (Throwable object4) {
                        copyOptionArray = object4;
                        throw object4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)copyOptionArray);
                    }
                    $this$moveFileToClientDirectory_u24lambda_u241 = Result.constructor-impl((Object)((Object)xmlUtil2.findSchemaDefinition(document)));
                }
                catch (Throwable bl) {
                    $this$moveFileToClientDirectory_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$moveFileToClientDirectory_u24lambda_u241;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    it2 = (DocumentType)((Object)object2);
                    boolean bl = false;
                    documentType2 = it2;
                } else {
                    Throwable e = throwable;
                    boolean bl = false;
                    PullFileHandlingKt.access$getLogger$p().error(() -> PullFileHandling.moveFileToClientDirectory$lambda$3$0(file, e));
                    documentType2 = DocumentType.UNDEFINED;
                }
                documentType = documentType2;
                object3 = connector.getEffectiveDocTypeFolders().get((Object)documentType);
                if (object3 == null) break block24;
                Object docTypeFolder = object3;
                boolean bl = false;
                Path path = connector.effectiveTargetFolder((Connector.DocTypeFolders)docTypeFolder);
                object3 = path;
                if (path != null) break block23;
            }
            Path bl = connector.getTargetFolder();
            it = bl;
            boolean bl3 = false;
            PullFileHandlingKt.access$getLogger$p().debug(() -> PullFileHandling.moveFileToClientDirectory$lambda$5$0(documentType));
            object3 = bl;
        }
        Path targetDir = object3;
        Path targetTmpFile = targetDir.resolve(PathsKt.getName((Path)file));
        object2 = this;
        try {
            $this$moveFileToClientDirectory_u24lambda_u246 = (PullFileHandling)object2;
            boolean bl = false;
            it = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(file, targetTmpFile, (CopyOption[])it);
            PullFileHandlingKt.access$getLogger$p().debug(PullFileHandling::moveFileToClientDirectory$lambda$6$0);
            $this$moveFileToClientDirectory_u24lambda_u246 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$moveFileToClientDirectory_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$moveFileToClientDirectory_u24lambda_u246;
        if (Result.isSuccess-impl((Object)object2)) {
            Object bl;
            $this$moveFileToClientDirectory_u24lambda_u246 = object2;
            try {
                bl = $this$moveFileToClientDirectory_u24lambda_u246;
                it = (Unit)bl;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)targetTmpFile);
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                bl = Result.constructor-impl((Object)Files.move(targetTmpFile, targetTmpFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)targetTmpFile) + ".xml"), copyOptionArray));
            }
            catch (Throwable throwable) {
                bl = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = bl;
        } else {
            object = Result.constructor-impl((Object)object2);
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            it2 = (Path)object2;
            boolean bl = false;
            PullFileHandlingKt.access$getLogger$p().debug(() -> PullFileHandling.moveFileToClientDirectory$lambda$8$0(file, targetTmpFile));
        } else {
            Throwable t = throwable;
            boolean bl = false;
            PullFileHandlingKt.access$getLogger$p().error(() -> PullFileHandling.moveFileToClientDirectory$lambda$9$0(file, connector, t));
        }
    }

    private static final Object pullSyncConnector$lambda$0$0(Connector $connector) {
        return "Sync connector '" + ConnectorId.toString-impl($connector.getConnectorId-3VxJTic()) + "' (" + $connector.getMode() + ") - pulling";
    }

    private static final Object pullSyncConnector$lambda$0$2$0(Ref.IntRef $counter) {
        return "Sync connector done - '" + $counter.element + "' file(s) pulled";
    }

    private static final Object pullSyncConnector$lambda$0$3$0(Ref.IntRef $counter) {
        return "Synced '" + $counter.element + "' file(s) before exception happened";
    }

    private static final Object moveFileToClientDirectory$lambda$0() {
        return "Move file to target directory start";
    }

    private static final Object moveFileToClientDirectory$lambda$3$0(Path $file, Throwable $e) {
        return "Failed to determine document type of file '" + $file + "': " + $e.getMessage();
    }

    private static final Object moveFileToClientDirectory$lambda$5$0(DocumentType $documentType) {
        return "No specific target directory defined for files of type '" + $documentType + "'";
    }

    private static final Object moveFileToClientDirectory$lambda$6$0() {
        return "Move file to target directory done";
    }

    private static final Object moveFileToClientDirectory$lambda$8$0(Path $file, Path $targetTmpFile) {
        Intrinsics.checkNotNull((Object)$targetTmpFile);
        return "Moved file '" + $file + "' to '" + $targetTmpFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)$targetTmpFile) + ".xml") + "'";
    }

    private static final Object moveFileToClientDirectory$lambda$9$0(Path $file, Connector $connector, Throwable $t) {
        return "Unable to move file '" + $file + "' to '" + $connector.getTargetFolder() + "': " + $t.getMessage();
    }
}

