/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Marker;

class LogstashBasicMarker
implements Marker {
    private final String name;
    private volatile List<Marker> referenceList;

    LogstashBasicMarker(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Marker reference) {
        Objects.requireNonNull(reference);
        if (this.contains(reference)) {
            return;
        }
        if (reference.contains((Marker)this)) {
            return;
        }
        if (this.referenceList == null) {
            LogstashBasicMarker logstashBasicMarker = this;
            synchronized (logstashBasicMarker) {
                if (this.referenceList == null) {
                    this.referenceList = new CopyOnWriteArrayList<Marker>();
                }
            }
        }
        this.referenceList.add(reference);
    }

    public boolean hasReferences() {
        return this.referenceList != null && !this.referenceList.isEmpty();
    }

    @Deprecated
    public boolean hasChildren() {
        return this.hasReferences();
    }

    public Iterator<Marker> iterator() {
        if (this.referenceList == null) {
            return Collections.emptyIterator();
        }
        return this.referenceList.iterator();
    }

    public boolean remove(Marker referenceToRemove) {
        if (this.referenceList != null) {
            return this.referenceList.remove(referenceToRemove);
        }
        return false;
    }

    public boolean contains(Marker other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker ref : this.referenceList) {
                if (!ref.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name) {
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            for (Marker ref : this.referenceList) {
                if (!ref.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder(this.getName()).append(" [ ");
        Iterator<Marker> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" ]");
        return sb.toString();
    }
}

