/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.lib.mac;

import androidx.compose.runtime.internal.StabilityInferred;
import com.kdroid.composetray.lib.mac.ApplicationServices;
import com.kdroid.composetray.utils.TrayPositionKt;
import io.github.kdroidfilter.platformtools.OperatingSystem;
import io.github.kdroidfilter.platformtools.OsProvider_jvmKt;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B%\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\u0006\u0010\u0010\u001a\u00020\u0007J\b\u0010\u0011\u001a\u00020\u0007H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/kdroid/composetray/lib/mac/MacOutsideClickWatcher;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "windowSupplier", "Lkotlin/Function0;", "Ljava/awt/Window;", "onOutsideClick", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "prevLeft", "", "start", "pollOnce", "stop", "close", "ComposeNativeTray"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMacOutsideClickWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOutsideClickWatcher.kt\ncom/kdroid/composetray/lib/mac/MacOutsideClickWatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class MacOutsideClickWatcher
implements AutoCloseable {
    @NotNull
    private final Function0<Window> windowSupplier;
    @NotNull
    private final Function0<Unit> onOutsideClick;
    @Nullable
    private ScheduledExecutorService scheduler;
    private boolean prevLeft;
    public static final int $stable = 8;

    public MacOutsideClickWatcher(@NotNull Function0<? extends Window> windowSupplier, @NotNull Function0<Unit> onOutsideClick) {
        Intrinsics.checkNotNullParameter(windowSupplier, (String)"windowSupplier");
        Intrinsics.checkNotNullParameter(onOutsideClick, (String)"onOutsideClick");
        this.windowSupplier = windowSupplier;
        this.onOutsideClick = onOutsideClick;
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void exec;
        ScheduledExecutorService scheduledExecutorService;
        if (OsProvider_jvmKt.getOperatingSystem() != OperatingSystem.MACOS) {
            return;
        }
        if (this.scheduler != null) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(MacOutsideClickWatcher::start$lambda$0);
        MacOutsideClickWatcher macOutsideClickWatcher = this;
        boolean bl = false;
        exec.scheduleAtFixedRate(() -> MacOutsideClickWatcher.start$lambda$1$0(this), 0L, 16L, TimeUnit.MILLISECONDS);
        macOutsideClickWatcher.scheduler = scheduledExecutorService;
    }

    private final void pollOnce() {
        try {
            Window win;
            ApplicationServices asvc = ApplicationServices.Companion.getINSTANCE();
            boolean left = asvc.CGEventSourceButtonState(0, 0);
            if (left && left != this.prevLeft && (win = (Window)this.windowSupplier.invoke()) != null && win.isShowing()) {
                Point loc;
                PointerInfo pointer;
                PointerInfo pointerInfo;
                try {
                    pointerInfo = MouseInfo.getPointerInfo();
                }
                catch (Throwable throwable) {
                    pointerInfo = null;
                }
                PointerInfo pointerInfo2 = pointer = pointerInfo;
                Point point = loc = pointerInfo2 != null ? pointerInfo2.getLocation() : null;
                if (loc != null) {
                    Point point2;
                    int px = loc.x;
                    int py = loc.y;
                    try {
                        point2 = win.getLocationOnScreen();
                    }
                    catch (Throwable throwable) {
                        point2 = null;
                    }
                    Point winLoc = point2;
                    if (winLoc != null) {
                        int wx = winLoc.x;
                        int wy = winLoc.y;
                        int ww = win.getWidth();
                        int wh = win.getHeight();
                        boolean insideWindow = px >= wx && px < wx + ww && py >= wy && py < wy + wh;
                        boolean onTrayIcon = TrayPositionKt.isPointWithinMacStatusItem(px, py);
                        if (!insideWindow && !onTrayIcon) {
                            this.onOutsideClick.invoke();
                        }
                    }
                }
            }
            this.prevLeft = left;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void stop() {
        this.close();
    }

    @Override
    public void close() {
        try {
            ScheduledExecutorService scheduledExecutorService = this.scheduler;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.scheduler = null;
    }

    private static final Thread start$lambda$0(Runnable r) {
        Thread thread;
        Thread $this$start_u24lambda_u240_u240 = thread = new Thread(r, "MacOutsideClickWatcher");
        boolean bl = false;
        $this$start_u24lambda_u240_u240.setDaemon(true);
        return thread;
    }

    private static final void start$lambda$1$0(MacOutsideClickWatcher this$0) {
        this$0.pollOnce();
    }
}

