/*
 * Decompiled with CFR 0.152.
 */
package com.kdroid.composetray.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0003*\u00020\u0001H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0003*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"extractToTempIfDifferent", "Ljava/io/File;", "jarPath", "", "sha256", "Ljava/io/InputStream;", "ComposeNativeTray"})
@SourceDebugExtension(value={"SMAP\nJarResourceExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarResourceExtractor.kt\ncom/kdroid/composetray/utils/JarResourceExtractorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class JarResourceExtractorKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final File extractToTempIfDifferent(@NotNull String jarPath) {
        File file;
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        String correctedJarFilePath = URLDecoder.decode(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)jarPath, (String)"jar:file:", null, (int)2, null), (String)"!", null, (int)2, null), Charsets.UTF_8.name());
        Intrinsics.checkNotNull((Object)correctedJarFilePath);
        String encodedJarFilePath = StringsKt.replace$default((String)correctedJarFilePath, (String)" ", (String)"%20", (boolean)false, (int)4, null);
        try {
            file = new File(new URI(encodedJarFilePath));
        }
        catch (IllegalArgumentException e) {
            file = new File(StringsKt.removePrefix((String)correctedJarFilePath, (CharSequence)"file:"));
        }
        File jarFile = file;
        if (!jarFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + correctedJarFilePath);
        }
        char[] e = new char[]{'/'};
        String entryPath = StringsKt.trimStart((String)StringsKt.substringAfter$default((String)jarPath, (String)"!", null, (int)2, null), (char[])e);
        if (!StringsKt.endsWith$default((String)correctedJarFilePath, (String)".jar", (boolean)false, (int)2, null)) {
            CopyOption[] copyOptionArray;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path = Files.createTempFile("extracted_", ".tmp", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            CopyOption[] $this$extractToTempIfDifferent_u24lambda_u240 = copyOptionArray = path.toFile();
            boolean bl = false;
            $this$extractToTempIfDifferent_u24lambda_u240.deleteOnExit();
            CopyOption[] tempFile = copyOptionArray;
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(jarFile.toPath(), tempFile.toPath(), copyOptionArray);
            return tempFile;
        }
        Closeable closeable = new JarFile(jarFile);
        Throwable throwable = null;
        try {
            Object object;
            JarEntry jarEntry;
            JarFile jar = (JarFile)closeable;
            boolean bl = false;
            if (jar.getJarEntry(entryPath) == null) {
                File file2 = null;
                return file2;
            }
            JarEntry entry = jarEntry;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path = Files.createTempFile("extracted_", ".tmp", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            Object object2 = path.toFile();
            File $this$extractToTempIfDifferent_u24lambda_u241_u240 = object2;
            boolean bl22 = false;
            $this$extractToTempIfDifferent_u24lambda_u241_u240.deleteOnExit();
            File tempFile = object2;
            if (tempFile.exists()) {
                Intrinsics.checkNotNull((Object)tempFile);
                String tempFileHash = JarResourceExtractorKt.sha256(tempFile);
                object = jar.getInputStream(entry);
                Throwable bl22 = null;
                try {
                    InputStream input = (InputStream)object;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)input);
                    String jarEntryHash = JarResourceExtractorKt.sha256(input);
                    if (Intrinsics.areEqual((Object)tempFileHash, (Object)jarEntryHash)) {
                        File file3 = tempFile;
                        File file4 = file3;
                        return file4;
                    }
                    input = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    bl22 = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)bl22);
                }
            }
            object2 = jar.getInputStream(entry);
            object = null;
            try {
                InputStream input = (InputStream)object2;
                boolean bl4 = false;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(input, tempFile.toPath(), copyOptionArray);
            }
            catch (Throwable throwable3) {
                object = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            File file5 = tempFile;
            return file5;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String sha256(File $this$sha256) {
        String string2;
        Closeable closeable = new FileInputStream($this$sha256);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            string2 = JarResourceExtractorKt.sha256(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string2;
    }

    private static final String sha256(InputStream $this$sha256) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while (true) {
            int n;
            int it = n = $this$sha256.read(buffer);
            boolean bl = false;
            bytesRead = it;
            if (n == -1) break;
            digest.update(buffer, 0, bytesRead);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, JarResourceExtractorKt::sha256$lambda$2, (int)30, null);
    }

    private static final CharSequence sha256$lambda$2(byte it) {
        String string2 = "%02x";
        Object[] objectArray = new Object[]{it};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }
}

