/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdroidfilter.platformtools.darkmodedetector.windows;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.SnapshotStateKt;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import io.github.kdroidfilter.platformtools.OperatingSystem;
import io.github.kdroidfilter.platformtools.OsProvider_jvmKt;
import io.github.kdroidfilter.platformtools.darkmodedetector.IsSystemInDarkMode_jvmKt;
import io.github.kdroidfilter.platformtools.darkmodedetector.windows.DwmApi;
import io.github.kdroidfilter.platformtools.darkmodedetector.windows.WindowsThemeDetector;
import java.awt.Component;
import java.awt.Window;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\r\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\u0010\u0006\u001a\u001b\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u000b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"windowsLogger", "Lco/touchlab/kermit/Logger;", "getWindowsLogger", "()Lco/touchlab/kermit/Logger;", "isWindowsInDarkMode", "", "(Landroidx/compose/runtime/Composer;I)Z", "setWindowsAdaptiveTitleBar", "", "Ljava/awt/Window;", "dark", "(Ljava/awt/Window;ZLandroidx/compose/runtime/Composer;II)V", "darkmodedetector"})
@SourceDebugExtension(value={"SMAP\nWindowsThemeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/windows/WindowsThemeDetectorKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 Logger.kt\nco/touchlab/kermit/Logger\n+ 4 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 5 Effects.kt\nandroidx/compose/runtime/DisposableEffectScope\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1282#2,6:227\n1282#2,6:233\n31#3,3:239\n34#3:251\n31#3,3:252\n34#3:264\n31#3,3:270\n34#3:282\n31#4,9:242\n31#4,9:255\n31#4,9:273\n66#5,5:265\n1#6:283\n*S KotlinDebug\n*F\n+ 1 WindowsThemeDetector.kt\nio/github/kdroidfilter/platformtools/darkmodedetector/windows/WindowsThemeDetectorKt\n*L\n172#1:227,6\n174#1:233,6\n223#1:239,3\n223#1:251\n175#1:252,3\n175#1:264\n177#1:270,3\n177#1:282\n223#1:242,9\n175#1:255,9\n177#1:273,9\n183#1:265,5\n*E\n"})
public final class WindowsThemeDetectorKt {
    @NotNull
    private static final Logger windowsLogger;

    @NotNull
    public static final Logger getWindowsLogger() {
        return windowsLogger;
    }

    @Composable
    public static final boolean isWindowsInDarkMode(@Nullable Composer $composer, int $changed) {
        Object object;
        Object object2;
        Composer $this$cache$iv;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-683189569, (int)$changed, (int)-1, (String)"io.github.kdroidfilter.platformtools.darkmodedetector.windows.isWindowsInDarkMode (WindowsThemeDetector.kt:169)");
        }
        Composer composer = $composer;
        boolean bl = false;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl3 = false;
            MutableState value$iv = SnapshotStateKt.mutableStateOf$default((Object)WindowsThemeDetector.INSTANCE.isDark(), null, (int)2, null);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object2 = value$iv;
        } else {
            object2 = it$iv;
        }
        MutableState darkModeState = (MutableState)object2;
        Unit unit = Unit.INSTANCE;
        $this$cache$iv = $composer;
        boolean invalid$iv = false;
        $i$f$cache = false;
        it$iv = $this$cache$iv.rememberedValue();
        bl2 = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            Unit unit2 = unit;
            boolean bl4 = false;
            unit = unit2;
            Function1 value$iv = arg_0 -> WindowsThemeDetectorKt.isWindowsInDarkMode$lambda$1$0(darkModeState, arg_0);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        EffectsKt.DisposableEffect((Object)unit, (Function1)((Function1)object), (Composer)$composer, (int)54);
        boolean bl5 = (Boolean)darkModeState.getValue();
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        return bl5;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    public static final void setWindowsAdaptiveTitleBar(@NotNull Window $this$setWindowsAdaptiveTitleBar, boolean dark, @Nullable Composer $composer, int $changed, int n) {
        block14: {
            Intrinsics.checkNotNullParameter((Object)$this$setWindowsAdaptiveTitleBar, (String)"<this>");
            $composer = $composer.startRestartGroup(-538186158);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance((Object)$this$setWindowsAdaptiveTitleBar) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= (n & 1) == 0 && $composer.changed(dark) ? 32 : 16;
            }
            if ($composer.shouldExecute(($dirty & 0x13) != 18, $dirty & 1)) {
                block13: {
                    $composer.startDefaults();
                    if (($changed & 1) == 0 || $composer.getDefaultsInvalid()) {
                        if ((n & 1) != 0) {
                            dark = IsSystemInDarkMode_jvmKt.isSystemInDarkMode($composer, 0);
                            $dirty &= 0xFFFFFF8F;
                        }
                    } else {
                        $composer.skipToGroupEnd();
                        if ((n & 1) != 0) {
                            $dirty &= 0xFFFFFF8F;
                        }
                    }
                    $composer.endDefaults();
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)-538186158, (int)$dirty, (int)-1, (String)"io.github.kdroidfilter.platformtools.darkmodedetector.windows.setWindowsAdaptiveTitleBar (WindowsThemeDetector.kt:204)");
                    }
                    try {
                        if (OsProvider_jvmKt.getOperatingSystem() == OperatingSystem.WINDOWS) {
                            WinDef.HWND hwnd = new WinDef.HWND(Native.getComponentPointer((Component)$this$setWindowsAdaptiveTitleBar));
                            IntByReference darkModeEnabled = new IntByReference(dark ? 1 : 0);
                            DwmApi dwmApi = DwmApi.Companion.getINSTANCE();
                            Pointer pointer = darkModeEnabled.getPointer();
                            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
                            dwmApi.DwmSetWindowAttribute(hwnd, 20, pointer, 4);
                        }
                    }
                    catch (Exception e) {
                        void this_$iv$iv;
                        Logger $this$iv = windowsLogger;
                        Throwable throwable$iv = null;
                        String tag$iv = $this$iv.getTag();
                        boolean $i$f$d = false;
                        BaseLogger baseLogger = (BaseLogger)$this$iv;
                        Severity severity$iv$iv = Severity.Debug;
                        boolean $i$f$logBlock = false;
                        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) > 0) break block13;
                        Throwable throwable = throwable$iv;
                        String string = tag$iv;
                        Severity severity = severity$iv$iv;
                        void var15_19 = this_$iv$iv;
                        boolean bl = false;
                        String string2 = "Failed to set dark mode: " + e.getMessage();
                        var15_19.processLog(severity, string, throwable, string2);
                    }
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block14;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> WindowsThemeDetectorKt.setWindowsAdaptiveTitleBar$lambda$1($this$setWindowsAdaptiveTitleBar, dark, $changed, n, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final DisposableEffectResult isWindowsInDarkMode$lambda$1$0(MutableState $darkModeState, DisposableEffectScope $this$DisposableEffect) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
        Logger $this$iv = windowsLogger;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$logBlock = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            Throwable throwable = throwable$iv;
            String string = tag$iv;
            Severity severity = severity$iv$iv;
            void var10_13 = this_$iv$iv;
            boolean bl = false;
            String string2 = "Registering Windows dark mode listener in Compose";
            var10_13.processLog(severity, string, throwable, string2);
        }
        Consumer<Boolean> listener = arg_0 -> WindowsThemeDetectorKt.isWindowsInDarkMode$lambda$1$0$1($darkModeState, arg_0);
        WindowsThemeDetector.INSTANCE.registerListener(listener);
        DisposableEffectScope this_$iv = $this$DisposableEffect;
        boolean $i$f$onDispose = false;
        return new DisposableEffectResult(listener){
            final /* synthetic */ Consumer $listener$inlined;
            {
                this.$listener$inlined = consumer;
            }

            /*
             * WARNING - void declaration
             */
            public void dispose() {
                void this_$iv$iv;
                boolean bl = false;
                Logger $this$iv = WindowsThemeDetectorKt.getWindowsLogger();
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$d = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Debug;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var12_12 = this_$iv$iv;
                    boolean bl2 = false;
                    String string2 = "Removing Windows dark mode listener in Compose";
                    var12_12.processLog(severity, string, throwable, string2);
                }
                WindowsThemeDetector.INSTANCE.removeListener(this.$listener$inlined);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final void isWindowsInDarkMode$lambda$1$0$1(MutableState $darkModeState, Boolean newValue) {
        void this_$iv$iv;
        Logger $this$iv = windowsLogger;
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$d = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Debug;
        boolean $i$f$logBlock = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            Throwable throwable = throwable$iv;
            String string = tag$iv;
            Severity severity = severity$iv$iv;
            void var10_12 = this_$iv$iv;
            boolean bl = false;
            String string2 = "Windows dark mode updated: " + newValue;
            var10_12.processLog(severity, string, throwable, string2);
        }
        Intrinsics.checkNotNull((Object)newValue);
        $darkModeState.setValue((Object)newValue);
    }

    private static final Unit setWindowsAdaptiveTitleBar$lambda$1(Window $this_setWindowsAdaptiveTitleBar, boolean $dark, int $$changed, int $$default, Composer $composer, int $force) {
        WindowsThemeDetectorKt.setWindowsAdaptiveTitleBar($this_setWindowsAdaptiveTitleBar, $dark, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
        return Unit.INSTANCE;
    }

    static {
        Logger logger;
        Logger $this$windowsLogger_u24lambda_u240 = logger = Logger.Companion.withTag("WindowsThemeDetector");
        boolean bl = false;
        Logger.Companion.setMinSeverity(Severity.Warn);
        windowsLogger = logger;
    }
}

